#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/wait.h>

int my_system(const char *fmt, ...)
{
	va_list ap;
	char cmdln[BUFSIZ];
	int rc;

	va_start(ap, fmt);
	rc = vsnprintf(cmdln, sizeof(cmdln), fmt, ap);
	va_end(ap);

	if (rc > 0)
		rc = system(cmdln);

	return rc <= 0 ? rc : WEXITSTATUS(rc);
}


