/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#ifndef STATS_LOGIC_HPP
#define STATS_LOGIC_HPP

#include <utility>

#include <QStringList>

#include "UserProfile.hpp"

using std::pair;

class StatsLogic
{
 public:
	StatsLogic(const UserProfile& profile);

	//typedef int Stat;
	typedef float stat_t;
	typedef int plot_caption_t;

	struct Stat
	{
		stat_t exerciseCount;
		stat_t mistakeAverage;
		stat_t rhythmAverage;
		stat_t speedAverage;
		stat_t symbolCount;
		stat_t time;
		QStringList mistakes;
		QStringList combinations;

		stat_t index() const;
	};

	struct DisplayStat
	{
		Stat stat;
		QString caption;
	};

	struct AddInfo
	{
		time_t timestamp;
		size_t exerciseNumber;
	};

	enum CategorizeType { byExercise, byDay, byWeek, byMonth, byYear, byAll };
	struct CategorizeInfo
	{
		CategorizeType type;
		QString caption;

		CategorizeInfo(CategorizeType type, const QString& caption)
			: type(type), caption(caption)
		{}
	};

	const vector<CategorizeInfo>& categorizeInfo() const;


	typedef vector< pair< QString, vector<DisplayStat> > > CategorizedStats;

	CategorizedStats categorize(CategorizeType categorizeBy, CategorizeType summarizeBy);

 private:
	void initCategorizeInfo();

	QString category(const AddInfo& addInfo, CategorizeType);
	void logIncrement(stat_t& stat, size_t newValue);
	void statIncrement(Stat& stat, const Stat& newStat);

	const UserProfile& profile;
	vector< pair<Stat, AddInfo> > stats;
	vector<CategorizeInfo> myCategorizeInfo;
};

#endif

