/*
 * Decompiled with CFR 0.152.
 */
package gj.layout.tree;

class Contour {
    protected static final int WEST = 0;
    protected static final int EAST = 1;
    int north;
    int south;
    int west;
    int east;
    private int dlat = 0;
    private int dlon = 0;
    private int[][] data = null;
    private int[] size = null;

    Contour(double n, double w, double e, double s) {
        this.north = (int)Math.floor(n);
        this.west = (int)Math.floor(w);
        this.east = (int)Math.ceil(e);
        this.south = (int)Math.ceil(s);
    }

    static Contour merge(Contour[] contours) {
        if (contours.length == 0) {
            throw new IllegalArgumentException("zero-length list n/a");
        }
        if (contours.length == 1 || contours.length == 2 && contours[0] == contours[1]) {
            return contours[0];
        }
        Contour result = new Contour(0.0, 2.147483647E9, -2.147483648E9, 0.0);
        int demand = 0;
        for (int c = 0; c < contours.length; ++c) {
            if (contours[c].size == null) {
                demand += 2;
                continue;
            }
            demand += Math.max(contours[c].size[1], contours[c].size[0]);
        }
        result.data = new int[2][demand];
        result.size = new int[2];
        block1: for (int c2 = contours.length - 1; c2 >= 0; --c2) {
            Iterator it = contours[c2].getIterator(1);
            if (c2 == contours.length - 1) {
                result.north = it.north;
            } else {
                while (it.south <= result.south) {
                    if (it.next()) continue;
                    continue block1;
                }
            }
            do {
                result.east = Math.max(result.east, it.longitude);
                int n = result.size[1];
                result.size[1] = n + 1;
                result.data[1][n] = it.longitude;
                int n2 = result.size[1];
                result.size[1] = n2 + 1;
                result.data[1][n2] = it.south;
                result.south = it.south;
            } while (it.next());
        }
        int[] size = result.size;
        boolean n = true;
        size[1] = size[1] - 1;
        block4: for (int c3 = 0; c3 < contours.length; ++c3) {
            Iterator it2 = contours[c3].getIterator(0);
            if (c3 == 0) {
                result.north = it2.north;
            } else {
                while (it2.south <= result.south) {
                    if (it2.next()) continue;
                    continue block4;
                }
            }
            do {
                result.west = Math.min(result.west, it2.longitude);
                int n3 = result.size[0];
                result.size[0] = n3 + 1;
                result.data[0][n3] = it2.longitude;
                int n4 = result.size[0];
                result.size[0] = n4 + 1;
                result.data[0][n4] = it2.south;
                result.south = it2.south;
            } while (it2.next());
        }
        int[] size2 = result.size;
        boolean n2 = false;
        size2[0] = size2[0] - 1;
        return result;
    }

    void pad(int[] pad) {
        this.north -= pad[0];
        this.west -= pad[1];
        this.east += pad[2];
        this.south += pad[3];
    }

    void translate(int dlat, int dlon) {
        this.north += dlat;
        this.south += dlat;
        this.west += dlon;
        this.east += dlon;
        this.dlat += dlat;
        this.dlon += dlon;
    }

    Iterator getIterator(int side) {
        return new Iterator(this, side);
    }

    static class Iterator {
        private final Contour contour;
        private int i;
        private final int side;
        int north;
        int longitude;
        int south;

        private Iterator(Contour c, int s) {
            this.contour = c;
            this.side = s;
            if (this.contour.size == null) {
                this.north = this.contour.north;
                this.longitude = s == 0 ? this.contour.west : this.contour.east;
                this.south = this.contour.south;
            } else {
                this.south = this.contour.north;
                this.i = 0;
                this.next();
            }
        }

        final boolean next() {
            if (this.contour.size == null || this.i >= this.contour.size[this.side]) {
                return false;
            }
            this.north = this.south;
            this.longitude = this.contour.dlon + this.contour.data[this.side][this.i++];
            this.south = this.i == this.contour.size[this.side] ? this.contour.south : this.contour.dlat + this.contour.data[this.side][this.i++];
            return true;
        }
    }
}

