/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.model;

import ancestris.modules.releve.model.Field;
import ancestris.modules.releve.model.FieldAge;
import ancestris.modules.releve.model.FieldComment;
import ancestris.modules.releve.model.FieldDate;
import ancestris.modules.releve.model.FieldDead;
import ancestris.modules.releve.model.FieldEventTag;
import ancestris.modules.releve.model.FieldEventType;
import ancestris.modules.releve.model.FieldPicture;
import ancestris.modules.releve.model.FieldPlace;
import ancestris.modules.releve.model.FieldSex;
import ancestris.modules.releve.model.FieldSimpleValue;
import ancestris.modules.releve.model.RecordInfoPlace;
import org.openide.util.NbBundle;

public abstract class AbstractRecord {
    protected Field[] fields = new Field[FieldType.values().length];

    public abstract RecordType getType();

    public String getEventTagLabel() {
        return switch (this.getType()) {
            case RecordType.BIRTH -> NbBundle.getMessage(AbstractRecord.class, (String)"record.type.birth");
            case RecordType.DEATH -> NbBundle.getMessage(AbstractRecord.class, (String)"record.type.death");
            case RecordType.MARRIAGE -> NbBundle.getMessage(AbstractRecord.class, (String)"record.type.marriage");
            default -> this.getFieldString(FieldType.eventTag);
        };
    }

    public Field getField(FieldType fieldType) {
        return this.fields[fieldType.ordinal()];
    }

    public String getFieldValue(FieldType fieldType) {
        Field field = this.getField(fieldType);
        if (field != null) {
            return field.getValue();
        }
        return "";
    }

    public String getFieldString(FieldType fieldType) {
        Field field = this.getField(fieldType);
        if (field != null) {
            return field.toString();
        }
        return "";
    }

    public boolean isEmptyField(FieldType fieldType) {
        Field field = this.getField(fieldType);
        if (field != null) {
            return field.isEmpty();
        }
        return true;
    }

    public void setFieldValue(FieldType fieldType, String value) {
        Field field = this.getField(fieldType);
        if (!value.isEmpty() || field != null) {
            if (field == null) {
                field = this.createField(fieldType);
            }
            field.setValue(value);
        }
    }

    public Field createField(FieldType fieldType) {
        switch (fieldType) {
            case eventType: {
                this.fields[fieldType.ordinal()] = new FieldEventType();
                break;
            }
            case eventTag: {
                this.fields[fieldType.ordinal()] = new FieldEventTag();
                break;
            }
            case indiAge: 
            case indiFatherAge: 
            case indiMotherAge: 
            case wifeAge: 
            case wifeFatherAge: 
            case wifeMotherAge: {
                this.fields[fieldType.ordinal()] = new FieldAge();
                break;
            }
            case freeComment: {
                this.fields[fieldType.ordinal()] = new FieldPicture();
                break;
            }
            case generalComment: 
            case deedText: 
            case indiComment: 
            case indiMarriedComment: 
            case indiFatherComment: 
            case indiMotherComment: 
            case wifeComment: 
            case wifeMarriedComment: 
            case wifeFatherComment: 
            case wifeMotherComment: {
                this.fields[fieldType.ordinal()] = new FieldComment();
                break;
            }
            case eventDate: 
            case secondDate: 
            case indiBirthDate: 
            case indiDeathDate: 
            case wifeBirthDate: {
                this.fields[fieldType.ordinal()] = new FieldDate();
                break;
            }
            case indiMarriedDead: 
            case indiFatherDead: 
            case indiMotherDead: 
            case wifeMarriedDead: 
            case wifeFatherDead: 
            case wifeMotherDead: {
                this.fields[fieldType.ordinal()] = new FieldDead();
                break;
            }
            case indiBirthPlace: 
            case indiBirthAddress: 
            case indiDeathPlace: 
            case indiDeathAddress: 
            case indiResidence: 
            case indiAddress: 
            case indiMarriedResidence: 
            case indiMarriedAddress: 
            case indiFatherResidence: 
            case indiFatherAddress: 
            case indiMotherResidence: 
            case indiMotherAddress: 
            case wifeBirthPlace: 
            case wifeBirthAddress: 
            case wifeResidence: 
            case wifeAddress: 
            case wifeMarriedResidence: 
            case wifeMarriedAddress: 
            case wifeFatherResidence: 
            case wifeFatherAddress: 
            case wifeMotherResidence: 
            case wifeMotherAddress: {
                this.fields[fieldType.ordinal()] = new FieldPlace();
                break;
            }
            case indiSex: 
            case wifeSex: {
                this.fields[fieldType.ordinal()] = new FieldSex();
                break;
            }
            case place: {
                this.fields[fieldType.ordinal()] = new RecordInfoPlace();
                break;
            }
            default: {
                this.fields[fieldType.ordinal()] = new FieldSimpleValue();
            }
        }
        return this.fields[fieldType.ordinal()];
    }

    public void setPlace(String cityName, String cityCode, String county, String state, String country) {
        Field place = this.getField(FieldType.place);
        if (place == null) {
            place = this.createField(FieldType.place);
        }
        ((RecordInfoPlace)place).setValue(cityName, cityCode, county, state, country);
    }

    public void setPlace(RecordInfoPlace place) {
        this.setPlace(place.getCityName(), place.getCityCode(), place.getCountyName(), place.getStateName(), place.getCountryName());
    }

    public void setPlace(String place) {
        String[] bits = place.split(",");
        String city = "";
        String code = "";
        String cnty = "";
        String state = "";
        String ctry = "";
        if (bits.length > 0) {
            city = bits[0].trim();
        }
        if (bits.length > 1) {
            code = bits[1].trim();
        }
        if (bits.length > 2) {
            cnty = bits[2].trim();
        }
        if (bits.length > 3) {
            state = bits[3].trim();
        }
        if (bits.length > 4) {
            ctry = bits[4].trim();
        }
        this.setPlace(city, code, cnty, state, ctry);
    }

    public RecordInfoPlace getPlace() {
        Field place = this.getField(FieldType.place);
        if (place == null) {
            place = this.createField(FieldType.place);
        }
        return (RecordInfoPlace)place;
    }

    public String getCity() {
        return this.getPlace().getCityName();
    }

    public void setIndi(String inFirstName, String inLastName, String inSexe, String inAge, String inBirthDate, String inBirthPlace, String inBirthAddress, String inOccupation, String inResidence, String inAddress, String inDeathDate, String inDeathPlace, String inDeathAddress, String inComment) {
        this.setFieldValue(FieldType.indiFirstName, inFirstName.trim());
        this.setFieldValue(FieldType.indiLastName, inLastName.trim());
        this.setFieldValue(FieldType.indiSex, inSexe.trim());
        this.setFieldValue(FieldType.indiAge, inAge.trim());
        this.setFieldValue(FieldType.indiBirthDate, inBirthDate.trim());
        this.setFieldValue(FieldType.indiBirthPlace, inBirthPlace.trim());
        this.setFieldValue(FieldType.indiBirthAddress, inBirthAddress.trim());
        this.setFieldValue(FieldType.indiOccupation, inOccupation.trim());
        this.setFieldValue(FieldType.indiResidence, inResidence.trim());
        this.setFieldValue(FieldType.indiAddress, inAddress.trim());
        this.setFieldValue(FieldType.indiDeathDate, inDeathDate.trim());
        this.setFieldValue(FieldType.indiDeathPlace, inDeathPlace.trim());
        this.setFieldValue(FieldType.indiDeathAddress, inDeathAddress.trim());
        this.setFieldValue(FieldType.indiComment, inComment.trim());
    }

    public void setIndiMarried(String inFirstName, String inLastName, String inOccupation, String inResidence, String inAddress, String inComment, String inDead) {
        this.setFieldValue(FieldType.indiMarriedFirstName, inFirstName.trim());
        this.setFieldValue(FieldType.indiMarriedLastName, inLastName.trim());
        this.setFieldValue(FieldType.indiMarriedOccupation, inOccupation.trim());
        this.setFieldValue(FieldType.indiMarriedResidence, inResidence.trim());
        this.setFieldValue(FieldType.indiMarriedAddress, inAddress.trim());
        this.setFieldValue(FieldType.indiMarriedComment, inComment.trim());
        this.setFieldValue(FieldType.indiMarriedDead, inDead.trim());
    }

    public void setIndiFather(String inFirstName, String inLastName, String inOccupation, String inResidence, String inAddress, String inComment, String inDead, String inAge) {
        this.setFieldValue(FieldType.indiFatherFirstName, inFirstName.trim());
        this.setFieldValue(FieldType.indiFatherLastName, inLastName.trim());
        this.setFieldValue(FieldType.indiFatherOccupation, inOccupation.trim());
        this.setFieldValue(FieldType.indiFatherResidence, inResidence.trim());
        this.setFieldValue(FieldType.indiFatherAddress, inAddress.trim());
        this.setFieldValue(FieldType.indiFatherComment, inComment.trim());
        this.setFieldValue(FieldType.indiFatherDead, inDead.trim());
        this.setFieldValue(FieldType.indiFatherAge, inAge.trim());
    }

    public void setIndiMother(String inFirstName, String inLastName, String inOccupation, String inResidence, String inAddress, String inComment, String inDead, String inAge) {
        this.setFieldValue(FieldType.indiMotherFirstName, inFirstName.trim());
        this.setFieldValue(FieldType.indiMotherLastName, inLastName.trim());
        this.setFieldValue(FieldType.indiMotherOccupation, inOccupation.trim());
        this.setFieldValue(FieldType.indiMotherResidence, inResidence.trim());
        this.setFieldValue(FieldType.indiMotherAddress, inAddress.trim());
        this.setFieldValue(FieldType.indiMotherComment, inComment.trim());
        this.setFieldValue(FieldType.indiMotherDead, inDead.trim());
        this.setFieldValue(FieldType.indiMotherAge, inAge.trim());
    }

    public void setWife(String inFirstName, String inLastName, String inSexe, String inAge, String inBirthDate, String inBirthPlace, String inBirthAddress, String inOccupation, String inResidence, String inAddress, String inComment) {
        this.setFieldValue(FieldType.wifeFirstName, inFirstName.trim());
        this.setFieldValue(FieldType.wifeLastName, inLastName.trim());
        this.setFieldValue(FieldType.wifeSex, inSexe.trim());
        this.setFieldValue(FieldType.wifeAge, inAge.trim());
        this.setFieldValue(FieldType.wifeBirthDate, inBirthDate.trim());
        this.setFieldValue(FieldType.wifeBirthPlace, inBirthPlace.trim());
        this.setFieldValue(FieldType.wifeBirthAddress, inBirthAddress.trim());
        this.setFieldValue(FieldType.wifeOccupation, inOccupation.trim());
        this.setFieldValue(FieldType.wifeResidence, inResidence.trim());
        this.setFieldValue(FieldType.wifeAddress, inAddress.trim());
        this.setFieldValue(FieldType.wifeComment, inComment.trim());
    }

    public void setWifeMarried(String inFirstName, String inLastName, String inOccupation, String inResidence, String inAddress, String inComment, String inDead) {
        this.setFieldValue(FieldType.wifeMarriedFirstName, inFirstName.trim());
        this.setFieldValue(FieldType.wifeMarriedLastName, inLastName.trim());
        this.setFieldValue(FieldType.wifeMarriedOccupation, inOccupation.trim());
        this.setFieldValue(FieldType.wifeMarriedResidence, inResidence.trim());
        this.setFieldValue(FieldType.wifeMarriedAddress, inAddress.trim());
        this.setFieldValue(FieldType.wifeMarriedComment, inComment.trim());
        this.setFieldValue(FieldType.wifeMarriedDead, inDead.trim());
    }

    public void setWifeFather(String inFirstName, String inLastName, String inOccupation, String inResidence, String inAddress, String inComment, String inDead, String inAge) {
        this.setFieldValue(FieldType.wifeFatherFirstName, inFirstName.trim());
        this.setFieldValue(FieldType.wifeFatherLastName, inLastName.trim());
        this.setFieldValue(FieldType.wifeFatherOccupation, inOccupation.trim());
        this.setFieldValue(FieldType.wifeFatherResidence, inResidence.trim());
        this.setFieldValue(FieldType.wifeFatherAddress, inAddress.trim());
        this.setFieldValue(FieldType.wifeFatherComment, inComment.trim());
        this.setFieldValue(FieldType.wifeFatherDead, inDead.trim());
        this.setFieldValue(FieldType.wifeFatherAge, inAge.trim());
    }

    public void setWifeMother(String inFirstName, String inLastName, String inOccupation, String inResidence, String inAddress, String inComment, String inDead, String inAge) {
        this.setFieldValue(FieldType.wifeMotherFirstName, inFirstName.trim());
        this.setFieldValue(FieldType.wifeMotherLastName, inLastName.trim());
        this.setFieldValue(FieldType.wifeMotherOccupation, inOccupation.trim());
        this.setFieldValue(FieldType.wifeMotherResidence, inResidence.trim());
        this.setFieldValue(FieldType.wifeMotherAddress, inAddress.trim());
        this.setFieldValue(FieldType.wifeMotherComment, inComment.trim());
        this.setFieldValue(FieldType.wifeMotherDead, inDead.trim());
        this.setFieldValue(FieldType.wifeMotherAge, inAge.trim());
    }

    public void setWitness1(String firstName, String lastName, String occupation, String comment) {
        this.setFieldValue(FieldType.witness1FirstName, firstName.trim());
        this.setFieldValue(FieldType.witness1LastName, lastName.trim());
        this.setFieldValue(FieldType.witness1Occupation, occupation.trim());
        this.setFieldValue(FieldType.witness1Comment, comment.trim());
    }

    public void setWitness2(String firstName, String lastName, String occupation, String comment) {
        this.setFieldValue(FieldType.witness2FirstName, firstName.trim());
        this.setFieldValue(FieldType.witness2LastName, lastName.trim());
        this.setFieldValue(FieldType.witness2Occupation, occupation.trim());
        this.setFieldValue(FieldType.witness2Comment, comment.trim());
    }

    public void setWitness3(String firstName, String lastName, String occupation, String comment) {
        this.setFieldValue(FieldType.witness3FirstName, firstName.trim());
        this.setFieldValue(FieldType.witness3LastName, lastName.trim());
        this.setFieldValue(FieldType.witness3Occupation, occupation.trim());
        this.setFieldValue(FieldType.witness3Comment, comment.trim());
    }

    public void setWitness4(String firstName, String lastName, String occupation, String comment) {
        this.setFieldValue(FieldType.witness4FirstName, firstName.trim());
        this.setFieldValue(FieldType.witness4LastName, lastName.trim());
        this.setFieldValue(FieldType.witness4Occupation, occupation.trim());
        this.setFieldValue(FieldType.witness4Comment, comment.trim());
    }

    public static enum FieldType {
        place,
        eventTag,
        eventType,
        cote,
        freeComment,
        generalComment,
        eventDate,
        secondDate,
        notary,
        parish,
        deedText,
        eventMedia,
        indiFirstName,
        indiLastName,
        indiSex,
        indiAge,
        indiBirthDate,
        indiBirthPlace,
        indiBirthAddress,
        indiOccupation,
        indiResidence,
        indiAddress,
        indiDeathDate,
        indiDeathPlace,
        indiDeathAddress,
        indiComment,
        indiMarriedFirstName,
        indiMarriedLastName,
        indiMarriedDead,
        indiMarriedOccupation,
        indiMarriedResidence,
        indiMarriedAddress,
        indiMarriedComment,
        indiFatherFirstName,
        indiFatherLastName,
        indiFatherAge,
        indiFatherDead,
        indiFatherOccupation,
        indiFatherResidence,
        indiFatherAddress,
        indiFatherComment,
        indiMotherFirstName,
        indiMotherLastName,
        indiMotherAge,
        indiMotherDead,
        indiMotherOccupation,
        indiMotherResidence,
        indiMotherAddress,
        indiMotherComment,
        wifeFirstName,
        wifeLastName,
        wifeSex,
        wifeAge,
        wifeBirthDate,
        wifeBirthPlace,
        wifeBirthAddress,
        wifeOccupation,
        wifeResidence,
        wifeAddress,
        wifeComment,
        wifeMarriedFirstName,
        wifeMarriedLastName,
        wifeMarriedDead,
        wifeMarriedOccupation,
        wifeMarriedResidence,
        wifeMarriedAddress,
        wifeMarriedComment,
        wifeFatherFirstName,
        wifeFatherLastName,
        wifeFatherAge,
        wifeFatherDead,
        wifeFatherOccupation,
        wifeFatherResidence,
        wifeFatherAddress,
        wifeFatherComment,
        wifeMotherFirstName,
        wifeMotherLastName,
        wifeMotherAge,
        wifeMotherDead,
        wifeMotherOccupation,
        wifeMotherResidence,
        wifeMotherAddress,
        wifeMotherComment,
        witness1FirstName,
        witness1LastName,
        witness1Occupation,
        witness1Role,
        witness1Comment,
        witness2FirstName,
        witness2LastName,
        witness2Occupation,
        witness2Role,
        witness2Comment,
        witness3FirstName,
        witness3LastName,
        witness3Occupation,
        witness3Role,
        witness3Comment,
        witness4FirstName,
        witness4LastName,
        witness4Occupation,
        witness4Role,
        witness4Comment;

    }

    public static enum RecordType {
        BIRTH,
        MARRIAGE,
        DEATH,
        MISC;

    }
}

