/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.gedcom.GedcomDirectory;
import ancestris.modules.releve.merge.MergeOption;
import ancestris.modules.releve.merge.RecordSourceConfigDialog;
import ancestris.modules.releve.merge.SimilarNameDialog;
import ancestris.modules.releve.model.PlaceFormatModel;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.PropertyPlace;
import genj.gedcom.Source;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class MergeOptionPanel
extends JPanel {
    private File currentFile;
    private Frame parent;
    private GedcomFormatModel gedcomFormatModel;
    private int currentGedcomIndex;
    private final HashMap<PlaceFormatModel.RecordJuridiction, JComboBox<String>> comboxBoxMap = new HashMap();
    private JButton jButtonAddSource;
    private ButtonGroup jButtonGroupSourceScope;
    private JButton jButtonModify;
    private JButton jButtonRemoveSource;
    private JButton jButtonSimilarFirstNames;
    private JButton jButtonSimilarLastNames;
    private JComboBox<String> jComboBoxCityCode;
    private JComboBox<String> jComboBoxCityName;
    private JComboBox<String> jComboBoxCountry;
    private JComboBox<String> jComboBoxCounty;
    private JComboBox<String> jComboBoxState;
    private JLabel jLabelCityCode;
    private JLabel jLabelCityName;
    private JLabel jLabelCountry;
    private JLabel jLabelCounty;
    private JLabel jLabelGedcomFile;
    private JLabel jLabelGedcomJuridiction;
    private JLabel jLabelRecordJuridiction;
    private JLabel jLabelState;
    private JList<String> jListGedcomFile;
    private JPanel jPanelPlace;
    private JPanel jPanelSimilar;
    private JPanel jPanelSource;
    private JRadioButton jRadioButtonSourceScopeCity;
    private JRadioButton jRadioButtonSourceScopeRecord;
    private JScrollPane jScrollPaneGedcomFile;
    private JScrollPane jScrollPaneSource;
    private JTable jTableSource;

    public MergeOptionPanel() {
        this.initComponents();
        this.jPanelPlace.setVisible(false);
    }

    public void initData(Frame parent, File currentFile) {
        this.parent = parent;
        this.currentFile = currentFile;
        this.gedcomFormatModel = new GedcomFormatModel();
        this.currentGedcomIndex = this.gedcomFormatModel.defaultGedcom;
        this.jListGedcomFile.setModel(this.gedcomFormatModel);
        ItemListener comboBoxItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    JComboBox comboBox = (JComboBox)event.getSource();
                    PlaceComboBoxModel comnoBoxModel = (PlaceComboBoxModel)comboBox.getModel();
                    MergeOptionPanel.this.gedcomFormatModel.getGedcomInfo(MergeOptionPanel.this.currentGedcomIndex).setOrder(comnoBoxModel.getJuridiction(), comboBox.getSelectedIndex());
                }
            }
        };
        this.comboxBoxMap.put(PlaceFormatModel.RecordJuridiction.CITY_NAME, this.jComboBoxCityName);
        this.comboxBoxMap.put(PlaceFormatModel.RecordJuridiction.CITY_CODE, this.jComboBoxCityCode);
        this.comboxBoxMap.put(PlaceFormatModel.RecordJuridiction.COUNTY, this.jComboBoxCounty);
        this.comboxBoxMap.put(PlaceFormatModel.RecordJuridiction.STATE, this.jComboBoxState);
        this.comboxBoxMap.put(PlaceFormatModel.RecordJuridiction.COUNTRY, this.jComboBoxCountry);
        for (PlaceFormatModel.RecordJuridiction recordJuridiction : this.comboxBoxMap.keySet()) {
            JComboBox<String> combobox = this.comboxBoxMap.get((Object)recordJuridiction);
            combobox.setModel(new PlaceComboBoxModel(recordJuridiction));
            combobox.addItemListener(comboBoxItemListener);
        }
        this.jListGedcomFile.addListSelectionListener(new GedcomListSelectionHandler());
        this.jListGedcomFile.setSelectedIndex(this.currentGedcomIndex);
        if (MergeOption.getSourceScopeCity()) {
            this.jRadioButtonSourceScopeCity.setSelected(true);
        } else {
            this.jRadioButtonSourceScopeRecord.setSelected(true);
        }
        SourceModel sourceModel = SourceModel.getModel();
        this.jTableSource.setModel(sourceModel);
        if (sourceModel.getRowCount() > 0) {
            this.jTableSource.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (currentFile != null && sourceModel.exist(currentFile.getName())) {
            this.jButtonAddSource.setVisible(false);
        } else {
            this.jButtonAddSource.setVisible(true);
        }
    }

    public void loadPreferences() {
        SourceModel.getModel().loadPreferences();
    }

    public void savePreferences() {
        this.gedcomFormatModel.savePreferences(this.currentGedcomIndex);
        MergeOption.setSourceScopeCity(this.jRadioButtonSourceScopeCity.isSelected());
        SourceModel.getModel().savePreferences();
    }

    private void initComponents() {
        this.jButtonGroupSourceScope = new ButtonGroup();
        this.jPanelSimilar = new JPanel();
        this.jButtonSimilarLastNames = new JButton();
        this.jButtonSimilarFirstNames = new JButton();
        this.jPanelPlace = new JPanel();
        this.jLabelCityName = new JLabel();
        this.jLabelCityCode = new JLabel();
        this.jLabelCounty = new JLabel();
        this.jLabelState = new JLabel();
        this.jLabelCountry = new JLabel();
        this.jComboBoxCityName = new JComboBox();
        this.jComboBoxCityCode = new JComboBox();
        this.jComboBoxCounty = new JComboBox();
        this.jComboBoxState = new JComboBox();
        this.jComboBoxCountry = new JComboBox();
        this.jLabelGedcomFile = new JLabel();
        this.jScrollPaneGedcomFile = new JScrollPane();
        this.jListGedcomFile = new JList();
        this.jLabelRecordJuridiction = new JLabel();
        this.jLabelGedcomJuridiction = new JLabel();
        this.jPanelSource = new JPanel();
        this.jScrollPaneSource = new JScrollPane();
        this.jTableSource = new JTable();
        this.jButtonAddSource = new JButton();
        this.jButtonModify = new JButton();
        this.jButtonRemoveSource = new JButton();
        this.jRadioButtonSourceScopeCity = new JRadioButton();
        this.jRadioButtonSourceScopeRecord = new JRadioButton();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jPanel.border.title")));
        this.setMinimumSize(new Dimension(260, 500));
        this.setName("");
        this.setPreferredSize(new Dimension(400, 500));
        this.jPanelSimilar.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jPanelSimilar.border.title")));
        this.jPanelSimilar.setMinimumSize(new Dimension(300, 33));
        this.jButtonSimilarLastNames.setText(NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jButtonSimilarLastNames.text"));
        this.jButtonSimilarLastNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeOptionPanel.this.jButtonSimilarLastNamesActionPerformed(evt);
            }
        });
        this.jButtonSimilarFirstNames.setText(NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jButtonSimilarFirstNames.text"));
        this.jButtonSimilarFirstNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeOptionPanel.this.jButtonSimilarFirstNamesActionPerformed(evt);
            }
        });
        GroupLayout jPanelSimilarLayout = new GroupLayout(this.jPanelSimilar);
        this.jPanelSimilar.setLayout(jPanelSimilarLayout);
        jPanelSimilarLayout.setHorizontalGroup(jPanelSimilarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSimilarLayout.createSequentialGroup().addComponent(this.jButtonSimilarLastNames).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSimilarFirstNames).addGap(0, 0, Short.MAX_VALUE)));
        jPanelSimilarLayout.setVerticalGroup(jPanelSimilarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSimilarLayout.createSequentialGroup().addContainerGap().addGroup(jPanelSimilarLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSimilarLastNames).addComponent(this.jButtonSimilarFirstNames)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelPlace.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jPanelPlace.border.title")));
        this.jPanelPlace.setMinimumSize(new Dimension(200, 100));
        this.jPanelPlace.setOpaque(false);
        this.jPanelPlace.setPreferredSize(new Dimension(300, 230));
        this.jLabelCityName.setText(NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jLabelCityName.text"));
        this.jLabelCityCode.setText(NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jLabelCityCode.text"));
        this.jLabelCounty.setText(NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jLabelCounty.text"));
        this.jLabelState.setText(NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jLabelState.text"));
        this.jLabelCountry.setText(NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jLabelCountry.text"));
        this.jComboBoxCityName.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jLabelGedcomFile.setText(NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jLabelGedcomFile.text"));
        this.jListGedcomFile.setSelectionMode(0);
        this.jScrollPaneGedcomFile.setViewportView(this.jListGedcomFile);
        this.jLabelRecordJuridiction.setText(NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jLabelRecordJuridiction.text"));
        this.jLabelGedcomJuridiction.setText(NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jLabelGedcomJuridiction.text"));
        GroupLayout jPanelPlaceLayout = new GroupLayout(this.jPanelPlace);
        this.jPanelPlace.setLayout(jPanelPlaceLayout);
        jPanelPlaceLayout.setHorizontalGroup(jPanelPlaceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPlaceLayout.createSequentialGroup().addGroup(jPanelPlaceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPlaceLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanelPlaceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelCityName).addComponent(this.jLabelCityCode).addComponent(this.jLabelCounty).addComponent(this.jLabelState).addComponent(this.jLabelCountry)).addGap(50, 50, 50).addGroup(jPanelPlaceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxCityName, GroupLayout.Alignment.TRAILING, -2, 145, -2).addComponent(this.jComboBoxCityCode, GroupLayout.Alignment.TRAILING, -2, 145, -2).addComponent(this.jComboBoxCounty, GroupLayout.Alignment.TRAILING, -2, 145, -2).addComponent(this.jComboBoxState, GroupLayout.Alignment.TRAILING, -2, 145, -2).addComponent(this.jComboBoxCountry, GroupLayout.Alignment.TRAILING, -2, 145, -2))).addGroup(jPanelPlaceLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelRecordJuridiction).addGap(18, 18, 18).addComponent(this.jLabelGedcomJuridiction))).addGap(12, 12, 12).addGroup(jPanelPlaceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelGedcomFile).addComponent(this.jScrollPaneGedcomFile, -2, 0, Short.MAX_VALUE)).addGap(2, 2, 2)));
        jPanelPlaceLayout.setVerticalGroup(jPanelPlaceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPlaceLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(jPanelPlaceLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelRecordJuridiction).addComponent(this.jLabelGedcomJuridiction).addComponent(this.jLabelGedcomFile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelPlaceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPlaceLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jLabelCityName).addGap(14, 14, 14).addComponent(this.jLabelCityCode).addGap(14, 14, 14).addComponent(this.jLabelCounty).addGap(9, 9, 9).addGroup(jPanelPlaceLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelState).addComponent(this.jComboBoxState, -2, -1, -2)).addGap(4, 4, 4).addGroup(jPanelPlaceLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCountry).addComponent(this.jComboBoxCountry, -2, -1, -2))).addGroup(jPanelPlaceLayout.createSequentialGroup().addComponent(this.jComboBoxCityName, -2, -1, -2).addGap(4, 4, 4).addComponent(this.jComboBoxCityCode, -2, -1, -2).addGap(4, 4, 4).addComponent(this.jComboBoxCounty, -2, -1, -2)).addComponent(this.jScrollPaneGedcomFile, -2, 150, -2)).addContainerGap()));
        this.jPanelSource.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jPanelSource.border.title")));
        this.jPanelSource.setPreferredSize(new Dimension(300, 150));
        this.jTableSource.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title1", "Title2"}));
        this.jTableSource.setMaximumSize(new Dimension(Integer.MAX_VALUE, 500));
        this.jTableSource.setMinimumSize(new Dimension(60, 60));
        this.jTableSource.setSelectionMode(0);
        this.jScrollPaneSource.setViewportView(this.jTableSource);
        this.jButtonAddSource.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/edit_add.png")));
        this.jButtonAddSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeOptionPanel.this.jButtonAddSourceActionPerformed(evt);
            }
        });
        this.jButtonModify.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/edit.png")));
        this.jButtonModify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeOptionPanel.this.jButtonModifyActionPerformed(evt);
            }
        });
        this.jButtonRemoveSource.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/edit_delete.png")));
        this.jButtonRemoveSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeOptionPanel.this.jButtonRemoveSourceActionPerformed(evt);
            }
        });
        this.jButtonGroupSourceScope.add(this.jRadioButtonSourceScopeCity);
        this.jRadioButtonSourceScopeCity.setText(NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jRadioButtonSourceScopeCity.text"));
        this.jRadioButtonSourceScopeCity.setToolTipText(NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jRadioButtonSourceScopeCity.tooltip"));
        this.jRadioButtonSourceScopeCity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeOptionPanel.this.jRadioButtonSourceScopeCityActionPerformed(evt);
            }
        });
        this.jButtonGroupSourceScope.add(this.jRadioButtonSourceScopeRecord);
        this.jRadioButtonSourceScopeRecord.setText(NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jRadioButtonSourceScopeRecord.text"));
        this.jRadioButtonSourceScopeRecord.setToolTipText(NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jRadioButtonSourceScopeRecord.tooltip"));
        this.jRadioButtonSourceScopeRecord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeOptionPanel.this.jRadioButtonSourceScopeRecordActionPerformed(evt);
            }
        });
        GroupLayout jPanelSourceLayout = new GroupLayout(this.jPanelSource);
        this.jPanelSource.setLayout(jPanelSourceLayout);
        jPanelSourceLayout.setHorizontalGroup(jPanelSourceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSourceLayout.createSequentialGroup().addGroup(jPanelSourceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSourceLayout.createSequentialGroup().addComponent(this.jScrollPaneSource, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelSourceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAddSource, GroupLayout.Alignment.TRAILING).addComponent(this.jButtonModify, GroupLayout.Alignment.TRAILING).addComponent(this.jButtonRemoveSource, GroupLayout.Alignment.TRAILING))).addGroup(jPanelSourceLayout.createSequentialGroup().addComponent(this.jRadioButtonSourceScopeCity).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSourceScopeRecord).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelSourceLayout.setVerticalGroup(jPanelSourceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSourceLayout.createSequentialGroup().addGap(7, 7, 7).addGroup(jPanelSourceLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonSourceScopeCity).addComponent(this.jRadioButtonSourceScopeRecord)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelSourceLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelSourceLayout.createSequentialGroup().addComponent(this.jButtonAddSource).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonModify).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRemoveSource)).addComponent(this.jScrollPaneSource, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelPlace, GroupLayout.Alignment.TRAILING, -1, 390, Short.MAX_VALUE).addComponent(this.jPanelSource, GroupLayout.Alignment.TRAILING, -2, 390, Short.MAX_VALUE).addComponent(this.jPanelSimilar, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanelSimilar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelPlace, -2, 218, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelSource, -2, 160, -2).addContainerGap(15, Short.MAX_VALUE)));
    }

    private void jButtonAddSourceActionPerformed(ActionEvent evt) {
        if (this.currentFile != null && !this.currentFile.getName().isEmpty()) {
            Source newSource = RecordSourceConfigDialog.show(this.parent, this.currentFile.getName(), "");
            if (newSource != null) {
                SourceModel.getModel().add(this.currentFile.getName(), newSource.getTitle());
                int index = this.jTableSource.convertRowIndexToView(SourceModel.getModel().getRowCount() - 1);
                this.jTableSource.getSelectionModel().setSelectionInterval(index, index);
            }
        } else {
            String message = NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.message.FirstSaveFile");
            String title = NbBundle.getMessage(MergeOptionPanel.class, (String)"MergeOptionPanel.jPanelSource.border.title");
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this, message, title, 0);
        }
    }

    private void jButtonRemoveSourceActionPerformed(ActionEvent evt) {
        if (this.jTableSource.getSelectedRow() != -1) {
            SourceModel.getModel().remove(this.jTableSource.convertRowIndexToModel(this.jTableSource.getSelectedRow()));
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        if (this.jTableSource.getSelectedRow() != -1) {
            String sourceName;
            int index = this.jTableSource.convertRowIndexToModel(this.jTableSource.getSelectedRow());
            String fileName = (String)SourceModel.getModel().getValueAt(index, 0);
            Source newSource = RecordSourceConfigDialog.show(this.parent, fileName, sourceName = (String)SourceModel.getModel().getValueAt(index, 1));
            if (newSource != null) {
                SourceModel.getModel().modify(index, newSource.getTitle());
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void jButtonSimilarFirstNamesActionPerformed(ActionEvent evt) {
        SimilarNameDialog.showSimilarFirstNamePanel();
    }

    private void jButtonSimilarLastNamesActionPerformed(ActionEvent evt) {
        SimilarNameDialog.showSimilarLastNamePanel();
    }

    private void jButtonShowGedcomJuridictionsActionPerformed(ActionEvent evt) {
    }

    private void jRadioButtonSourceScopeCityActionPerformed(ActionEvent evt) {
    }

    private void jRadioButtonSourceScopeRecordActionPerformed(ActionEvent evt) {
    }

    public static class GedcomFormatModel
    extends AbstractListModel<String>
    implements ListModel<String> {
        public GedcomInfo[] gedcomInfoArray = null;
        public int defaultGedcom = -1;

        public GedcomFormatModel() {
            String dgn = PlaceFormatModel.loadDefaultGedcomName();
            List contexts = GedcomDirectory.getDefault().getContexts();
            this.gedcomInfoArray = new GedcomInfo[contexts.size()];
            for (int i = 0; i < contexts.size(); ++i) {
                Gedcom gedcom = ((Context)contexts.get(i)).getGedcom();
                String gedcomName = gedcom.getName();
                String placeFormat = gedcom.getPlaceFormat();
                this.gedcomInfoArray[i] = new GedcomInfo(gedcom, placeFormat, new PlaceFormatModel(gedcomName));
                if (!dgn.equals(gedcomName)) continue;
                this.defaultGedcom = i;
            }
            if (this.defaultGedcom == -1 && this.gedcomInfoArray.length > 0) {
                this.defaultGedcom = 0;
            }
        }

        @Override
        public int getSize() {
            return this.gedcomInfoArray.length;
        }

        @Override
        public String getElementAt(int index) {
            if (index >= 0 && index < this.gedcomInfoArray.length) {
                return this.gedcomInfoArray[index].getGedcomName();
            }
            return "";
        }

        public String[] getGedcomPlaceFormatList(int index) {
            if (index >= 0 && index < this.gedcomInfoArray.length) {
                return this.gedcomInfoArray[index].getPlaceFormatList();
            }
            return new String[0];
        }

        public GedcomInfo getDefaultGedcomInfo() {
            return this.gedcomInfoArray == null ? null : this.gedcomInfoArray[this.defaultGedcom];
        }

        public GedcomInfo getGedcomInfo(int index) {
            return index < 0 || index >= this.gedcomInfoArray.length ? null : this.gedcomInfoArray[index];
        }

        private void savePreferences(int index) {
            if (index == -1) {
                return;
            }
            this.defaultGedcom = index;
            for (GedcomInfo info : this.gedcomInfoArray) {
                info.getPlaceFormatModel().savePreferences(info.getOrder(PlaceFormatModel.RecordJuridiction.CITY_NAME), info.getOrder(PlaceFormatModel.RecordJuridiction.CITY_CODE), info.getOrder(PlaceFormatModel.RecordJuridiction.COUNTY), info.getOrder(PlaceFormatModel.RecordJuridiction.STATE), info.getOrder(PlaceFormatModel.RecordJuridiction.COUNTRY), info.getNbJuridictions());
            }
            PlaceFormatModel.saveDefaultGedcomName(this.getDefaultGedcomInfo().gedcomName);
        }
    }

    public class PlaceComboBoxModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        String selection = null;
        private final PlaceFormatModel.RecordJuridiction juridiction;

        PlaceComboBoxModel(PlaceFormatModel.RecordJuridiction juridiction) {
            this.juridiction = juridiction;
        }

        PlaceFormatModel.RecordJuridiction getJuridiction() {
            return this.juridiction;
        }

        @Override
        public int getSize() {
            return MergeOptionPanel.this.gedcomFormatModel.getGedcomInfo(MergeOptionPanel.this.currentGedcomIndex) != null ? MergeOptionPanel.this.gedcomFormatModel.getGedcomInfo(MergeOptionPanel.this.currentGedcomIndex).getNbJuridictions() + 1 : 0;
        }

        @Override
        public String getElementAt(int index) {
            if (MergeOptionPanel.this.gedcomFormatModel.getGedcomInfo(MergeOptionPanel.this.currentGedcomIndex) == null) {
                return "";
            }
            if (index >= 0 && index < MergeOptionPanel.this.gedcomFormatModel.getGedcomInfo(MergeOptionPanel.this.currentGedcomIndex).getNbJuridictions()) {
                return String.valueOf(index + 1) + " - " + MergeOptionPanel.this.gedcomFormatModel.getGedcomInfo(MergeOptionPanel.this.currentGedcomIndex).getPlaceFormatList()[index].trim().replaceAll("_", " ");
            }
            return "";
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selection = anItem != null ? anItem.toString() : "";
        }

        @Override
        public String getSelectedItem() {
            return this.selection;
        }
    }

    public class GedcomListSelectionHandler
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (MergeOptionPanel.this.jListGedcomFile.getSelectedIndex() == -1) {
                return;
            }
            MergeOptionPanel.this.currentGedcomIndex = MergeOptionPanel.this.jListGedcomFile.getSelectedIndex();
            for (PlaceFormatModel.RecordJuridiction recordJuridiction : MergeOptionPanel.this.comboxBoxMap.keySet()) {
                JComboBox<String> combobox = MergeOptionPanel.this.comboxBoxMap.get((Object)recordJuridiction);
                combobox.setModel(new PlaceComboBoxModel(recordJuridiction));
                int juridictionOrder = MergeOptionPanel.this.gedcomFormatModel.getGedcomInfo(MergeOptionPanel.this.currentGedcomIndex).getOrder(recordJuridiction);
                if (juridictionOrder >= 0 && juridictionOrder < combobox.getItemCount()) {
                    combobox.setSelectedIndex(juridictionOrder);
                    continue;
                }
                combobox.setSelectedIndex(-1);
            }
        }
    }

    public static class SourceModel
    extends AbstractTableModel {
        static final String SOURCE_PREFERENCE = "RecordSource";
        private static SourceModel sourceModel = null;
        final String[] columnName = new String[]{NbBundle.getMessage(SourceModel.class, (String)"MergeOptionPanel.column.title.file"), NbBundle.getMessage(SourceModel.class, (String)"MergeOptionPanel.column.title.source")};
        final Class<?>[] columnClass = new Class[]{String.class, String.class};
        private final ArrayList<SourceModelElement> sourceList = new ArrayList();

        public static SourceModel getModel() {
            if (sourceModel == null) {
                sourceModel = new SourceModel();
                sourceModel.loadPreferences();
            }
            return sourceModel;
        }

        private void loadPreferences() {
            String[] arrayData;
            this.sourceList.clear();
            String stringData = NbPreferences.forModule(SourceModel.class).get(SOURCE_PREFERENCE, "");
            for (String arrayData1 : arrayData = stringData.split(";")) {
                String[] item;
                if (arrayData1.isEmpty() || (item = arrayData1.split("=")).length != 2) continue;
                this.sourceList.add(new SourceModelElement(item[0], item[1]));
            }
        }

        public void savePreferences() {
            StringBuilder values = new StringBuilder();
            for (SourceModelElement element : this.sourceList) {
                values.append(element.fileName).append("=").append(element.sourceName).append(";");
            }
            NbPreferences.forModule(SourceModel.class).put(SOURCE_PREFERENCE, values.toString());
        }

        public void add(String fileName, String sourceName) {
            int index = this.index(fileName);
            if (index != -1) {
                this.sourceList.get((int)index).sourceName = sourceName;
                this.fireTableRowsUpdated(index, index);
            } else {
                this.sourceList.add(new SourceModelElement(fileName, sourceName));
                index = this.sourceList.size() - 1;
                this.fireTableRowsInserted(index, index);
            }
        }

        public void remove(int index) {
            this.sourceList.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public void modify(int index, String sourceName) {
            this.sourceList.get((int)index).sourceName = sourceName;
            this.fireTableRowsUpdated(index, index);
        }

        public int index(String fileName) {
            for (int i = 0; i < this.sourceList.size(); ++i) {
                if (!this.sourceList.get((int)i).fileName.equalsIgnoreCase(fileName)) continue;
                return i;
            }
            return -1;
        }

        public boolean exist(String fileName) {
            return this.index(fileName) != -1;
        }

        public String getSource(String fileName) {
            if (fileName != null && !fileName.isEmpty()) {
                int index = this.index(fileName);
                if (index != -1) {
                    return this.sourceList.get((int)index).sourceName;
                }
                return "";
            }
            return "";
        }

        @Override
        public String getColumnName(int col) {
            return this.columnName[col];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.columnClass[col];
        }

        @Override
        public int getRowCount() {
            return this.sourceList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnClass.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.sourceList.get((int)rowIndex).fileName;
                }
            }
            return this.sourceList.get((int)rowIndex).sourceName;
        }
    }

    private static class SourceModelElement {
        public String fileName;
        public String sourceName;

        public SourceModelElement(String fileName, String sourceName) {
            this.fileName = fileName;
            this.sourceName = sourceName;
        }
    }

    public static class GedcomInfo {
        private final String gedcomName;
        private final String[] placeFormatList;
        private final PlaceFormatModel placeFormatModel;
        private final HashMap<PlaceFormatModel.RecordJuridiction, Integer> juridictionOrder = new HashMap();

        public GedcomInfo(Gedcom gedcom, String placeFormat, PlaceFormatModel placeFormatModel) {
            this.gedcomName = gedcom.getName();
            this.placeFormatList = placeFormat.split(",", -1);
            this.placeFormatModel = placeFormatModel;
            Integer cityTagIndex = PropertyPlace.getCityTagIndex((Gedcom)gedcom);
            Integer countryTagIndex = PropertyPlace.getCountryTagIndex((Gedcom)gedcom);
            Integer cityCodeIndex = cityTagIndex != -1 ? cityTagIndex + 1 : -1;
            Integer countyIndex = cityTagIndex != -1 ? cityTagIndex + 2 : -1;
            Integer stateIndex = cityTagIndex != -1 ? cityTagIndex + 3 : -1;
            this.juridictionOrder.put(PlaceFormatModel.RecordJuridiction.CITY_NAME, placeFormatModel.getCityNameJuridiction() != -1 ? placeFormatModel.getCityNameJuridiction() : cityTagIndex.intValue());
            this.juridictionOrder.put(PlaceFormatModel.RecordJuridiction.CITY_CODE, placeFormatModel.getCityCodeJuridiction() != -1 ? placeFormatModel.getCityCodeJuridiction() : cityCodeIndex.intValue());
            this.juridictionOrder.put(PlaceFormatModel.RecordJuridiction.COUNTY, placeFormatModel.getCountyJuridiction() != -1 ? placeFormatModel.getCountyJuridiction() : countyIndex.intValue());
            this.juridictionOrder.put(PlaceFormatModel.RecordJuridiction.STATE, placeFormatModel.getStateJuridiction() != -1 ? placeFormatModel.getStateJuridiction() : stateIndex.intValue());
            this.juridictionOrder.put(PlaceFormatModel.RecordJuridiction.COUNTRY, placeFormatModel.getCountryJuridiction() != -1 ? placeFormatModel.getCountryJuridiction() : countryTagIndex.intValue());
        }

        public int getNbJuridictions() {
            return this.placeFormatList.length;
        }

        public PlaceFormatModel getPlaceFormatModel() {
            return this.placeFormatModel;
        }

        public String getGedcomName() {
            return this.gedcomName;
        }

        public String[] getPlaceFormatList() {
            return this.placeFormatList;
        }

        public int getOrder(PlaceFormatModel.RecordJuridiction juridiction) {
            return this.juridictionOrder.get((Object)juridiction);
        }

        public void setOrder(PlaceFormatModel.RecordJuridiction juridiction, int order) {
            this.juridictionOrder.put(juridiction, order);
        }
    }
}

