/************************************************************************
 *
 * Copyright (C) 2023-2024 IRCAD France
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

// This file was automatically generated by the '/lib/core/data/dicom/class_generator.py' script. DO NOT EDIT !
// Used arguments: 'Namespace(verbose=False, source_url='http://dicom.nema.org/medical/dicom/current/source/docbook',
// sop_list=None, mandatory_tags=[Tag(group='7FE0', element='0010'), Tag(group='0062', element='0002'),
// Tag(group='0066', element='0002'), Tag(group='0066', element='0011'), Tag(group='0070', element='031C')])'

#pragma once

#include <sight/data/config.hpp>

#include <cstdint>
#include <string_view>

// cspell: ignore Wundefined afterloader angio autorefraction autosequence boli bscan cadsr ciexy ctdi ctdivol decf
// cspell: ignore deidentification dermoscopic diconde dicos dvhroi exif fiducials fluence fnumber frameof gpsdop hicpp
// cspell: ignore hpgl imager inms inua inus iods isop ivol ivus keratoconus keratometer keratometric kerma lensometry
// cspell: ignore lookat meterset metersets mrfov multiway nmpet nmtomo nolintbegin nolintend octb octz oecf olink
// cspell: ignore postamble powerline prcs presaturation radiofluoroscopic relaxivity reprojection rgblut rtdvh rtroi
// cspell: ignore sddn sdhn sdvn softcopy soundpath stereometric stowrs tlhc tomo tomosynthesis tomotherapeutic toric
// cspell: ignore tractography xaxrf Ascan Framek

// NOLINTBEGIN

namespace sight::data::dicom::attribute
{

enum class Keyword : std::uint16_t
{
    INVALID = 0,
    SpecificCharacterSet,
    LanguageCodeSequence,
    ImageType,
    InstanceCreationDate,
    InstanceCreationTime,
    InstanceCreatorUID,
    InstanceCoercionDateTime,
    sop_classUID,
    AcquisitionUID,
    SOPInstanceUID,
    PyramidUID,
    RelatedGeneralsop_classUID,
    OriginalSpecializedsop_classUID,
    StudyDate,
    SeriesDate,
    AcquisitionDate,
    ContentDate,
    AcquisitionDateTime,
    StudyTime,
    SeriesTime,
    AcquisitionTime,
    ContentTime,
    AccessionNumber,
    IssuerOfAccessionNumberSequence,
    QueryRetrieveView,
    RetrieveAETitle,
    StationAETitle,
    Modality,
    ConversionType,
    PresentationIntentType,
    Manufacturer,
    InstitutionName,
    InstitutionAddress,
    InstitutionCodeSequence,
    ReferringPhysicianName,
    ReferringPhysicianIdentificationSequence,
    ConsultingPhysicianName,
    ConsultingPhysicianIdentificationSequence,
    CodeValue,
    CodingSchemeDesignator,
    CodingSchemeVersion,
    CodeMeaning,
    MappingResource,
    ContextGroupVersion,
    ContextGroupLocalVersion,
    CodingSchemeResourcesSequence,
    ContextGroupExtensionFlag,
    CodingSchemeUID,
    ContextGroupExtensionCreatorUID,
    ContextIdentifier,
    CodingSchemeIdentificationSequence,
    CodingSchemeRegistry,
    CodingSchemeExternalID,
    CodingSchemeName,
    CodingSchemeResponsibleOrganization,
    ContextUID,
    MappingResourceUID,
    LongCodeValue,
    URNCodeValue,
    EquivalentCodeSequence,
    MappingResourceName,
    ContextGroupIdentificationSequence,
    MappingResourceIdentificationSequence,
    TimezoneOffsetFromUTC,
    ResponsibleGroupCodeSequence,
    PrivateDataElementCharacteristicsSequence,
    PrivateGroupReference,
    PrivateCreatorReference,
    BlockIdentifyingInformationStatus,
    NonidentifyingPrivateElements,
    DeidentificationActionSequence,
    PrivateDataElementDefinitionSequence,
    StationName,
    StudyDescription,
    ProcedureCodeSequence,
    SeriesDescription,
    SeriesDescriptionCodeSequence,
    InstitutionalDepartmentName,
    InstitutionalDepartmentTypeCodeSequence,
    PhysiciansOfRecord,
    PhysiciansOfRecordIdentificationSequence,
    PerformingPhysicianName,
    PerformingPhysicianIdentificationSequence,
    NameOfPhysiciansReadingStudy,
    PhysiciansReadingStudyIdentificationSequence,
    OperatorsName,
    OperatorIdentificationSequence,
    AdmittingDiagnosesDescription,
    AdmittingDiagnosesCodeSequence,
    PyramidDescription,
    ManufacturerModelName,
    ReferencedStudySequence,
    ReferencedPerformedProcedureStepSequence,
    ReferencedSeriesSequence,
    ReferencedPatientSequence,
    ReferencedStereometricInstanceSequence,
    ReferencedWaveformSequence,
    ReferencedImageSequence,
    ReferencedInstanceSequence,
    ReferencedRealWorldValueMappingInstanceSequence,
    ReferencedSOPClassUID,
    ReferencedSOPInstanceUID,
    DefinitionSourceSequence,
    ReferencedFrameNumber,
    SimpleFrameList,
    CalculatedFrameList,
    TimeRange,
    FrameExtractionSequence,
    MultiFrameSourceSOPInstanceUID,
    RetrieveURL,
    ReferencedSOPSequence,
    StudiesContainingOtherReferencedInstancesSequence,
    RelatedSeriesSequence,
    DerivationDescription,
    SourceImageSequence,
    StageName,
    StageNumber,
    NumberOfStages,
    ViewName,
    ViewNumber,
    NumberOfEventTimers,
    NumberOfViewsInStage,
    EventElapsedTimes,
    EventTimerNames,
    EventTimerSequence,
    EventTimeOffset,
    EventCodeSequence,
    StartTrim,
    StopTrim,
    RecommendedDisplayFrameRate,
    AnatomicRegionSequence,
    AnatomicRegionModifierSequence,
    PrimaryAnatomicStructureSequence,
    PrimaryAnatomicStructureModifierSequence,
    IrradiationEventUID,
    SourceIrradiationEventSequence,
    RadiopharmaceuticalAdministrationEventUID,
    FrameType,
    ReferencedImageEvidenceSequence,
    ReferencedRawDataSequence,
    DerivationImageSequence,
    SourceImageEvidenceSequence,
    PixelPresentation,
    VolumetricProperties,
    VolumeBasedCalculationTechnique,
    ComplexImageComponent,
    AcquisitionContrast,
    DerivationCodeSequence,
    ReferencedPresentationStateSequence,
    ReferencedOtherPlaneSequence,
    FrameDisplaySequence,
    RecommendedDisplayFrameRateInFloat,
    SkipFrameRangeFlag,
    PatientName,
    PatientID,
    IssuerOfPatientID,
    TypeOfPatientID,
    IssuerOfPatientIDQualifiersSequence,
    SourcePatientGroupIdentificationSequence,
    GroupOfPatientsIdentificationSequence,
    SubjectRelativePositionInImage,
    PatientBirthDate,
    PatientBirthTime,
    PatientBirthDateInAlternativeCalendar,
    PatientDeathDateInAlternativeCalendar,
    PatientAlternativeCalendar,
    PatientSex,
    QualityControlSubject,
    StrainDescription,
    StrainNomenclature,
    StrainStockNumber,
    StrainSourceRegistryCodeSequence,
    StrainStockSequence,
    StrainSource,
    StrainAdditionalInformation,
    StrainCodeSequence,
    GeneticModificationsSequence,
    GeneticModificationsDescription,
    GeneticModificationsNomenclature,
    GeneticModificationsCodeSequence,
    OtherPatientNames,
    OtherPatientIDsSequence,
    PatientAge,
    PatientSize,
    PatientSizeCodeSequence,
    PatientBodyMassIndex,
    MeasuredAPDimension,
    MeasuredLateralDimension,
    PatientWeight,
    ReferencedPatientPhotoSequence,
    MedicalAlerts,
    Allergies,
    EthnicGroup,
    Occupation,
    SmokingStatus,
    AdditionalPatientHistory,
    PregnancyStatus,
    LastMenstrualDate,
    PatientSpeciesDescription,
    PatientSpeciesCodeSequence,
    PatientSexNeutered,
    AnatomicalOrientationType,
    PatientBreedDescription,
    PatientBreedCodeSequence,
    BreedRegistrationSequence,
    BreedRegistrationNumber,
    BreedRegistryCodeSequence,
    ResponsiblePerson,
    ResponsiblePersonRole,
    ResponsibleOrganization,
    PatientComments,
    ExaminedBodyThickness,
    ClinicalTrialSponsorName,
    ClinicalTrialProtocolID,
    ClinicalTrialProtocolName,
    ClinicalTrialSiteID,
    ClinicalTrialSiteName,
    ClinicalTrialSubjectID,
    ClinicalTrialSubjectReadingID,
    ClinicalTrialTimePointID,
    ClinicalTrialTimePointDescription,
    LongitudinalTemporalOffsetFromEvent,
    LongitudinalTemporalEventType,
    ClinicalTrialTimePointTypeCodeSequence,
    ClinicalTrialCoordinatingCenterName,
    PatientIdentityRemoved,
    DeidentificationMethod,
    DeidentificationMethodCodeSequence,
    ClinicalTrialSeriesID,
    ClinicalTrialSeriesDescription,
    ClinicalTrialProtocolEthicsCommitteeName,
    ClinicalTrialProtocolEthicsCommitteeApprovalNumber,
    ConsentForClinicalTrialUseSequence,
    DistributionType,
    ConsentForDistributionFlag,
    WhitePoint,
    PrimaryChromaticities,
    BatteryLevel,
    ExposureTimeInSeconds,
    FNumber,
    OECFRows,
    OECFColumns,
    OECFColumnNames,
    OECFValues,
    SpatialFrequencyResponseRows,
    SpatialFrequencyResponseColumns,
    SpatialFrequencyResponseColumnNames,
    SpatialFrequencyResponseValues,
    ColorFilterArrayPatternRows,
    ColorFilterArrayPatternColumns,
    ColorFilterArrayPatternValues,
    FlashFiringStatus,
    FlashReturnStatus,
    FlashMode,
    FlashFunctionPresent,
    FlashRedEyeMode,
    ExposureProgram,
    SpectralSensitivity,
    PhotographicSensitivity,
    SelfTimerMode,
    SensitivityType,
    StandardOutputSensitivity,
    RecommendedExposureIndex,
    ISOSpeed,
    ISOSpeedLatitudeyyy,
    ISOSpeedLatitudezzz,
    EXIFVersion,
    ShutterSpeedValue,
    ApertureValue,
    BrightnessValue,
    ExposureBiasValue,
    MaxApertureValue,
    SubjectDistance,
    MeteringMode,
    LightSource,
    FocalLength,
    SubjectArea,
    MakerNote,
    Temperature,
    Humidity,
    Pressure,
    WaterDepth,
    Acceleration,
    CameraElevationAngle,
    FlashEnergy,
    SubjectLocation,
    PhotographicExposureIndex,
    SensingMethod,
    FileSource,
    SceneType,
    CustomRendered,
    ExposureMode,
    WhiteBalance,
    DigitalZoomRatio,
    FocalLengthIn35mmFilm,
    SceneCaptureType,
    GainControl,
    Contrast,
    Saturation,
    Sharpness,
    DeviceSettingDescription,
    SubjectDistanceRange,
    CameraOwnerName,
    LensSpecification,
    LensMake,
    LensModel,
    LensSerialNumber,
    InteroperabilityIndex,
    InteroperabilityVersion,
    GPSVersionID,
    GPSLatitudeRef,
    GPSLatitude,
    GPSLongitudeRef,
    GPSLongitude,
    GPSAltitudeRef,
    GPSAltitude,
    GPSTimeStamp,
    GPSSatellites,
    GPstatus,
    GPSMeasureMode,
    GPSDOP,
    GPSSpeedRef,
    GPSSpeed,
    GPSTrackRef,
    GPSTrack,
    GPSImgDirectionRef,
    GPSImgDirection,
    GPSMapDatum,
    GPSDestLatitudeRef,
    GPSDestLatitude,
    GPSDestLongitudeRef,
    GPSDestLongitude,
    GPSDestBearingRef,
    GPSDestBearing,
    GPSDestDistanceRef,
    GPSDestDistance,
    GPSProcessingMethod,
    GPSAreaInformation,
    GPSDateStamp,
    GPSDifferential,
    LightSourcePolarization,
    EmitterColorTemperature,
    ContactMethod,
    ImmersionMedia,
    OpticalMagnificationFactor,
    ContrastBolusAgent,
    ContrastBolusAgentSequence,
    ContrastBolusT1Relaxivity,
    ContrastBolusAdministrationRouteSequence,
    BodyPartExamined,
    ScanningSequence,
    SequenceVariant,
    ScanOptions,
    MRAcquisitionType,
    SequenceName,
    AngioFlag,
    InterventionDrugInformationSequence,
    InterventionDrugStopTime,
    InterventionDrugDose,
    InterventionDrugCodeSequence,
    AdditionalDrugSequence,
    Radiopharmaceutical,
    InterventionDrugName,
    InterventionDrugStartTime,
    InterventionSequence,
    InterventionStatus,
    InterventionDescription,
    CineRate,
    InitialCineRunState,
    SliceThickness,
    KVP,
    CountsAccumulated,
    AcquisitionTerminationCondition,
    EffectiveDuration,
    AcquisitionStartCondition,
    AcquisitionStartConditionData,
    AcquisitionTerminationConditionData,
    RepetitionTime,
    EchoTime,
    InversionTime,
    NumberOfAverages,
    ImagingFrequency,
    ImagedNucleus,
    EchoNumbers,
    MagneticFieldStrength,
    SpacingBetweenSlices,
    NumberOfPhaseEncodingSteps,
    DataCollectionDiameter,
    EchoTrainLength,
    PercentSampling,
    PercentPhaseFieldOfView,
    PixelBandwidth,
    DeviceSerialNumber,
    DeviceUID,
    DeviceID,
    PlateID,
    GeneratorID,
    GridID,
    CassetteID,
    GantryID,
    UniqueDeviceIdentifier,
    UDISequence,
    ManufacturerDeviceClassUID,
    SecondaryCaptureDeviceID,
    DateOfSecondaryCapture,
    TimeOfSecondaryCapture,
    SecondaryCaptureDeviceManufacturer,
    SecondaryCaptureDeviceManufacturerModelName,
    SecondaryCaptureDeviceSoftwareVersions,
    SoftwareVersions,
    VideoImageFormatAcquired,
    DigitalImageFormatAcquired,
    ProtocolName,
    ContrastBolusRoute,
    ContrastBolusVolume,
    ContrastBolusStartTime,
    ContrastBolusStopTime,
    ContrastBolusTotalDose,
    ContrastFlowRate,
    ContrastFlowDuration,
    ContrastBolusIngredient,
    ContrastBolusIngredientConcentration,
    SpatialResolution,
    TriggerTime,
    TriggerSourceOrType,
    NominalInterval,
    FrameTime,
    CardiacFramingType,
    FrameTimeVector,
    FrameDelay,
    ImageTriggerDelay,
    SynchronizationTrigger,
    SynchronizationChannel,
    RadiopharmaceuticalRoute,
    RadiopharmaceuticalVolume,
    RadiopharmaceuticalStartTime,
    RadiopharmaceuticalStopTime,
    RadionuclideTotalDose,
    RadionuclideHalfLife,
    RadionuclidePositronFraction,
    RadiopharmaceuticalSpecificActivity,
    RadiopharmaceuticalStartDateTime,
    RadiopharmaceuticalStopDateTime,
    BeatRejectionFlag,
    LowRRValue,
    HighRRValue,
    IntervalsAcquired,
    IntervalsRejected,
    PVCRejection,
    SkipBeats,
    HeartRate,
    CardiacNumberOfImages,
    TriggerWindow,
    ReconstructionDiameter,
    DistanceSourceToDetector,
    DistanceSourceToPatient,
    EstimatedRadiographicMagnificationFactor,
    GantryDetectorTilt,
    GantryDetectorSlew,
    TableHeight,
    TableTraverse,
    TableMotion,
    TableVerticalIncrement,
    TableLateralIncrement,
    TableLongitudinalIncrement,
    TableAngle,
    TableType,
    RotationDirection,
    RadialPosition,
    ScanArc,
    AngularStep,
    CenterOfRotationOffset,
    FieldOfViewShape,
    FieldOfViewDimensions,
    ExposureTime,
    XRayTubeCurrent,
    Exposure,
    ExposureInuAs,
    AveragePulseWidth,
    RadiationSetting,
    RectificationType,
    RadiationMode,
    ImageAndFluoroscopyAreaDoseProduct,
    FilterType,
    TypeOfFilters,
    IntensifierSize,
    ImagerPixelSpacing,
    Grid,
    GeneratorPower,
    CollimatorGridName,
    CollimatorType,
    FocalDistance,
    XFocusCenter,
    YFocusCenter,
    FocalSpots,
    AnodeTargetMaterial,
    BodyPartThickness,
    CompressionForce,
    CompressionPressure,
    PaddleDescription,
    CompressionContactArea,
    DateOfLastCalibration,
    TimeOfLastCalibration,
    DateOfManufacture,
    DateOfInstallation,
    ConvolutionKernel,
    ActualFrameDuration,
    CountRate,
    PreferredPlaybackSequencing,
    ReceiveCoilName,
    TransmitCoilName,
    PlateType,
    PhosphorType,
    WaterEquivalentDiameter,
    WaterEquivalentDiameterCalculationMethodCodeSequence,
    ScanVelocity,
    WholeBodyTechnique,
    ScanLength,
    AcquisitionMatrix,
    InPlanePhaseEncodingDirection,
    FlipAngle,
    VariableFlipAngleFlag,
    SAR,
    dBdt,
    B1rms,
    AcquisitionDeviceProcessingDescription,
    AcquisitionDeviceProcessingCode,
    CassetteOrientation,
    CassetteSize,
    ExposuresOnPlate,
    RelativeXRayExposure,
    ExposureIndex,
    TargetExposureIndex,
    DeviationIndex,
    ColumnAngulation,
    TomoLayerHeight,
    TomoAngle,
    TomoTime,
    TomoType,
    TomoClass,
    NumberOfTomosynthesisSourceImages,
    PositionerMotion,
    PositionerType,
    PositionerPrimaryAngle,
    PositionerSecondaryAngle,
    PositionerPrimaryAngleIncrement,
    PositionerSecondaryAngleIncrement,
    DetectorPrimaryAngle,
    DetectorSecondaryAngle,
    ShutterShape,
    ShutterLeftVerticalEdge,
    ShutterRightVerticalEdge,
    ShutterUpperHorizontalEdge,
    ShutterLowerHorizontalEdge,
    CenterOfCircularShutter,
    RadiusOfCircularShutter,
    VerticesOfThePolygonalShutter,
    ShutterPresentationValue,
    ShutterOverlayGroup,
    ShutterPresentationColorCIELabValue,
    OutlineShapeType,
    OutlineLeftVerticalEdge,
    OutlineRightVerticalEdge,
    OutlineUpperHorizontalEdge,
    OutlineLowerHorizontalEdge,
    CenterOfCircularOutline,
    DiameterOfCircularOutline,
    NumberOfPolygonalVertices,
    VerticesOfThePolygonalOutline,
    CollimatorShape,
    CollimatorLeftVerticalEdge,
    CollimatorRightVerticalEdge,
    CollimatorUpperHorizontalEdge,
    CollimatorLowerHorizontalEdge,
    CenterOfCircularCollimator,
    RadiusOfCircularCollimator,
    VerticesOfThePolygonalCollimator,
    AcquisitionTimeSynchronized,
    TimeSource,
    TimeDistributionProtocol,
    NTPSourceAddress,
    PageNumberVector,
    FrameLabelVector,
    FramePrimaryAngleVector,
    FrameSecondaryAngleVector,
    SliceLocationVector,
    DisplayWindowLabelVector,
    NominalScannedPixelSpacing,
    DigitizingDeviceTransportDirection,
    RotationOfScannedFilm,
    BiopsyTargetSequence,
    TargetUID,
    LocalizingCursorPosition,
    CalculatedTargetPosition,
    TargetLabel,
    DisplayedZValue,
    IVUSAcquisition,
    IVUSPullbackRate,
    IVUSGatedRate,
    IVUSPullbackStartFrameNumber,
    IVUSPullbackStopFrameNumber,
    LesionNumber,
    OutputPower,
    TransducerData,
    TransducerIdentificationSequence,
    FocusDepth,
    ProcessingFunction,
    MechanicalIndex,
    BoneThermalIndex,
    CranialThermalIndex,
    SoftTissueThermalIndex,
    SoftTissueFocusThermalIndex,
    SoftTissueSurfaceThermalIndex,
    DepthOfScanField,
    PatientPosition,
    ViewPosition,
    ProjectionEponymousNameCodeSequence,
    Sensitivity,
    SequenceOfUltrasoundRegions,
    RegionSpatialFormat,
    RegionDataType,
    RegionFlags,
    RegionLocationMinX0,
    RegionLocationMinY0,
    RegionLocationMaxX1,
    RegionLocationMaxY1,
    ReferencePixelX0,
    ReferencePixelY0,
    PhysicalUnitsXDirection,
    PhysicalUnitsYDirection,
    ReferencePixelPhysicalValueX,
    ReferencePixelPhysicalValueY,
    PhysicalDeltaX,
    PhysicalDeltaY,
    TransducerFrequency,
    TransducerType,
    PulseRepetitionFrequency,
    DopplerCorrectionAngle,
    SteeringAngle,
    DopplerSampleVolumeXPosition,
    DopplerSampleVolumeYPosition,
    TMLinePositionX0,
    TMLinePositionY0,
    TMLinePositionX1,
    TMLinePositionY1,
    PixelComponentOrganization,
    PixelComponentMask,
    PixelComponentRangeStart,
    PixelComponentRangeStop,
    PixelComponentPhysicalUnits,
    PixelComponentDataType,
    NumberOfTableBreakPoints,
    TableOfXBreakPoints,
    TableOfYBreakPoints,
    NumberOfTableEntries,
    TableOfPixelValues,
    TableOfParameterValues,
    RWaveTimeVector,
    ActiveImageAreaOverlayGroup,
    DetectorConditionsNominalFlag,
    DetectorTemperature,
    DetectorType,
    DetectorConfiguration,
    DetectorDescription,
    DetectorMode,
    DetectorID,
    DateOfLastDetectorCalibration,
    TimeOfLastDetectorCalibration,
    ExposuresOnDetectorSinceLastCalibration,
    ExposuresOnDetectorSinceManufactured,
    DetectorTimeSinceLastExposure,
    DetectorActiveTime,
    DetectorActivationOffsetFromExposure,
    DetectorBinning,
    DetectorElementPhysicalSize,
    DetectorElementSpacing,
    DetectorActiveShape,
    DetectorActiveDimensions,
    DetectorActiveOrigin,
    DetectorManufacturerName,
    DetectorManufacturerModelName,
    FieldOfViewOrigin,
    FieldOfViewRotation,
    FieldOfViewHorizontalFlip,
    PixelDataAreaOriginRelativeToFOV,
    PixelDataAreaRotationAngleRelativeToFOV,
    GridAbsorbingMaterial,
    GridSpacingMaterial,
    GridThickness,
    GridPitch,
    GridAspectRatio,
    GridPeriod,
    GridFocalDistance,
    FilterMaterial,
    FilterThicknessMinimum,
    FilterThicknessMaximum,
    FilterBeamPathLengthMinimum,
    FilterBeamPathLengthMaximum,
    ExposureControlMode,
    ExposureControlModeDescription,
    ExposureStatus,
    PhototimerSetting,
    ExposureTimeInuS,
    XRayTubeCurrentInuA,
    ContentQualification,
    PulseSequenceName,
    MRImagingModifierSequence,
    EchoPulseSequence,
    InversionRecovery,
    FlowCompensation,
    MultipleSpinEcho,
    MultiPlanarExcitation,
    PhaseContrast,
    TimeOfFlightContrast,
    Spoiling,
    SteadyStatePulseSequence,
    EchoPlanarPulseSequence,
    TagAngleFirstAxis,
    MagnetizationTransfer,
    T2Preparation,
    BloodSignalNulling,
    SaturationRecovery,
    SpectrallySelectedSuppression,
    SpectrallySelectedExcitation,
    SpatialPresaturation,
    Tagging,
    OversamplingPhase,
    TagSpacingFirstDimension,
    GeometryOfKSpaceTraversal,
    SegmentedKSpaceTraversal,
    RectilinearPhaseEncodeReordering,
    TagThickness,
    PartialFourierDirection,
    CardiacSynchronizationTechnique,
    ReceiveCoilManufacturerName,
    MRReceiveCoilSequence,
    ReceiveCoilType,
    QuadratureReceiveCoil,
    MultiCoilDefinitionSequence,
    MultiCoilConfiguration,
    MRTransmitCoilSequence,
    TransmitCoilManufacturerName,
    TransmitCoilType,
    MRAcquisitionFrequencyEncodingSteps,
    KSpaceFiltering,
    ParallelReductionFactorInPlane,
    CardiacRRIntervalSpecified,
    AcquisitionDuration,
    FrameAcquisitionDateTime,
    DiffusionDirectionality,
    DiffusionGradientDirectionSequence,
    ParallelAcquisition,
    ParallelAcquisitionTechnique,
    InversionTimes,
    MetaboliteMapDescription,
    PartialFourier,
    EffectiveEchoTime,
    MetaboliteMapCodeSequence,
    ChemicalShiftSequence,
    CardiacSignalSource,
    DiffusionBValue,
    VelocityEncodingDirection,
    VelocityEncodingMinimumValue,
    VelocityEncodingAcquisitionSequence,
    NumberOfKSpaceTrajectories,
    CoverageOfKSpace,
    TransmitterFrequency,
    ResonantNucleus,
    SlabThickness,
    SlabOrientation,
    MidSlabPosition,
    MRSpatialSaturationSequence,
    MRTimingAndRelatedParametersSequence,
    MREchoSequence,
    MRModifierSequence,
    MRDiffusionSequence,
    CardiacSynchronizationSequence,
    MRAveragesSequence,
    MRFOVGeometrySequence,
    DiffusionAnisotropyType,
    FrameReferenceDateTime,
    MRMetaboliteMapSequence,
    ParallelReductionFactorOutOfPlane,
    ParallelReductionFactorSecondInPlane,
    CardiacBeatRejectionTechnique,
    RespiratoryMotionCompensationTechnique,
    RespiratorySignalSource,
    BulkMotionCompensationTechnique,
    BulkMotionSignalSource,
    ApplicableSafetyStandardAgency,
    ApplicableSafetyStandardDescription,
    OperatingModeSequence,
    GradientOutputType,
    GradientOutput,
    FlowCompensationDirection,
    TaggingDelay,
    MRVelocityEncodingSequence,
    RespiratoryCyclePosition,
    VelocityEncodingMaximumValue,
    TagSpacingSecondDimension,
    TagAngleSecondAxis,
    FrameAcquisitionDuration,
    MRImageFrameTypeSequence,
    MRAcquisitionPhaseEncodingStepsInPlane,
    MRAcquisitionPhaseEncodingStepsOutOfPlane,
    CardiacCyclePosition,
    SpecificAbsorptionRateSequence,
    RFEchoTrainLength,
    GradientEchoTrainLength,
    ArterialSpinLabelingContrast,
    MRArterialSpinLabelingSequence,
    ASLTechniqueDescription,
    ASLContext,
    ASLCrusherFlag,
    ASLCrusherFlowLimit,
    ASLCrusherDescription,
    ASLBolusCutoffFlag,
    ASLBolusCutoffTimingSequence,
    ASLSlabSequence,
    CTAcquisitionTypeSequence,
    AcquisitionType,
    TubeAngle,
    CTAcquisitionDetailsSequence,
    RevolutionTime,
    SingleCollimationWidth,
    TotalCollimationWidth,
    CTTableDynamicsSequence,
    TableSpeed,
    TableFeedPerRotation,
    SpiralPitchFactor,
    CTGeometrySequence,
    DataCollectionCenterPatient,
    CTReconstructionSequence,
    ReconstructionAlgorithm,
    ConvolutionKernelGroup,
    ReconstructionFieldOfView,
    ReconstructionTargetCenterPatient,
    ReconstructionAngle,
    ImageFilter,
    CTExposureSequence,
    ReconstructionPixelSpacing,
    ExposureModulationType,
    CTXRayDetailsSequence,
    CTPositionSequence,
    TablePosition,
    ExposureTimeInms,
    CTImageFrameTypeSequence,
    XRayTubeCurrentInmA,
    ExposureInmAs,
    ConstantVolumeFlag,
    FluoroscopyFlag,
    DistanceSourceToDataCollectionCenter,
    ContrastBolusAgentNumber,
    ContrastBolusIngredientCodeSequence,
    ContrastAdministrationProfileSequence,
    ContrastBolusUsageSequence,
    ContrastBolusAgentAdministered,
    ContrastBolusAgentDetected,
    ContrastBolusAgentPhase,
    CTDIvol,
    CTDIPhantomTypeCodeSequence,
    CalciumScoringMassFactorPatient,
    CalciumScoringMassFactorDevice,
    EnergyWeightingFactor,
    CTAdditionalXRaySourceSequence,
    MultienergyCTAcquisition,
    MultienergyCTAcquisitionSequence,
    MultienergyCTProcessingSequence,
    MultienergyCTCharacteristicsSequence,
    MultienergyCTXRaySourceSequence,
    XRaySourceIndex,
    XRaySourceID,
    MultienergySourceTechnique,
    SourceStartDateTime,
    SourceEndDateTime,
    SwitchingPhaseNumber,
    SwitchingPhaseNominalDuration,
    SwitchingPhaseTransitionDuration,
    EffectiveBinEnergy,
    MultienergyCTXRayDetectorSequence,
    XRayDetectorIndex,
    XRayDetectorID,
    MultienergyDetectorType,
    XRayDetectorLabel,
    NominalMaxEnergy,
    NominalMinEnergy,
    ReferencedXRayDetectorIndex,
    ReferencedXRaySourceIndex,
    ReferencedPathIndex,
    MultienergyCTPathSequence,
    MultienergyCTPathIndex,
    MultienergyAcquisitionDescription,
    MonoenergeticEnergyEquivalent,
    DecompositionMethod,
    DecompositionDescription,
    DecompositionAlgorithmIdentificationSequence,
    DecompositionMaterialSequence,
    ProjectionPixelCalibrationSequence,
    DistanceSourceToIsocenter,
    DistanceObjectToTableTop,
    ObjectPixelSpacingInCenterOfBeam,
    PositionerPositionSequence,
    TablePositionSequence,
    CollimatorShapeSequence,
    PlanesInAcquisition,
    XAXRFFrameCharacteristicsSequence,
    FrameAcquisitionSequence,
    XRayReceptorType,
    AcquisitionProtocolName,
    AcquisitionProtocolDescription,
    ContrastBolusIngredientOpaque,
    DistanceReceptorPlaneToDetectorHousing,
    IntensifierActiveShape,
    IntensifierActiveDimensions,
    PhysicalDetectorSize,
    PositionOfIsocenterProjection,
    FieldOfViewSequence,
    FieldOfViewDescription,
    ExposureControlSensingRegionsSequence,
    ExposureControlSensingRegionShape,
    ExposureControlSensingRegionLeftVerticalEdge,
    ExposureControlSensingRegionRightVerticalEdge,
    ExposureControlSensingRegionUpperHorizontalEdge,
    ExposureControlSensingRegionLowerHorizontalEdge,
    CenterOfCircularExposureControlSensingRegion,
    RadiusOfCircularExposureControlSensingRegion,
    VerticesOfThePolygonalExposureControlSensingRegion,
    ColumnAngulationPatient,
    BeamAngle,
    FrameDetectorParametersSequence,
    CalculatedAnatomyThickness,
    CalibrationSequence,
    ObjectThicknessSequence,
    PlaneIdentification,
    FieldOfViewDimensionsInFloat,
    IsocenterReferenceSystemSequence,
    PositionerIsocenterPrimaryAngle,
    PositionerIsocenterSecondaryAngle,
    PositionerIsocenterDetectorRotationAngle,
    TableXPositionToIsocenter,
    TableYPositionToIsocenter,
    TableZPositionToIsocenter,
    TableHorizontalRotationAngle,
    TableHeadTiltAngle,
    TableCradleTiltAngle,
    FrameDisplayShutterSequence,
    AcquiredImageAreaDoseProduct,
    CArmPositionerTabletopRelationship,
    XRayGeometrySequence,
    IrradiationEventIdentificationSequence,
    XRay3DFrameTypeSequence,
    ContributingSourcesSequence,
    XRay3DAcquisitionSequence,
    PrimaryPositionerScanArc,
    SecondaryPositionerScanArc,
    PrimaryPositionerScanStartAngle,
    SecondaryPositionerScanStartAngle,
    PrimaryPositionerIncrement,
    SecondaryPositionerIncrement,
    StartAcquisitionDateTime,
    EndAcquisitionDateTime,
    PrimaryPositionerIncrementSign,
    SecondaryPositionerIncrementSign,
    ApplicationName,
    ApplicationVersion,
    ApplicationManufacturer,
    AlgorithmType,
    AlgorithmDescription,
    XRay3DReconstructionSequence,
    ReconstructionDescription,
    PerProjectionAcquisitionSequence,
    DetectorPositionSequence,
    XRayAcquisitionDoseSequence,
    XRaySourceIsocenterPrimaryAngle,
    XRaySourceIsocenterSecondaryAngle,
    BreastSupportIsocenterPrimaryAngle,
    BreastSupportIsocenterSecondaryAngle,
    BreastSupportXPositionToIsocenter,
    BreastSupportYPositionToIsocenter,
    BreastSupportZPositionToIsocenter,
    DetectorIsocenterPrimaryAngle,
    DetectorIsocenterSecondaryAngle,
    DetectorXPositionToIsocenter,
    DetectorYPositionToIsocenter,
    DetectorZPositionToIsocenter,
    XRayGridSequence,
    XRayFilterSequence,
    DetectorActiveAreaTLHCPosition,
    DetectorActiveAreaOrientation,
    PositionerPrimaryAngleDirection,
    DiffusionBMatrixSequence,
    FunctionalMRSequence,
    FunctionalSettlingPhaseFramesPresent,
    FunctionalSyncPulse,
    SettlingPhaseFrame,
    DecayCorrectionDateTime,
    StartDensityThreshold,
    StartRelativeDensityDifferenceThreshold,
    StartCardiacTriggerCountThreshold,
    StartRespiratoryTriggerCountThreshold,
    TerminationCountsThreshold,
    TerminationDensityThreshold,
    TerminationRelativeDensityThreshold,
    TerminationTimeThreshold,
    TerminationCardiacTriggerCountThreshold,
    TerminationRespiratoryTriggerCountThreshold,
    DetectorGeometry,
    TransverseDetectorSeparation,
    AxialDetectorDimension,
    RadiopharmaceuticalAgentNumber,
    PETFrameAcquisitionSequence,
    PETDetectorMotionDetailsSequence,
    PETTableDynamicsSequence,
    PETPositionSequence,
    PETFrameCorrectionFactorsSequence,
    RadiopharmaceuticalUsageSequence,
    AttenuationCorrectionSource,
    NumberOfIterations,
    NumberOfSubsets,
    PETReconstructionSequence,
    PETFrameTypeSequence,
    TimeOfFlightInformationUsed,
    ReconstructionType,
    DecayCorrected,
    AttenuationCorrected,
    ScatterCorrected,
    DeadTimeCorrected,
    GantryMotionCorrected,
    PatientMotionCorrected,
    CountLossNormalizationCorrected,
    RandomsCorrected,
    NonUniformRadialSamplingCorrected,
    SensitivityCalibrated,
    DetectorNormalizationCorrection,
    IterativeReconstructionMethod,
    AttenuationCorrectionTemporalRelationship,
    PatientPhysiologicalStateSequence,
    PatientPhysiologicalStateCodeSequence,
    DepthsOfFocus,
    ExcludedIntervalsSequence,
    ExclusionStartDateTime,
    ExclusionDuration,
    USImageDescriptionSequence,
    ImageDataTypeSequence,
    DataType,
    TransducerScanPatternCodeSequence,
    AliasedDataType,
    PositionMeasuringDeviceUsed,
    TransducerGeometryCodeSequence,
    TransducerBeamSteeringCodeSequence,
    TransducerApplicationCodeSequence,
    ZeroVelocityPixelValue,
    PhotoacousticExcitationCharacteristicsSequence,
    ExcitationSpectralWidth,
    ExcitationEnergy,
    ExcitationPulseDuration,
    ExcitationWavelengthSequence,
    ExcitationWavelength,
    IlluminationTranslationFlag,
    AcousticCouplingMediumFlag,
    AcousticCouplingMediumCodeSequence,
    AcousticCouplingMediumTemperature,
    TransducerResponseSequence,
    CenterFrequency,
    FractionalBandwidth,
    LowerCutoffFrequency,
    UpperCutoffFrequency,
    TransducerTechnologySequence,
    SoundSpeedCorrectionMechanismCodeSequence,
    ObjectSoundSpeed,
    AcousticCouplingMediumSoundSpeed,
    PhotoacousticImageFrameTypeSequence,
    ImageDataTypeCodeSequence,
    ReferencedDefinedProtocolSequence,
    ReferencedPerformedProtocolSequence,
    SourceAcquisitionProtocolElementNumber,
    SourceReconstructionProtocolElementNumber,
    ReconstructionAlgorithmSequence,
    ContributingEquipmentSequence,
    ContributionDateTime,
    ContributionDescription,
    StudyInstanceUID,
    SeriesInstanceUID,
    StudyID,
    SeriesNumber,
    AcquisitionNumber,
    InstanceNumber,
    PatientOrientation,
    PyramidLabel,
    ImagePositionPatient,
    ImageOrientationPatient,
    FrameOfReferenceUID,
    Laterality,
    ImageLaterality,
    TemporalPositionIdentifier,
    NumberOfTemporalPositions,
    TemporalResolution,
    SynchronizationFrameOfReferenceUID,
    SOPInstanceUIDOfConcatenationSource,
    ImagesInAcquisition,
    PositionReferenceIndicator,
    SliceLocation,
    ImageComments,
    StackID,
    InStackPositionNumber,
    FrameAnatomySequence,
    FrameLaterality,
    FrameContentSequence,
    PlanePositionSequence,
    PlaneOrientationSequence,
    TemporalPositionIndex,
    NominalCardiacTriggerDelayTime,
    NominalCardiacTriggerTimePriorToRPeak,
    ActualCardiacTriggerTimePriorToRPeak,
    FrameAcquisitionNumber,
    DimensionIndexValues,
    FrameComments,
    ConcatenationUID,
    InConcatenationNumber,
    InConcatenationTotalNumber,
    DimensionOrganizationUID,
    DimensionIndexPointer,
    FunctionalGroupPointer,
    UnassignedSharedConvertedAttributesSequence,
    UnassignedPerFrameConvertedAttributesSequence,
    ConversionSourceAttributesSequence,
    DimensionIndexPrivateCreator,
    DimensionOrganizationSequence,
    DimensionIndexSequence,
    ConcatenationFrameOffsetNumber,
    FunctionalGroupPrivateCreator,
    NominalPercentageOfCardiacPhase,
    NominalPercentageOfRespiratoryPhase,
    StartingRespiratoryAmplitude,
    StartingRespiratoryPhase,
    EndingRespiratoryAmplitude,
    EndingRespiratoryPhase,
    RespiratoryTriggerType,
    RRIntervalTimeNominal,
    ActualCardiacTriggerDelayTime,
    RespiratorySynchronizationSequence,
    RespiratoryIntervalTime,
    NominalRespiratoryTriggerDelayTime,
    RespiratoryTriggerDelayThreshold,
    ActualRespiratoryTriggerDelayTime,
    ImagePositionVolume,
    ImageOrientationVolume,
    UltrasoundAcquisitionGeometry,
    ApexPosition,
    VolumeToTransducerMappingMatrix,
    VolumeToTableMappingMatrix,
    VolumeToTransducerRelationship,
    PatientFrameOfReferenceSource,
    TemporalPositionTimeOffset,
    PlanePositionVolumeSequence,
    PlaneOrientationVolumeSequence,
    TemporalPositionSequence,
    DimensionOrganizationType,
    VolumeFrameOfReferenceUID,
    TableFrameOfReferenceUID,
    DimensionDescriptionLabel,
    PatientOrientationInFrameSequence,
    FrameLabel,
    AcquisitionIndex,
    ContributingSOPInstancesReferenceSequence,
    ReconstructionIndex,
    LightPathFilterPassThroughWavelength,
    LightPathFilterPassBand,
    ImagePathFilterPassThroughWavelength,
    ImagePathFilterPassBand,
    PatientEyeMovementCommanded,
    PatientEyeMovementCommandCodeSequence,
    SphericalLensPower,
    CylinderLensPower,
    CylinderAxis,
    EmmetropicMagnification,
    IntraOcularPressure,
    HorizontalFieldOfView,
    PupilDilated,
    DegreeOfDilation,
    AcquisitionDeviceTypeCodeSequence,
    IlluminationTypeCodeSequence,
    LightPathFilterTypeStackCodeSequence,
    ImagePathFilterTypeStackCodeSequence,
    LensesCodeSequence,
    ChannelDescriptionCodeSequence,
    RefractiveStateSequence,
    MydriaticAgentCodeSequence,
    RelativeImagePositionCodeSequence,
    CameraAngleOfView,
    StereoPairsPresent,
    AxialLengthOfTheEye,
    OphthalmicFrameLocationSequence,
    ReferenceCoordinates,
    DepthSpatialResolution,
    MaximumDepthDistortion,
    AlongScanSpatialResolution,
    MaximumAlongScanDistortion,
    OphthalmicImageOrientation,
    DepthOfTransverseImage,
    MydriaticAgentConcentrationUnitsSequence,
    AcrossScanSpatialResolution,
    MaximumAcrossScanDistortion,
    MydriaticAgentConcentration,
    IlluminationWaveLength,
    IlluminationPower,
    IlluminationBandwidth,
    MydriaticAgentSequence,
    OphthalmicAxialLength,
    ImplantName,
    ImplantPartNumber,
    OphthalmicMappingDeviceType,
    AcquisitionMethodCodeSequence,
    AcquisitionMethodAlgorithmSequence,
    OphthalmicThicknessMapTypeCodeSequence,
    OphthalmicThicknessMappingNormalsSequence,
    RetinalThicknessDefinitionCodeSequence,
    PixelValueMappingToCodedConceptSequence,
    MappedPixelValue,
    PixelValueMappingExplanation,
    OphthalmicThicknessMapQualityThresholdSequence,
    AnatomicStructureReferencePoint,
    RegistrationToLocalizerSequence,
    RegisteredLocalizerUnits,
    RegisteredLocalizerTopLeftHandCorner,
    RegisteredLocalizerBottomRightHandCorner,
    OphthalmicThicknessMapQualityRatingSequence,
    RelevantOPTAttributesSequence,
    TransformationMethodCodeSequence,
    TransformationAlgorithmSequence,
    OphthalmicAxialLengthMethod,
    OphthalmicFOV,
    TwoDimensionalToThreeDimensionalMapSequence,
    WideFieldOphthalmicPhotographyQualityRatingSequence,
    WideFieldOphthalmicPhotographyQualityThresholdSequence,
    XCoordinatesCenterPixelViewAngle,
    YCoordinatesCenterPixelViewAngle,
    NumberOfMapPoints,
    TwoDimensionalToThreeDimensionalMapData,
    DerivationAlgorithmSequence,
    OphthalmicImageTypeCodeSequence,
    OphthalmicImageTypeDescription,
    ScanPatternTypeCodeSequence,
    ReferencedSurfaceMeshIdentificationSequence,
    OphthalmicVolumetricPropertiesFlag,
    OphthalmicAnatomicReferencePointXCoordinate,
    OphthalmicAnatomicReferencePointYCoordinate,
    OphthalmicEnFaceImageQualityRatingSequence,
    QualityThreshold,
    OCTBscanAnalysisAcquisitionParametersSequence,
    NumberOfBscansPerFrame,
    BscanSlabThickness,
    DistanceBetweenBscanSlabs,
    BscanCycleTime,
    BscanCycleTimeVector,
    AscanRate,
    BscanRate,
    SurfaceMeshZPixelOffset,
    AlgorithmSource,
    DataSetName,
    DataSetVersion,
    DataSetSource,
    DataSetDescription,
    SamplesPerPixel,
    SamplesPerPixelUsed,
    PhotometricInterpretation,
    PlanarConfiguration,
    NumberOfFrames,
    FrameIncrementPointer,
    FrameDimensionPointer,
    Rows,
    Columns,
    UltrasoundColorDataPresent,
    PixelSpacing,
    ZoomFactor,
    ZoomCenter,
    PixelAspectRatio,
    CorrectedImage,
    BitsAllocated,
    BitsStored,
    HighBit,
    PixelRepresentation,
    SmallestImagePixelValue,
    LargestImagePixelValue,
    SmallestPixelValueInSeries,
    LargestPixelValueInSeries,
    PixelPaddingValue,
    PixelPaddingRangeLimit,
    FloatPixelPaddingValue,
    DoubleFloatPixelPaddingValue,
    FloatPixelPaddingRangeLimit,
    DoubleFloatPixelPaddingRangeLimit,
    QualityControlImage,
    BurnedInAnnotation,
    RecognizableVisualFeatures,
    LongitudinalTemporalInformationModified,
    ReferencedColorPaletteInstanceUID,
    PixelSpacingCalibrationType,
    PixelSpacingCalibrationDescription,
    PixelIntensityRelationship,
    PixelIntensityRelationshipSign,
    WindowCenter,
    WindowWidth,
    RescaleIntercept,
    RescaleSlope,
    RescaleType,
    WindowCenterWidthExplanation,
    VOILUTFunction,
    RecommendedViewingMode,
    RedPaletteColorLookupTableDescriptor,
    GreenPaletteColorLookupTableDescriptor,
    BluePaletteColorLookupTableDescriptor,
    AlphaPaletteColorLookupTableDescriptor,
    PaletteColorLookupTableUID,
    RedPaletteColorLookupTableData,
    GreenPaletteColorLookupTableData,
    BluePaletteColorLookupTableData,
    AlphaPaletteColorLookupTableData,
    SegmentedRedPaletteColorLookupTableData,
    SegmentedGreenPaletteColorLookupTableData,
    SegmentedBluePaletteColorLookupTableData,
    StoredValueColorRangeSequence,
    MinimumStoredValueMapped,
    MaximumStoredValueMapped,
    BreastImplantPresent,
    PartialView,
    PartialViewDescription,
    PartialViewCodeSequence,
    SpatialLocationsPreserved,
    DataFrameAssignmentSequence,
    DataPathAssignment,
    BitsMappedToColorLookupTable,
    BlendingLUT1Sequence,
    BlendingLUT1TransferFunction,
    BlendingWeightConstant,
    BlendingLookupTableDescriptor,
    BlendingLookupTableData,
    EnhancedPaletteColorLookupTableSequence,
    BlendingLUT2Sequence,
    BlendingLUT2TransferFunction,
    DataPathID,
    RGBLUTTransferFunction,
    AlphaLUTTransferFunction,
    ICCProfile,
    ColorSpace,
    LossyImageCompression,
    LossyImageCompressionRatio,
    LossyImageCompressionMethod,
    ModalityLUTSequence,
    LUTDescriptor,
    LUTExplanation,
    ModalityLUTType,
    LUTData,
    VOILUTSequence,
    RepresentativeFrameNumber,
    FrameNumbersOfInterest,
    FrameOfInterestDescription,
    FrameOfInterestType,
    RWavePointer,
    MaskSubtractionSequence,
    MaskOperation,
    ApplicableFrameRange,
    MaskFrameNumbers,
    ContrastFrameAveraging,
    MaskSubPixelShift,
    TIDOffset,
    MaskOperationExplanation,
    PixelDataProviderURL,
    PixelMeasuresSequence,
    FrameVOILUTSequence,
    PixelValueTransformationSequence,
    DisplayFilterPercentage,
    FramePixelShiftSequence,
    SubtractionItemID,
    PixelIntensityRelationshipLUTSequence,
    FramePixelDataPropertiesSequence,
    GeometricalProperties,
    GeometricMaximumDistortion,
    ImageProcessingApplied,
    MaskSelectionMode,
    LUTFunction,
    MaskVisibilityPercentage,
    ImageToEquipmentMappingMatrix,
    EquipmentCoordinateSystemIdentification,
    RequestingService,
    RequestingServiceCodeSequence,
    RequestedProcedureDescription,
    RequestedProcedureCodeSequence,
    ReasonForVisit,
    ReasonForVisitCodeSequence,
    FrameOriginTimestamp,
    IncludesImagingSubject,
    FrameUsefulnessGroupSequence,
    CameraPositionGroupSequence,
    IncludesInformation,
    TimeOfFrameGroupSequence,
    AdmissionID,
    IssuerOfAdmissionIDSequence,
    ServiceEpisodeID,
    ServiceEpisodeDescription,
    IssuerOfServiceEpisodeIDSequence,
    PatientState,
    ChannelSourceSequence,
    MultiplexedAudioChannelsDescriptionCodeSequence,
    ChannelIdentificationCode,
    ChannelMode,
    ScheduledProcedureStepDescription,
    ScheduledProtocolCodeSequence,
    ScheduledProcedureStepID,
    StageCodeSequence,
    OrderPlacerIdentifierSequence,
    OrderFillerIdentifierSequence,
    LocalNamespaceEntityID,
    UniversalEntityID,
    UniversalEntityIDType,
    IdentifierTypeCode,
    AssigningFacilitySequence,
    AssigningJurisdictionCodeSequence,
    AssigningAgencyOrDepartmentCodeSequence,
    PerformedProcedureStepStartDate,
    PerformedProcedureStepStartTime,
    PerformedProcedureStepEndDate,
    PerformedProcedureStepEndTime,
    PerformedProcedureStepID,
    PerformedProcedureStepDescription,
    PerformedProtocolCodeSequence,
    PerformedProtocolType,
    RequestAttributesSequence,
    CommentsOnThePerformedProcedureStep,
    EntranceDose,
    ExposedArea,
    DistanceSourceToEntrance,
    CommentsOnRadiationDose,
    XRayOutput,
    HalfValueLayer,
    OrganDose,
    OrganExposed,
    ProtocolContextSequence,
    ContentItemModifierSequence,
    ContainerIdentifier,
    IssuerOfTheContainerIdentifierSequence,
    AlternateContainerIdentifierSequence,
    ContainerTypeCodeSequence,
    ContainerDescription,
    ContainerComponentSequence,
    SpecimenIdentifier,
    SpecimenUID,
    AcquisitionContextSequence,
    AcquisitionContextDescription,
    SpecimenDescriptionSequence,
    IssuerOfTheSpecimenIdentifierSequence,
    SpecimenTypeCodeSequence,
    SpecimenShortDescription,
    SpecimenDetailedDescription,
    SpecimenPreparationSequence,
    SpecimenLocalizationContentItemSequence,
    WholeSlideMicroscopyImageFrameTypeSequence,
    ImageCenterPointCoordinatesSequence,
    XOffsetInSlideCoordinateSystem,
    YOffsetInSlideCoordinateSystem,
    ZOffsetInSlideCoordinateSystem,
    MeasurementUnitsCodeSequence,
    RequestedProcedureID,
    ReasonForTheRequestedProcedure,
    ReasonForRequestedProcedureCodeSequence,
    ReasonForPerformedProcedureCodeSequence,
    PersonIdentificationCodeSequence,
    PersonAddress,
    PersonTelephoneNumbers,
    PersonTelecomInformation,
    PlacerOrderNumberImagingServiceRequest,
    FillerOrderNumberImagingServiceRequest,
    EntranceDoseInmGy,
    EntranceDoseDerivation,
    ParametricMapFrameTypeSequence,
    RealWorldValueMappingSequence,
    PixelValueMappingCodeSequence,
    LUTLabel,
    RealWorldValueLastValueMapped,
    RealWorldValueLUTData,
    DoubleFloatRealWorldValueLastValueMapped,
    DoubleFloatRealWorldValueFirstValueMapped,
    RealWorldValueFirstValueMapped,
    QuantityDefinitionSequence,
    RealWorldValueIntercept,
    RealWorldValueSlope,
    RelationshipType,
    VerifyingOrganization,
    VerificationDateTime,
    ObservationDateTime,
    ObservationStartDateTime,
    ValueType,
    ConceptNameCodeSequence,
    ContinuityOfContent,
    VerifyingObserverSequence,
    VerifyingObserverName,
    AuthorObserverSequence,
    ParticipantSequence,
    CustodialOrganizationSequence,
    ParticipationType,
    ParticipationDateTime,
    ObserverType,
    VerifyingObserverIdentificationCodeSequence,
    ReferencedWaveformChannels,
    DateTime,
    Date,
    Time,
    PersonName,
    UID,
    TemporalRangeType,
    ReferencedSamplePositions,
    ReferencedTimeOffsets,
    ReferencedDateTime,
    TextValue,
    FloatingPointValue,
    RationalNumeratorValue,
    RationalDenominatorValue,
    ConceptCodeSequence,
    PurposeOfReferenceCodeSequence,
    ObservationUID,
    MeasuredValueSequence,
    NumericValueQualifierCodeSequence,
    NumericValue,
    PredecessorDocumentsSequence,
    ReferencedRequestSequence,
    PerformedProcedureCodeSequence,
    CurrentRequestedProcedureEvidenceSequence,
    PertinentOtherEvidenceSequence,
    HL7StructuredDocumentReferenceSequence,
    CompletionFlag,
    CompletionFlagDescription,
    VerificationFlag,
    PreliminaryFlag,
    ContentTemplateSequence,
    IdenticalDocumentsSequence,
    ContentSequence,
    TabulatedValuesSequence,
    NumberOfTableRows,
    NumberOfTableColumns,
    TableRowDefinitionSequence,
    TableColumnDefinitionSequence,
    CellValuesSequence,
    TemplateIdentifier,
    ReferencedContentItemIdentifier,
    HL7InstanceIdentifier,
    DocumentClassCodeSequence,
    RetrieveURI,
    RetrieveLocationUID,
    TypeOfInstances,
    DICOMRetrievalSequence,
    DICOMMediaRetrievalSequence,
    WADORetrievalSequence,
    XDSRetrievalSequence,
    WADORSRetrievalSequence,
    RepositoryUniqueID,
    HomeCommunityID,
    DocumentTitle,
    EncapsulatedDocument,
    MIMETypeOfEncapsulatedDocument,
    SourceInstanceSequence,
    ListOfMIMETypes,
    EncapsulatedDocumentLength,
    OrganizationalRoleCodeSequence,
    SteepKeratometricAxisSequence,
    RadiusOfCurvature,
    KeratometricPower,
    KeratometricAxis,
    FlatKeratometricAxisSequence,
    CornealTopographySurface,
    CornealVertexLocation,
    PupilCentroidXCoordinate,
    PupilCentroidYCoordinate,
    EquivalentPupilRadius,
    CornealTopographyMapTypeCodeSequence,
    VerticesOfTheOutlineOfPupil,
    CornealTopographyMappingNormalsSequence,
    MaximumCornealCurvatureSequence,
    MaximumCornealCurvature,
    MaximumCornealCurvatureLocation,
    MinimumKeratometricSequence,
    SimulatedKeratometricCylinderSequence,
    AverageCornealPower,
    CornealISValue,
    AnalyzedArea,
    SurfaceRegularityIndex,
    SurfaceAsymmetryIndex,
    CornealEccentricityIndex,
    KeratoconusPredictionIndex,
    DecimalPotentialVisualAcuity,
    CornealTopographyMapQualityEvaluation,
    SourceImageCornealProcessedDataSequence,
    CornealPointLocation,
    CornealPointEstimated,
    AxialPower,
    TangentialPower,
    RefractivePower,
    RelativeElevation,
    CornealWavefront,
    ImagedVolumeWidth,
    ImagedVolumeHeight,
    ImagedVolumeDepth,
    TotalPixelMatrixColumns,
    TotalPixelMatrixRows,
    TotalPixelMatrixOriginSequence,
    SpecimenLabelInImage,
    FocusMethod,
    ExtendedDepthOfField,
    NumberOfFocalPlanes,
    DistanceBetweenFocalPlanes,
    RecommendedAbsentPixelCIELabValue,
    IlluminatorTypeCodeSequence,
    ImageOrientationSlide,
    OpticalPathSequence,
    OpticalPathIdentifier,
    OpticalPathDescription,
    IlluminationColorCodeSequence,
    SpecimenReferenceSequence,
    CondenserLensPower,
    ObjectiveLensPower,
    ObjectiveLensNumericalAperture,
    PaletteColorLookupTableSequence,
    OpticalPathIdentificationSequence,
    PlanePositionSlideSequence,
    ColumnPositionInTotalImagePixelMatrix,
    RowPositionInTotalImagePixelMatrix,
    PixelOriginInterpretation,
    NumberOfOpticalPaths,
    TotalPixelMatrixFocalPlanes,
    CalibrationImage,
    DeviceSequence,
    ContainerComponentTypeCodeSequence,
    ContainerComponentThickness,
    DeviceLength,
    ContainerComponentWidth,
    DeviceDiameter,
    DeviceDiameterUnits,
    DeviceVolume,
    InterMarkerDistance,
    ContainerComponentMaterial,
    ContainerComponentID,
    ContainerComponentLength,
    ContainerComponentDiameter,
    ContainerComponentDescription,
    DeviceDescription,
    LongDeviceDescription,
    ContrastBolusIngredientPercentByVolume,
    OCTFocalDistance,
    BeamSpotSize,
    EffectiveRefractiveIndex,
    OCTAcquisitionDomain,
    OCTOpticalCenterWavelength,
    AxialResolution,
    RangingDepth,
    ALineRate,
    ALinesPerFrame,
    CatheterRotationalRate,
    ALinePixelSpacing,
    ModeOfPercutaneousAccessSequence,
    IntravascularOCTFrameTypeSequence,
    OCTZOffsetApplied,
    IntravascularFrameContentSequence,
    IntravascularLongitudinalDistance,
    IntravascularOCTFrameContentSequence,
    OCTZOffsetCorrection,
    CatheterDirectionOfRotation,
    SeamLineLocation,
    FirstALineLocation,
    SeamLineIndex,
    NumberOfPaddedALines,
    InterpolationType,
    RefractiveIndexApplied,
    EnergyWindowVector,
    NumberOfEnergyWindows,
    EnergyWindowInformationSequence,
    EnergyWindowRangeSequence,
    EnergyWindowLowerLimit,
    EnergyWindowUpperLimit,
    RadiopharmaceuticalInformationSequence,
    EnergyWindowName,
    DetectorVector,
    NumberOfDetectors,
    DetectorInformationSequence,
    PhaseVector,
    NumberOfPhases,
    PhaseInformationSequence,
    NumberOfFramesInPhase,
    PhaseDelay,
    PauseBetweenFrames,
    PhaseDescription,
    RotationVector,
    NumberOfRotations,
    RotationInformationSequence,
    NumberOfFramesInRotation,
    RRIntervalVector,
    NumberOfRRIntervals,
    GatedInformationSequence,
    DataInformationSequence,
    TimeSlotVector,
    NumberOfTimeSlots,
    SliceVector,
    NumberOfSlices,
    AngularViewVector,
    TimeSliceVector,
    NumberOfTimeSlices,
    StartAngle,
    TypeOfDetectorMotion,
    TriggerVector,
    NumberOfTriggersInPhase,
    ViewCodeSequence,
    ViewModifierCodeSequence,
    RadionuclideCodeSequence,
    AdministrationRouteCodeSequence,
    RadiopharmaceuticalCodeSequence,
    CalibrationDataSequence,
    ImageID,
    PatientOrientationCodeSequence,
    PatientOrientationModifierCodeSequence,
    PatientGantryRelationshipCodeSequence,
    SliceProgressionDirection,
    ScanProgressionDirection,
    SeriesType,
    Units,
    CountsSource,
    ReprojectionMethod,
    SUVType,
    RandomsCorrectionMethod,
    AttenuationCorrectionMethod,
    DecayCorrection,
    ReconstructionMethod,
    DetectorLinesOfResponseUsed,
    ScatterCorrectionMethod,
    AxialAcceptance,
    AxialMash,
    TransverseMash,
    DetectorElementSize,
    CoincidenceWindowWidth,
    SecondaryCountsType,
    FrameReferenceTime,
    PrimaryPromptsCountsAccumulated,
    SecondaryCountsAccumulated,
    SliceSensitivityFactor,
    DecayFactor,
    DoseCalibrationFactor,
    ScatterFractionFactor,
    DeadTimeFactor,
    ImageIndex,
    HistogramSequence,
    HistogramNumberOfBins,
    HistogramFirstBinValue,
    HistogramLastBinValue,
    HistogramBinWidth,
    HistogramExplanation,
    HistogramData,
    SegmentationType,
    SegmentSequence,
    SegmentedPropertyCategoryCodeSequence,
    SegmentNumber,
    SegmentLabel,
    SegmentDescription,
    SegmentationAlgorithmIdentificationSequence,
    SegmentAlgorithmType,
    SegmentAlgorithmName,
    SegmentIdentificationSequence,
    ReferencedSegmentNumber,
    RecommendedDisplayGrayscaleValue,
    RecommendedDisplayCIELabValue,
    MaximumFractionalValue,
    SegmentedPropertyTypeCodeSequence,
    SegmentationFractionalType,
    SegmentedPropertyTypeModifierCodeSequence,
    SegmentsOverlap,
    TrackingID,
    TrackingUID,
    NumberOfSurfaces,
    SurfaceSequence,
    SurfaceNumber,
    SurfaceComments,
    SurfaceProcessing,
    SurfaceProcessingRatio,
    SurfaceProcessingDescription,
    RecommendedPresentationOpacity,
    RecommendedPresentationType,
    FiniteVolume,
    Manifold,
    SurfacePointsSequence,
    SurfacePointsNormalsSequence,
    SurfaceMeshPrimitivesSequence,
    NumberOfSurfacePoints,
    PointCoordinatesData,
    PointPositionAccuracy,
    MeanPointDistance,
    MaximumPointDistance,
    PointsBoundingBoxCoordinates,
    AxisOfRotation,
    CenterOfRotation,
    SurfaceCount,
    ReferencedSurfaceSequence,
    ReferencedSurfaceNumber,
    AlgorithmFamilyCodeSequence,
    AlgorithmNameCodeSequence,
    AlgorithmVersion,
    AlgorithmParameters,
    SurfaceProcessingAlgorithmIdentificationSequence,
    AlgorithmName,
    RecommendedPointRadius,
    RecommendedLineThickness,
    ImplantSize,
    ImplantTemplateVersion,
    ReplacedImplantTemplateSequence,
    ImplantType,
    DerivationImplantTemplateSequence,
    OriginalImplantTemplateSequence,
    EffectiveDateTime,
    ImplantTargetAnatomySequence,
    InformationFromManufacturerSequence,
    NotificationFromManufacturerSequence,
    InformationIssueDateTime,
    InformationSummary,
    ImplantRegulatoryDisapprovalCodeSequence,
    OverallTemplateSpatialTolerance,
    HPGLDocumentSequence,
    HPGLDocumentID,
    HPGLDocumentLabel,
    ViewOrientationCodeSequence,
    ViewOrientationModifierCodeSequence,
    HPGLDocumentScaling,
    HPGLDocument,
    HPGLContourPenNumber,
    HPGLPenSequence,
    RecommendedRotationPoint,
    BoundingRectangle,
    ImplantTemplate3DModelSurfaceNumber,
    SurfaceModelDescriptionSequence,
    SurfaceModelLabel,
    SurfaceModelScalingFactor,
    MaterialsCodeSequence,
    CoatingMaterialsCodeSequence,
    ImplantTypeCodeSequence,
    FixationMethodCodeSequence,
    MatingFeatureSetsSequence,
    MatingFeatureSetID,
    MatingFeatureSetLabel,
    MatingFeatureSequence,
    ReferencedHPGLDocumentID,
    PlanningLandmarkPointSequence,
    PlanningLandmarkLineSequence,
    PlanningLandmarkPlaneSequence,
    PlanningLandmarkID,
    PlanningLandmarkDescription,
    PlanningLandmarkIdentificationCodeSequence,
    TwoDPointCoordinatesSequence,
    TwoDPointCoordinates,
    ThreeDPointCoordinates,
    TwoDLineCoordinatesSequence,
    TwoDLineCoordinates,
    ThreeDLineCoordinates,
    TwoDPlaneCoordinatesSequence,
    TwoDPlaneIntersection,
    ThreeDPlaneOrigin,
    ThreeDPlaneNormal,
    ModelModification,
    ModelMirroring,
    ModelUsageCodeSequence,
    ModelGroupUID,
    RelativeURIReferenceWithinEncapsulatedDocument,
    UnformattedTextValue,
    BoundingBoxTextHorizontalJustification,
    GraphicData,
    GraphicType,
    ContentLabel,
    ContentDescription,
    PresentationCreationDate,
    PresentationCreationTime,
    ContentCreatorName,
    ContentCreatorIdentificationCodeSequence,
    AlternateContentDescriptionSequence,
    FiducialUID,
    FiducialSetSequence,
    FiducialSequence,
    GraphicLayerRecommendedDisplayCIELabValue,
    ReferencedSpatialRegistrationSequence,
    RenderProjection,
    ViewpointPosition,
    ViewpointLookAtPoint,
    ViewpointUpDirection,
    RenderFieldOfView,
    HangingProtocolName,
    HangingProtocolCreator,
    NumberOfScreens,
    NominalScreenDefinitionSequence,
    NumberOfVerticalPixels,
    NumberOfHorizontalPixels,
    DisplayEnvironmentSpatialPosition,
    ScreenMinimumGrayscaleBitDepth,
    ScreenMinimumColorBitDepth,
    ApplicationMaximumRepaintTime,
    ImageBoxNumber,
    ImageBoxLayoutType,
    ImageBoxTileHorizontalDimension,
    ImageBoxTileVerticalDimension,
    ImageBoxOverlapPriority,
    CineRelativeToRealTime,
    StructuredDisplayBackgroundCIELabValue,
    EmptyImageBoxCIELabValue,
    StructuredDisplayImageBoxSequence,
    StructuredDisplayTextBoxSequence,
    ReferencedFirstFrameSequence,
    ImageBoxSynchronizationSequence,
    SynchronizedImageBoxList,
    TypeOfSynchronization,
    DisplaySetHorizontalJustification,
    DisplaySetVerticalJustification,
    PerformedProcessingParametersSequence,
    SurfaceScanAcquisitionTypeCodeSequence,
    SurfaceScanModeCodeSequence,
    RegistrationMethodCodeSequence,
    ShotDurationTime,
    ShotOffsetTime,
    SurfacePointPresentationValueData,
    SurfacePointColorCIELabValueData,
    UVMappingSequence,
    TextureLabel,
    UValueData,
    VValueData,
    ReferencedTextureSequence,
    ReferencedSurfaceDataSequence,
    StorageMediaFileSetID,
    StorageMediaFileSetUID,
    IconImageSequence,
    SOPInstanceStatus,
    SOPAuthorizationDateTime,
    SOPAuthorizationComment,
    AuthorizationEquipmentCertificationNumber,
    MACIDNumber,
    MACCalculationTransferSyntaxUID,
    MACAlgorithm,
    DataElementsSigned,
    DigitalSignatureUID,
    DigitalSignatureDateTime,
    CertificateType,
    CertificateOfSigner,
    Signature,
    CertifiedTimestampType,
    CertifiedTimestamp,
    DigitalSignaturePurposeCodeSequence,
    ReferencedDigitalSignatureSequence,
    ReferencedSOPInstanceMACSequence,
    EncryptedAttributesSequence,
    EncryptedContentTransferSyntaxUID,
    EncryptedContent,
    ModifiedAttributesSequence,
    NonconformingModifiedAttributesSequence,
    OriginalAttributesSequence,
    AttributeModificationDateTime,
    ModifyingSystem,
    SourceOfPreviousValues,
    ReasonForTheAttributeModification,
    InstanceOriginStatus,
    Illumination,
    ReflectedAmbientLight,
    PresentationLUTShape,
    LabelText,
    BarcodeValue,
    RTImageLabel,
    RTImageName,
    RTImageDescription,
    ReportedValuesOrigin,
    RTImagePlane,
    XRayImageReceptorTranslation,
    XRayImageReceptorAngle,
    RTImageOrientation,
    ImagePlanePixelSpacing,
    RTImagePosition,
    RadiationMachineName,
    RadiationMachineSAD,
    RadiationMachineSSD,
    RTImageSID,
    SourceToReferenceObjectDistance,
    FractionNumber,
    ExposureSequence,
    MetersetExposure,
    DiaphragmPosition,
    FluenceMapSequence,
    FluenceDataSource,
    FluenceDataScale,
    PrimaryFluenceModeSequence,
    SelectedFrameNumber,
    SelectedFrameFunctionalGroupsSequence,
    RTImageFrameGeneralContentSequence,
    RTImageFrameContextSequence,
    RTImageScopeSequence,
    BeamModifierCoordinatesPresenceFlag,
    StartCumulativeMeterset,
    StopCumulativeMeterset,
    RTImageFrameImagingDevicePositionSequence,
    RTImageFramekVRadiationAcquisitionSequence,
    RTImageFrameMVRadiationAcquisitionSequence,
    RTImageFrameRadiationAcquisitionSequence,
    ImagingSourcePositionSequence,
    ImageReceptorPositionSequence,
    DevicePositionToEquipmentMappingMatrix,
    DevicePositionParameterSequence,
    NumberOfAcquisitionDevices,
    AcquisitionDeviceSequence,
    DVHType,
    DoseUnits,
    DoseType,
    SpatialTransformOfDose,
    DoseComment,
    NormalizationPoint,
    DoseSummationType,
    GridFrameOffsetVector,
    DoseGridScaling,
    TissueHeterogeneityCorrection,
    DVHNormalizationPoint,
    DVHNormalizationDoseValue,
    DVHSequence,
    DVHDoseScaling,
    DVHVolumeUnits,
    DVHNumberOfBins,
    DVHData,
    DVHReferencedROISequence,
    DVHMinimumDose,
    DVHMaximumDose,
    DVHMeanDose,
    ReferencedFrameOfReferenceUID,
    ReferencedROINumber,
    FrameOfReferenceTransformationComment,
    PatientLocationCoordinatesSequence,
    PatientLocationCoordinatesCodeSequence,
    PatientSupportPositionSequence,
    CurrentFractionNumber,
    ReferencedTreatmentRecordSequence,
    EnhancedRTBeamLimitingDeviceSequence,
    EnhancedRTBeamLimitingOpeningSequence,
    EnhancedRTBeamLimitingDeviceDefinitionFlag,
    ParallelRTBeamDelimiterOpeningExtents,
    RTPlanLabel,
    PrimaryDosimeterUnit,
    BeamLimitingDeviceSequence,
    NumberOfBlocks,
    BlockSequence,
    ApplicatorSequence,
    GantryAngle,
    BeamLimitingDeviceAngle,
    PatientSupportAngle,
    TableTopEccentricAxisDistance,
    TableTopEccentricAngle,
    TableTopVerticalPosition,
    TableTopLongitudinalPosition,
    TableTopLateralPosition,
    IsocenterPosition,
    TableTopPitchAngle,
    TableTopRollAngle,
    GantryPitchAngle,
    GeneralAccessorySequence,
    ReferencedDefinedDeviceIndex,
    TreatmentPositionIndex,
    ReferencedDeviceIndex,
    ReferencedTreatmentPositionIndex,
    ReferencedRTAccessoryHolderDeviceIndex,
    RTAccessoryHolderSlotID,
    RTAccessorySlotDistance,
    RTAccessoryDeviceSlotID,
    TreatmentPositionSequence,
    NumberOfRTBeamLimitingDevices,
    RTBeamLimitingDeviceProximalDistance,
    RTBeamLimitingDeviceDistalDistance,
    ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence,
    BeamModifierOrientationAngle,
    FixedRTBeamDelimiterDeviceSequence,
    ParallelRTBeamDelimiterDeviceSequence,
    NumberOfParallelRTBeamDelimiters,
    ParallelRTBeamDelimiterBoundaries,
    ParallelRTBeamDelimiterPositions,
    RTBeamLimitingDeviceOffset,
    RTBeamDelimiterGeometrySequence,
    RTBeamLimitingDeviceDefinitionSequence,
    ParallelRTBeamDelimiterOpeningMode,
    ParallelRTBeamDelimiterLeafMountingSide,
    RTBeamLimitingDeviceOpeningSequence,
    RadiationDosimeterUnitSequence,
    RTDeviceDistanceReferenceLocationCodeSequence,
    PatientSupportPositionParameterSequence,
    PatientSupportPositionSpecificationMethod,
    PatientSupportPositionDeviceParameterSequence,
    DeviceOrderIndex,
    GeneralAccessoryDefinitionSequence,
    NumberOfGeneralAccessories,
    EquipmentFrameOfReferenceUID,
    PatientSupportDevicesSequence,
    NumberOfPatientSupportDevices,
    RTBeamModifierDefinitionDistance,
    TreatmentSessionUID,
    RTRadiationSetDeliveryNumber,
    ClinicalFractionNumber,
    ReferencedRTPlanSequence,
    ReferencedBeamSequence,
    ReferencedBeamNumber,
    StartCumulativeMetersetWeight,
    EndCumulativeMetersetWeight,
    ReferencedFractionGroupSequence,
    ReferencedFractionGroupNumber,
    ReferencedStructureSetSequence,
    PrescriptionOverviewSequence,
    PlanOverviewSequence,
    PlanOverviewIndex,
    ReferencedPlanOverviewIndex,
    NumberOfFractionsIncluded,
    ApprovalStatus,
    ReviewDate,
    ReviewTime,
    ReviewerName,
    AuthorIdentificationSequence,
    ManufacturerModelVersion,
    DeviceAlternateIdentifier,
    DeviceAlternateIdentifierType,
    DeviceAlternateIdentifierFormat,
    ConceptualVolumeSequence,
    DeviceLabel,
    DeviceTypeCodeSequence,
    PatientEquipmentRelationshipCodeSequence,
    EntityDescription,
    EntityLongLabel,
    DeviceIndex,
    ManufacturerDeviceIdentifier,
    InstanceLevelReferencedPerformedProcedureStepSequence,
    TreatmentSite,
    TreatmentSiteCodeSequence,
    MACParametersSequence,
    SharedFunctionalGroupsSequence,
    PerFrameFunctionalGroupsSequence,
    OverlayRows,
    OverlayColumns,
    NumberOfFramesInOverlay,
    OverlayDescription,
    OverlayType,
    OverlaySubtype,
    OverlayOrigin,
    ImageFrameOrigin,
    OverlayBitsAllocated,
    OverlayBitPosition,
    ROIArea,
    ROIMean,
    ROIStandardDeviation,
    OverlayLabel,
    OverlayData,
    ExtendedOffsetTable,
    ExtendedOffsetTableLengths,
    EncapsulatedPixelDataValueTotalLength,
    FloatPixelData,
    DoubleFloatPixelData,
    PixelData,
    DigitalSignaturesSequence,
    _SIZE
};

enum class VR : std::uint8_t
{
    INVALID = 0,
    AE,
    AS,
    AT,
    CS,
    DA,
    DS,
    DT,
    FD,
    FL,
    IS,
    LO,
    LT,
    OB,
    OB_OW,
    OD,
    OF,
    OL,
    OV,
    OW,
    OW_US,
    PN,
    SH,
    SL,
    SQ,
    SS,
    SS_US,
    ST,
    SV,
    TM,
    UC,
    UI,
    UL,
    UN,
    UR,
    US,
    UT,
    UV,
    _SIZE
};

enum class VM : std::uint8_t
{
    INVALID = 0,
    MIN_16_MAX_16,
    MIN_1_MAX_1,
    MIN_1_MAX_2,
    MIN_1_MAX_3,
    MIN_1_MAX_8,
    MIN_1_MAX_N,
    MIN_2_MAX_2,
    MIN_2_MAX_2N,
    MIN_2_MAX_4,
    MIN_2_MAX_N,
    MIN_3_MAX_3,
    MIN_3_MAX_3N,
    MIN_3_MAX_N,
    MIN_4_MAX_4,
    MIN_4_MAX_5,
    MIN_6_MAX_6,
    MIN_6_MAX_N,
    MIN_9_MAX_9,
    _SIZE
};

struct SIGHT_DATA_CLASS_API IAttribute
{
    constexpr IAttribute(
        const Keyword& keyword,
        const std::uint16_t& group,
        const std::uint16_t& element,
        const std::string_view& name,
        const VR& vr,
        const VM& vm
    ) noexcept :
        m_keyword(keyword),
        m_group(group),
        m_element(element),
        m_name(name),
        m_vr(vr),
        m_vm(vm)
    {
    }

    //------------------------------------------------------------------------------

    constexpr operator Keyword() const noexcept
    {
        return m_keyword;
    }

    //------------------------------------------------------------------------------

    constexpr auto operator==(const IAttribute& other) const noexcept
    {
        return m_keyword == other.m_keyword;
    }

    const Keyword& m_keyword;
    const std::uint16_t& m_group;
    const std::uint16_t& m_element;
    const std::string_view& m_name;
    const VR& m_vr;
    const VM& m_vm;
};

template<Keyword>
struct SIGHT_DATA_CLASS_API Attribute final : public IAttribute
{
    constexpr Attribute() noexcept :
        IAttribute(s_keyword, s_group, s_element, s_name, s_vr, s_vm)
    {
    }

    SIGHT_DATA_API static const Keyword s_keyword;
    SIGHT_DATA_API static const std::uint16_t s_group;
    SIGHT_DATA_API static const std::uint16_t s_element;
    SIGHT_DATA_API static const std::string_view s_name;
    SIGHT_DATA_API static const VR s_vr;
    SIGHT_DATA_API static const VM s_vm;
};

/// @return a static const reference to an Attribute
/// @{
SIGHT_DATA_API const IAttribute& get(Keyword keyword);
SIGHT_DATA_API const IAttribute& get(std::uint16_t group, std::uint16_t element);
/// @}

} // namespace sight::data::dicom::attribute

// NOLINTEND
