/*
 * Decompiled with CFR 0.152.
 */
package usbsid;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Config {

    public static enum Cfg {
        RESET_USBSID(32),
        READ_CONFIG(48),
        APPLY_CONFIG(49),
        SET_CONFIG(50),
        SAVE_CONFIG(51),
        SAVE_NORESET(52),
        RESET_CONFIG(53),
        WRITE_CONFIG(54),
        READ_SOCKETCFG(55),
        RELOAD_CONFIG(56),
        READ_NUMSIDS(57),
        READ_FMOPLSID(58),
        SINGLE_SID(64),
        DUAL_SID(65),
        QUAD_SID(66),
        TRIPLE_SID(67),
        TRIPLE_SID_TWO(68),
        MIRRORED_SID(69),
        DUAL_SOCKET1(70),
        DUAL_SOCKET2(71),
        SET_CLOCK(80),
        DETECT_SIDS(81),
        TEST_ALLSIDS(82),
        TEST_SID1(83),
        TEST_SID2(84),
        TEST_SID3(85),
        TEST_SID4(86),
        GET_CLOCK(87),
        LOCK_CLOCK(88),
        STOP_TESTS(89),
        LOAD_MIDI_STATE(96),
        SAVE_MIDI_STATE(97),
        RESET_MIDI_STATE(99),
        USBSID_VERSION(-128),
        US_PCB_VERSION(-127),
        RESTART_BUS(-123),
        RESTART_BUS_CLK(-122),
        SYNC_PIOS(-121),
        TOGGLE_AUDIO(-120),
        SET_AUDIO(-119);

        private byte cmd;
        private static final Map<Byte, Cfg> lookup;

        private Cfg(byte cmd) {
            this.cmd = cmd;
        }

        public byte get() {
            return this.cmd;
        }

        public static Cfg getCfgCmd(byte cmd) {
            return lookup.get(cmd);
        }

        static {
            lookup = Collections.unmodifiableMap(Arrays.asList(Cfg.values()).stream().collect(Collectors.toMap(Cfg::get, Function.identity())));
        }
    }

    public static enum CLK {
        DEFAULT(1000000),
        PAL(985248),
        NTSC(1022727),
        DREAN(1023440),
        NTSC2(1022730);

        private int clk;
        private static final Map<Integer, CLK> lookup;

        private CLK(int clk) {
            this.clk = clk;
        }

        public int get() {
            return this.clk;
        }

        public static CLK getCLK(int clk) {
            return lookup.get(clk);
        }

        public static int clkID(CLK clock) {
            switch (clock.ordinal()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
            }
            return 1;
        }

        public static int IDclk(int clock) {
            switch (clock) {
                case 0: {
                    return DEFAULT.get();
                }
                case 1: {
                    return PAL.get();
                }
                case 2: {
                    return NTSC.get();
                }
                case 3: {
                    return DREAN.get();
                }
                case 4: {
                    return NTSC2.get();
                }
            }
            return PAL.get();
        }

        static {
            lookup = Collections.unmodifiableMap(Arrays.asList(CLK.values()).stream().collect(Collectors.toMap(CLK::get, Function.identity())));
        }
    }
}

