#include "test.h"


typedef short v8hi __attribute__((vector_size(16)));

int main() {
    // pmulhrsw128: (a[i] * b[i] + 0x4000) >> 15  with signed saturation.

    v8hi a = {3000, -3000, 10000, -10000, 20000, -20000, 0, 1234};
    v8hi b = {2, 2, -3, -3, 4, 4, 0, -10};

    v8hi r = __builtin_ia32_pmulhrsw128(a, b);

    // Expected:
    // i=0: (3000*2 + 0x4000) >> 15 = (6000+16384)>>15 = 22384>>15 = 0
    // i=1: (-3000*2 + 16384)>>15 = ( -6000+16384)>>15 = 10384>>15 = 0
    // i=2: (10000 * -3 + 16384) >> 15 = (-30000+16384)>>15 = -13616>>15 = -1
    // i=3: (-10000 * -3 + 16384)>>15 = (30000+16384)>>15 = 46384>>15 = 1
    // i=4: (20000*4 + 16384)>>15 = (80000+16384)>>15 = 96384>>15 = 2
    // i=5: (-20000*4 + 16384)>>15 = (-80000+16384)>>15 = (-63616)>>15 = -2
    // i=6: (0*0 + 16384)>>15 = 16384>>15 = 0
    // i=7: (1234 * -10 + 16384)>>15 = (-12340+16384)>>15 = 4044>>15 = 0

    ASSERT(0, r[0]);
    ASSERT(0, r[1]);
    ASSERT(-1, r[2]);
    ASSERT(1, r[3]);
    ASSERT(2, r[4]);
    ASSERT(-2, r[5]);
    ASSERT(0, r[6]);
    ASSERT(0, r[7]);

    printf("pmulhrsw128 OK\n");
    return 0;
}
