/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ObjectName;
import org.apache.catalina.Engine;
import org.apache.catalina.Executor;
import org.apache.catalina.JmxEnabled;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.mapper.Mapper;
import org.apache.catalina.mapper.MapperListener;
import org.apache.catalina.util.LifecycleBase;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class StandardService
extends LifecycleMBeanBase
implements Service {
    private static final Log log = LogFactory.getLog(StandardService.class);
    private static final StringManager sm = StringManager.getManager(StandardService.class);
    private String name = null;
    private Server server = null;
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Connector[] connectors = new Connector[0];
    private final ReadWriteLock connectorsLock = new ReentrantReadWriteLock();
    protected final ArrayList<Executor> executors = new ArrayList();
    private final ReadWriteLock executorsLock = new ReentrantReadWriteLock();
    private Engine engine = null;
    private ClassLoader parentClassLoader = null;
    protected final Mapper mapper = new Mapper();
    protected final MapperListener mapperListener = new MapperListener(this);
    private long gracefulStopAwaitMillis = 0L;

    public long getGracefulStopAwaitMillis() {
        return this.gracefulStopAwaitMillis;
    }

    public void setGracefulStopAwaitMillis(long l) {
        this.gracefulStopAwaitMillis = l;
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    @Override
    public Engine getContainer() {
        return this.engine;
    }

    @Override
    public void setContainer(Engine engine) {
        Engine engine2 = this.engine;
        if (engine2 != null) {
            engine2.setService(null);
        }
        this.engine = engine;
        if (this.engine != null) {
            this.engine.setService(this);
        }
        if (this.getState().isAvailable()) {
            if (this.engine != null) {
                try {
                    this.engine.start();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)sm.getString("standardService.engine.startFailed"), (Throwable)lifecycleException);
                }
            }
            try {
                this.mapperListener.stop();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("standardService.mapperListener.stopFailed"), (Throwable)lifecycleException);
            }
            try {
                this.mapperListener.start();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("standardService.mapperListener.startFailed"), (Throwable)lifecycleException);
            }
            if (engine2 != null) {
                try {
                    engine2.stop();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)sm.getString("standardService.engine.stopFailed"), (Throwable)lifecycleException);
                }
            }
        }
        this.support.firePropertyChange("container", engine2, this.engine);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnector(Connector connector) {
        Lock lock = this.connectorsLock.writeLock();
        lock.lock();
        try {
            connector.setService(this);
            Connector[] connectorArray = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, connectorArray, 0, this.connectors.length);
            connectorArray[this.connectors.length] = connector;
            this.connectors = connectorArray;
        }
        finally {
            lock.unlock();
        }
        try {
            if (this.getState().isAvailable()) {
                connector.start();
            }
        }
        catch (LifecycleException lifecycleException) {
            throw new IllegalArgumentException(sm.getString("standardService.connector.startFailed", new Object[]{connector}), lifecycleException);
        }
        this.support.firePropertyChange("connector", null, connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getConnectorNames() {
        Lock lock = this.connectorsLock.readLock();
        lock.lock();
        try {
            ObjectName[] objectNameArray = new ObjectName[this.connectors.length];
            for (int i = 0; i < objectNameArray.length; ++i) {
                objectNameArray[i] = this.connectors[i].getObjectName();
            }
            ObjectName[] objectNameArray2 = objectNameArray;
            return objectNameArray2;
        }
        finally {
            lock.unlock();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public Connector[] findConnectors() {
        Lock lock = this.connectorsLock.readLock();
        lock.lock();
        try {
            Connector[] connectorArray = (Connector[])this.connectors.clone();
            return connectorArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnector(Connector connector) {
        Lock lock = this.connectorsLock.writeLock();
        lock.lock();
        try {
            int n;
            int n2 = -1;
            for (n = 0; n < this.connectors.length; ++n) {
                if (connector != this.connectors[n]) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                return;
            }
            n = 0;
            Connector[] connectorArray = new Connector[this.connectors.length - 1];
            for (int i = 0; i < this.connectors.length; ++i) {
                if (i == n2) continue;
                connectorArray[n++] = this.connectors[i];
            }
            this.connectors = connectorArray;
        }
        finally {
            lock.unlock();
        }
        if (connector.getState().isAvailable()) {
            try {
                connector.stop();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("standardService.connector.stopFailed", new Object[]{connector}), (Throwable)lifecycleException);
            }
        }
        connector.setService(null);
        this.support.firePropertyChange("connector", connector, null);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        return "StandardService[" + this.getName() + "]";
    }

    @Override
    public void addExecutor(Executor executor) {
        boolean bl = false;
        this.executorsLock.writeLock().lock();
        try {
            if (!this.executors.contains(executor)) {
                bl = true;
                this.executors.add(executor);
            }
        }
        finally {
            this.executorsLock.writeLock().unlock();
        }
        if (bl && this.getState().isAvailable()) {
            try {
                executor.start();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("standardService.executor.start"), (Throwable)lifecycleException);
            }
        }
    }

    @Override
    public Executor[] findExecutors() {
        this.executorsLock.readLock().lock();
        try {
            Executor[] executorArray = this.executors.toArray(new Executor[0]);
            return executorArray;
        }
        finally {
            this.executorsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor getExecutor(String string) {
        this.executorsLock.readLock().lock();
        try {
            for (Executor executor : this.executors) {
                if (!string.equals(executor.getName())) continue;
                Executor executor2 = executor;
                return executor2;
            }
        }
        finally {
            this.executorsLock.readLock().unlock();
        }
        return null;
    }

    @Override
    public void removeExecutor(Executor executor) {
        boolean bl;
        this.executorsLock.writeLock().lock();
        try {
            bl = this.executors.remove(executor);
        }
        finally {
            this.executorsLock.writeLock().unlock();
        }
        if (bl && this.getState().isAvailable()) {
            try {
                executor.stop();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("standardService.executor.stop"), (Throwable)lifecycleException);
            }
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardService.start.name", new Object[]{this.name}));
        }
        this.setState(LifecycleState.STARTING);
        if (this.engine != null) {
            this.engine.start();
        }
        for (Executor lifecycle : this.findExecutors()) {
            lifecycle.start();
        }
        this.mapperListener.start();
        for (Lifecycle lifecycle : this.findConnectors()) {
            if (((LifecycleBase)lifecycle).getState() == LifecycleState.FAILED) continue;
            ((LifecycleBase)lifecycle).start();
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        Connector[] connectorArray;
        for (Connector connector : connectorArray = this.findConnectors()) {
            connector.getProtocolHandler().closeServerSocketGraceful();
        }
        long l = this.gracefulStopAwaitMillis;
        if (l > 0L) {
            Connector[] connectorArray2 = connectorArray;
            int n = connectorArray2.length;
            for (int i = 0; i < n; ++i) {
                Connector lifecycle = connectorArray2[i];
                l = lifecycle.getProtocolHandler().awaitConnectionsClose(l);
            }
        }
        for (Connector connector : connectorArray) {
            connector.pause();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardService.stop.name", new Object[]{this.name}));
        }
        this.setState(LifecycleState.STOPPING);
        if (this.engine != null) {
            this.engine.stop();
        }
        for (Connector connector : connectorArray) {
            if (!LifecycleState.STARTED.equals((Object)connector.getState())) continue;
            connector.stop();
        }
        if (this.mapperListener.getState() != LifecycleState.INITIALIZED) {
            this.mapperListener.stop();
        }
        for (Lifecycle lifecycle : this.findExecutors()) {
            lifecycle.stop();
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.engine != null) {
            this.engine.init();
        }
        for (Executor lifecycle : this.findExecutors()) {
            if (lifecycle instanceof JmxEnabled) {
                ((JmxEnabled)((Object)lifecycle)).setDomain(this.getDomain());
            }
            lifecycle.init();
        }
        this.mapperListener.init();
        for (Lifecycle lifecycle : this.findConnectors()) {
            ((LifecycleBase)lifecycle).init();
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        this.mapperListener.destroy();
        for (Connector lifecycle : this.findConnectors()) {
            lifecycle.destroy();
        }
        for (Lifecycle lifecycle : this.findExecutors()) {
            lifecycle.destroy();
        }
        if (this.engine != null) {
            this.engine.destroy();
        }
        super.destroyInternal();
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.server != null) {
            return this.server.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader classLoader) {
        ClassLoader classLoader2 = this.parentClassLoader;
        this.parentClassLoader = classLoader;
        this.support.firePropertyChange("parentClassLoader", classLoader2, this.parentClassLoader);
    }

    @Override
    protected String getDomainInternal() {
        String string = null;
        Engine engine = this.getContainer();
        if (engine != null) {
            string = engine.getName();
        }
        if (string == null) {
            string = this.getName();
        }
        return string;
    }

    @Override
    public final String getObjectNameKeyProperties() {
        return "type=Service";
    }
}

