/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import org.apache.tomcat.util.digester.Rule;
import org.xml.sax.Attributes;

public class ObjectCreateRule
extends Rule {
    protected String attributeName;
    protected String className;

    public ObjectCreateRule(String string) {
        this(string, null);
    }

    public ObjectCreateRule(String string, String string2) {
        this.className = string;
        this.attributeName = string2;
    }

    @Override
    public void begin(String string, String string2, Attributes attributes) throws Exception {
        String string3 = this.getRealClassName(attributes);
        if (string3 == null) {
            throw new NullPointerException(sm.getString("rule.noClassName", new Object[]{string, string2}));
        }
        Class<?> clazz = this.digester.getClassLoader().loadClass(string3);
        Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        this.digester.push(obj);
        StringBuilder stringBuilder = this.digester.getGeneratedCode();
        if (stringBuilder != null) {
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append(string3).append(' ').append(this.digester.toVariableName(obj)).append(" = new ");
            stringBuilder.append(string3).append("();").append(System.lineSeparator());
        }
    }

    protected String getRealClassName(Attributes attributes) {
        String string;
        String string2 = this.className;
        if (this.attributeName != null && (string = attributes.getValue(this.attributeName)) != null) {
            string2 = string;
        }
        return string2;
    }

    @Override
    public void end(String string, String string2) throws Exception {
        Object object = this.digester.pop();
        if (this.digester.log.isTraceEnabled()) {
            this.digester.log.trace((Object)("[ObjectCreateRule]{" + this.digester.match + "} Pop " + object.getClass().getName()));
        }
    }

    public String toString() {
        return "ObjectCreateRule[className=" + this.className + ", attributeName=" + this.attributeName + "]";
    }
}

