/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ism;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ism.ChangePolicyResponse;
import org.opensearch.client.opensearch.ism.IncludeState;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class ChangePolicyRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ChangePolicyRequest> {
    @Nonnull
    private final List<IncludeState> include;
    @Nullable
    private final String index;
    @Nonnull
    private final String policyId;
    @Nullable
    private final String state;
    public static final JsonpDeserializer<ChangePolicyRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChangePolicyRequest::setupChangePolicyRequestDeserializer);
    public static final Endpoint<ChangePolicyRequest, ChangePolicyResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ChangePolicyRequest, ChangePolicyResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_plugins/_ism/change_policy";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_plugins/_ism/change_policy/");
            SimpleEndpoint.pathEncode(request.index, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, ChangePolicyResponse._DESERIALIZER);

    private ChangePolicyRequest(Builder builder) {
        super(builder);
        this.include = ApiTypeHelper.unmodifiable(builder.include);
        this.index = builder.index;
        this.policyId = ApiTypeHelper.requireNonNull(builder.policyId, this, "policyId");
        this.state = builder.state;
    }

    public static ChangePolicyRequest of(Function<Builder, ObjectBuilder<ChangePolicyRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<IncludeState> include() {
        return this.include;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nonnull
    public final String policyId() {
        return this.policyId;
    }

    @Nullable
    public final String state() {
        return this.state;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.include)) {
            generator.writeKey("include");
            generator.writeStartArray();
            for (IncludeState item0 : this.include) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("policy_id");
        generator.write(this.policyId);
        if (this.state != null) {
            generator.writeKey("state");
            generator.write(this.state);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupChangePolicyRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::include, JsonpDeserializer.arrayDeserializer(IncludeState._DESERIALIZER), "include");
        op.add(Builder::policyId, JsonpDeserializer.stringDeserializer(), "policy_id");
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.include);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + this.policyId.hashCode();
        result = 31 * result + Objects.hashCode(this.state);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangePolicyRequest other = (ChangePolicyRequest)o;
        return Objects.equals(this.include, other.include) && Objects.equals(this.index, other.index) && this.policyId.equals(other.policyId) && Objects.equals(this.state, other.state);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ChangePolicyRequest> {
        @Nullable
        private List<IncludeState> include;
        @Nullable
        private String index;
        private String policyId;
        @Nullable
        private String state;

        public Builder() {
        }

        private Builder(ChangePolicyRequest o) {
            super(o);
            this.include = Builder._listCopy(o.include);
            this.index = o.index;
            this.policyId = o.policyId;
            this.state = o.state;
        }

        private Builder(Builder o) {
            super(o);
            this.include = Builder._listCopy(o.include);
            this.index = o.index;
            this.policyId = o.policyId;
            this.state = o.state;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder include(List<IncludeState> list) {
            this.include = Builder._listAddAll(this.include, list);
            return this;
        }

        @Nonnull
        public final Builder include(IncludeState value, IncludeState ... values) {
            this.include = Builder._listAdd(this.include, value, values);
            return this;
        }

        @Nonnull
        public final Builder include(Function<IncludeState.Builder, ObjectBuilder<IncludeState>> fn) {
            return this.include(fn.apply(new IncludeState.Builder()).build(), new IncludeState[0]);
        }

        @Nonnull
        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder policyId(String value) {
            this.policyId = value;
            return this;
        }

        @Nonnull
        public final Builder state(@Nullable String value) {
            this.state = value;
            return this;
        }

        @Override
        @Nonnull
        public ChangePolicyRequest build() {
            this._checkSingleUse();
            return new ChangePolicyRequest(this);
        }
    }
}

