/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.tasks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.tasks.CancelResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class CancelRequest
extends RequestBase
implements ToCopyableBuilder<Builder, CancelRequest> {
    @Nonnull
    private final List<String> actions;
    @Nonnull
    private final List<String> nodes;
    @Nullable
    private final String parentTaskId;
    @Nullable
    private final String taskId;
    @Nullable
    private final Boolean waitForCompletion;
    public static final Endpoint<CancelRequest, CancelResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CancelRequest, CancelResponse>(request -> "POST", request -> {
        boolean _taskId = true;
        boolean propsSet = false;
        if (request.taskId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_tasks/_cancel";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_tasks/");
            SimpleEndpoint.pathEncode(request.taskId, buf);
            buf.append("/_cancel");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, CancelResponse._DESERIALIZER);

    private CancelRequest(Builder builder) {
        super(builder);
        this.actions = ApiTypeHelper.unmodifiable(builder.actions);
        this.nodes = ApiTypeHelper.unmodifiable(builder.nodes);
        this.parentTaskId = builder.parentTaskId;
        this.taskId = builder.taskId;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static CancelRequest of(Function<Builder, ObjectBuilder<CancelRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> actions() {
        return this.actions;
    }

    @Nonnull
    public final List<String> nodes() {
        return this.nodes;
    }

    @Nullable
    public final String parentTaskId() {
        return this.parentTaskId;
    }

    @Nullable
    public final String taskId() {
        return this.taskId;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (ApiTypeHelper.isDefined(this.actions)) {
            params.put("actions", String.join((CharSequence)",", this.actions));
        }
        if (ApiTypeHelper.isDefined(this.nodes)) {
            params.put("nodes", String.join((CharSequence)",", this.nodes));
        }
        if (this.parentTaskId != null) {
            params.put("parent_task_id", this.parentTaskId);
        }
        if (this.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(this.waitForCompletion));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.actions);
        result = 31 * result + Objects.hashCode(this.nodes);
        result = 31 * result + Objects.hashCode(this.parentTaskId);
        result = 31 * result + Objects.hashCode(this.taskId);
        result = 31 * result + Objects.hashCode(this.waitForCompletion);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelRequest other = (CancelRequest)o;
        return Objects.equals(this.actions, other.actions) && Objects.equals(this.nodes, other.nodes) && Objects.equals(this.parentTaskId, other.parentTaskId) && Objects.equals(this.taskId, other.taskId) && Objects.equals(this.waitForCompletion, other.waitForCompletion);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CancelRequest> {
        @Nullable
        private List<String> actions;
        @Nullable
        private List<String> nodes;
        @Nullable
        private String parentTaskId;
        @Nullable
        private String taskId;
        @Nullable
        private Boolean waitForCompletion;

        public Builder() {
        }

        private Builder(CancelRequest o) {
            super(o);
            this.actions = Builder._listCopy(o.actions);
            this.nodes = Builder._listCopy(o.nodes);
            this.parentTaskId = o.parentTaskId;
            this.taskId = o.taskId;
            this.waitForCompletion = o.waitForCompletion;
        }

        private Builder(Builder o) {
            super(o);
            this.actions = Builder._listCopy(o.actions);
            this.nodes = Builder._listCopy(o.nodes);
            this.parentTaskId = o.parentTaskId;
            this.taskId = o.taskId;
            this.waitForCompletion = o.waitForCompletion;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder actions(List<String> list) {
            this.actions = Builder._listAddAll(this.actions, list);
            return this;
        }

        @Nonnull
        public final Builder actions(String value, String ... values) {
            this.actions = Builder._listAdd(this.actions, value, values);
            return this;
        }

        @Nonnull
        public final Builder nodes(List<String> list) {
            this.nodes = Builder._listAddAll(this.nodes, list);
            return this;
        }

        @Nonnull
        public final Builder nodes(String value, String ... values) {
            this.nodes = Builder._listAdd(this.nodes, value, values);
            return this;
        }

        @Nonnull
        public final Builder parentTaskId(@Nullable String value) {
            this.parentTaskId = value;
            return this;
        }

        @Nonnull
        public final Builder taskId(@Nullable String value) {
            this.taskId = value;
            return this;
        }

        @Nonnull
        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        @Nonnull
        public CancelRequest build() {
            this._checkSingleUse();
            return new CancelRequest(this);
        }
    }
}

