/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene91;

public abstract class Lucene91BoundsChecker {
    float bound;

    public abstract void update(float var1);

    public void set(float sample) {
        this.bound = sample;
    }

    public abstract boolean check(float var1);

    public static Lucene91BoundsChecker create(boolean reversed) {
        if (reversed) {
            return new Min();
        }
        return new Max();
    }

    public static class Min
    extends Lucene91BoundsChecker {
        Min() {
            this.bound = Float.POSITIVE_INFINITY;
        }

        @Override
        public void update(float sample) {
            if (sample < this.bound) {
                this.bound = sample;
            }
        }

        @Override
        public boolean check(float sample) {
            return sample > this.bound;
        }
    }

    public static class Max
    extends Lucene91BoundsChecker {
        Max() {
            this.bound = Float.NEGATIVE_INFINITY;
        }

        @Override
        public void update(float sample) {
            if (sample > this.bound) {
                this.bound = sample;
            }
        }

        @Override
        public boolean check(float sample) {
            return sample < this.bound;
        }
    }
}

