/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pt extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u00e1rabe";
        final String metaValue_hy = "arm\u00eanio";
        final String metaValue_ae = "av\u00e9stico";
        final String metaValue_ban = "balin\u00eas";
        final String metaValue_bax = "bamum";
        final String metaValue_bn = "bengali";
        final String metaValue_bug = "bugin\u00eas";
        final String metaValue_ka = "georgiano";
        final String metaValue_got = "g\u00f3tico";
        final String metaValue_el = "grego";
        final String metaValue_gu = "guzerate";
        final String metaValue_he = "hebraico";
        final String metaValue_jv = "javan\u00eas";
        final String metaValue_ja = "japon\u00eas";
        final String metaValue_km = "khmer";
        final String metaValue_ko = "coreano";
        final String metaValue_la = "latim";
        final String metaValue_ml = "malaiala";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birman\u00eas";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_or = "ori\u00e1";
        final String metaValue_phn = "fen\u00edcio";
        final String metaValue_si = "cingal\u00eas";
        final String metaValue_su = "sundan\u00eas";
        final String metaValue_syr = "sir\u00edaco";
        final String metaValue_ta = "t\u00e2mil";
        final String metaValue_te = "t\u00e9lugo";
        final String metaValue_tl = "tagalo";
        final String metaValue_th = "tailand\u00eas";
        final String metaValue_bo = "tibetano";
        final String metaValue_uga = "ugar\u00edtico";
        final String metaValue_vai = "vai";
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "Mundo" },
            { "002", "\u00c1frica" },
            { "003", "Am\u00e9rica do Norte" },
            { "005", "Am\u00e9rica do Sul" },
            { "009", "Oceania" },
            { "011", "\u00c1frica Ocidental" },
            { "013", "Am\u00e9rica Central" },
            { "014", "\u00c1frica Oriental" },
            { "015", "\u00c1frica do Norte" },
            { "017", "\u00c1frica Central" },
            { "018", "\u00c1frica Meridional" },
            { "019", "Am\u00e9ricas" },
            { "021", "Am\u00e9rica Setentrional" },
            { "029", "Caribe" },
            { "030", "\u00c1sia Oriental" },
            { "034", "\u00c1sia Meridional" },
            { "035", "Sudeste Asi\u00e1tico" },
            { "039", "Europa Meridional" },
            { "053", "Austral\u00e1sia" },
            { "054", "Melan\u00e9sia" },
            { "057", "Regi\u00e3o da Micron\u00e9sia" },
            { "061", "Polin\u00e9sia" },
            { "142", "\u00c1sia" },
            { "143", "\u00c1sia Central" },
            { "145", "\u00c1sia Ocidental" },
            { "150", "Europa" },
            { "151", "Europa Oriental" },
            { "154", "Europa Setentrional" },
            { "155", "Europa Ocidental" },
            { "202", "\u00c1frica Subsaariana" },
            { "419", "Am\u00e9rica Latina" },
            { "AC", "Ilha de Ascens\u00e3o" },
            { "AD", "Andorra" },
            { "AE", "Emirados \u00c1rabes Unidos" },
            { "AF", "Afeganist\u00e3o" },
            { "AG", "Ant\u00edgua e Barbuda" },
            { "AI", "Anguila" },
            { "AL", "Alb\u00e2nia" },
            { "AM", "Arm\u00eania" },
            { "AO", "Angola" },
            { "AQ", "Ant\u00e1rtida" },
            { "AR", "Argentina" },
            { "AS", "Samoa Americana" },
            { "AT", "\u00c1ustria" },
            { "AU", "Austr\u00e1lia" },
            { "AW", "Aruba" },
            { "AX", "Ilhas Aland" },
            { "AZ", "Azerbaij\u00e3o" },
            { "BA", "B\u00f3snia e Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "B\u00e9lgica" },
            { "BF", "Burquina Faso" },
            { "BG", "Bulg\u00e1ria" },
            { "BH", "Barein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "S\u00e3o Bartolomeu" },
            { "BM", "Bermudas" },
            { "BN", "Brunei" },
            { "BO", "Bol\u00edvia" },
            { "BQ", "Pa\u00edses Baixos Caribenhos" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "BT", "But\u00e3o" },
            { "BV", "Ilha Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "Bielorr\u00fassia" },
            { "BZ", "Belize" },
            { "CA", "Canad\u00e1" },
            { "CC", "Ilhas Cocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Rep\u00fablica Centro-Africana" },
            { "CG", "Rep\u00fablica do Congo" },
            { "CH", "Su\u00ed\u00e7a" },
            { "CI", "Costa do Marfim" },
            { "CK", "Ilhas Cook" },
            { "CL", "Chile" },
            { "CM", "Camar\u00f5es" },
            { "CN", "China" },
            { "CO", "Col\u00f4mbia" },
            { "CP", "Ilha de Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Ilha Christmas" },
            { "CY", "Chipre" },
            { "CZ", "Tch\u00e9quia" },
            { "DE", "Alemanha" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibuti" },
            { "DK", "Dinamarca" },
            { "DM", "Dominica" },
            { "DO", "Rep\u00fablica Dominicana" },
            { "DZ", "Arg\u00e9lia" },
            { "EA", "Ceuta e Melilla" },
            { "EC", "Equador" },
            { "EE", "Est\u00f4nia" },
            { "EG", "Egito" },
            { "EH", "Saara Ocidental" },
            { "ER", "Eritreia" },
            { "ES", "Espanha" },
            { "ET", "Eti\u00f3pia" },
            { "EU", "Uni\u00e3o Europeia" },
            { "EZ", "zona do euro" },
            { "FI", "Finl\u00e2ndia" },
            { "FJ", "Fiji" },
            { "FK", "Ilhas Malvinas" },
            { "FM", "Micron\u00e9sia" },
            { "FO", "Ilhas Faro\u00e9" },
            { "FR", "Fran\u00e7a" },
            { "GA", "Gab\u00e3o" },
            { "GB", "Reino Unido" },
            { "GD", "Granada" },
            { "GE", "Ge\u00f3rgia" },
            { "GF", "Guiana Francesa" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenl\u00e2ndia" },
            { "GM", "G\u00e2mbia" },
            { "GN", "Guin\u00e9" },
            { "GP", "Guadalupe" },
            { "GQ", "Guin\u00e9 Equatorial" },
            { "GR", "Gr\u00e9cia" },
            { "GS", "Ilhas Ge\u00f3rgia do Sul e Sandwich do Sul" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guin\u00e9-Bissau" },
            { "GY", "Guiana" },
            { "HK", "Hong Kong, RAE da China" },
            { "HM", "Ilhas Heard e McDonald" },
            { "HN", "Honduras" },
            { "HR", "Cro\u00e1cia" },
            { "HT", "Haiti" },
            { "HU", "Hungria" },
            { "IC", "Ilhas Can\u00e1rias" },
            { "ID", "Indon\u00e9sia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Ilha de Man" },
            { "IN", "\u00cdndia" },
            { "IO", "Territ\u00f3rio Brit\u00e2nico do Oceano \u00cdndico" },
            { "IQ", "Iraque" },
            { "IR", "Ir\u00e3" },
            { "IS", "Isl\u00e2ndia" },
            { "IT", "It\u00e1lia" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jord\u00e2nia" },
            { "JP", "Jap\u00e3o" },
            { "KE", "Qu\u00eania" },
            { "KG", "Quirguist\u00e3o" },
            { "KH", "Camboja" },
            { "KI", "Quiribati" },
            { "KM", "Comores" },
            { "KN", "S\u00e3o Crist\u00f3v\u00e3o e N\u00e9vis" },
            { "KP", "Coreia do Norte" },
            { "KR", "Coreia do Sul" },
            { "KW", "Kuwait" },
            { "KY", "Ilhas Cayman" },
            { "KZ", "Cazaquist\u00e3o" },
            { "LA", "Laos" },
            { "LB", "L\u00edbano" },
            { "LC", "Santa L\u00facia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Lib\u00e9ria" },
            { "LS", "Lesoto" },
            { "LT", "Litu\u00e2nia" },
            { "LU", "Luxemburgo" },
            { "LV", "Let\u00f4nia" },
            { "LY", "L\u00edbia" },
            { "MA", "Marrocos" },
            { "MC", "M\u00f4naco" },
            { "MD", "Mold\u00e1via" },
            { "ME", "Montenegro" },
            { "MF", "S\u00e3o Martinho" },
            { "MG", "Madagascar" },
            { "MH", "Ilhas Marshall" },
            { "MK", "Maced\u00f4nia do Norte" },
            { "ML", "Mali" },
            { "MM", "Mianmar (Birm\u00e2nia)" },
            { "MN", "Mong\u00f3lia" },
            { "MO", "Macau, RAE da China" },
            { "MP", "Ilhas Marianas do Norte" },
            { "MQ", "Martinica" },
            { "MR", "Maurit\u00e2nia" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Maur\u00edcio" },
            { "MV", "Maldivas" },
            { "MW", "Malaui" },
            { "MX", "M\u00e9xico" },
            { "MY", "Mal\u00e1sia" },
            { "MZ", "Mo\u00e7ambique" },
            { "NA", "Nam\u00edbia" },
            { "NC", "Nova Caled\u00f4nia" },
            { "NE", "N\u00edger" },
            { "NF", "Ilha Norfolk" },
            { "NG", "Nig\u00e9ria" },
            { "NI", "Nicar\u00e1gua" },
            { "NL", "Pa\u00edses Baixos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nova Zel\u00e2ndia" },
            { "OM", "Om\u00e3" },
            { "PA", "Panam\u00e1" },
            { "PE", "Peru" },
            { "PF", "Polin\u00e9sia Francesa" },
            { "PG", "Papua-Nova Guin\u00e9" },
            { "PH", "Filipinas" },
            { "PK", "Paquist\u00e3o" },
            { "PL", "Pol\u00f4nia" },
            { "PM", "S\u00e3o Pedro e Miquel\u00e3o" },
            { "PN", "Ilhas Pitcairn" },
            { "PR", "Porto Rico" },
            { "PS", "Territ\u00f3rios palestinos" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Catar" },
            { "QO", "Oceania Remota" },
            { "RE", "Reuni\u00e3o" },
            { "RO", "Rom\u00eania" },
            { "RS", "S\u00e9rvia" },
            { "RU", "R\u00fassia" },
            { "RW", "Ruanda" },
            { "SA", "Ar\u00e1bia Saudita" },
            { "SB", "Ilhas Salom\u00e3o" },
            { "SC", "Seicheles" },
            { "SD", "Sud\u00e3o" },
            { "SE", "Su\u00e9cia" },
            { "SG", "Singapura" },
            { "SH", "Santa Helena" },
            { "SI", "Eslov\u00eania" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "SK", "Eslov\u00e1quia" },
            { "SL", "Serra Leoa" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Som\u00e1lia" },
            { "SR", "Suriname" },
            { "SS", "Sud\u00e3o do Sul" },
            { "ST", "S\u00e3o Tom\u00e9 e Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "S\u00edria" },
            { "SZ", "Essuat\u00edni" },
            { "TA", "Trist\u00e3o da Cunha" },
            { "TC", "Ilhas Turcas e Caicos" },
            { "TD", "Chade" },
            { "TF", "Territ\u00f3rios Franceses do Sul" },
            { "TG", "Togo" },
            { "TH", "Tail\u00e2ndia" },
            { "TJ", "Tadjiquist\u00e3o" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turcomenist\u00e3o" },
            { "TN", "Tun\u00edsia" },
            { "TO", "Tonga" },
            { "TR", "Turquia" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanz\u00e2nia" },
            { "UA", "Ucr\u00e2nia" },
            { "UG", "Uganda" },
            { "UM", "Ilhas Menores Distantes dos EUA" },
            { "UN", "Na\u00e7\u00f5es Unidas" },
            { "US", "Estados Unidos" },
            { "UY", "Uruguai" },
            { "UZ", "Uzbequist\u00e3o" },
            { "VA", "Cidade do Vaticano" },
            { "VC", "S\u00e3o Vicente e Granadinas" },
            { "VE", "Venezuela" },
            { "VG", "Ilhas Virgens Brit\u00e2nicas" },
            { "VI", "Ilhas Virgens Americanas" },
            { "VN", "Vietn\u00e3" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudossotaques" },
            { "XB", "Pseudobidirecional" },
            { "XK", "Kosovo" },
            { "YE", "I\u00eamen" },
            { "YT", "Mayotte" },
            { "ZA", "\u00c1frica do Sul" },
            { "ZM", "Z\u00e2mbia" },
            { "ZW", "Zimb\u00e1bue" },
            { "ZZ", "Regi\u00e3o desconhecida" },
            { "aa", "afar" },
            { "ab", "abc\u00e1zio" },
            { "ae", metaValue_ae },
            { "af", "afric\u00e2ner" },
            { "ak", "akan" },
            { "am", "am\u00e1rico" },
            { "an", "aragon\u00eas" },
            { "ar", metaValue_ar },
            { "as", "assam\u00eas" },
            { "av", "av\u00e1rico" },
            { "ay", "aimar\u00e1" },
            { "az", "azerbaijano" },
            { "ba", "bashkir" },
            { "be", "bielorrusso" },
            { "bg", "b\u00falgaro" },
            { "bi", "bislam\u00e1" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bret\u00e3o" },
            { "bs", "b\u00f3snio" },
            { "ca", "catal\u00e3o" },
            { "ce", "checheno" },
            { "ch", "chamorro" },
            { "co", "corso" },
            { "cr", "cree" },
            { "cs", "tcheco" },
            { "cu", "eslavo eclesi\u00e1stico" },
            { "cv", "tchuvache" },
            { "cy", "gal\u00eas" },
            { "da", "dinamarqu\u00eas" },
            { "de", "alem\u00e3o" },
            { "dv", "divehi" },
            { "dz", "dzonga" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "ingl\u00eas" },
            { "eo", "esperanto" },
            { "es", "espanhol" },
            { "et", "estoniano" },
            { "eu", "basco" },
            { "fa", "persa" },
            { "ff", "fula" },
            { "fi", "finland\u00eas" },
            { "fj", "fijiano" },
            { "fo", "fero\u00eas" },
            { "fr", "franc\u00eas" },
            { "fy", "fr\u00edsio ocidental" },
            { "ga", "irland\u00eas" },
            { "gd", "ga\u00e9lico escoc\u00eas" },
            { "gl", "galego" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hau\u00e7\u00e1" },
            { "he", metaValue_he },
            { "hi", "h\u00edndi" },
            { "ho", "hiri motu" },
            { "hr", "croata" },
            { "ht", "haitiano" },
            { "hu", "h\u00fangaro" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interl\u00edngua" },
            { "id", "indon\u00e9sio" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "ik", "inupiaque" },
            { "io", "ido" },
            { "is", "island\u00eas" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "congol\u00eas" },
            { "ki", "quicuio" },
            { "kj", "cuanhama" },
            { "kk", "cazaque" },
            { "kl", "groenland\u00eas" },
            { "km", metaValue_km },
            { "kn", "canarim" },
            { "ko", metaValue_ko },
            { "kr", "can\u00fari" },
            { "ks", "caxemira" },
            { "ku", "curdo" },
            { "kv", "komi" },
            { "kw", "c\u00f3rnico" },
            { "ky", "quirguiz" },
            { "la", metaValue_la },
            { "lb", "luxemburgu\u00eas" },
            { "lg", "luganda" },
            { "li", "limburgu\u00eas" },
            { "ln", "lingala" },
            { "lo", "laosiano" },
            { "lt", "lituano" },
            { "lu", "luba-catanga" },
            { "lv", "let\u00e3o" },
            { "mg", "malgaxe" },
            { "mh", "marshal\u00eas" },
            { "mi", "maori" },
            { "mk", "maced\u00f4nio" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marati" },
            { "ms", "malaio" },
            { "mt", "malt\u00eas" },
            { "my", metaValue_my },
            { "na", "nauruano" },
            { "nb", "bokm\u00e5l noruegu\u00eas" },
            { "nd", "ndebele do norte" },
            { "ne", "nepal\u00eas" },
            { "ng", "dongo" },
            { "nl", "holand\u00eas" },
            { "nn", "nynorsk noruegu\u00eas" },
            { "no", "noruegu\u00eas" },
            { "nr", "ndebele do sul" },
            { "nv", "navajo" },
            { "ny", "nianja" },
            { "oc", "occit\u00e2nico" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "osseto" },
            { "pa", "panjabi" },
            { "pi", "p\u00e1li" },
            { "pl", "polon\u00eas" },
            { "ps", "pashto" },
            { "pt", "portugu\u00eas" },
            { "qu", "qu\u00edchua" },
            { "rm", "romanche" },
            { "rn", "rundi" },
            { "ro", "romeno" },
            { "ru", "russo" },
            { "rw", "quiniaruanda" },
            { "sa", "s\u00e2nscrito" },
            { "sc", "sardo" },
            { "sd", "sindi" },
            { "se", "sami setentrional" },
            { "sg", "sango" },
            { "sh", "servo-croata" },
            { "si", metaValue_si },
            { "sk", "eslovaco" },
            { "sl", "esloveno" },
            { "sm", "samoano" },
            { "sn", "xona" },
            { "so", "somali" },
            { "sq", "alban\u00eas" },
            { "sr", "s\u00e9rvio" },
            { "ss", "su\u00e1zi" },
            { "st", "soto do sul" },
            { "su", metaValue_su },
            { "sv", "sueco" },
            { "sw", "sua\u00edli" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tadjique" },
            { "th", metaValue_th },
            { "ti", "tigr\u00ednia" },
            { "tk", "turcomeno" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tongan\u00eas" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "tt", "t\u00e1rtaro" },
            { "tw", "twi" },
            { "ty", "taitiano" },
            { "ug", "uigur" },
            { "uk", "ucraniano" },
            { "ur", "urdu" },
            { "uz", "uzbeque" },
            { "ve", "venda" },
            { "vi", "vietnamita" },
            { "vo", "volapuque" },
            { "wa", "val\u00e3o" },
            { "wo", "uolofe" },
            { "xh", "xhosa" },
            { "yi", "i\u00eddiche" },
            { "yo", "iorub\u00e1" },
            { "za", "zhuang" },
            { "zh", "chin\u00eas" },
            { "zu", "zulu" },
            { "ace", "ach\u00e9m" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adigue" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "acadiano" },
            { "ale", "ale\u00fate" },
            { "alt", "altai meridional" },
            { "ang", "ingl\u00eas arcaico" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aramaico" },
            { "arn", "mapudungun" },
            { "arp", "arapaho" },
            { "ars", "\u00e1rabe n\u00e9gede" },
            { "arw", "arauaqui" },
            { "asa", "asu" },
            { "ast", "asturiano" },
            { "atj", "atikamekw" },
            { "awa", "awadhi" },
            { "bal", "bal\u00fachi" },
            { "ban", metaValue_ban },
            { "bas", "basa" },
            { "bax", metaValue_bax },
            { "bbj", "ghomala\u2019" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bgn", "bal\u00fachi ocidental" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "buriato" },
            { "bug", metaValue_bug },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "caribe" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", "chakma" },
            { "ceb", "cebuano" },
            { "cgg", "chiga" },
            { "chb", "chibcha" },
            { "chg", "chagatai" },
            { "chk", "chuukese" },
            { "chm", "mari" },
            { "chn", "jarg\u00e3o Chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "cheroqui" },
            { "chy", "cheiene" },
            { "ckb", "curdo central" },
            { "clc", "chilcotin" },
            { "cop", "copta" },
            { "crg", "michif" },
            { "crh", "t\u00e1rtara da Crimeia" },
            { "crj", "cree do sudeste" },
            { "crk", "cree das plan\u00edcies" },
            { "crl", "cree do nordeste" },
            { "crm", "moose cree" },
            { "crr", "algonquiano Carolina" },
            { "crs", "crioulo franc\u00eas seichelense" },
            { "csb", "kashubian" },
            { "csw", "cree swampy" },
            { "dak", "dacota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "baixo sor\u00e1bio" },
            { "dua", "duala" },
            { "dum", "holand\u00eas m\u00e9dio" },
            { "dyo", "jola-fonyi" },
            { "dyu", "di\u00fala" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efique" },
            { "egy", "eg\u00edpcio arcaico" },
            { "eka", "ekajuk" },
            { "elx", "elamite" },
            { "enm", "ingl\u00eas m\u00e9dio" },
            { "ewo", "ewondo" },
            { "fan", "fangue" },
            { "fat", "fanti" },
            { "fil", "filipino" },
            { "fon", "fom" },
            { "frc", "franc\u00eas cajun" },
            { "frm", "franc\u00eas m\u00e9dio" },
            { "fro", "franc\u00eas arcaico" },
            { "frr", "fr\u00edsio setentrional" },
            { "frs", "fris\u00e3o oriental" },
            { "fur", "friulano" },
            { "gaa", "ga" },
            { "gag", "gagauz" },
            { "gan", "gan" },
            { "gay", "gayo" },
            { "gba", "gbaia" },
            { "gez", "geez" },
            { "gil", "gilbert\u00eas" },
            { "gmh", "alto alem\u00e3o m\u00e9dio" },
            { "goh", "alem\u00e3o arcaico alto" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "grego arcaico" },
            { "gsw", "alem\u00e3o (Su\u00ed\u00e7a)" },
            { "guz", "gusii" },
            { "gwi", "gwich\u02bcin" },
            { "hai", "haida" },
            { "hak", "hac\u00e1" },
            { "haw", "havaiano" },
            { "hax", "haida do sul" },
            { "hil", "hiligaynon" },
            { "hit", "hitita" },
            { "hmn", "hmong" },
            { "hsb", "alto sor\u00e1bio" },
            { "hsn", "xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut canadense ocidental" },
            { "ilo", "ilocano" },
            { "inh", "inguche" },
            { "jbo", "lojban" },
            { "jgo", "nguemba" },
            { "jmc", "machame" },
            { "jpr", "judaico-persa" },
            { "jrb", "judaico-ar\u00e1bico" },
            { "kaa", "kara-kalpak" },
            { "kab", "kabyle" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardiano" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "maconde" },
            { "kea", "crioulo cabo-verdiano" },
            { "kfo", "koro" },
            { "kgp", "caingangue" },
            { "kha", "khasi" },
            { "kho", "khotan\u00eas" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "quimbundo" },
            { "koi", "komi-permyak" },
            { "kok", "concani" },
            { "kos", "kosraean" },
            { "kpe", "kpelle" },
            { "krc", "karachay-balkar" },
            { "krl", "car\u00e9lio" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "k\u00f6lsch" },
            { "kum", "kumyk" },
            { "kut", "kutenai" },
            { "kwk", "kwak\u02bcwala" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezgui" },
            { "lil", "lillooet" },
            { "lkt", "lacota" },
            { "lmo", "lombardo" },
            { "lol", "mongo" },
            { "lou", "crioulo da Louisiana" },
            { "loz", "lozi" },
            { "lrc", "luri setentrional" },
            { "lsm", "saamia" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lushai" },
            { "luy", "luyia" },
            { "mad", "madur\u00eas" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mandinga" },
            { "mas", "massai" },
            { "mde", "maba" },
            { "mdf", "mocsa" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "morisyen" },
            { "mga", "irland\u00eas m\u00e9dio" },
            { "mgh", "macua" },
            { "mgo", "meta\u2019" },
            { "mic", "miquemaque" },
            { "min", "minangkabau" },
            { "mnc", "manchu" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "moicano" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "m\u00faltiplos idiomas" },
            { "mus", "creek" },
            { "mwl", "mirand\u00eas" },
            { "mwr", "marwari" },
            { "mye", "myene" },
            { "myv", "erzya" },
            { "mzn", "mazandarani" },
            { "nan", "min nan" },
            { "nap", "napolitano" },
            { "naq", "nama" },
            { "nds", "baixo alem\u00e3o" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niueano" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "non", "n\u00f3rdico arcaico" },
            { "nqo", metaValue_nqo },
            { "nso", "soto setentrional" },
            { "nus", "nuer" },
            { "nwc", "newari cl\u00e1ssico" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "ojibwa do noroeste" },
            { "ojc", "ojibwa central" },
            { "ojs", "oji-cree" },
            { "ojw", "ojibwa ocidental" },
            { "oka", "okanagan" },
            { "osa", "osage" },
            { "ota", "turco otomano" },
            { "pag", "pangasin\u00e3" },
            { "pal", "p\u00e1lavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauano" },
            { "pcm", "pidgin nigeriano" },
            { "peo", "persa arcaico" },
            { "phn", metaValue_phn },
            { "pis", "pijin" },
            { "pon", "pohnpeiano" },
            { "pqm", "malecite\u2013passamaquoddy" },
            { "prg", "prussiano" },
            { "pro", "proven\u00e7al arcaico" },
            { "quc", "quich\u00e9" },
            { "raj", "rajastani" },
            { "rap", "rapanui" },
            { "rar", "rarotongano" },
            { "rhg", "ruainga" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rup", "aromeno" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "sakha" },
            { "sam", "aramaico samaritano" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "siciliano" },
            { "sco", "scots" },
            { "sdh", "curdo meridional" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sel", "selkup" },
            { "ses", "koyraboro senni" },
            { "sga", "irland\u00eas arcaico" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "shu", "\u00e1rabe chadiano" },
            { "sid", "sidamo" },
            { "slh", "lushootseed do sul" },
            { "sma", "sami meridional" },
            { "smj", "sami de Lule" },
            { "smn", "lap\u00e3o de Inari" },
            { "sms", "sami de Skolt" },
            { "snk", "soninqu\u00ea" },
            { "sog", "sogdiano" },
            { "srn", "surinam\u00eas" },
            { "srr", "serere" },
            { "ssy", metaValue_ssy },
            { "str", "salish do estreito norte" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sum\u00e9rio" },
            { "swb", "comoriano" },
            { "syc", "sir\u00edaco cl\u00e1ssico" },
            { "syr", metaValue_syr },
            { "tce", "tutchone do sul" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "t\u00e9tum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigr\u00e9" },
            { "tiv", "tiv" },
            { "tkl", "toquelauano" },
            { "tlh", "klingon" },
            { "tli", "tlinguite" },
            { "tmh", "tamaxeque" },
            { "tog", "tongan\u00eas de Nyasa" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tsi", "tsimshiano" },
            { "ttm", "tutchone setentrional" },
            { "tum", "tumbuka" },
            { "tvl", "tuvaluano" },
            { "twq", "tasawaq" },
            { "tyv", "tuviniano" },
            { "tzm", "tamazight do Atlas Central" },
            { "udm", "udmurte" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "idioma desconhecido" },
            { "vai", metaValue_vai },
            { "vot", "v\u00f3tico" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaytta" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "wu" },
            { "xal", "kalmyk" },
            { "xog", "lusoga" },
            { "yao", "yao" },
            { "yap", "yapese" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "canton\u00eas" },
            { "zap", "zapoteco" },
            { "zbl", "s\u00edmbolos blis" },
            { "zen", "zenaga" },
            { "zgh", "tamazirte marroqino padr\u00e3o" },
            { "zun", "zunhi" },
            { "zxx", "sem conte\u00fado lingu\u00edstico" },
            { "zza", "zazaki" },
            { "Adlm", "adlam" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armi", "armi" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bamu", metaValue_bax },
            { "Batk", "bataque" },
            { "Beng", metaValue_bn },
            { "Blis", "s\u00edmbolos bliss" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", "cakm" },
            { "Cans", "escrita sil\u00e1bica unificada dos abor\u00edgenes canadenses" },
            { "Cari", "cariano" },
            { "Cham", "cham" },
            { "Cher", "cherokee" },
            { "Cirt", "cirth" },
            { "Copt", "c\u00f3ptico" },
            { "Cprt", "cipriota" },
            { "Cyrl", "cir\u00edlico" },
            { "Cyrs", "cir\u00edlico eslavo eclesi\u00e1stico" },
            { "Deva", "devan\u00e1gari" },
            { "Dsrt", "deseret" },
            { "Egyd", "dem\u00f3tico eg\u00edpcio" },
            { "Egyh", "hier\u00e1tico eg\u00edpcio" },
            { "Egyp", "hier\u00f3glifos eg\u00edpcios" },
            { "Ethi", "eti\u00f3pico" },
            { "Geok", "khutsuri georgiano" },
            { "Geor", metaValue_ka },
            { "Glag", "glagol\u00edtico" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmuqui" },
            { "Hanb", "hanb" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "simplificado" },
            { "Hant", "tradicional" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "silab\u00e1rios japoneses" },
            { "Hung", "h\u00fangaro antigo" },
            { "Inds", "indo" },
            { "Ital", "it\u00e1lico antigo" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharoshthi" },
            { "Khmr", metaValue_km },
            { "Knda", "kannada" },
            { "Kore", metaValue_ko },
            { "Kthi", "kthi" },
            { "Lana", "lanna" },
            { "Laoo", "lao" },
            { "Latf", "latim fraktur" },
            { "Latg", "latim ga\u00e9lico" },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "linear A" },
            { "Linb", "linear B" },
            { "Lisu", "lisu" },
            { "Lyci", "l\u00edcio" },
            { "Lydi", "l\u00eddio" },
            { "Mand", "mandaico" },
            { "Mani", "maniqueano" },
            { "Maya", "hier\u00f3glifos maias" },
            { "Merc", "mero\u00edtico cursivo" },
            { "Mero", "mero\u00edtico" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "moon" },
            { "Mtei", "meitei mayek" },
            { "Mymr", metaValue_my },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "og\u00e2mico" },
            { "Olck", "ol chiki" },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osma", "osmania" },
            { "Perm", "p\u00e9rmico antigo" },
            { "Phag", "phags-pa" },
            { "Phli", "phli" },
            { "Phlp", "phlp" },
            { "Phlv", "pahlavi antigo" },
            { "Phnx", metaValue_phn },
            { "Plrd", "fon\u00e9tico pollard" },
            { "Prti", "prti" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "r\u00fanico" },
            { "Samr", "samaritano" },
            { "Sara", "sarati" },
            { "Saur", "saurashtra" },
            { "Sgnw", "signwriting" },
            { "Shaw", "shaviano" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "sir\u00edaco estrangelo" },
            { "Syrj", "sir\u00edaco ocidental" },
            { "Syrn", "sir\u00edaco oriental" },
            { "Tagb", "tagbanwa" },
            { "Tale", "tai Le" },
            { "Talu", "novo tai lue" },
            { "Taml", metaValue_ta },
            { "Tavt", "tavt" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "visible speech" },
            { "Xpeo", "persa antigo" },
            { "Xsux", "sum\u00e9rio-acadiano cuneiforme" },
            { "Yiii", "yi" },
            { "Zinh", "herdado" },
            { "Zmth", "nota\u00e7\u00e3o matem\u00e1tica" },
            { "Zsye", "emoji" },
            { "Zsym", "zsym" },
            { "Zxxx", "\u00e1grafo" },
            { "Zyyy", "comum" },
            { "Zzzz", "escrita desconhecida" },
            { "de_CH", "alto alem\u00e3o (Su\u00ed\u00e7a)" },
            { "fa_AF", "dari" },
            { "nl_BE", "flamengo" },
            { "ro_MD", "mold\u00e1vio" },
            { "sw_CD", "sua\u00edli do Congo" },
            { "%%1901", "ortografia alem\u00e3 tradicional" },
            { "%%1994", "ortografia resiana padronizada" },
            { "%%1996", "ortografia alem\u00e3 de 1996" },
            { "ar_001", "\u00e1rabe moderno" },
            { "key.ca", "Calend\u00e1rio" },
            { "key.cf", "Formato de moeda" },
            { "key.co", "Ordena\u00e7\u00e3o" },
            { "key.cu", "Moeda" },
            { "key.hc", "Ciclo de hor\u00e1rio (12 vs. 24)" },
            { "key.lb", "Estilo de quebra de linha" },
            { "key.ms", "Sistema de medi\u00e7\u00e3o" },
            { "key.nu", "N\u00fameros" },
            { "key.tz", "Fuso hor\u00e1rio" },
            { "key.va", "Variante de localidade" },
            { "nds_NL", "baixo sax\u00e3o" },
            { "%%BISKE", "dialeto san giorgio/bila" },
            { "%%BOONT", "boontling" },
            { "%%KKCOR", "ortografia comum" },
            { "%%LIPAW", "dialeto lipovaz de Resian" },
            { "%%NEDIS", "dialeto natisone" },
            { "%%NJIVA", "dialeto gniva/njiva" },
            { "%%OSOJS", "dialeto oseacco/osojane" },
            { "%%POSIX", "computador" },
            { "%%ROZAJ", "resiano" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "dialeto stolvizza/solbica" },
            { "%%UCCOR", "ortografia unificada" },
            { "az_Arab", "azeri sul" },
            { "zh_Hans", "chin\u00eas simplificado" },
            { "zh_Hant", "chin\u00eas tradicional" },
            { "%%AO1990", "Acordo Ortogr\u00e1fico da L\u00edngua Portuguesa de 1990" },
            { "%%FONIPA", "fon\u00e9tica do Alfabeto Fon\u00e9tico Internacional" },
            { "%%FONUPA", "fon\u00e9tica do Alfabeto Fon\u00e9tico Ur\u00e1lico" },
            { "%%NDYUKA", "dialeto ndyuka" },
            { "%%PAMAKA", "dialeto pamaka" },
            { "%%PINYIN", "romaniza\u00e7\u00e3o Pinyin" },
            { "%%SCOUSE", "scouse" },
            { "%%TARASK", "ortografia taraskievica" },
            { "%%UCRCOR", "ortografia revisada e unificada" },
            { "%%ABL1943", "Formul\u00e1rio Ortogr\u00e1fico de 1943" },
            { "%%AREVELA", "arm\u00eanio oriental" },
            { "%%AREVMDA", "arm\u00eanio ocidental" },
            { "%%HEPBURN", "romaniza\u00e7\u00e3o hepburn" },
            { "%%MONOTON", "monot\u00f4nico" },
            { "%%POLYTON", "polit\u00f4nico" },
            { "%%REVISED", "ortografia revisada" },
            { "%%1606NICT", "franc\u00eas antigo de 1606" },
            { "%%1694ACAD", "franc\u00eas da idade moderna" },
            { "%%1959ACAD", "acad\u00eamico" },
            { "%%BAKU1926", "alfabeto latino turco unificado" },
            { "%%BISCAYAN", "biscainho" },
            { "%%COLB1945", "Conven\u00e7\u00e3o Ortogr\u00e1fica Luso-Brasileira de 1945" },
            { "%%HOGNORSK", "alto noruego" },
            { "%%SCOTLAND", "ingl\u00eas padr\u00e3o escoc\u00eas" },
            { "%%VALENCIA", "valenciano" },
            { "%%WADEGILE", "romaniza\u00e7\u00e3o Wade-Giles" },
            { "type.ca.roc", "Calend\u00e1rio da Rep\u00fablica da China" },
            { "type.co.eor", "Regras europeias de ordena\u00e7\u00e3o" },
            { "type.hc.h11", "Sistema de 12 horas (0\u201311)" },
            { "type.hc.h12", "Sistema de 12 horas (1\u201312)" },
            { "type.hc.h23", "Sistema de 24 horas (0\u201323)" },
            { "type.hc.h24", "Sistema de 24 horas (1\u201324)" },
            { "type.m0.bgn", "Translitera\u00e7\u00e3o BGN EUA" },
            { "type.nu.arab", "Algarismos indo-ar\u00e1bicos" },
            { "type.nu.armn", "Algarismos arm\u00eanios" },
            { "type.nu.beng", "Algarismos bengali" },
            { "type.nu.cakm", "Algarismos chakma" },
            { "type.nu.deva", "Algarismos devan\u00e1gari" },
            { "type.nu.ethi", "Algarismos etiopianos" },
            { "type.nu.geor", "Algarismos georgianos" },
            { "type.nu.grek", "Algarismos gregos" },
            { "type.nu.gujr", "Algarismos guzerate" },
            { "type.nu.guru", "Algarismos gurmuqui" },
            { "type.nu.hans", "Algarismos chineses simplificados" },
            { "type.nu.hant", "Algarismos chineses tradicionais" },
            { "type.nu.hebr", "Algarismos hebraicos" },
            { "type.nu.java", "Algarismos javaneses" },
            { "type.nu.jpan", "Algarismos japoneses" },
            { "type.nu.khmr", "Algarismos khmer" },
            { "type.nu.knda", "Algarismos canareses" },
            { "type.nu.laoo", "Algarismos laosianos" },
            { "type.nu.latn", "Algarismos ocidentais" },
            { "type.nu.mlym", "Algarismos malaialos" },
            { "type.nu.mong", "Algarismos mong\u00f3is" },
            { "type.nu.mtei", "Algarismos meetei mayek" },
            { "type.nu.mymr", "Algarismos mianmarenses" },
            { "type.nu.olck", "Algarismos ol chiki" },
            { "type.nu.orya", "Algarismos ori\u00e1" },
            { "type.nu.taml", "Algarismos t\u00e2mil tradicionais" },
            { "type.nu.telu", "Algarismos telugos" },
            { "type.nu.thai", "Algarismos tailandeses" },
            { "type.nu.tibt", "Algarismos tibetanos" },
            { "type.nu.vaii", "Algarismos vai" },
            { "type.ca.dangi", "Calend\u00e1rio Dangi" },
            { "type.co.ducet", "Ordem padr\u00e3o do Unicode" },
            { "type.lb.loose", "Quebra de linha com estilo solto" },
            { "type.nu.roman", "Algarismos romanos" },
            { "type.ca.coptic", "Calend\u00e1rio Copta" },
            { "type.ca.hebrew", "Calend\u00e1rio Hebraico" },
            { "type.ca.indian", "Calend\u00e1rio Nacional Indiano" },
            { "type.co.compat", "Ordem anterior, para compatibilidade" },
            { "type.co.pinyin", "Ordem Pin-yin" },
            { "type.co.search", "Pesquisa de uso geral" },
            { "type.co.stroke", "Ordem dos tra\u00e7os" },
            { "type.co.unihan", "Ordem por Radical-Tra\u00e7os" },
            { "type.co.zhuyin", "Ordem Zhuyin" },
            { "type.d0.fwidth", "Largura inteira" },
            { "type.d0.hwidth", "Meia largura" },
            { "type.lb.normal", "Quebra de linha com estilo normal" },
            { "type.lb.strict", "Quebra de linha com estilo estrito" },
            { "type.m0.ungegn", "Translitera\u00e7\u00e3o UN GEGN" },
            { "type.ms.metric", "Sistema m\u00e9trico" },
            { "type.nu.native", "Algarismos nativos" },
            { "type.ca.chinese", "Calend\u00e1rio Chin\u00eas" },
            { "type.ca.islamic", "Calend\u00e1rio Isl\u00e2mico" },
            { "type.ca.iso8601", "Calend\u00e1rio ISO-8601" },
            { "type.ca.persian", "Calend\u00e1rio Persa" },
            { "type.cf.account", "Formato de moeda para contabilidade" },
            { "type.co.big5han", "Ordem do Chin\u00eas Tradicional - Big5" },
            { "type.d0.npinyin", "Num\u00e9rico" },
            { "type.nu.arabext", "Algarismos indo-ar\u00e1bicos estendidos" },
            { "type.nu.armnlow", "Algarismos arm\u00eanios min\u00fasculos" },
            { "type.nu.finance", "Numerais financeiros" },
            { "type.nu.greklow", "Algarismos gregos min\u00fasculos" },
            { "type.nu.hanidec", "Algarismos decimais chineses" },
            { "type.nu.hansfin", "Algarismos financeiros chineses simplificados" },
            { "type.nu.hantfin", "Algarismos financeiros chineses tradicionais" },
            { "type.nu.jpanfin", "Algarismos financeiros japoneses" },
            { "type.nu.tamldec", "Algarismos t\u00e2mil" },
            { "type.ca.buddhist", "Calend\u00e1rio Budista" },
            { "type.ca.ethiopic", "Calend\u00e1rio Et\u00edope" },
            { "type.ca.japanese", "Calend\u00e1rio Japon\u00eas" },
            { "type.cf.standard", "Formato de moeda padr\u00e3o" },
            { "type.co.phonetic", "Ordem de classifica\u00e7\u00e3o fon\u00e9tica" },
            { "type.co.reformed", "Ordem reformulada" },
            { "type.co.searchjl", "Pesquisar por consonante inicial hangul" },
            { "type.co.standard", "Ordem padr\u00e3o" },
            { "type.ms.uksystem", "Sistema de medi\u00e7\u00e3o imperial" },
            { "type.ms.ussystem", "Sistema de medi\u00e7\u00e3o americano" },
            { "type.nu.fullwide", "Algarismos em extens\u00e3o total" },
            { "type.nu.romanlow", "Algarismos romanos min\u00fasculos" },
            { "type.ca.gregorian", "Calend\u00e1rio Gregoriano" },
            { "type.co.gb2312han", "Ordem do Chin\u00eas Simplificado - GB2312" },
            { "type.co.phonebook", "Ordem de lista telef\u00f4nica" },
            { "type.co.dictionary", "Ordem do dicion\u00e1rio" },
            { "type.co.traditional", "Ordem tradicional" },
            { "type.nu.traditional", "Numerais tradicionais" },
            { "type.ca.islamic-civil", "Calend\u00e1rio Civil Isl\u00e2mico" },
            { "type.ca.islamic-umalqura", "Calend\u00e1rio Isl\u00e2mico (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Calend\u00e1rio Amete Alem da Eti\u00f3pia" },
        };
        return data;
    }
}
