/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.bookmark;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mediathek.config.Daten;
import mediathek.config.StandardLocations;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.gui.bookmark.BookmarkData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BookmarkDataList {
    private static final Logger logger = LogManager.getLogger();
    private final BasicEventList<BookmarkData> bookmarks = new BasicEventList();
    private final ObjectMapper objectMapper = ((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();

    public BookmarkDataList(@NotNull Daten daten) {
        daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(this){
            final /* synthetic */ BookmarkDataList this$0;
            {
                BookmarkDataList bookmarkDataList = this$0;
                Objects.requireNonNull(bookmarkDataList);
                this.this$0 = bookmarkDataList;
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                Thread.ofVirtual().start(() -> this.this$0.updateBookMarksFromFilmList());
            }
        });
    }

    public void clear() {
        this.bookmarks.forEach(bookmark -> {
            Optional<DatenFilm> filmOpt = bookmark.getDatenFilmOptional();
            filmOpt.ifPresent(film -> film.setBookmark(null));
        });
        this.bookmarks.clear();
        this.saveToFile();
    }

    @JsonGetter(value="bookmarks")
    public EventList<BookmarkData> getEventList() {
        return this.bookmarks;
    }

    public void removeBookmark(@NotNull BookmarkData bookmark) {
        Optional<DatenFilm> filmOpt = bookmark.getDatenFilmOptional();
        filmOpt.ifPresent(film -> film.setBookmark(null));
        bookmark.setDatenFilm(null);
        this.bookmarks.remove((Object)bookmark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndBookmarkMovies(@NotNull List<DatenFilm> movies) {
        ArrayList<DatenFilm> addlist = new ArrayList<DatenFilm>();
        ArrayList<BookmarkData> dellist = new ArrayList<BookmarkData>();
        boolean add = false;
        for (DatenFilm film : movies) {
            if (!film.isBookmarked()) {
                add = true;
                addlist.add(film);
                continue;
            }
            BookmarkData bookmark = this.findBookmarkFromFilm(film);
            if (bookmark == null) continue;
            dellist.add(bookmark);
        }
        if (add) {
            this.bookmarks.getReadWriteLock().writeLock().lock();
            try (SeenHistoryController history = new SeenHistoryController();){
                addlist.forEach(movie -> {
                    BookmarkData bdata = new BookmarkData((DatenFilm)movie);
                    movie.setBookmark(bdata);
                    bdata.setSeen(history.hasBeenSeen((DatenFilm)movie));
                    bdata.setFilmHashCode(movie.getSha256().toString());
                    bdata.setBookmarkAdded(LocalDate.now());
                    this.bookmarks.add((Object)bdata);
                });
            }
            catch (Exception ex) {
                logger.error("history produced error", (Throwable)ex);
            }
            finally {
                this.bookmarks.getReadWriteLock().writeLock().unlock();
            }
        } else {
            movies.forEach(movie -> movie.setBookmark(null));
            this.bookmarks.getReadWriteLock().writeLock().lock();
            try {
                this.bookmarks.removeAll(dellist);
            }
            finally {
                this.bookmarks.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    public void loadFromFile() {
        Path filePath = StandardLocations.getBookmarkFilePath();
        try {
            BookmarksWrapper wrapper = (BookmarksWrapper)this.objectMapper.readValue(filePath.toFile(), BookmarksWrapper.class);
            List<BookmarkData> bookmarkList = wrapper.getBookmarks();
            if (bookmarkList != null) {
                this.bookmarks.addAll(bookmarkList);
                bookmarkList.clear();
            }
        }
        catch (Exception e) {
            logger.error("Could not read bookmarks from file {}, error {} => file ignored", (Object)filePath.toString(), (Object)e.getMessage());
        }
    }

    public synchronized void saveToFile() {
        Path filePath = StandardLocations.getBookmarkFilePath();
        try {
            ObjectWriter objectWriter = this.objectMapper.writerWithDefaultPrettyPrinter();
            objectWriter.writeValue(filePath.toFile(), (Object)this);
            logger.trace("Bookmarks written");
        }
        catch (IOException e) {
            logger.error("Could not save bookmarks to {}", (Object)filePath, (Object)e);
        }
    }

    public void updateSeen(boolean seen, @NotNull List<DatenFilm> list) {
        list.stream().filter(DatenFilm::isBookmarked).forEachOrdered(movie -> {
            BookmarkData bookmark = movie.getBookmark();
            if (bookmark != null) {
                bookmark.setSeen(seen);
            }
        });
    }

    public void updateSeen(boolean seen, @NotNull DatenFilm film) {
        BookmarkData bookmark;
        if (film.isBookmarked() && (bookmark = film.getBookmark()) != null) {
            bookmark.setSeen(seen);
        }
    }

    private BookmarkData findBookmarkFromFilm(@NotNull DatenFilm film) {
        for (BookmarkData bookmark : this.bookmarks) {
            DatenFilm bookmarkFilm = bookmark.getDatenFilm();
            if (bookmarkFilm == null || !bookmarkFilm.equals(film)) continue;
            return bookmark;
        }
        return null;
    }

    private void updateBookMarksFromFilmList() {
        if (this.bookmarks.isEmpty()) {
            return;
        }
        ListeFilme listefilme = Daten.getInstance().getListeFilme();
        for (BookmarkData bookmark : this.bookmarks) {
            String hashCodeStr = bookmark.getFilmHashCode();
            if (hashCodeStr != null) {
                HashCode hashCode = HashCode.fromString((String)hashCodeStr);
                DatenFilm film = listefilme.parallelStream().filter(df -> df.getSha256().equals((Object)hashCode)).findFirst().orElse(null);
                this.assignData(bookmark, film);
                continue;
            }
            DatenFilm film = listefilme.getFilmByUrl(bookmark.getUrl());
            this.assignData(bookmark, film);
            if (film == null) continue;
            bookmark.setFilmHashCode(film.getSha256().toString());
        }
    }

    private void assignData(BookmarkData bookmark, DatenFilm film) {
        bookmark.setDatenFilm(film);
        if (film != null) {
            film.setBookmark(bookmark);
        }
    }

    private static class BookmarksWrapper {
        private List<BookmarkData> bookmarks;

        private BookmarksWrapper() {
        }

        public List<BookmarkData> getBookmarks() {
            return this.bookmarks;
        }

        public void setBookmarks(List<BookmarkData> bookmarks) {
            this.bookmarks = bookmarks;
        }
    }
}

