/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ!\u0010\u000e\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u0010H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u000f*\u00020\u0013H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirContextParameterInCalledSignatureChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "hasContextualFunctionTypeInSignature", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "hasContextParametersFullyExpanded", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContextParameterInCalledSignatureChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContextParameterInCalledSignatureChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirContextParameterInCalledSignatureChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1807#2,3:59\n1807#2,3:62\n*S KotlinDebug\n*F\n+ 1 FirContextParameterInCalledSignatureChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirContextParameterInCalledSignatureChecker\n*L\n46#1:59,3\n49#1:62,3\n*E\n"})
public final class FirContextParameterInCalledSignatureChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirContextParameterInCalledSignatureChecker INSTANCE = new FirContextParameterInCalledSignatureChecker();

    private FirContextParameterInCalledSignatureChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ContextParameters) || LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ContextReceivers)) {
            return;
        }
        FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(expression);
        boolean bl = firCallableSymbol != null ? this.hasContextualFunctionTypeInSignature(context2, firCallableSymbol) : false;
        if (bl) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getUNSUPPORTED_CONTEXTUAL_DECLARATION_CALL(), null, (int)8, null);
        }
    }

    private final boolean hasContextualFunctionTypeInSignature(CheckerContext context2, FirCallableSymbol<?> $this$hasContextualFunctionTypeInSignature) {
        boolean bl;
        block15: {
            boolean bl2;
            block14: {
                ConeKotlinType coneKotlinType = $this$hasContextualFunctionTypeInSignature.getResolvedReceiverType();
                boolean bl3 = coneKotlinType != null ? this.hasContextParametersFullyExpanded(context2, coneKotlinType) : false;
                if (bl3) {
                    return true;
                }
                if (this.hasContextParametersFullyExpanded(context2, $this$hasContextualFunctionTypeInSignature.getResolvedReturnType())) {
                    return true;
                }
                Iterable $this$any$iv = $this$hasContextualFunctionTypeInSignature.getTypeParameterSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl4;
                        block13: {
                            FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv;
                            boolean bl5 = false;
                            Iterable $this$any$iv2 = it.getResolvedBounds();
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl4 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    FirResolvedTypeRef it2 = (FirResolvedTypeRef)element$iv2;
                                    boolean bl6 = false;
                                    if (!INSTANCE.hasContextParametersFullyExpanded(context2, it2.getConeType())) continue;
                                    bl4 = true;
                                    break block13;
                                }
                                bl4 = false;
                            }
                        }
                        if (!bl4) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return true;
            }
            FirFunctionSymbol firFunctionSymbol = $this$hasContextualFunctionTypeInSignature instanceof FirFunctionSymbol ? (FirFunctionSymbol)$this$hasContextualFunctionTypeInSignature : null;
            if (firFunctionSymbol == null) {
                return false;
            }
            FirFunctionSymbol functionSymbol = firFunctionSymbol;
            Iterable $this$any$iv = functionSymbol.getValueParameterSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                    boolean bl7 = false;
                    if (!INSTANCE.hasContextParametersFullyExpanded(context2, it.getResolvedReturnType())) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasContextParametersFullyExpanded(CheckerContext context2, ConeKotlinType $this$hasContextParametersFullyExpanded) {
        return ConeTypeUtilsKt.contains(TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, $this$hasContextParametersFullyExpanded), (Function1<? super ConeKotlinType, Boolean>)((Function1)FirContextParameterInCalledSignatureChecker::hasContextParametersFullyExpanded$lambda$0));
    }

    private static final boolean hasContextParametersFullyExpanded$lambda$0(ConeKotlinType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CompilerConeAttributesKt.getHasContextParameters(it);
    }
}

