/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.markuptable;

import ghidra.feature.vt.gui.editors.DisplayableOffset;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import java.math.BigInteger;

public class DisplayableListingOffset
implements DisplayableOffset {
    protected final Program program;
    protected Address address;
    protected long offset;
    protected BigInteger offsetAsBigInteger;

    public DisplayableListingOffset(Program program, Address currentAddress) {
        Address startAddress;
        this.program = program;
        this.address = currentAddress;
        if (currentAddress == null || currentAddress == Address.NO_ADDRESS) {
            return;
        }
        Function function = program.getFunctionManager().getFunctionContaining(currentAddress);
        if (function != null) {
            startAddress = function.getEntryPoint();
        } else {
            CodeUnit codeUnit = program.getListing().getCodeUnitContaining(currentAddress);
            startAddress = codeUnit.getMinAddress();
        }
        long startOffset = startAddress.getOffset();
        BigInteger startOffsetAsBigInteger = startAddress.getOffsetAsBigInteger();
        long currentOffset = currentAddress.getOffset();
        BigInteger currentOffsetAsBigInteger = currentAddress.getOffsetAsBigInteger();
        this.offset = currentOffset - startOffset;
        this.offsetAsBigInteger = currentOffsetAsBigInteger.subtract(startOffsetAsBigInteger);
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public BigInteger getOffsetAsBigInteger() {
        return this.offsetAsBigInteger;
    }

    @Override
    public String getDisplayString() {
        if (this.address == null || this.address == Address.NO_ADDRESS) {
            return "No Offset";
        }
        return this.offsetAsBigInteger.toString();
    }

    public String toString() {
        return this.getDisplayString();
    }

    @Override
    public int compareTo(DisplayableOffset otherDisplayableOffset) {
        if (otherDisplayableOffset == null) {
            return 1;
        }
        Address otherAddress = otherDisplayableOffset.getAddress();
        if (this.address == null || this.address == Address.NO_ADDRESS) {
            return otherAddress == null || otherAddress == Address.NO_ADDRESS ? 0 : -1;
        }
        if (otherAddress == null || otherAddress == Address.NO_ADDRESS) {
            return 1;
        }
        return this.offsetAsBigInteger.compareTo(otherDisplayableOffset.getOffsetAsBigInteger());
    }
}

