/*
 * Decompiled with CFR 0.152.
 */
package docking.resources.icons;

import docking.util.GraphicsUtils;
import generic.theme.GThemeDefaults;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;

public class NumberIcon
implements Icon {
    private static final Color BORDER_COLOR = GThemeDefaults.Colors.Palette.getColor((String)"lightskyblue");
    private String number;
    private float bestFontSize = -1.0f;

    public NumberIcon(int number) {
        this.number = Integer.toString(number);
    }

    public void setNumber(int number) {
        this.number = Integer.toString(number);
        this.bestFontSize = -1.0f;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor((Color)GThemeDefaults.Colors.BACKGROUND);
        g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
        g.setColor(BORDER_COLOR);
        g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
        float fontSize = this.getMaxFontSize(g, this.getIconWidth() - 1, this.getIconHeight());
        Font originalFont = g.getFont();
        Font textFont = originalFont.deriveFont(fontSize).deriveFont(1);
        g.setFont(textFont);
        FontMetrics fontMetrics = g.getFontMetrics(textFont);
        Rectangle2D stringBounds = fontMetrics.getStringBounds(this.number, g);
        int textHeight = (int)stringBounds.getHeight();
        int iconHeight = this.getIconHeight();
        int space = y + iconHeight - textHeight;
        int halfSpace = space >> 1;
        int baselineY = y + iconHeight - halfSpace;
        int textWidth = (int)stringBounds.getWidth();
        int iconWidth = this.getIconWidth();
        int halfWidth = iconWidth >> 1;
        int halfTextWidth = textWidth >> 1;
        int baselineX = x + (halfWidth - halfTextWidth);
        g.setColor((Color)GThemeDefaults.Colors.FOREGROUND);
        JComponent jc = null;
        if (c instanceof JComponent) {
            jc = (JComponent)c;
        }
        GraphicsUtils.drawString(jc, g, this.number, baselineX, baselineY);
    }

    private float getMaxFontSize(Graphics g, int width, int height) {
        if (this.bestFontSize > 0.0f) {
            return this.bestFontSize;
        }
        float size = 12.0f;
        Font font = g.getFont().deriveFont(size);
        if (this.textFitsInFont(g, font, width, height)) {
            this.bestFontSize = size;
            return this.bestFontSize;
        }
        while (!this.textFitsInFont(g, font = g.getFont().deriveFont(size -= 1.0f), width, height)) {
        }
        this.bestFontSize = Math.max(1.0f, size);
        return this.bestFontSize;
    }

    private boolean textFitsInFont(Graphics g, Font font, int width, int height) {
        int padding = 2;
        FontMetrics fontMetrics = g.getFontMetrics(font);
        int textWidth = fontMetrics.stringWidth(this.number) + padding;
        if (textWidth > width) {
            return false;
        }
        int textHeight = fontMetrics.getHeight();
        return textHeight < height;
    }

    @Override
    public int getIconHeight() {
        return 16;
    }

    @Override
    public int getIconWidth() {
        return 16;
    }
}

