/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial.rect;

import ghidra.util.database.spatial.BoundedShape;
import ghidra.util.database.spatial.Query;
import ghidra.util.database.spatial.rect.EuclideanSpace2D;
import ghidra.util.database.spatial.rect.Rectangle2D;
import ghidra.util.database.spatial.rect.Rectangle2DDirection;
import java.util.Comparator;

public abstract class AbstractRectangle2DQuery<X, Y, DS extends BoundedShape<NS>, NS extends Rectangle2D<X, Y, NS>, Q extends AbstractRectangle2DQuery<X, Y, DS, NS, Q>>
implements Query<DS, NS> {
    protected final NS r1;
    protected final NS r2;
    protected final EuclideanSpace2D<X, Y> space;
    protected final Rectangle2DDirection direction;
    protected Comparator<NS> comparator;

    protected static <X, Y, NS extends Rectangle2D<X, Y, NS>, Q extends AbstractRectangle2DQuery<X, Y, ?, NS, Q>> Q intersecting(NS rect, Rectangle2DDirection direction, QueryFactory<NS, Q> factory) {
        Rectangle2D<X, Y, ?> full = rect.getSpace().getFull();
        NS r1 = rect.immutable(full.getX1(), rect.getX2(), full.getY1(), rect.getY2());
        NS r2 = rect.immutable(rect.getX1(), full.getX2(), rect.getY1(), full.getY2());
        return factory.create(r1, r2, direction);
    }

    protected static <X, Y, NS extends Rectangle2D<X, Y, NS>, Q extends AbstractRectangle2DQuery<X, Y, ?, NS, Q>> Q enclosing(NS rect, Rectangle2DDirection direction, QueryFactory<NS, Q> factory) {
        Rectangle2D<X, Y, ?> full = rect.getSpace().getFull();
        NS r1 = rect.immutable(full.getX1(), rect.getX1(), full.getY1(), rect.getY1());
        NS r2 = rect.immutable(rect.getX2(), full.getX2(), rect.getY2(), full.getY2());
        return factory.create(r1, r2, direction);
    }

    protected static <X, Y, NS extends Rectangle2D<X, Y, NS>, Q extends AbstractRectangle2DQuery<X, Y, ?, NS, Q>> Q enclosed(NS rect, Rectangle2DDirection direction, QueryFactory<NS, Q> factory) {
        Rectangle2D<X, Y, ?> full = rect.getSpace().getFull();
        NS r1 = rect.immutable(rect.getX1(), full.getX2(), rect.getY1(), full.getY2());
        NS r2 = rect.immutable(full.getX1(), rect.getX2(), full.getY1(), rect.getY2());
        return factory.create(r1, r2, direction);
    }

    protected static <X, Y, NS extends Rectangle2D<X, Y, NS>, Q extends AbstractRectangle2DQuery<X, Y, ?, NS, Q>> Q equalTo(NS rect, Rectangle2DDirection direction, QueryFactory<NS, Q> factory) {
        NS r1 = rect.immutable(rect.getX1(), rect.getX1(), rect.getY1(), rect.getY1());
        NS r2 = rect.immutable(rect.getX2(), rect.getX2(), rect.getY2(), rect.getY2());
        return factory.create(r1, r2, direction);
    }

    public AbstractRectangle2DQuery(NS r1, NS r2, EuclideanSpace2D<X, Y> space, Rectangle2DDirection direction) {
        this.r1 = r1;
        this.r2 = r2;
        this.space = space;
        this.direction = direction;
    }

    @Override
    public boolean terminateEarlyData(DS shape) {
        return this.terminateEarlyNode((NS)((Rectangle2D)shape.getBounds()));
    }

    @Override
    public boolean terminateEarlyNode(NS shape) {
        switch (this.getDirection()) {
            case LEFTMOST: {
                return this.space.compareX(shape.getX1(), this.r2.getX2()) > 0;
            }
            case RIGHTMOST: {
                return this.space.compareX(shape.getX2(), this.r1.getX1()) < 0;
            }
            case BOTTOMMOST: {
                return this.space.compareY(shape.getY1(), this.r2.getY2()) > 0;
            }
            case TOPMOST: {
                return this.space.compareY(shape.getY2(), this.r1.getY1()) < 0;
            }
        }
        throw new AssertionError();
    }

    @Override
    public Comparator<NS> getBoundsComparator() {
        if (this.comparator == null) {
            this.comparator = this.createBoundsComparator();
        }
        return this.comparator;
    }

    protected Comparator<NS> createBoundsComparator() {
        switch (this.getDirection()) {
            case LEFTMOST: {
                return Comparator.comparing(Rectangle2D::getX1, this.space::compareX);
            }
            case RIGHTMOST: {
                return Comparator.comparing(Rectangle2D::getX2, (a, b) -> this.space.compareX(b, a));
            }
            case BOTTOMMOST: {
                return Comparator.comparing(Rectangle2D::getY1, this.space::compareY);
            }
            case TOPMOST: {
                return Comparator.comparing(Rectangle2D::getY2, (a, b) -> this.space.compareY(b, a));
            }
        }
        throw new AssertionError();
    }

    @Override
    public Query.QueryInclusion testNode(NS shape) {
        if (this.space.compareX(shape.getX1(), this.r1.getX2()) > 0) {
            return Query.QueryInclusion.NONE;
        }
        if (this.space.compareX(shape.getX1(), this.r2.getX2()) > 0) {
            return Query.QueryInclusion.NONE;
        }
        if (this.space.compareY(shape.getY1(), this.r1.getY2()) > 0) {
            return Query.QueryInclusion.NONE;
        }
        if (this.space.compareY(shape.getY1(), this.r2.getY2()) > 0) {
            return Query.QueryInclusion.NONE;
        }
        if (this.space.compareX(shape.getX2(), this.r2.getX1()) < 0) {
            return Query.QueryInclusion.NONE;
        }
        if (this.space.compareX(shape.getX2(), this.r1.getX1()) < 0) {
            return Query.QueryInclusion.NONE;
        }
        if (this.space.compareY(shape.getY2(), this.r2.getY1()) < 0) {
            return Query.QueryInclusion.NONE;
        }
        if (this.space.compareY(shape.getY2(), this.r1.getY1()) < 0) {
            return Query.QueryInclusion.NONE;
        }
        if (this.space.compareX(shape.getX1(), this.r1.getX1()) < 0) {
            return Query.QueryInclusion.SOME;
        }
        if (this.space.compareX(shape.getX1(), this.r2.getX1()) < 0) {
            return Query.QueryInclusion.SOME;
        }
        if (this.space.compareY(shape.getY1(), this.r1.getY1()) < 0) {
            return Query.QueryInclusion.SOME;
        }
        if (this.space.compareY(shape.getY1(), this.r2.getY1()) < 0) {
            return Query.QueryInclusion.SOME;
        }
        if (this.space.compareX(shape.getX2(), this.r2.getX2()) > 0) {
            return Query.QueryInclusion.SOME;
        }
        if (this.space.compareX(shape.getX2(), this.r1.getX2()) > 0) {
            return Query.QueryInclusion.SOME;
        }
        if (this.space.compareY(shape.getY2(), this.r2.getY2()) > 0) {
            return Query.QueryInclusion.SOME;
        }
        if (this.space.compareY(shape.getY2(), this.r1.getY2()) > 0) {
            return Query.QueryInclusion.SOME;
        }
        return Query.QueryInclusion.ALL;
    }

    protected abstract Q create(NS var1, NS var2, Rectangle2DDirection var3);

    public Q and(Q query) {
        NS ir1 = this.r1.intersection(((AbstractRectangle2DQuery)query).r1);
        NS ir2 = this.r2.intersection(((AbstractRectangle2DQuery)query).r2);
        return this.create(ir1, ir2, ((AbstractRectangle2DQuery)query).direction != null ? ((AbstractRectangle2DQuery)query).direction : this.direction);
    }

    public Rectangle2DDirection getDirection() {
        if (this.direction == null) {
            return Rectangle2DDirection.LEFTMOST;
        }
        return this.direction;
    }

    public Q starting(Rectangle2DDirection newDirection) {
        return this.create(this.r1, this.r2, newDirection);
    }

    public static interface QueryFactory<NS extends Rectangle2D<?, ?, NS>, Q extends AbstractRectangle2DQuery<?, ?, ?, NS, Q>> {
        public Q create(NS var1, NS var2, Rectangle2DDirection var3);
    }
}

