/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.math.FloatUtil;
import com.jogamp.math.Matrix4f;
import com.jogamp.math.Quaternion;
import com.jogamp.math.Recti;
import com.jogamp.math.Vec3f;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.fixedfunc.GLMatrixFunc;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public final class PMVMatrix
extends PMVMatrix4f
implements GLMatrixFunc {
    private int matrixMode = 5888;

    public static final boolean isMatrixModeName(int n) {
        switch (n) {
            case 2982: 
            case 2983: 
            case 2984: {
                return true;
            }
        }
        return false;
    }

    public static final int matrixModeName2MatrixGetName(int n) {
        switch (n) {
            case 5888: {
                return 2982;
            }
            case 5889: {
                return 2983;
            }
            case 5890: {
                return 2984;
            }
        }
        throw new GLException("unsupported matrixName: " + n);
    }

    public static final boolean isMatrixGetName(int n) {
        switch (n) {
            case 2976: 
            case 2982: 
            case 2983: 
            case 2984: {
                return true;
            }
        }
        return false;
    }

    public static final int matrixGetName2MatrixModeName(int n) {
        switch (n) {
            case 2982: {
                return 5888;
            }
            case 2983: {
                return 5889;
            }
            case 2984: {
                return 5890;
            }
        }
        throw new GLException("unsupported matrixGetName: " + n);
    }

    public PMVMatrix() {
        this(0);
    }

    public PMVMatrix(int n) {
        super(n);
    }

    @Override
    public void reset() {
        super.reset();
        this.matrixMode = 5888;
    }

    public final int glGetMatrixMode() {
        return this.matrixMode;
    }

    public final Matrix4f getCurrentMat() {
        return this.getMat(this.matrixMode);
    }

    public final Matrix4f getMat(int n) {
        switch (n) {
            case 2982: 
            case 5888: {
                return this.matMv;
            }
            case 2983: 
            case 5889: {
                return this.matP;
            }
            case 2984: 
            case 5890: {
                return this.matTex;
            }
        }
        throw new GLException("unsupported matrixName: " + n);
    }

    @Override
    public final void glMatrixMode(int n) {
        switch (n) {
            case 5888: 
            case 5889: 
            case 5890: {
                break;
            }
            default: {
                throw new GLException("unsupported matrixName: " + n);
            }
        }
        this.matrixMode = n;
    }

    @Override
    public final void glGetFloatv(int n, FloatBuffer floatBuffer) {
        int n2 = floatBuffer.position();
        if (n == 2976) {
            floatBuffer.put(this.matrixMode);
        } else {
            this.getMat(n).get(floatBuffer);
        }
        floatBuffer.position(n2);
    }

    @Override
    public final void glGetFloatv(int n, float[] fArray, int n2) {
        if (n == 2976) {
            fArray[n2] = this.matrixMode;
        } else {
            this.getMat(n).get(fArray, n2);
        }
    }

    @Override
    public final void glGetIntegerv(int n, IntBuffer intBuffer) {
        int n2 = intBuffer.position();
        if (n != 2976) {
            throw new GLException("unsupported pname: " + n);
        }
        intBuffer.put(this.matrixMode);
        intBuffer.position(n2);
    }

    @Override
    public final void glGetIntegerv(int n, int[] nArray, int n2) {
        if (n != 2976) {
            throw new GLException("unsupported pname: " + n);
        }
        nArray[n2] = this.matrixMode;
    }

    @Override
    public final void glLoadMatrixf(float[] fArray, int n) {
        if (this.matrixMode == 5888) {
            this.loadMv(fArray, n);
        } else if (this.matrixMode == 5889) {
            this.loadP(fArray, n);
        } else if (this.matrixMode == 5890) {
            this.loadT(fArray, n);
        }
    }

    @Override
    public final void glLoadMatrixf(FloatBuffer floatBuffer) {
        if (this.matrixMode == 5888) {
            this.loadMv(floatBuffer);
        } else if (this.matrixMode == 5889) {
            this.loadP(floatBuffer);
        } else if (this.matrixMode == 5890) {
            this.loadT(floatBuffer);
        }
    }

    public final void glLoadMatrixf(Matrix4f matrix4f) {
        if (this.matrixMode == 5888) {
            this.loadMv(matrix4f);
        } else if (this.matrixMode == 5889) {
            this.loadP(matrix4f);
        } else if (this.matrixMode == 5890) {
            this.loadT(matrix4f);
        }
    }

    public final void glLoadMatrix(Quaternion quaternion) {
        if (this.matrixMode == 5888) {
            this.loadMv(quaternion);
        } else if (this.matrixMode == 5889) {
            this.loadP(quaternion);
        } else if (this.matrixMode == 5890) {
            this.loadT(quaternion);
        }
    }

    @Override
    public final void glLoadIdentity() {
        if (this.matrixMode == 5888) {
            this.loadMvIdentity();
        } else if (this.matrixMode == 5889) {
            this.loadPIdentity();
        } else if (this.matrixMode == 5890) {
            this.loadTIdentity();
        }
    }

    @Override
    public final void glMultMatrixf(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        if (this.matrixMode == 5888) {
            this.mulMv(this.mat4Tmp1.load(floatBuffer));
        } else if (this.matrixMode == 5889) {
            this.mulP(this.mat4Tmp1.load(floatBuffer));
        } else if (this.matrixMode == 5890) {
            this.mulT(this.mat4Tmp1.load(floatBuffer));
        }
        floatBuffer.position(n);
    }

    @Override
    public final void glMultMatrixf(float[] fArray, int n) {
        if (this.matrixMode == 5888) {
            this.mulMv(this.mat4Tmp1.load(fArray, n));
        } else if (this.matrixMode == 5889) {
            this.mulP(this.mat4Tmp1.load(fArray, n));
        } else if (this.matrixMode == 5890) {
            this.mulT(this.mat4Tmp1.load(fArray, n));
        }
    }

    public final PMVMatrix glMultMatrixf(Matrix4f matrix4f) {
        if (this.matrixMode == 5888) {
            this.mulMv(matrix4f);
        } else if (this.matrixMode == 5889) {
            this.mulP(matrix4f);
        } else if (this.matrixMode == 5890) {
            this.mulT(matrix4f);
        }
        return this;
    }

    @Override
    public final void glTranslatef(float f, float f2, float f3) {
        this.glMultMatrixf(this.mat4Tmp1.setToTranslation(f, f2, f3));
    }

    public final PMVMatrix glTranslatef(Vec3f vec3f) {
        return this.glMultMatrixf(this.mat4Tmp1.setToTranslation(vec3f));
    }

    @Override
    public final void glScalef(float f, float f2, float f3) {
        this.glMultMatrixf(this.mat4Tmp1.setToScale(f, f2, f3));
    }

    public final PMVMatrix glScalef(Vec3f vec3f) {
        return this.glMultMatrixf(this.mat4Tmp1.setToScale(vec3f));
    }

    @Override
    public final void glRotatef(float f, float f2, float f3, float f4) {
        this.glMultMatrixf(this.mat4Tmp1.setToRotationAxis(FloatUtil.adegToRad(f), f2, f3, f4));
    }

    public final PMVMatrix glRotatef(float f, Vec3f vec3f) {
        return this.glMultMatrixf(this.mat4Tmp1.setToRotationAxis(f, vec3f));
    }

    public final PMVMatrix glRotate(Quaternion quaternion) {
        return this.glMultMatrixf(this.mat4Tmp1.setToRotation(quaternion));
    }

    @Override
    public final void glPopMatrix() {
        if (this.matrixMode == 5888) {
            this.popMv();
        } else if (this.matrixMode == 5889) {
            this.popP();
        } else if (this.matrixMode == 5890) {
            this.popT();
        }
    }

    @Override
    public final void glPushMatrix() {
        if (this.matrixMode == 5888) {
            this.pushMv();
        } else if (this.matrixMode == 5889) {
            this.pushP();
        } else if (this.matrixMode == 5890) {
            this.pushT();
        }
    }

    @Override
    public final void glOrthof(float f, float f2, float f3, float f4, float f5, float f6) {
        this.glMultMatrixf(this.mat4Tmp1.setToOrtho(f, f2, f3, f4, f5, f6));
    }

    @Override
    public final void glFrustumf(float f, float f2, float f3, float f4, float f5, float f6) throws IllegalArgumentException {
        this.glMultMatrixf(this.mat4Tmp1.setToFrustum(f, f2, f3, f4, f5, f6));
    }

    public final void gluPerspective(float f, float f2, float f3, float f4) throws IllegalArgumentException {
        this.glMultMatrixf(this.mat4Tmp1.setToPerspective(f, f2, f3, f4));
    }

    public final void gluLookAt(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
        this.glMultMatrixf(this.mat4Tmp1.setToLookAt(vec3f, vec3f2, vec3f3, this.getTmp2Mat()));
    }

    public final void gluPickMatrix(float f, float f2, float f3, float f4, Recti recti) {
        if (null != this.mat4Tmp1.setToPick(f, f2, f3, f4, recti, this.getTmp2Mat())) {
            this.glMultMatrixf(this.mat4Tmp1);
        }
    }
}

