/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.AbstractSVGFilterPrimitiveElementBridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.ext.awt.image.CompositeRule;
import io.sf.carte.echosvg.ext.awt.image.PadMode;
import io.sf.carte.echosvg.ext.awt.image.renderable.CompositeRable8Bit;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.renderable.PadRable8Bit;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Map;
import org.w3c.dom.Element;

public class SVGFeCompositeElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    @Override
    public String getLocalName() {
        return "feComposite";
    }

    @Override
    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map<String, Filter> map) {
        CompositeRule compositeRule = SVGFeCompositeElementBridge.convertOperator(element, bridgeContext);
        Filter filter2 = SVGFeCompositeElementBridge.getIn(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        Filter filter3 = SVGFeCompositeElementBridge.getIn2(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter3 == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = (Rectangle2D)filter2.getBounds2D().clone();
        rectangle2D2.add(filter3.getBounds2D());
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        ArrayList<Filter> arrayList = new ArrayList<Filter>(2);
        arrayList.add(filter3);
        arrayList.add(filter2);
        CompositeRable8Bit compositeRable8Bit = new CompositeRable8Bit(arrayList, compositeRule, true);
        SVGFeCompositeElementBridge.handleColorInterpolationFilters((Filter)compositeRable8Bit, element);
        compositeRable8Bit = new PadRable8Bit((Filter)compositeRable8Bit, rectangle2D3, PadMode.ZERO_PAD);
        SVGFeCompositeElementBridge.updateFilterMap(element, (Filter)compositeRable8Bit, map);
        return compositeRable8Bit;
    }

    protected static CompositeRule convertOperator(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "operator");
        if (string.length() == 0) {
            return CompositeRule.OVER;
        }
        if ("atop".equals(string)) {
            return CompositeRule.ATOP;
        }
        if ("in".equals(string)) {
            return CompositeRule.IN;
        }
        if ("over".equals(string)) {
            return CompositeRule.OVER;
        }
        if ("out".equals(string)) {
            return CompositeRule.OUT;
        }
        if ("xor".equals(string)) {
            return CompositeRule.XOR;
        }
        if ("arithmetic".equals(string)) {
            float f = SVGFeCompositeElementBridge.convertNumber(element, "k1", 0.0f, bridgeContext);
            float f2 = SVGFeCompositeElementBridge.convertNumber(element, "k2", 0.0f, bridgeContext);
            float f3 = SVGFeCompositeElementBridge.convertNumber(element, "k3", 0.0f, bridgeContext);
            float f4 = SVGFeCompositeElementBridge.convertNumber(element, "k4", 0.0f, bridgeContext);
            return CompositeRule.ARITHMETIC((float)f, (float)f2, (float)f3, (float)f4);
        }
        throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"operator", string});
    }
}

