/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

public class FilterInfo {
    static final int MATCHES = 2;
    static final int HAS_MATCHED_DESCENDANT = 4;
    static final int HAS_MATCHED_ANCESTOR = 8;
    static final int NO_MATCH = 16;
    static final int HAS_HIDDEN_DESCENDANT = 32;
    static final int HAS_HIDDEN_ANCESTOR = 64;
    static final int SHOW_AS_INITIAL_VALUE = 1;
    static final int SHOW_AS_MATCHED = 2;
    static final int SHOW_AS_MATCHED_ANCESTOR = 4;
    static final int SHOW_AS_MATCHED_DESCENDANT = 8;
    static final int SHOW_AS_HIDDEN = 16;
    static final int SHOW_AS_HIDDEN_ANCESTOR = 32;
    static final int SHOW_AS_HIDDEN_DESCENDANT = 64;
    public static final FilterInfo TRANSPARENT = new FilterInfo(2);
    private int info;

    public FilterInfo() {
        this(1);
    }

    private FilterInfo(int info) {
        this.info = info;
    }

    boolean set(int newInfo) {
        if (this.info != newInfo) {
            this.info = newInfo;
            return true;
        }
        return false;
    }

    boolean add(int flag) {
        int oldInfo = this.info;
        if ((flag & 0x12) != 0) {
            this.info &= 0xFFFFFFFE;
        }
        this.info |= flag;
        return oldInfo != this.info;
    }

    public boolean canBeAncestor() {
        return (this.info & 5) != 0;
    }

    public boolean isMatched() {
        return (this.info & 2) != 0;
    }

    public void reset() {
        this.info = 1;
    }

    boolean matches(int filterOptions) {
        return this.get(filterOptions) != 0;
    }

    int get(int filterOptions) {
        return filterOptions & this.info;
    }

    boolean isNotChecked() {
        return this.matches(1);
    }
}

