# -*- coding: utf-8 -*-
# Copyright 2025 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# ansible.content_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the documentation in the module file and re-run
# ansible.content_builder commenting out
# the path to external 'docstring' in build.yaml.
#
##############################################

"""
The arg spec for the nxos_l3_interfaces module
"""


class L3_interfacesArgs(object):  # pylint: disable=R0903
    """The arg spec for the nxos_l3_interfaces module"""

    argument_spec = {
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "name": {"type": "str", "required": True},
                "mac_address": {"type": "str"},
                "bandwidth": {
                    "type": "dict",
                    "options": {
                        "kilobits": {"type": "int"},
                        "inherit": {"type": "bool"},
                    },
                },
                "dot1q": {"type": "int"},
                "evpn_multisite_tracking": {
                    "type": "str",
                    "choices": ["fabric-tracking", "dci-tracking"],
                },
                "ipv6_redirects": {"type": "bool"},
                "ipv6_unreachables": {"type": "bool"},
                "redirects": {"type": "bool"},
                "unreachables": {"type": "bool"},
                "proxy_arp": {"type": "bool"},
                "port_unreachable": {"type": "bool"},
                "verify": {
                    "type": "dict",
                    "options": {
                        "unicast": {
                            "type": "dict",
                            "options": {
                                "source": {
                                    "type": "dict",
                                    "options": {
                                        "reachable_via": {
                                            "type": "dict",
                                            "options": {
                                                "mode": {"type": "str"},
                                                "allow_default": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                            },
                        },
                    },
                },
                "ipv6_verify": {
                    "type": "dict",
                    "options": {
                        "unicast": {
                            "type": "dict",
                            "options": {
                                "source": {
                                    "type": "dict",
                                    "options": {
                                        "reachable_via": {
                                            "type": "dict",
                                            "options": {
                                                "mode": {"type": "str"},
                                                "allow_default": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                            },
                        },
                    },
                },
                "dhcp": {
                    "type": "dict",
                    "options": {
                        "ipv4": {
                            "type": "dict",
                            "options": {
                                "option82": {
                                    "type": "dict",
                                    "options": {
                                        "suboption": {
                                            "type": "dict",
                                            "options": {
                                                "circuit_id": {"type": "str"},
                                            },
                                        },
                                    },
                                },
                                "smart_relay": {"type": "bool"},
                                "relay": {
                                    "type": "dict",
                                    "options": {
                                        "information": {
                                            "type": "dict",
                                            "options": {
                                                "trusted": {"type": "bool"},
                                            },
                                        },
                                        "subnet_selection": {
                                            "type": "dict",
                                            "options": {
                                                "subnet_ip": {"type": "str"},
                                            },
                                        },
                                        "source_interface": {
                                            "type": "dict",
                                            "options": {
                                                "interface_type": {"type": "str"},
                                                "interface_id": {"type": "str"},
                                            },
                                        },
                                        "address": {
                                            "type": "list",
                                            "elements": "dict",
                                            "options": {
                                                "relay_ip": {"type": "str"},
                                                "vrf_name": {"type": "str"},
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "ipv6": {
                            "type": "dict",
                            "options": {
                                "smart_relay": {"type": "bool"},
                                "relay": {
                                    "type": "dict",
                                    "options": {
                                        "source_interface": {
                                            "type": "dict",
                                            "options": {
                                                "interface_type": {"type": "str"},
                                                "interface_id": {"type": "str"},
                                            },
                                        },
                                        "address": {
                                            "type": "list",
                                            "elements": "dict",
                                            "options": {
                                                "relay_ip": {"type": "str"},
                                                "vrf_name": {"type": "str"},
                                                "interface_type": {"type": "str"},
                                                "interface_id": {"type": "str"},
                                            },
                                        },
                                    },
                                },
                            },
                        },
                    },
                },
                "ipv4": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "address": {"type": "str"},
                        "tag": {"type": "int"},
                        "secondary": {"type": "bool"},
                        "ip_network_mask": {"type": "str"},
                        "route_preference": {"type": "int"},
                    },
                },
                "ipv6": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "address": {"type": "str"},
                        "tag": {"type": "int"},
                        "aggregate_prefix_length": {"type": "int"},
                        "anycast": {"type": "bool"},
                        "eui64": {"type": "bool"},
                        "route_preference": {"type": "int"},
                        "use_bia": {"type": "bool"},
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "rendered",
                "gathered",
                "parsed",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
