/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.ui.Splitter;
import com.intellij.util.MathUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class PseudoSplitter
extends Splitter {
    private boolean myFirstIsFixed = false;
    private int myFirstFixedSize;

    PseudoSplitter(boolean vertical) {
        super(vertical);
    }

    private int getSizeForComp(JComponent component) {
        return this.getOrientation() ? component.getHeight() : component.getWidth();
    }

    public void fixFirst(float proportion) {
        assert (this.getFirstComponent() != null);
        int total = this.getSizeForComp((JComponent)((Object)this));
        this.myFirstFixedSize = (int)(proportion * (float)(total - this.getDividerWidth()));
        this.myFirstIsFixed = true;
    }

    public void fixFirst() {
        assert (this.getFirstComponent() != null);
        this.myFirstFixedSize = this.getSizeForComp(this.getFirstComponent());
        this.myFirstIsFixed = true;
    }

    public void freeAll() {
        this.myFirstIsFixed = false;
    }

    public void doLayout() {
        int total = this.getSizeForComp((JComponent)((Object)this));
        if (this.myFirstIsFixed) {
            float fixedProportion = (float)this.myFirstFixedSize / (float)(total - this.getDividerWidth());
            this.myProportion = MathUtil.clamp((float)fixedProportion, (float)0.05f, (float)0.95f);
        }
        super.doLayout();
    }

    public void setProportion(float proportion) {
        boolean firstIsFixed = this.myFirstIsFixed;
        this.myFirstIsFixed = false;
        super.setProportion(proportion);
        int total = this.getSizeForComp((JComponent)((Object)this));
        if (firstIsFixed) {
            this.myFirstFixedSize = (int)(this.myProportion * (float)(total - this.getDividerWidth()));
            this.myFirstIsFixed = true;
        }
    }
}

