from __future__ import absolute_import, division, print_function
from scitbx.array_family import flex
from libtbx import group_args
from libtbx.utils import user_plus_sys_time
from mmtbx.refinement.real_space import individual_sites
from mmtbx.refinement.real_space import weight
import mmtbx

pdb_str_1 = """\
CRYST1   44.034   76.843   61.259  90.00  90.00  90.00 P 1
ATOM      1  N   ASP L   1      41.034  57.788  45.685  1.00 34.60           N
ATOM      2  CA  ASP L   1      39.662  57.398  45.251  1.00 33.86           C
ATOM      3  C   ASP L   1      38.809  56.927  46.419  1.00 34.02           C
ATOM      4  O   ASP L   1      39.260  56.141  47.252  1.00 32.23           O
ATOM      5  CB  ASP L   1      39.743  56.287  44.206  1.00 33.99           C
ATOM      6  CG  ASP L   1      40.130  56.803  42.838  1.00 36.93           C
ATOM      7  OD1 ASP L   1      40.975  57.720  42.767  1.00 36.67           O
ATOM      8  OD2 ASP L   1      39.593  56.283  41.834  1.00 38.81           O
ATOM      9  N   VAL L   2      37.576  57.416  46.480  1.00 31.94           N
ATOM     10  CA  VAL L   2      36.665  57.016  47.538  1.00 29.81           C
ATOM     11  C   VAL L   2      36.159  55.619  47.205  1.00 28.28           C
ATOM     12  O   VAL L   2      35.676  55.371  46.101  1.00 27.24           O
ATOM     13  CB  VAL L   2      35.474  57.979  47.646  1.00 30.66           C
ATOM     14  CG1 VAL L   2      34.500  57.492  48.710  1.00 29.42           C
ATOM     15  CG2 VAL L   2      35.974  59.366  47.985  1.00 31.43           C
ATOM     16  N   GLN L   3      36.272  54.714  48.169  1.00 25.93           N
ATOM     17  CA  GLN L   3      35.853  53.330  47.991  1.00 24.46           C
ATOM     18  C   GLN L   3      34.417  53.087  48.458  1.00 23.33           C
ATOM     19  O   GLN L   3      34.076  53.358  49.607  1.00 20.10           O
ATOM     20  CB  GLN L   3      36.814  52.422  48.760  1.00 29.74           C
ATOM     21  CG  GLN L   3      36.363  50.981  48.896  1.00 39.72           C
ATOM     22  CD  GLN L   3      36.975  50.300  50.112  1.00 51.31           C
ATOM     23  OE1 GLN L   3      36.709  49.124  50.384  1.00 57.11           O
ATOM     24  NE2 GLN L   3      37.798  51.041  50.855  1.00 54.00           N
ATOM     25  N   MET L   4      33.581  52.566  47.561  1.00 24.27           N
ATOM     26  CA  MET L   4      32.184  52.274  47.881  1.00 22.89           C
ATOM     27  C   MET L   4      32.013  50.768  48.100  1.00 21.48           C
ATOM     28  O   MET L   4      32.320  49.967  47.216  1.00 23.73           O
ATOM     29  CB  MET L   4      31.267  52.748  46.744  1.00 22.77           C
ATOM     30  CG  MET L   4      31.390  54.239  46.393  1.00 20.45           C
ATOM     31  SD  MET L   4      30.924  55.388  47.735  1.00 23.95           S
ATOM     32  CE  MET L   4      29.163  55.282  47.675  1.00 24.76           C
ATOM     33  N   THR L   5      31.523  50.384  49.276  1.00 20.55           N
ATOM     34  CA  THR L   5      31.339  48.966  49.606  1.00 20.64           C
ATOM     35  C   THR L   5      29.875  48.588  49.801  1.00 20.08           C
ATOM     36  O   THR L   5      29.221  49.085  50.714  1.00 20.87           O
ATOM     37  CB  THR L   5      32.098  48.596  50.895  1.00 23.39           C
ATOM     38  OG1 THR L   5      33.471  48.984  50.770  1.00 30.91           O
ATOM     39  CG2 THR L   5      32.029  47.098  51.145  1.00 26.97           C
ATOM     40  N   GLN L   6      29.367  47.701  48.948  1.00 21.97           N
ATOM     41  CA  GLN L   6      27.975  47.267  49.048  1.00 25.11           C
ATOM     42  C   GLN L   6      27.834  45.887  49.675  1.00 25.56           C
ATOM     43  O   GLN L   6      28.599  44.970  49.369  1.00 26.32           O
ATOM     44  CB  GLN L   6      27.306  47.231  47.672  1.00 20.36           C
ATOM     45  CG  GLN L   6      27.329  48.527  46.918  1.00 21.68           C
ATOM     46  CD  GLN L   6      26.477  48.475  45.674  1.00 20.77           C
ATOM     47  OE1 GLN L   6      26.746  49.180  44.702  1.00 24.00           O
ATOM     48  NE2 GLN L   6      25.430  47.644  45.697  1.00 16.25           N
ATOM     49  N   THR L   7      26.828  45.753  50.534  1.00 27.28           N
ATOM     50  CA  THR L   7      26.529  44.505  51.224  1.00 29.94           C
ATOM     51  C   THR L   7      25.019  44.310  51.166  1.00 30.28           C
ATOM     52  O   THR L   7      24.263  45.253  51.396  1.00 30.65           O
ATOM     53  CB  THR L   7      26.941  44.575  52.705  1.00 33.05           C
ATOM     54  OG1 THR L   7      28.286  45.056  52.805  1.00 36.48           O
ATOM     55  CG2 THR L   7      26.858  43.194  53.347  1.00 38.31           C
ATOM     56  N   PRO L   8      24.554  43.090  50.860  1.00 29.43           N
ATOM     57  CA  PRO L   8      25.323  41.881  50.561  1.00 27.63           C
ATOM     58  C   PRO L   8      25.669  41.802  49.078  1.00 27.58           C
ATOM     59  O   PRO L   8      25.321  42.697  48.305  1.00 28.53           O
ATOM     60  CB  PRO L   8      24.375  40.773  50.987  1.00 27.24           C
ATOM     61  CG  PRO L   8      23.056  41.319  50.539  1.00 29.03           C
ATOM     62  CD  PRO L   8      23.119  42.773  50.982  1.00 28.99           C
ATOM     63  N   LEU L   9      26.356  40.736  48.678  1.00 27.41           N
ATOM     64  CA  LEU L   9      26.722  40.568  47.274  1.00 25.92           C
ATOM     65  C   LEU L   9      25.495  40.183  46.464  1.00 23.43           C
ATOM     66  O   LEU L   9      25.289  40.689  45.364  1.00 22.17           O
ATOM     67  CB  LEU L   9      27.799  39.491  47.108  1.00 26.82           C
ATOM     68  CG  LEU L   9      29.182  39.809  47.673  1.00 33.53           C
ATOM     69  CD1 LEU L   9      30.123  38.653  47.379  1.00 35.06           C
ATOM     70  CD2 LEU L   9      29.711  41.095  47.055  1.00 36.76           C
ATOM     71  N   THR L  10      24.690  39.279  47.013  1.00 20.90           N
ATOM     72  CA  THR L  10      23.473  38.827  46.350  1.00 23.73           C
ATOM     73  C   THR L  10      22.344  38.769  47.368  1.00 25.10           C
ATOM     74  O   THR L  10      22.579  38.643  48.572  1.00 24.48           O
ATOM     75  CB  THR L  10      23.639  37.430  45.715  1.00 23.27           C
ATOM     76  OG1 THR L  10      23.934  36.470  46.735  1.00 30.08           O
ATOM     77  CG2 THR L  10      24.755  37.440  44.696  1.00 27.84           C
ATOM     78  N   LEU L  11      21.116  38.857  46.878  1.00 26.12           N
ATOM     79  CA  LEU L  11      19.957  38.844  47.749  1.00 30.70           C
ATOM     80  C   LEU L  11      18.815  38.085  47.090  1.00 32.76           C
ATOM     81  O   LEU L  11      18.274  38.524  46.074  1.00 33.60           O
ATOM     82  CB  LEU L  11      19.533  40.287  48.038  1.00 33.97           C
ATOM     83  CG  LEU L  11      18.433  40.582  49.057  1.00 39.69           C
ATOM     84  CD1 LEU L  11      18.879  40.167  50.452  1.00 43.19           C
ATOM     85  CD2 LEU L  11      18.130  42.066  49.030  1.00 43.64           C
ATOM     86  N   SER L  12      18.459  36.935  47.657  1.00 31.08           N
ATOM     87  CA  SER L  12      17.360  36.148  47.116  1.00 30.15           C
ATOM     88  C   SER L  12      16.142  36.402  47.998  1.00 29.02           C
ATOM     89  O   SER L  12      16.100  35.974  49.152  1.00 28.74           O
ATOM     90  CB  SER L  12      17.716  34.662  47.104  1.00 32.01           C
ATOM     91  OG  SER L  12      16.708  33.917  46.439  1.00 36.13           O
ATOM     92  N   VAL L  13      15.153  37.100  47.447  1.00 26.21           N
ATOM     93  CA  VAL L  13      13.949  37.450  48.194  1.00 28.30           C
ATOM     94  C   VAL L  13      12.666  37.041  47.485  1.00 28.12           C
ATOM     95  O   VAL L  13      12.570  37.136  46.263  1.00 28.03           O
ATOM     96  CB  VAL L  13      13.893  38.973  48.436  1.00 28.47           C
ATOM     97  CG1 VAL L  13      12.710  39.318  49.326  1.00 31.69           C
ATOM     98  CG2 VAL L  13      15.194  39.444  49.057  1.00 29.64           C
ATOM     99  N   THR L  14      11.675  36.604  48.257  1.00 27.89           N
ATOM    100  CA  THR L  14      10.398  36.189  47.683  1.00 28.32           C
ATOM    101  C   THR L  14       9.493  37.398  47.478  1.00 26.52           C
ATOM    102  O   THR L  14       9.536  38.350  48.257  1.00 25.01           O
ATOM    103  CB  THR L  14       9.662  35.188  48.596  1.00 28.53           C
ATOM    104  OG1 THR L  14       9.009  35.895  49.655  1.00 32.97           O
ATOM    105  CG2 THR L  14      10.642  34.203  49.198  1.00 29.78           C
ATOM    106  N   ILE L  15       8.677  37.354  46.427  1.00 27.49           N
ATOM    107  CA  ILE L  15       7.755  38.443  46.118  1.00 30.40           C
ATOM    108  C   ILE L  15       6.923  38.807  47.350  1.00 31.66           C
ATOM    109  O   ILE L  15       6.426  37.928  48.053  1.00 30.80           O
ATOM    110  CB  ILE L  15       6.790  38.051  44.972  1.00 33.00           C
ATOM    111  CG1 ILE L  15       7.581  37.712  43.707  1.00 34.49           C
ATOM    112  CG2 ILE L  15       5.825  39.195  44.685  1.00 31.76           C
ATOM    113  CD1 ILE L  15       8.358  38.881  43.145  1.00 35.24           C
ATOM    114  N   GLY L  16       6.786  40.104  47.612  1.00 33.59           N
ATOM    115  CA  GLY L  16       6.005  40.550  48.752  1.00 31.81           C
ATOM    116  C   GLY L  16       6.829  40.795  49.999  1.00 32.58           C
ATOM    117  O   GLY L  16       6.389  41.501  50.908  1.00 30.43           O
ATOM    118  N   GLN L  17       8.020  40.209  50.059  1.00 32.24           N
ATOM    119  CA  GLN L  17       8.884  40.401  51.216  1.00 34.33           C
ATOM    120  C   GLN L  17       9.780  41.621  51.036  1.00 34.70           C
ATOM    121  O   GLN L  17      10.007  42.076  49.913  1.00 32.37           O
ATOM    122  CB  GLN L  17       9.732  39.152  51.461  1.00 37.95           C
ATOM    123  CG  GLN L  17       8.932  37.997  52.035  1.00 45.88           C
ATOM    124  CD  GLN L  17       8.284  38.349  53.367  1.00 49.94           C
ATOM    125  OE1 GLN L  17       8.971  38.579  54.365  1.00 49.94           O
ATOM    126  NE2 GLN L  17       6.955  38.403  53.384  1.00 51.10           N
ATOM    127  N   PRO L  18      10.283  42.182  52.150  1.00 33.30           N
ATOM    128  CA  PRO L  18      11.154  43.358  52.095  1.00 32.71           C
ATOM    129  C   PRO L  18      12.611  43.007  51.799  1.00 30.96           C
ATOM    130  O   PRO L  18      13.056  41.887  52.040  1.00 30.74           O
ATOM    131  CB  PRO L  18      10.976  43.970  53.478  1.00 31.82           C
ATOM    132  CG  PRO L  18      10.862  42.754  54.342  1.00 33.36           C
ATOM    133  CD  PRO L  18       9.923  41.864  53.545  1.00 34.01           C
ATOM    134  N   ALA L  19      13.344  43.978  51.268  1.00 28.50           N
ATOM    135  CA  ALA L  19      14.751  43.790  50.946  1.00 27.23           C
ATOM    136  C   ALA L  19      15.503  45.055  51.332  1.00 27.07           C
ATOM    137  O   ALA L  19      14.952  46.158  51.281  1.00 24.32           O
ATOM    138  CB  ALA L  19      14.918  43.513  49.462  1.00 30.04           C
ATOM    139  N   SER L  20      16.762  44.898  51.716  1.00 24.81           N
ATOM    140  CA  SER L  20      17.561  46.043  52.121  1.00 27.97           C
ATOM    141  C   SER L  20      18.991  45.917  51.615  1.00 26.96           C
ATOM    142  O   SER L  20      19.599  44.853  51.713  1.00 27.07           O
ATOM    143  CB  SER L  20      17.550  46.156  53.649  1.00 29.31           C
ATOM    144  OG  SER L  20      18.192  47.338  54.084  1.00 39.96           O
ATOM    145  N   ILE L  21      19.522  47.004  51.062  1.00 26.94           N
ATOM    146  CA  ILE L  21      20.889  47.005  50.551  1.00 26.44           C
ATOM    147  C   ILE L  21      21.674  48.097  51.264  1.00 24.60           C
ATOM    148  O   ILE L  21      21.199  49.220  51.405  1.00 22.55           O
ATOM    149  CB  ILE L  21      20.949  47.298  49.033  1.00 26.88           C
ATOM    150  CG1 ILE L  21      19.869  46.508  48.285  1.00 25.90           C
ATOM    151  CG2 ILE L  21      22.337  46.950  48.504  1.00 22.24           C
ATOM    152  CD1 ILE L  21      19.981  45.019  48.421  1.00 34.36           C
ATOM    153  N   SER L  22      22.880  47.765  51.701  1.00 24.87           N
ATOM    154  CA  SER L  22      23.722  48.719  52.405  1.00 25.53           C
ATOM    155  C   SER L  22      24.895  49.182  51.563  1.00 24.12           C
ATOM    156  O   SER L  22      25.440  48.425  50.757  1.00 20.85           O
ATOM    157  CB  SER L  22      24.256  48.100  53.696  1.00 27.44           C
ATOM    158  OG  SER L  22      23.196  47.814  54.590  1.00 40.03           O
ATOM    159  N   CYS L  23      25.288  50.431  51.763  1.00 22.21           N
ATOM    160  CA  CYS L  23      26.410  50.989  51.038  1.00 24.67           C
ATOM    161  C   CYS L  23      27.253  51.856  51.951  1.00 24.91           C
ATOM    162  O   CYS L  23      26.731  52.740  52.626  1.00 26.77           O
ATOM    163  CB  CYS L  23      25.925  51.824  49.868  1.00 27.61           C
ATOM    164  SG  CYS L  23      27.322  52.421  48.887  1.00 39.58           S
ATOM    165  N   GLU L  24      28.560  51.615  51.956  1.00 26.57           N
ATOM    166  CA  GLU L  24      29.464  52.379  52.807  1.00 28.88           C
ATOM    167  C   GLU L  24      30.595  53.036  52.026  1.00 24.96           C
ATOM    168  O   GLU L  24      31.211  52.420  51.157  1.00 19.29           O
ATOM    169  CB  GLU L  24      30.052  51.467  53.888  1.00 37.33           C
ATOM    170  CG  GLU L  24      29.002  50.836  54.784  1.00 48.95           C
ATOM    171  CD  GLU L  24      29.597  49.887  55.806  1.00 57.09           C
ATOM    172  OE1 GLU L  24      30.219  48.883  55.393  1.00 62.46           O
ATOM    173  OE2 GLU L  24      29.441  50.145  57.020  1.00 61.25           O
ATOM    174  N   SER L  25      30.865  54.297  52.341  1.00 23.05           N
ATOM    175  CA  SER L  25      31.930  55.022  51.673  1.00 24.10           C
ATOM    176  C   SER L  25      33.067  55.236  52.655  1.00 23.38           C
ATOM    177  O   SER L  25      32.841  55.392  53.852  1.00 23.77           O
ATOM    178  CB  SER L  25      31.416  56.366  51.155  1.00 23.21           C
ATOM    179  OG  SER L  25      30.726  57.062  52.173  1.00 24.94           O
ATOM    180  N   SER L  26      34.289  55.231  52.138  1.00 23.43           N
ATOM    181  CA  SER L  26      35.479  55.413  52.954  1.00 22.76           C
ATOM    182  C   SER L  26      35.608  56.852  53.457  1.00 25.79           C
ATOM    183  O   SER L  26      36.287  57.116  54.453  1.00 27.95           O
ATOM    184  CB  SER L  26      36.710  55.017  52.139  1.00 23.39           C
ATOM    185  OG  SER L  26      36.700  55.655  50.875  1.00 21.58           O
ATOM    186  N   GLN L  27      34.953  57.779  52.765  1.00 23.64           N
ATOM    187  CA  GLN L  27      34.976  59.187  53.137  1.00 24.84           C
ATOM    188  C   GLN L  27      33.556  59.729  53.163  1.00 25.95           C
ATOM    189  O   GLN L  27      32.674  59.212  52.477  1.00 26.41           O
ATOM    190  CB  GLN L  27      35.795  60.003  52.135  1.00 27.09           C
ATOM    191  CG  GLN L  27      37.289  59.974  52.353  1.00 35.67           C
ATOM    192  CD  GLN L  27      38.025  60.825  51.338  1.00 38.53           C
ATOM    193  OE1 GLN L  27      38.362  60.364  50.247  1.00 43.32           O
ATOM    194  NE2 GLN L  27      38.259  62.085  51.685  1.00 40.19           N
ATOM    195  N   SER L  27A     33.340  60.773  53.956  1.00 21.30           N
ATOM    196  CA  SER L  27A     32.027  61.383  54.049  1.00 23.38           C
ATOM    197  C   SER L  27A     31.607  61.916  52.682  1.00 22.05           C
ATOM    198  O   SER L  27A     32.399  62.542  51.983  1.00 19.83           O
ATOM    199  CB  SER L  27A     32.049  62.535  55.050  1.00 20.17           C
ATOM    200  OG  SER L  27A     30.809  63.216  55.043  1.00 24.39           O
ATOM    201  N   LEU L  27B     30.356  61.674  52.308  1.00 21.73           N
ATOM    202  CA  LEU L  27B     29.860  62.146  51.025  1.00 20.41           C
ATOM    203  C   LEU L  27B     29.171  63.503  51.159  1.00 21.13           C
ATOM    204  O   LEU L  27B     28.436  63.922  50.266  1.00 21.34           O
ATOM    205  CB  LEU L  27B     28.899  61.119  50.421  1.00 17.54           C
ATOM    206  CG  LEU L  27B     29.492  59.710  50.243  1.00 21.70           C
ATOM    207  CD1 LEU L  27B     28.487  58.814  49.537  1.00 19.78           C
ATOM    208  CD2 LEU L  27B     30.779  59.784  49.437  1.00 17.87           C
ATOM    209  N   LEU L  27C     29.411  64.192  52.274  1.00 19.63           N
ATOM    210  CA  LEU L  27C     28.818  65.509  52.480  1.00 20.26           C
ATOM    211  C   LEU L  27C     29.631  66.525  51.679  1.00 20.73           C
ATOM    212  O   LEU L  27C     30.858  66.568  51.777  1.00 20.62           O
ATOM    213  CB  LEU L  27C     28.825  65.874  53.966  1.00 22.61           C
ATOM    214  CG  LEU L  27C     28.110  67.173  54.344  1.00 24.16           C
ATOM    215  CD1 LEU L  27C     26.639  67.082  53.959  1.00 24.09           C
ATOM    216  CD2 LEU L  27C     28.253  67.415  55.842  1.00 27.61           C
ATOM    217  N   TYR L  27D     28.947  67.330  50.874  1.00 20.20           N
ATOM    218  CA  TYR L  27D     29.621  68.320  50.044  1.00 23.42           C
ATOM    219  C   TYR L  27D     29.679  69.681  50.742  1.00 23.19           C
ATOM    220  O   TYR L  27D     29.025  69.888  51.761  1.00 23.52           O
ATOM    221  CB  TYR L  27D     28.912  68.439  48.689  1.00 25.39           C
ATOM    222  CG  TYR L  27D     29.754  69.103  47.627  1.00 30.37           C
ATOM    223  CD1 TYR L  27D     30.986  68.569  47.260  1.00 34.82           C
ATOM    224  CD2 TYR L  27D     29.331  70.271  46.999  1.00 33.19           C
ATOM    225  CE1 TYR L  27D     31.779  69.181  46.291  1.00 38.04           C
ATOM    226  CE2 TYR L  27D     30.117  70.894  46.030  1.00 34.49           C
ATOM    227  CZ  TYR L  27D     31.338  70.341  45.684  1.00 36.73           C
ATOM    228  OH  TYR L  27D     32.119  70.940  44.729  1.00 41.25           O
ATOM    229  N   SER L  27E     30.451  70.606  50.179  1.00 22.89           N
ATOM    230  CA  SER L  27E     30.626  71.927  50.774  1.00 25.51           C
ATOM    231  C   SER L  27E     29.380  72.811  50.794  1.00 26.55           C
ATOM    232  O   SER L  27E     29.359  73.843  51.476  1.00 27.33           O
ATOM    233  CB  SER L  27E     31.782  72.660  50.087  1.00 22.60           C
ATOM    234  OG  SER L  27E     31.528  72.845  48.708  1.00 29.11           O
ATOM    235  N   ASN L  28      28.346  72.417  50.056  1.00 23.50           N
ATOM    236  CA  ASN L  28      27.105  73.184  50.038  1.00 19.92           C
ATOM    237  C   ASN L  28      26.098  72.552  50.990  1.00 22.34           C
ATOM    238  O   ASN L  28      24.961  73.006  51.099  1.00 25.95           O
ATOM    239  CB  ASN L  28      26.518  73.254  48.626  1.00 19.19           C
ATOM    240  CG  ASN L  28      26.363  71.885  47.985  1.00 22.32           C
ATOM    241  OD1 ASN L  28      26.390  70.860  48.664  1.00 19.98           O
ATOM    242  ND2 ASN L  28      26.185  71.866  46.669  1.00 21.69           N
ATOM    243  N   GLY L  29      26.522  71.499  51.679  1.00 23.30           N
ATOM    244  CA  GLY L  29      25.644  70.846  52.634  1.00 23.12           C
ATOM    245  C   GLY L  29      24.822  69.680  52.115  1.00 25.74           C
ATOM    246  O   GLY L  29      24.034  69.092  52.860  1.00 22.95           O
ATOM    247  N   LYS L  30      24.999  69.336  50.845  1.00 25.83           N
ATOM    248  CA  LYS L  30      24.256  68.227  50.260  1.00 26.77           C
ATOM    249  C   LYS L  30      25.144  66.998  50.164  1.00 26.51           C
ATOM    250  O   LYS L  30      26.366  67.112  50.070  1.00 24.03           O
ATOM    251  CB  LYS L  30      23.754  68.606  48.864  1.00 28.32           C
ATOM    252  CG  LYS L  30      22.865  69.841  48.841  1.00 34.89           C
ATOM    253  CD  LYS L  30      22.366  70.137  47.433  1.00 43.34           C
ATOM    254  CE  LYS L  30      21.493  71.389  47.403  1.00 47.80           C
ATOM    255  NZ  LYS L  30      20.322  71.286  48.325  1.00 45.05           N
ATOM    256  N   THR L  31      24.532  65.822  50.203  1.00 24.46           N
ATOM    257  CA  THR L  31      25.286  64.585  50.090  1.00 25.48           C
ATOM    258  C   THR L  31      24.889  63.885  48.788  1.00 25.18           C
ATOM    259  O   THR L  31      23.766  63.390  48.638  1.00 22.28           O
ATOM    260  CB  THR L  31      25.060  63.673  51.328  1.00 27.75           C
ATOM    261  OG1 THR L  31      25.454  62.329  51.020  1.00 28.87           O
ATOM    262  CG2 THR L  31      23.614  63.705  51.763  1.00 35.45           C
ATOM    263  N   TYR L  32      25.823  63.871  47.839  1.00 21.74           N
ATOM    264  CA  TYR L  32      25.586  63.274  46.533  1.00 21.62           C
ATOM    265  C   TYR L  32      25.767  61.759  46.475  1.00 20.47           C
ATOM    266  O   TYR L  32      26.821  61.264  46.088  1.00 20.35           O
ATOM    267  CB  TYR L  32      26.490  63.937  45.487  1.00 25.26           C
ATOM    268  CG  TYR L  32      26.284  65.430  45.356  1.00 29.46           C
ATOM    269  CD1 TYR L  32      25.008  65.967  45.195  1.00 30.70           C
ATOM    270  CD2 TYR L  32      27.365  66.307  45.385  1.00 32.63           C
ATOM    271  CE1 TYR L  32      24.812  67.337  45.067  1.00 29.14           C
ATOM    272  CE2 TYR L  32      27.180  67.679  45.256  1.00 31.78           C
ATOM    273  CZ  TYR L  32      25.902  68.187  45.099  1.00 32.44           C
ATOM    274  OH  TYR L  32      25.717  69.544  44.974  1.00 25.41           O
ATOM    275  N   LEU L  33      24.735  61.027  46.879  1.00 16.46           N
ATOM    276  CA  LEU L  33      24.767  59.574  46.833  1.00 14.29           C
ATOM    277  C   LEU L  33      23.527  59.123  46.068  1.00 14.89           C
ATOM    278  O   LEU L  33      22.395  59.460  46.446  1.00 14.83           O
ATOM    279  CB  LEU L  33      24.736  58.958  48.235  1.00 19.02           C
ATOM    280  CG  LEU L  33      24.644  57.438  48.062  1.00 24.27           C
ATOM    281  CD1 LEU L  33      26.041  56.839  47.953  1.00 23.06           C
ATOM    282  CD2 LEU L  33      23.882  56.836  49.195  1.00 26.31           C
ATOM    283  N   ASN L  34      23.748  58.359  45.004  1.00 14.89           N
ATOM    284  CA  ASN L  34      22.672  57.871  44.152  1.00 13.35           C
ATOM    285  C   ASN L  34      22.613  56.353  44.160  1.00 16.45           C
ATOM    286  O   ASN L  34      23.578  55.676  44.544  1.00 12.72           O
ATOM    287  CB  ASN L  34      22.893  58.311  42.699  1.00 17.67           C
ATOM    288  CG  ASN L  34      23.271  59.778  42.570  1.00 21.95           C
ATOM    289  OD1 ASN L  34      22.431  60.667  42.690  1.00 20.35           O
ATOM    290  ND2 ASN L  34      24.549  60.032  42.324  1.00 26.68           N
ATOM    291  N   TRP L  35      21.470  55.831  43.725  1.00 14.93           N
ATOM    292  CA  TRP L  35      21.263  54.396  43.607  1.00 15.61           C
ATOM    293  C   TRP L  35      20.778  54.125  42.188  1.00 17.92           C
ATOM    294  O   TRP L  35      19.873  54.800  41.692  1.00 16.60           O
ATOM    295  CB  TRP L  35      20.211  53.886  44.593  1.00 16.06           C
ATOM    296  CG  TRP L  35      20.643  53.848  46.010  1.00 14.52           C
ATOM    297  CD1 TRP L  35      20.390  54.783  46.967  1.00 16.42           C
ATOM    298  CD2 TRP L  35      21.376  52.799  46.655  1.00 17.46           C
ATOM    299  NE1 TRP L  35      20.911  54.380  48.173  1.00 14.83           N
ATOM    300  CE2 TRP L  35      21.523  53.165  48.009  1.00 16.93           C
ATOM    301  CE3 TRP L  35      21.922  51.584  46.220  1.00 17.09           C
ATOM    302  CZ2 TRP L  35      22.193  52.358  48.937  1.00 14.21           C
ATOM    303  CZ3 TRP L  35      22.589  50.780  47.145  1.00 21.53           C
ATOM    304  CH2 TRP L  35      22.716  51.173  48.487  1.00 18.08           C
ATOM    305  N   LEU L  36      21.391  53.140  41.540  1.00 16.84           N
ATOM    306  CA  LEU L  36      21.021  52.757  40.181  1.00 17.45           C
ATOM    307  C   LEU L  36      20.530  51.316  40.170  1.00 14.78           C
ATOM    308  O   LEU L  36      20.886  50.508  41.032  1.00 13.21           O
ATOM    309  CB  LEU L  36      22.224  52.833  39.234  1.00 14.08           C
ATOM    310  CG  LEU L  36      23.070  54.096  39.099  1.00 21.94           C
ATOM    311  CD1 LEU L  36      24.325  53.755  38.298  1.00 23.95           C
ATOM    312  CD2 LEU L  36      22.278  55.193  38.416  1.00 22.33           C
ATOM    313  N   LEU L  37      19.720  51.006  39.171  1.00 13.66           N
ATOM    314  CA  LEU L  37      19.204  49.671  38.985  1.00 14.99           C
ATOM    315  C   LEU L  37      19.459  49.327  37.536  1.00 14.95           C
ATOM    316  O   LEU L  37      19.079  50.077  36.640  1.00 16.53           O
ATOM    317  CB  LEU L  37      17.695  49.605  39.256  1.00 16.19           C
ATOM    318  CG  LEU L  37      17.014  48.332  38.725  1.00 14.96           C
ATOM    319  CD1 LEU L  37      17.633  47.097  39.365  1.00 17.06           C
ATOM    320  CD2 LEU L  37      15.518  48.393  39.009  1.00 18.19           C
ATOM    321  N   GLN L  38      20.133  48.210  37.307  1.00 14.33           N
ATOM    322  CA  GLN L  38      20.394  47.758  35.950  1.00 15.88           C
ATOM    323  C   GLN L  38      19.678  46.426  35.797  1.00 15.91           C
ATOM    324  O   GLN L  38      20.130  45.406  36.319  1.00 18.08           O
ATOM    325  CB  GLN L  38      21.900  47.576  35.706  1.00 17.23           C
ATOM    326  CG  GLN L  38      22.237  46.899  34.376  1.00 15.66           C
ATOM    327  CD  GLN L  38      23.722  46.959  34.034  1.00 15.82           C
ATOM    328  OE1 GLN L  38      24.574  46.690  34.876  1.00 18.16           O
ATOM    329  NE2 GLN L  38      24.032  47.302  32.788  1.00 16.89           N
ATOM    330  N   ARG L  39      18.543  46.447  35.110  1.00 14.18           N
ATOM    331  CA  ARG L  39      17.776  45.234  34.873  1.00 20.33           C
ATOM    332  C   ARG L  39      18.493  44.433  33.791  1.00 21.95           C
ATOM    333  O   ARG L  39      19.223  44.991  32.974  1.00 22.64           O
ATOM    334  CB  ARG L  39      16.357  45.571  34.405  1.00 19.28           C
ATOM    335  CG  ARG L  39      15.519  46.329  35.425  1.00 26.32           C
ATOM    336  CD  ARG L  39      14.040  46.299  35.050  1.00 30.01           C
ATOM    337  NE  ARG L  39      13.182  46.834  36.107  1.00 37.68           N
ATOM    338  CZ  ARG L  39      12.895  48.124  36.268  1.00 42.04           C
ATOM    339  NH1 ARG L  39      13.394  49.030  35.435  1.00 42.72           N
ATOM    340  NH2 ARG L  39      12.107  48.508  37.265  1.00 41.07           N
ATOM    341  N   PRO L  40      18.295  43.110  33.773  1.00 25.36           N
ATOM    342  CA  PRO L  40      18.943  42.262  32.768  1.00 26.92           C
ATOM    343  C   PRO L  40      18.774  42.791  31.343  1.00 27.27           C
ATOM    344  O   PRO L  40      17.673  43.147  30.931  1.00 29.19           O
ATOM    345  CB  PRO L  40      18.259  40.915  32.974  1.00 27.23           C
ATOM    346  CG  PRO L  40      18.008  40.907  34.452  1.00 27.26           C
ATOM    347  CD  PRO L  40      17.481  42.303  34.700  1.00 24.09           C
ATOM    348  N   GLY L  41      19.877  42.854  30.604  1.00 28.99           N
ATOM    349  CA  GLY L  41      19.831  43.322  29.227  1.00 29.79           C
ATOM    350  C   GLY L  41      19.474  44.785  29.030  1.00 33.61           C
ATOM    351  O   GLY L  41      19.016  45.176  27.955  1.00 34.06           O
ATOM    352  N   GLN L  42      19.685  45.602  30.057  1.00 32.20           N
ATOM    353  CA  GLN L  42      19.370  47.021  29.960  1.00 29.83           C
ATOM    354  C   GLN L  42      20.453  47.912  30.554  1.00 27.43           C
ATOM    355  O   GLN L  42      21.344  47.450  31.271  1.00 25.20           O
ATOM    356  CB  GLN L  42      18.032  47.307  30.641  1.00 30.55           C
ATOM    357  CG  GLN L  42      16.863  46.579  30.001  1.00 40.46           C
ATOM    358  CD  GLN L  42      15.527  47.041  30.540  1.00 46.52           C
ATOM    359  OE1 GLN L  42      15.203  48.229  30.487  1.00 53.14           O
ATOM    360  NE2 GLN L  42      14.739  46.106  31.060  1.00 48.57           N
ATOM    361  N   SER L  43      20.381  49.197  30.236  1.00 24.38           N
ATOM    362  CA  SER L  43      21.356  50.140  30.749  1.00 25.35           C
ATOM    363  C   SER L  43      20.965  50.523  32.174  1.00 22.38           C
ATOM    364  O   SER L  43      19.805  50.392  32.571  1.00 17.94           O
ATOM    365  CB  SER L  43      21.398  51.386  29.862  1.00 27.87           C
ATOM    366  OG  SER L  43      20.155  52.060  29.894  1.00 37.63           O
ATOM    367  N   PRO L  44      21.937  50.975  32.974  1.00 20.31           N
ATOM    368  CA  PRO L  44      21.611  51.361  34.349  1.00 20.54           C
ATOM    369  C   PRO L  44      20.551  52.458  34.345  1.00 20.65           C
ATOM    370  O   PRO L  44      20.449  53.240  33.392  1.00 17.85           O
ATOM    371  CB  PRO L  44      22.948  51.858  34.897  1.00 17.98           C
ATOM    372  CG  PRO L  44      23.946  51.015  34.155  1.00 19.43           C
ATOM    373  CD  PRO L  44      23.390  51.035  32.739  1.00 22.70           C
ATOM    374  N   LYS L  45      19.760  52.504  35.408  1.00 17.24           N
ATOM    375  CA  LYS L  45      18.718  53.505  35.539  1.00 16.32           C
ATOM    376  C   LYS L  45      18.751  54.031  36.966  1.00 14.58           C
ATOM    377  O   LYS L  45      18.753  53.253  37.922  1.00 11.26           O
ATOM    378  CB  LYS L  45      17.345  52.895  35.248  1.00 22.35           C
ATOM    379  CG  LYS L  45      16.232  53.917  35.256  1.00 28.96           C
ATOM    380  CD  LYS L  45      14.869  53.287  35.074  1.00 37.31           C
ATOM    381  CE  LYS L  45      13.801  54.364  34.907  1.00 43.23           C
ATOM    382  NZ  LYS L  45      13.790  55.324  36.050  1.00 43.54           N
ATOM    383  N   ARG L  46      18.793  55.348  37.117  1.00 12.76           N
ATOM    384  CA  ARG L  46      18.824  55.917  38.454  1.00 16.71           C
ATOM    385  C   ARG L  46      17.436  55.851  39.103  1.00 14.60           C
ATOM    386  O   ARG L  46      16.423  56.149  38.461  1.00 14.89           O
ATOM    387  CB  ARG L  46      19.321  57.365  38.409  1.00 14.67           C
ATOM    388  CG  ARG L  46      19.789  57.885  39.762  1.00 15.93           C
ATOM    389  CD  ARG L  46      20.267  59.315  39.663  1.00 15.47           C
ATOM    390  NE  ARG L  46      19.151  60.240  39.493  1.00 16.37           N
ATOM    391  CZ  ARG L  46      19.291  61.533  39.236  1.00 16.05           C
ATOM    392  NH1 ARG L  46      20.507  62.056  39.116  1.00 13.47           N
ATOM    393  NH2 ARG L  46      18.217  62.302  39.101  1.00 12.81           N
ATOM    394  N   LEU L  47      17.412  55.444  40.372  1.00 14.40           N
ATOM    395  CA  LEU L  47      16.181  55.321  41.154  1.00 15.42           C
ATOM    396  C   LEU L  47      16.122  56.408  42.220  1.00 18.73           C
ATOM    397  O   LEU L  47      15.076  57.027  42.443  1.00 19.02           O
ATOM    398  CB  LEU L  47      16.128  53.970  41.872  1.00 12.06           C
ATOM    399  CG  LEU L  47      16.204  52.684  41.048  1.00 19.55           C
ATOM    400  CD1 LEU L  47      16.092  51.490  41.987  1.00 18.49           C
ATOM    401  CD2 LEU L  47      15.088  52.652  40.008  1.00 19.39           C
ATOM    402  N   ILE L  48      17.263  56.625  42.871  1.00 18.50           N
ATOM    403  CA  ILE L  48      17.383  57.595  43.950  1.00 16.46           C
ATOM    404  C   ILE L  48      18.610  58.490  43.825  1.00 16.98           C
ATOM    405  O   ILE L  48      19.681  58.025  43.457  1.00 14.42           O
ATOM    406  CB  ILE L  48      17.479  56.865  45.309  1.00 18.05           C
ATOM    407  CG1 ILE L  48      16.187  56.094  45.573  1.00 19.86           C
ATOM    408  CG2 ILE L  48      17.781  57.859  46.422  1.00 17.08           C
ATOM    409  CD1 ILE L  48      16.163  55.366  46.893  1.00 25.31           C
ATOM    410  N   TYR L  49      18.442  59.772  44.141  1.00 16.21           N
ATOM    411  CA  TYR L  49      19.547  60.731  44.120  1.00 17.49           C
ATOM    412  C   TYR L  49      19.484  61.562  45.408  1.00 17.53           C
ATOM    413  O   TYR L  49      18.455  61.587  46.083  1.00 18.53           O
ATOM    414  CB  TYR L  49      19.482  61.641  42.884  1.00 15.12           C
ATOM    415  CG  TYR L  49      18.260  62.531  42.780  1.00 18.97           C
ATOM    416  CD1 TYR L  49      17.036  62.028  42.339  1.00 19.08           C
ATOM    417  CD2 TYR L  49      18.339  63.889  43.094  1.00 18.51           C
ATOM    418  CE1 TYR L  49      15.916  62.863  42.207  1.00 18.77           C
ATOM    419  CE2 TYR L  49      17.233  64.727  42.969  1.00 22.10           C
ATOM    420  CZ  TYR L  49      16.029  64.210  42.525  1.00 22.13           C
ATOM    421  OH  TYR L  49      14.947  65.044  42.403  1.00 24.02           O
ATOM    422  N   LEU L  50      20.579  62.236  45.748  1.00 18.75           N
ATOM    423  CA  LEU L  50      20.643  63.028  46.973  1.00 18.23           C
ATOM    424  C   LEU L  50      20.200  62.198  48.180  1.00 19.33           C
ATOM    425  O   LEU L  50      19.478  62.677  49.054  1.00 17.93           O
ATOM    426  CB  LEU L  50      19.781  64.288  46.848  1.00 20.23           C
ATOM    427  CG  LEU L  50      20.363  65.395  45.961  1.00 17.31           C
ATOM    428  CD1 LEU L  50      19.331  66.501  45.779  1.00 18.72           C
ATOM    429  CD2 LEU L  50      21.646  65.941  46.591  1.00  7.48           C
ATOM    430  N   VAL L  51      20.620  60.937  48.193  1.00 18.13           N
ATOM    431  CA  VAL L  51      20.329  60.009  49.284  1.00 16.91           C
ATOM    432  C   VAL L  51      18.910  59.465  49.412  1.00 16.58           C
ATOM    433  O   VAL L  51      18.719  58.260  49.569  1.00 18.45           O
ATOM    434  CB  VAL L  51      20.715  60.632  50.661  1.00 22.06           C
ATOM    435  CG1 VAL L  51      20.414  59.652  51.788  1.00 16.84           C
ATOM    436  CG2 VAL L  51      22.195  60.996  50.675  1.00 19.42           C
ATOM    437  N   SER L  52      17.908  60.330  49.337  1.00 16.63           N
ATOM    438  CA  SER L  52      16.546  59.856  49.539  1.00 19.17           C
ATOM    439  C   SER L  52      15.482  60.349  48.575  1.00 19.81           C
ATOM    440  O   SER L  52      14.302  60.088  48.788  1.00 21.93           O
ATOM    441  CB  SER L  52      16.116  60.208  50.961  1.00 20.87           C
ATOM    442  OG  SER L  52      16.182  61.614  51.148  1.00 21.76           O
ATOM    443  N   LYS L  53      15.876  61.058  47.525  1.00 20.59           N
ATOM    444  CA  LYS L  53      14.895  61.558  46.571  1.00 23.42           C
ATOM    445  C   LYS L  53      14.646  60.569  45.443  1.00 22.07           C
ATOM    446  O   LYS L  53      15.580  60.121  44.781  1.00 24.54           O
ATOM    447  CB  LYS L  53      15.345  62.903  45.999  1.00 25.03           C
ATOM    448  CG  LYS L  53      15.217  64.046  46.985  1.00 29.66           C
ATOM    449  CD  LYS L  53      15.684  65.358  46.393  1.00 33.90           C
ATOM    450  CE  LYS L  53      15.349  66.506  47.327  1.00 42.85           C
ATOM    451  NZ  LYS L  53      15.833  66.239  48.715  1.00 47.15           N
ATOM    452  N   LEU L  54      13.378  60.234  45.234  1.00 20.82           N
ATOM    453  CA  LEU L  54      12.995  59.301  44.188  1.00 22.53           C
ATOM    454  C   LEU L  54      12.900  59.965  42.826  1.00 25.63           C
ATOM    455  O   LEU L  54      12.310  61.039  42.684  1.00 23.36           O
ATOM    456  CB  LEU L  54      11.647  58.656  44.512  1.00 24.44           C
ATOM    457  CG  LEU L  54      11.621  57.447  45.451  1.00 28.62           C
ATOM    458  CD1 LEU L  54      12.227  57.817  46.795  1.00 32.75           C
ATOM    459  CD2 LEU L  54      10.182  56.973  45.620  1.00 29.37           C
ATOM    460  N   ASP L  55      13.499  59.324  41.828  1.00 23.13           N
ATOM    461  CA  ASP L  55      13.442  59.823  40.465  1.00 22.15           C
ATOM    462  C   ASP L  55      12.016  59.598  39.980  1.00 23.92           C
ATOM    463  O   ASP L  55      11.273  58.812  40.574  1.00 20.33           O
ATOM    464  CB  ASP L  55      14.435  59.064  39.581  1.00 19.91           C
ATOM    465  CG  ASP L  55      15.832  59.666  39.630  1.00 21.77           C
ATOM    466  OD1 ASP L  55      16.013  60.777  39.094  1.00 20.55           O
ATOM    467  OD2 ASP L  55      16.742  59.039  40.212  1.00 23.10           O
ATOM    468  N   SER L  56      11.637  60.291  38.912  1.00 26.03           N
ATOM    469  CA  SER L  56      10.295  60.175  38.352  1.00 31.82           C
ATOM    470  C   SER L  56      10.022  58.754  37.879  1.00 31.81           C
ATOM    471  O   SER L  56      10.879  58.128  37.259  1.00 35.23           O
ATOM    472  CB  SER L  56      10.136  61.124  37.164  1.00 33.67           C
ATOM    473  OG  SER L  56      10.702  62.389  37.448  1.00 43.12           O
ATOM    474  N   GLY L  57       8.826  58.254  38.167  1.00 33.54           N
ATOM    475  CA  GLY L  57       8.459  56.917  37.736  1.00 33.25           C
ATOM    476  C   GLY L  57       8.796  55.808  38.710  1.00 34.17           C
ATOM    477  O   GLY L  57       8.238  54.713  38.626  1.00 37.35           O
ATOM    478  N   VAL L  58       9.708  56.082  39.634  1.00 31.48           N
ATOM    479  CA  VAL L  58      10.110  55.086  40.617  1.00 26.25           C
ATOM    480  C   VAL L  58       9.018  54.903  41.679  1.00 29.64           C
ATOM    481  O   VAL L  58       8.556  55.867  42.288  1.00 28.05           O
ATOM    482  CB  VAL L  58      11.446  55.495  41.290  1.00 26.35           C
ATOM    483  CG1 VAL L  58      11.892  54.431  42.278  1.00 22.70           C
ATOM    484  CG2 VAL L  58      12.515  55.710  40.223  1.00 18.63           C
ATOM    485  N   PRO L  59       8.584  53.652  41.903  1.00 30.43           N
ATOM    486  CA  PRO L  59       7.548  53.310  42.883  1.00 32.06           C
ATOM    487  C   PRO L  59       7.850  53.737  44.320  1.00 32.74           C
ATOM    488  O   PRO L  59       9.002  53.749  44.756  1.00 33.07           O
ATOM    489  CB  PRO L  59       7.443  51.796  42.751  1.00 33.06           C
ATOM    490  CG  PRO L  59       7.753  51.571  41.313  1.00 32.07           C
ATOM    491  CD  PRO L  59       8.944  52.469  41.104  1.00 29.67           C
ATOM    492  N   ASP L  60       6.788  54.070  45.045  1.00 31.16           N
ATOM    493  CA  ASP L  60       6.857  54.499  46.439  1.00 32.37           C
ATOM    494  C   ASP L  60       7.462  53.402  47.328  1.00 30.41           C
ATOM    495  O   ASP L  60       7.812  53.650  48.484  1.00 27.13           O
ATOM    496  CB  ASP L  60       5.436  54.839  46.915  1.00 40.86           C
ATOM    497  CG  ASP L  60       5.411  55.551  48.255  1.00 49.34           C
ATOM    498  OD1 ASP L  60       5.969  55.012  49.235  1.00 54.47           O
ATOM    499  OD2 ASP L  60       4.818  56.650  48.332  1.00 53.40           O
ATOM    500  N   ARG L  61       7.574  52.189  46.788  1.00 28.18           N
ATOM    501  CA  ARG L  61       8.127  51.057  47.534  1.00 26.81           C
ATOM    502  C   ARG L  61       9.598  51.258  47.872  1.00 24.82           C
ATOM    503  O   ARG L  61      10.115  50.657  48.818  1.00 24.48           O
ATOM    504  CB  ARG L  61       8.006  49.762  46.729  1.00 30.87           C
ATOM    505  CG  ARG L  61       6.619  49.440  46.216  1.00 37.65           C
ATOM    506  CD  ARG L  61       6.533  47.970  45.840  1.00 39.88           C
ATOM    507  NE  ARG L  61       7.602  47.558  44.931  1.00 39.46           N
ATOM    508  CZ  ARG L  61       7.653  47.885  43.647  1.00 36.67           C
ATOM    509  NH1 ARG L  61       6.696  48.632  43.113  1.00 43.76           N
ATOM    510  NH2 ARG L  61       8.655  47.462  42.896  1.00 32.38           N
ATOM    511  N   PHE L  62      10.280  52.082  47.086  1.00 21.85           N
ATOM    512  CA  PHE L  62      11.697  52.330  47.326  1.00 24.54           C
ATOM    513  C   PHE L  62      11.902  53.494  48.277  1.00 23.56           C
ATOM    514  O   PHE L  62      11.208  54.509  48.201  1.00 20.33           O
ATOM    515  CB  PHE L  62      12.438  52.615  46.013  1.00 21.32           C
ATOM    516  CG  PHE L  62      12.565  51.419  45.118  1.00 24.06           C
ATOM    517  CD1 PHE L  62      11.506  51.018  44.311  1.00 25.50           C
ATOM    518  CD2 PHE L  62      13.741  50.677  45.095  1.00 26.55           C
ATOM    519  CE1 PHE L  62      11.621  49.892  43.494  1.00 24.36           C
ATOM    520  CE2 PHE L  62      13.863  49.551  44.283  1.00 25.25           C
ATOM    521  CZ  PHE L  62      12.803  49.159  43.483  1.00 21.45           C
ATOM    522  N   THR L  63      12.857  53.327  49.181  1.00 22.89           N
ATOM    523  CA  THR L  63      13.184  54.359  50.146  1.00 24.67           C
ATOM    524  C   THR L  63      14.686  54.376  50.396  1.00 22.41           C
ATOM    525  O   THR L  63      15.301  53.336  50.628  1.00 22.38           O
ATOM    526  CB  THR L  63      12.439  54.124  51.474  1.00 27.75           C
ATOM    527  OG1 THR L  63      11.033  54.300  51.260  1.00 34.04           O
ATOM    528  CG2 THR L  63      12.909  55.105  52.538  1.00 30.09           C
ATOM    529  N   GLY L  64      15.272  55.565  50.329  1.00 23.19           N
ATOM    530  CA  GLY L  64      16.694  55.709  50.568  1.00 17.74           C
ATOM    531  C   GLY L  64      16.943  56.537  51.815  1.00 20.94           C
ATOM    532  O   GLY L  64      16.227  57.499  52.084  1.00 20.63           O
ATOM    533  N   SER L  65      17.951  56.158  52.592  1.00 20.93           N
ATOM    534  CA  SER L  65      18.292  56.896  53.799  1.00 20.49           C
ATOM    535  C   SER L  65      19.779  56.737  54.090  1.00 20.64           C
ATOM    536  O   SER L  65      20.489  56.028  53.382  1.00 20.55           O
ATOM    537  CB  SER L  65      17.476  56.382  54.982  1.00 19.60           C
ATOM    538  OG  SER L  65      17.832  55.049  55.285  1.00 26.02           O
ATOM    539  N   GLY L  66      20.249  57.397  55.138  1.00 21.77           N
ATOM    540  CA  GLY L  66      21.652  57.295  55.489  1.00 22.74           C
ATOM    541  C   GLY L  66      22.255  58.669  55.643  1.00 24.85           C
ATOM    542  O   GLY L  66      21.587  59.679  55.417  1.00 24.29           O
ATOM    543  N   SER L  67      23.526  58.719  56.010  1.00 27.01           N
ATOM    544  CA  SER L  67      24.177  60.002  56.201  1.00 30.72           C
ATOM    545  C   SER L  67      25.669  59.800  56.402  1.00 29.06           C
ATOM    546  O   SER L  67      26.099  58.769  56.916  1.00 27.98           O
ATOM    547  CB  SER L  67      23.567  60.698  57.425  1.00 32.77           C
ATOM    548  OG  SER L  67      24.090  61.998  57.603  1.00 40.98           O
ATOM    549  N   GLY L  68      26.457  60.785  55.985  1.00 29.28           N
ATOM    550  CA  GLY L  68      27.895  60.695  56.152  1.00 28.85           C
ATOM    551  C   GLY L  68      28.592  59.615  55.351  1.00 29.75           C
ATOM    552  O   GLY L  68      29.005  59.849  54.211  1.00 32.70           O
ATOM    553  N   THR L  69      28.737  58.432  55.944  1.00 30.01           N
ATOM    554  CA  THR L  69      29.414  57.329  55.268  1.00 27.46           C
ATOM    555  C   THR L  69      28.583  56.049  55.167  1.00 25.79           C
ATOM    556  O   THR L  69      29.022  55.080  54.550  1.00 24.35           O
ATOM    557  CB  THR L  69      30.742  56.973  55.975  1.00 27.91           C
ATOM    558  OG1 THR L  69      30.463  56.420  57.267  1.00 26.61           O
ATOM    559  CG2 THR L  69      31.611  58.212  56.138  1.00 24.72           C
ATOM    560  N   ASP L  70      27.396  56.039  55.771  1.00 22.97           N
ATOM    561  CA  ASP L  70      26.539  54.852  55.732  1.00 25.61           C
ATOM    562  C   ASP L  70      25.186  55.164  55.124  1.00 22.62           C
ATOM    563  O   ASP L  70      24.489  56.071  55.574  1.00 22.80           O
ATOM    564  CB  ASP L  70      26.352  54.267  57.133  1.00 28.61           C
ATOM    565  CG  ASP L  70      27.632  53.681  57.689  1.00 37.03           C
ATOM    566  OD1 ASP L  70      28.565  54.458  57.984  1.00 40.10           O
ATOM    567  OD2 ASP L  70      27.710  52.440  57.822  1.00 41.86           O
ATOM    568  N   PHE L  71      24.816  54.386  54.111  1.00 20.71           N
ATOM    569  CA  PHE L  71      23.567  54.588  53.388  1.00 20.13           C
ATOM    570  C   PHE L  71      22.842  53.279  53.163  1.00 21.75           C
ATOM    571  O   PHE L  71      23.469  52.230  53.041  1.00 22.22           O
ATOM    572  CB  PHE L  71      23.880  55.248  52.053  1.00 19.20           C
ATOM    573  CG  PHE L  71      24.724  56.471  52.190  1.00 17.28           C
ATOM    574  CD1 PHE L  71      24.153  57.686  52.543  1.00 18.11           C
ATOM    575  CD2 PHE L  71      26.101  56.398  52.028  1.00 19.84           C
ATOM    576  CE1 PHE L  71      24.939  58.813  52.738  1.00 18.03           C
ATOM    577  CE2 PHE L  71      26.897  57.518  52.222  1.00 17.27           C
ATOM    578  CZ  PHE L  71      26.313  58.730  52.579  1.00 18.64           C
ATOM    579  N   THR L  72      21.516  53.345  53.093  1.00 21.07           N
ATOM    580  CA  THR L  72      20.718  52.145  52.904  1.00 22.12           C
ATOM    581  C   THR L  72      19.565  52.343  51.939  1.00 21.14           C
ATOM    582  O   THR L  72      18.870  53.362  51.985  1.00 22.76           O
ATOM    583  CB  THR L  72      20.117  51.651  54.242  1.00 24.07           C
ATOM    584  OG1 THR L  72      21.157  51.514  55.218  1.00 25.91           O
ATOM    585  CG2 THR L  72      19.427  50.298  54.049  1.00 19.04           C
ATOM    586  N   LEU L  73      19.374  51.355  51.069  1.00 18.96           N
ATOM    587  CA  LEU L  73      18.283  51.352  50.104  1.00 20.26           C
ATOM    588  C   LEU L  73      17.314  50.283  50.600  1.00 23.48           C
ATOM    589  O   LEU L  73      17.718  49.146  50.843  1.00 24.00           O
ATOM    590  CB  LEU L  73      18.790  50.969  48.711  1.00 20.30           C
ATOM    591  CG  LEU L  73      17.742  50.649  47.632  1.00 19.01           C
ATOM    592  CD1 LEU L  73      16.863  51.855  47.383  1.00 22.55           C
ATOM    593  CD2 LEU L  73      18.440  50.250  46.342  1.00 22.81           C
ATOM    594  N   ARG L  74      16.048  50.645  50.776  1.00 23.90           N
ATOM    595  CA  ARG L  74      15.059  49.674  51.226  1.00 27.69           C
ATOM    596  C   ARG L  74      13.892  49.555  50.267  1.00 27.05           C
ATOM    597  O   ARG L  74      13.446  50.538  49.682  1.00 28.12           O
ATOM    598  CB  ARG L  74      14.537  50.020  52.625  1.00 33.87           C
ATOM    599  CG  ARG L  74      15.555  49.761  53.717  1.00 43.57           C
ATOM    600  CD  ARG L  74      14.999  49.980  55.116  1.00 52.01           C
ATOM    601  NE  ARG L  74      16.011  49.655  56.122  1.00 59.20           N
ATOM    602  CZ  ARG L  74      15.846  49.787  57.434  1.00 62.75           C
ATOM    603  NH1 ARG L  74      16.834  49.461  58.259  1.00 64.77           N
ATOM    604  NH2 ARG L  74      14.700  50.244  57.923  1.00 66.17           N
ATOM    605  N   ILE L  75      13.429  48.326  50.094  1.00 25.99           N
ATOM    606  CA  ILE L  75      12.293  48.025  49.238  1.00 27.63           C
ATOM    607  C   ILE L  75      11.328  47.367  50.216  1.00 27.31           C
ATOM    608  O   ILE L  75      11.605  46.278  50.725  1.00 28.64           O
ATOM    609  CB  ILE L  75      12.680  47.030  48.121  1.00 25.47           C
ATOM    610  CG1 ILE L  75      13.949  47.519  47.410  1.00 23.16           C
ATOM    611  CG2 ILE L  75      11.537  46.908  47.114  1.00 25.23           C
ATOM    612  CD1 ILE L  75      14.421  46.604  46.276  1.00 25.74           C
ATOM    613  N   SER L  76      10.219  48.043  50.503  1.00 28.10           N
ATOM    614  CA  SER L  76       9.243  47.533  51.462  1.00 28.05           C
ATOM    615  C   SER L  76       8.580  46.247  50.996  1.00 29.07           C
ATOM    616  O   SER L  76       8.286  45.370  51.799  1.00 33.00           O
ATOM    617  CB  SER L  76       8.174  48.590  51.746  1.00 24.33           C
ATOM    618  OG  SER L  76       7.408  48.865  50.587  1.00 28.42           O
ATOM    619  N   ARG L  77       8.348  46.137  49.695  1.00 32.79           N
ATOM    620  CA  ARG L  77       7.718  44.949  49.138  1.00 34.86           C
ATOM    621  C   ARG L  77       8.290  44.685  47.746  1.00 34.04           C
ATOM    622  O   ARG L  77       8.099  45.477  46.823  1.00 36.30           O
ATOM    623  CB  ARG L  77       6.199  45.153  49.077  1.00 39.00           C
ATOM    624  CG  ARG L  77       5.415  43.995  48.491  1.00 48.60           C
ATOM    625  CD  ARG L  77       3.918  44.198  48.699  1.00 55.14           C
ATOM    626  NE  ARG L  77       3.451  45.475  48.164  1.00 59.60           N
ATOM    627  CZ  ARG L  77       3.442  45.789  46.871  1.00 63.57           C
ATOM    628  NH1 ARG L  77       3.875  44.919  45.968  1.00 65.41           N
ATOM    629  NH2 ARG L  77       3.000  46.977  46.480  1.00 64.21           N
ATOM    630  N   VAL L  78       8.998  43.569  47.610  1.00 31.01           N
ATOM    631  CA  VAL L  78       9.617  43.191  46.345  1.00 30.39           C
ATOM    632  C   VAL L  78       8.637  42.665  45.300  1.00 27.49           C
ATOM    633  O   VAL L  78       7.765  41.852  45.604  1.00 27.85           O
ATOM    634  CB  VAL L  78      10.713  42.116  46.571  1.00 30.51           C
ATOM    635  CG1 VAL L  78      11.194  41.560  45.234  1.00 31.54           C
ATOM    636  CG2 VAL L  78      11.881  42.721  47.338  1.00 28.69           C
ATOM    637  N   GLU L  79       8.795  43.141  44.069  1.00 26.98           N
ATOM    638  CA  GLU L  79       7.972  42.708  42.944  1.00 29.28           C
ATOM    639  C   GLU L  79       8.919  42.095  41.908  1.00 29.52           C
ATOM    640  O   GLU L  79      10.124  42.349  41.943  1.00 29.52           O
ATOM    641  CB  GLU L  79       7.204  43.890  42.341  1.00 30.19           C
ATOM    642  CG  GLU L  79       6.373  44.662  43.357  1.00 38.46           C
ATOM    643  CD  GLU L  79       5.200  45.400  42.730  1.00 45.24           C
ATOM    644  OE1 GLU L  79       5.392  46.064  41.688  1.00 47.35           O
ATOM    645  OE2 GLU L  79       4.083  45.324  43.291  1.00 49.11           O
ATOM    646  N   ALA L  80       8.379  41.288  40.997  1.00 29.76           N
ATOM    647  CA  ALA L  80       9.183  40.616  39.974  1.00 29.91           C
ATOM    648  C   ALA L  80      10.058  41.557  39.144  1.00 29.01           C
ATOM    649  O   ALA L  80      11.195  41.227  38.800  1.00 25.16           O
ATOM    650  CB  ALA L  80       8.271  39.808  39.056  1.00 32.00           C
ATOM    651  N   GLU L  81       9.527  42.730  38.831  1.00 30.57           N
ATOM    652  CA  GLU L  81      10.257  43.711  38.038  1.00 33.36           C
ATOM    653  C   GLU L  81      11.455  44.343  38.754  1.00 28.20           C
ATOM    654  O   GLU L  81      12.194  45.109  38.144  1.00 30.19           O
ATOM    655  CB  GLU L  81       9.308  44.824  37.574  1.00 39.51           C
ATOM    656  CG  GLU L  81       8.243  44.394  36.569  1.00 51.62           C
ATOM    657  CD  GLU L  81       7.271  43.368  37.132  1.00 58.32           C
ATOM    658  OE1 GLU L  81       6.734  43.598  38.239  1.00 60.07           O
ATOM    659  OE2 GLU L  81       7.037  42.335  36.461  1.00 60.57           O
ATOM    660  N   ASP L  82      11.654  44.029  40.032  1.00 24.54           N
ATOM    661  CA  ASP L  82      12.769  44.611  40.780  1.00 22.63           C
ATOM    662  C   ASP L  82      14.099  43.872  40.598  1.00 22.17           C
ATOM    663  O   ASP L  82      15.153  44.380  40.995  1.00 21.01           O
ATOM    664  CB  ASP L  82      12.457  44.667  42.287  1.00 25.45           C
ATOM    665  CG  ASP L  82      11.251  45.538  42.621  1.00 24.90           C
ATOM    666  OD1 ASP L  82      10.998  46.526  41.900  1.00 22.30           O
ATOM    667  OD2 ASP L  82      10.566  45.237  43.626  1.00 24.70           O
ATOM    668  N   LEU L  83      14.062  42.685  40.001  1.00 21.11           N
ATOM    669  CA  LEU L  83      15.283  41.906  39.827  1.00 21.79           C
ATOM    670  C   LEU L  83      16.324  42.582  38.943  1.00 18.59           C
ATOM    671  O   LEU L  83      15.998  43.271  37.980  1.00 15.11           O
ATOM    672  CB  LEU L  83      14.958  40.495  39.302  1.00 24.29           C
ATOM    673  CG  LEU L  83      14.406  40.231  37.898  1.00 27.27           C
ATOM    674  CD1 LEU L  83      15.532  40.265  36.884  1.00 28.06           C
ATOM    675  CD2 LEU L  83      13.744  38.855  37.872  1.00 25.40           C
ATOM    676  N   GLY L  84      17.590  42.379  39.294  1.00 19.70           N
ATOM    677  CA  GLY L  84      18.675  42.971  38.536  1.00 17.27           C
ATOM    678  C   GLY L  84      19.812  43.315  39.468  1.00 17.16           C
ATOM    679  O   GLY L  84      19.906  42.760  40.562  1.00 16.72           O
ATOM    680  N   VAL L  85      20.666  44.244  39.050  1.00 16.05           N
ATOM    681  CA  VAL L  85      21.805  44.638  39.867  1.00 16.03           C
ATOM    682  C   VAL L  85      21.679  46.078  40.338  1.00 15.07           C
ATOM    683  O   VAL L  85      21.515  46.992  39.532  1.00 17.13           O
ATOM    684  CB  VAL L  85      23.136  44.466  39.085  1.00 15.91           C
ATOM    685  CG1 VAL L  85      24.319  44.889  39.951  1.00 16.56           C
ATOM    686  CG2 VAL L  85      23.296  43.020  38.662  1.00 14.84           C
ATOM    687  N   TYR L  86      21.739  46.269  41.653  1.00 15.75           N
ATOM    688  CA  TYR L  86      21.645  47.598  42.236  1.00 16.77           C
ATOM    689  C   TYR L  86      23.036  48.139  42.525  1.00 18.90           C
ATOM    690  O   TYR L  86      23.884  47.432  43.068  1.00 23.45           O
ATOM    691  CB  TYR L  86      20.844  47.566  43.537  1.00 15.76           C
ATOM    692  CG  TYR L  86      19.387  47.248  43.338  1.00 17.49           C
ATOM    693  CD1 TYR L  86      18.963  45.943  43.107  1.00 15.27           C
ATOM    694  CD2 TYR L  86      18.432  48.264  43.324  1.00 16.16           C
ATOM    695  CE1 TYR L  86      17.623  45.658  42.863  1.00 16.14           C
ATOM    696  CE2 TYR L  86      17.096  47.988  43.075  1.00 15.26           C
ATOM    697  CZ  TYR L  86      16.700  46.684  42.843  1.00 13.24           C
ATOM    698  OH  TYR L  86      15.383  46.412  42.560  1.00 17.64           O
ATOM    699  N   TYR L  87      23.274  49.388  42.149  1.00 18.08           N
ATOM    700  CA  TYR L  87      24.563  50.002  42.402  1.00 14.95           C
ATOM    701  C   TYR L  87      24.429  51.265  43.216  1.00 17.80           C
ATOM    702  O   TYR L  87      23.463  52.023  43.105  1.00 16.92           O
ATOM    703  CB  TYR L  87      25.296  50.383  41.115  1.00 15.51           C
ATOM    704  CG  TYR L  87      25.619  49.249  40.175  1.00 15.88           C
ATOM    705  CD1 TYR L  87      24.736  48.892  39.160  1.00 12.65           C
ATOM    706  CD2 TYR L  87      26.842  48.578  40.254  1.00 13.98           C
ATOM    707  CE1 TYR L  87      25.059  47.906  38.238  1.00 13.18           C
ATOM    708  CE2 TYR L  87      27.177  47.584  39.332  1.00 13.43           C
ATOM    709  CZ  TYR L  87      26.280  47.259  38.328  1.00 14.55           C
ATOM    710  OH  TYR L  87      26.602  46.297  37.401  1.00 20.34           O
ATOM    711  N   CYS L  88      25.454  51.483  44.015  1.00 15.76           N
ATOM    712  CA  CYS L  88      25.584  52.638  44.872  1.00 22.32           C
ATOM    713  C   CYS L  88      26.582  53.535  44.130  1.00 17.35           C
ATOM    714  O   CYS L  88      27.524  53.018  43.537  1.00 17.46           O
ATOM    715  CB  CYS L  88      26.183  52.156  46.184  1.00 25.30           C
ATOM    716  SG  CYS L  88      26.437  53.444  47.393  1.00 48.74           S
ATOM    717  N   VAL L  89      26.394  54.853  44.138  1.00 16.22           N
ATOM    718  CA  VAL L  89      27.350  55.725  43.448  1.00 16.22           C
ATOM    719  C   VAL L  89      27.462  57.124  44.058  1.00 19.21           C
ATOM    720  O   VAL L  89      26.449  57.779  44.332  1.00 18.94           O
ATOM    721  CB  VAL L  89      27.021  55.828  41.927  1.00 17.57           C
ATOM    722  CG1 VAL L  89      25.610  56.331  41.720  1.00 16.58           C
ATOM    723  CG2 VAL L  89      28.019  56.740  41.231  1.00 19.58           C
ATOM    724  N   GLN L  90      28.698  57.578  44.277  1.00 15.38           N
ATOM    725  CA  GLN L  90      28.915  58.895  44.865  1.00 14.86           C
ATOM    726  C   GLN L  90      29.462  59.919  43.881  1.00 15.42           C
ATOM    727  O   GLN L  90      30.271  59.601  43.010  1.00 16.84           O
ATOM    728  CB  GLN L  90      29.837  58.793  46.093  1.00 12.57           C
ATOM    729  CG  GLN L  90      31.309  58.425  45.840  1.00 17.62           C
ATOM    730  CD  GLN L  90      32.152  59.594  45.342  1.00 18.58           C
ATOM    731  OE1 GLN L  90      31.914  60.749  45.701  1.00 18.92           O
ATOM    732  NE2 GLN L  90      33.156  59.293  44.527  1.00 19.78           N
ATOM    733  N   GLY L  91      28.996  61.153  44.024  1.00 14.46           N
ATOM    734  CA  GLY L  91      29.449  62.222  43.160  1.00 17.96           C
ATOM    735  C   GLY L  91      29.989  63.402  43.947  1.00 19.37           C
ATOM    736  O   GLY L  91      30.073  64.511  43.426  1.00 25.05           O
ATOM    737  N   THR L  92      30.355  63.169  45.203  1.00 17.41           N
ATOM    738  CA  THR L  92      30.892  64.228  46.054  1.00 18.38           C
ATOM    739  C   THR L  92      32.394  64.431  45.825  1.00 19.60           C
ATOM    740  O   THR L  92      32.877  65.560  45.798  1.00 20.34           O
ATOM    741  CB  THR L  92      30.669  63.904  47.546  1.00 15.49           C
ATOM    742  OG1 THR L  92      29.264  63.884  47.825  1.00 21.26           O
ATOM    743  CG2 THR L  92      31.344  64.948  48.436  1.00 21.66           C
ATOM    744  N   HIS L  93      33.119  63.330  45.659  1.00 19.71           N
ATOM    745  CA  HIS L  93      34.563  63.376  45.457  1.00 21.93           C
ATOM    746  C   HIS L  93      34.958  62.991  44.041  1.00 21.31           C
ATOM    747  O   HIS L  93      34.300  62.175  43.399  1.00 24.51           O
ATOM    748  CB  HIS L  93      35.253  62.431  46.439  1.00 22.05           C
ATOM    749  CG  HIS L  93      34.912  62.697  47.869  1.00 24.92           C
ATOM    750  ND1 HIS L  93      35.506  63.702  48.602  1.00 28.88           N
ATOM    751  CD2 HIS L  93      34.017  62.105  48.696  1.00 23.28           C
ATOM    752  CE1 HIS L  93      34.993  63.716  49.820  1.00 28.99           C
ATOM    753  NE2 HIS L  93      34.086  62.757  49.902  1.00 25.25           N
ATOM    754  N   PHE L  94      36.048  63.575  43.567  1.00 19.99           N
ATOM    755  CA  PHE L  94      36.545  63.301  42.229  1.00 22.72           C
ATOM    756  C   PHE L  94      37.661  62.264  42.320  1.00 21.64           C
ATOM    757  O   PHE L  94      38.567  62.395  43.142  1.00 28.16           O
ATOM    758  CB  PHE L  94      37.064  64.603  41.613  1.00 25.40           C
ATOM    759  CG  PHE L  94      37.487  64.474  40.185  1.00 28.81           C
ATOM    760  CD1 PHE L  94      38.716  63.917  39.856  1.00 30.47           C
ATOM    761  CD2 PHE L  94      36.645  64.897  39.161  1.00 30.95           C
ATOM    762  CE1 PHE L  94      39.104  63.782  38.526  1.00 27.48           C
ATOM    763  CE2 PHE L  94      37.024  64.765  37.830  1.00 29.08           C
ATOM    764  CZ  PHE L  94      38.257  64.205  37.516  1.00 26.89           C
ATOM    765  N   PRO L  95      37.603  61.205  41.494  1.00 19.24           N
ATOM    766  CA  PRO L  95      36.575  60.915  40.491  1.00 20.09           C
ATOM    767  C   PRO L  95      35.377  60.152  41.051  1.00 18.33           C
ATOM    768  O   PRO L  95      35.457  59.516  42.103  1.00 17.07           O
ATOM    769  CB  PRO L  95      37.336  60.082  39.469  1.00 18.87           C
ATOM    770  CG  PRO L  95      38.210  59.249  40.351  1.00 15.80           C
ATOM    771  CD  PRO L  95      38.739  60.275  41.344  1.00 19.88           C
ATOM    772  N   ARG L  96      34.267  60.217  40.324  1.00 19.22           N
ATOM    773  CA  ARG L  96      33.046  59.525  40.703  1.00 16.81           C
ATOM    774  C   ARG L  96      33.356  58.033  40.751  1.00 16.75           C
ATOM    775  O   ARG L  96      34.053  57.520  39.883  1.00 14.32           O
ATOM    776  CB  ARG L  96      31.955  59.809  39.663  1.00 20.25           C
ATOM    777  CG  ARG L  96      30.690  58.974  39.805  1.00 21.91           C
ATOM    778  CD  ARG L  96      29.706  59.374  38.727  1.00 18.74           C
ATOM    779  NE  ARG L  96      29.491  60.810  38.799  1.00 29.18           N
ATOM    780  CZ  ARG L  96      28.454  61.386  39.395  1.00 24.53           C
ATOM    781  NH1 ARG L  96      27.511  60.651  39.966  1.00 25.00           N
ATOM    782  NH2 ARG L  96      28.381  62.705  39.438  1.00 34.42           N
ATOM    783  N   THR L  97      32.847  57.348  41.771  1.00 13.95           N
ATOM    784  CA  THR L  97      33.081  55.920  41.932  1.00 16.33           C
ATOM    785  C   THR L  97      31.780  55.191  42.257  1.00 16.80           C
ATOM    786  O   THR L  97      30.871  55.768  42.857  1.00 14.18           O
ATOM    787  CB  THR L  97      34.096  55.649  43.057  1.00 13.03           C
ATOM    788  OG1 THR L  97      33.696  56.359  44.235  1.00 17.02           O
ATOM    789  CG2 THR L  97      35.488  56.111  42.644  1.00 15.08           C
ATOM    790  N   PHE L  98      31.704  53.925  41.853  1.00 16.56           N
ATOM    791  CA  PHE L  98      30.519  53.099  42.075  1.00 16.71           C
ATOM    792  C   PHE L  98      30.853  51.937  42.994  1.00 17.49           C
ATOM    793  O   PHE L  98      32.000  51.497  43.047  1.00 16.40           O
ATOM    794  CB  PHE L  98      30.012  52.478  40.766  1.00 15.96           C
ATOM    795  CG  PHE L  98      29.822  53.452  39.639  1.00 16.27           C
ATOM    796  CD1 PHE L  98      30.908  54.127  39.090  1.00 20.04           C
ATOM    797  CD2 PHE L  98      28.559  53.652  39.088  1.00 11.91           C
ATOM    798  CE1 PHE L  98      30.743  54.985  38.004  1.00 15.96           C
ATOM    799  CE2 PHE L  98      28.383  54.506  38.007  1.00 17.45           C
ATOM    800  CZ  PHE L  98      29.482  55.174  37.464  1.00 15.89           C
ATOM    801  N   GLY L  99      29.832  51.431  43.684  1.00 15.92           N
ATOM    802  CA  GLY L  99      30.001  50.288  44.555  1.00 15.99           C
ATOM    803  C   GLY L  99      30.064  49.059  43.663  1.00 19.28           C
ATOM    804  O   GLY L  99      29.798  49.158  42.464  1.00 16.40           O
ATOM    805  N   GLY L 100      30.390  47.905  44.241  1.00 15.57           N
ATOM    806  CA  GLY L 100      30.511  46.684  43.461  1.00 17.20           C
ATOM    807  C   GLY L 100      29.233  46.084  42.908  1.00 18.45           C
ATOM    808  O   GLY L 100      29.282  45.250  41.999  1.00 19.07           O
ATOM    809  N   GLY L 101      28.092  46.495  43.450  1.00 16.21           N
ATOM    810  CA  GLY L 101      26.824  45.971  42.977  1.00 12.89           C
ATOM    811  C   GLY L 101      26.230  44.882  43.855  1.00 16.63           C
ATOM    812  O   GLY L 101      26.944  44.117  44.507  1.00 19.11           O
ATOM    813  N   THR L 102      24.904  44.820  43.874  1.00 15.99           N
ATOM    814  CA  THR L 102      24.177  43.823  44.645  1.00 15.79           C
ATOM    815  C   THR L 102      23.144  43.227  43.705  1.00 17.18           C
ATOM    816  O   THR L 102      22.314  43.948  43.154  1.00 18.05           O
ATOM    817  CB  THR L 102      23.468  44.461  45.861  1.00 18.01           C
ATOM    818  OG1 THR L 102      24.454  44.945  46.779  1.00 18.32           O
ATOM    819  CG2 THR L 102      22.580  43.438  46.576  1.00 19.32           C
ATOM    820  N   LYS L 103      23.204  41.914  43.509  1.00 19.74           N
ATOM    821  CA  LYS L 103      22.272  41.240  42.614  1.00 18.89           C
ATOM    822  C   LYS L 103      21.023  40.780  43.349  1.00 19.24           C
ATOM    823  O   LYS L 103      21.101  40.037  44.321  1.00 16.37           O
ATOM    824  CB  LYS L 103      22.945  40.031  41.967  1.00 24.56           C
ATOM    825  CG  LYS L 103      22.185  39.459  40.781  1.00 27.08           C
ATOM    826  CD  LYS L 103      22.908  38.255  40.207  1.00 35.16           C
ATOM    827  CE  LYS L 103      22.543  38.030  38.747  1.00 40.81           C
ATOM    828  NZ  LYS L 103      21.070  37.962  38.526  1.00 46.41           N
ATOM    829  N   LEU L 104      19.864  41.228  42.890  1.00 19.61           N
ATOM    830  CA  LEU L 104      18.625  40.814  43.527  1.00 18.56           C
ATOM    831  C   LEU L 104      17.980  39.719  42.688  1.00 20.05           C
ATOM    832  O   LEU L 104      17.681  39.921  41.511  1.00 18.81           O
ATOM    833  CB  LEU L 104      17.668  42.005  43.674  1.00 19.25           C
ATOM    834  CG  LEU L 104      16.253  41.718  44.196  1.00 20.38           C
ATOM    835  CD1 LEU L 104      16.323  40.945  45.490  1.00 26.95           C
ATOM    836  CD2 LEU L 104      15.517  43.030  44.410  1.00 25.45           C
ATOM    837  N   GLU L 105      17.800  38.550  43.297  1.00 20.23           N
ATOM    838  CA  GLU L 105      17.169  37.422  42.631  1.00 21.84           C
ATOM    839  C   GLU L 105      15.826  37.189  43.309  1.00 19.89           C
ATOM    840  O   GLU L 105      15.694  37.363  44.521  1.00 18.85           O
ATOM    841  CB  GLU L 105      18.015  36.145  42.764  1.00 22.56           C
ATOM    842  CG  GLU L 105      17.363  34.928  42.089  1.00 28.91           C
ATOM    843  CD  GLU L 105      17.794  33.585  42.675  1.00 28.52           C
ATOM    844  OE1 GLU L 105      17.478  33.304  43.852  1.00 31.75           O
ATOM    845  OE2 GLU L 105      18.444  32.802  41.956  1.00 30.07           O
ATOM    846  N   ILE L 106      14.831  36.800  42.528  1.00 20.63           N
ATOM    847  CA  ILE L 106      13.513  36.529  43.075  1.00 20.50           C
ATOM    848  C   ILE L 106      13.496  35.082  43.545  1.00 23.46           C
ATOM    849  O   ILE L 106      13.718  34.174  42.744  1.00 25.56           O
ATOM    850  CB  ILE L 106      12.410  36.712  42.007  1.00 23.28           C
ATOM    851  CG1 ILE L 106      12.438  38.142  41.462  1.00 20.53           C
ATOM    852  CG2 ILE L 106      11.042  36.390  42.606  1.00 18.46           C
ATOM    853  CD1 ILE L 106      12.279  39.215  42.529  1.00 25.40           C
ATOM    854  N   LYS L 107      13.269  34.866  44.838  1.00 23.70           N
ATOM    855  CA  LYS L 107      13.201  33.506  45.362  1.00 26.21           C
ATOM    856  C   LYS L 107      11.813  33.020  45.004  1.00 27.53           C
ATOM    857  O   LYS L 107      10.807  33.546  45.471  1.00 31.16           O
ATOM    858  CB  LYS L 107      13.400  33.473  46.875  1.00 30.61           C
ATOM    859  CG  LYS L 107      13.229  32.087  47.471  1.00 35.39           C
ATOM    860  CD  LYS L 107      13.763  32.011  48.893  1.00 40.95           C
ATOM    861  CE  LYS L 107      15.283  32.084  48.904  1.00 46.41           C
ATOM    862  NZ  LYS L 107      15.853  31.866  50.262  1.00 49.96           N
ATOM    863  N   ARG L 108      11.773  32.004  44.161  1.00 26.17           N
ATOM    864  CA  ARG L 108      10.525  31.465  43.666  1.00 23.61           C
ATOM    865  C   ARG L 108      10.414  29.974  44.016  1.00 20.29           C
ATOM    866  O   ARG L 108      11.364  29.388  44.532  1.00 16.30           O
ATOM    867  CB  ARG L 108      10.521  31.725  42.154  1.00 23.68           C
ATOM    868  CG  ARG L 108       9.452  31.075  41.365  1.00 27.29           C
ATOM    869  CD  ARG L 108      10.072  30.219  40.280  1.00 19.40           C
ATOM    870  NE  ARG L 108       9.230  29.049  40.112  1.00 24.12           N
ATOM    871  CZ  ARG L 108       8.202  28.987  39.283  1.00 23.93           C
ATOM    872  NH1 ARG L 108       7.901  30.034  38.523  1.00 20.08           N
ATOM    873  NH2 ARG L 108       7.454  27.894  39.251  1.00 22.29           N
ATOM    874  N   ALA L 109       9.254  29.374  43.757  1.00 18.63           N
ATOM    875  CA  ALA L 109       9.032  27.953  44.038  1.00 18.59           C
ATOM    876  C   ALA L 109       9.801  27.074  43.045  1.00 17.80           C
ATOM    877  O   ALA L 109       9.987  27.460  41.896  1.00 16.24           O
ATOM    878  CB  ALA L 109       7.537  27.635  43.957  1.00 18.15           C
ATOM    879  N   ASP L 110      10.241  25.897  43.484  1.00 17.16           N
ATOM    880  CA  ASP L 110      10.981  24.988  42.608  1.00 19.95           C
ATOM    881  C   ASP L 110      10.211  24.670  41.327  1.00 19.90           C
ATOM    882  O   ASP L 110       8.997  24.492  41.349  1.00 19.52           O
ATOM    883  CB  ASP L 110      11.296  23.672  43.325  1.00 22.52           C
ATOM    884  CG  ASP L 110      12.266  23.846  44.473  1.00 24.08           C
ATOM    885  OD1 ASP L 110      12.881  24.925  44.577  1.00 25.66           O
ATOM    886  OD2 ASP L 110      12.422  22.891  45.263  1.00 26.01           O
ATOM    887  N   ALA L 111      10.936  24.580  40.216  1.00 18.87           N
ATOM    888  CA  ALA L 111      10.337  24.291  38.923  1.00 14.27           C
ATOM    889  C   ALA L 111      11.255  23.371  38.123  1.00 15.19           C
ATOM    890  O   ALA L 111      12.435  23.665  37.929  1.00 16.97           O
ATOM    891  CB  ALA L 111      10.099  25.592  38.164  1.00 12.29           C
ATOM    892  N   ALA L 112      10.700  22.263  37.651  1.00 13.07           N
ATOM    893  CA  ALA L 112      11.461  21.286  36.893  1.00 15.40           C
ATOM    894  C   ALA L 112      11.736  21.743  35.470  1.00 17.41           C
ATOM    895  O   ALA L 112      10.896  22.374  34.830  1.00 18.71           O
ATOM    896  CB  ALA L 112      10.722  19.944  36.879  1.00 16.36           C
ATOM    897  N   PRO L 113      12.926  21.421  34.950  1.00 16.05           N
ATOM    898  CA  PRO L 113      13.268  21.823  33.588  1.00 17.58           C
ATOM    899  C   PRO L 113      12.608  20.946  32.532  1.00 18.90           C
ATOM    900  O   PRO L 113      12.313  19.774  32.775  1.00 19.53           O
ATOM    901  CB  PRO L 113      14.786  21.684  33.566  1.00 16.01           C
ATOM    902  CG  PRO L 113      15.002  20.485  34.445  1.00 18.66           C
ATOM    903  CD  PRO L 113      14.067  20.759  35.610  1.00 14.79           C
ATOM    904  N   THR L 114      12.370  21.536  31.367  1.00 18.84           N
ATOM    905  CA  THR L 114      11.809  20.822  30.226  1.00 20.37           C
ATOM    906  C   THR L 114      13.042  20.638  29.348  1.00 20.61           C
ATOM    907  O   THR L 114      13.622  21.618  28.882  1.00 17.94           O
ATOM    908  CB  THR L 114      10.776  21.679  29.462  1.00 25.95           C
ATOM    909  OG1 THR L 114       9.708  22.047  30.345  1.00 34.32           O
ATOM    910  CG2 THR L 114      10.208  20.901  28.290  1.00 23.64           C
ATOM    911  N   VAL L 115      13.453  19.391  29.138  1.00 19.54           N
ATOM    912  CA  VAL L 115      14.643  19.112  28.348  1.00 17.09           C
ATOM    913  C   VAL L 115      14.339  18.642  26.933  1.00 17.02           C
ATOM    914  O   VAL L 115      13.458  17.814  26.714  1.00 16.34           O
ATOM    915  CB  VAL L 115      15.528  18.061  29.061  1.00 16.92           C
ATOM    916  CG1 VAL L 115      16.853  17.900  28.329  1.00 16.49           C
ATOM    917  CG2 VAL L 115      15.772  18.489  30.504  1.00 16.78           C
ATOM    918  N   SER L 116      15.080  19.193  25.977  1.00 19.59           N
ATOM    919  CA  SER L 116      14.926  18.855  24.565  1.00 17.45           C
ATOM    920  C   SER L 116      16.322  18.638  23.990  1.00 19.10           C
ATOM    921  O   SER L 116      17.246  19.388  24.307  1.00 18.10           O
ATOM    922  CB  SER L 116      14.254  20.005  23.813  1.00 18.92           C
ATOM    923  OG  SER L 116      13.022  20.374  24.404  1.00 25.77           O
ATOM    924  N   ILE L 117      16.479  17.618  23.150  1.00 18.19           N
ATOM    925  CA  ILE L 117      17.775  17.343  22.541  1.00 17.31           C
ATOM    926  C   ILE L 117      17.668  17.422  21.016  1.00 15.86           C
ATOM    927  O   ILE L 117      16.651  17.045  20.429  1.00 16.41           O
ATOM    928  CB  ILE L 117      18.320  15.954  22.989  1.00 16.44           C
ATOM    929  CG1 ILE L 117      19.797  15.829  22.610  1.00 15.90           C
ATOM    930  CG2 ILE L 117      17.499  14.831  22.367  1.00 14.41           C
ATOM    931  CD1 ILE L 117      20.499  14.681  23.294  1.00 21.22           C
ATOM    932  N   PHE L 118      18.713  17.940  20.381  1.00 14.79           N
ATOM    933  CA  PHE L 118      18.728  18.089  18.932  1.00 14.46           C
ATOM    934  C   PHE L 118      19.985  17.533  18.281  1.00 18.29           C
ATOM    935  O   PHE L 118      21.104  17.846  18.696  1.00 17.68           O
ATOM    936  CB  PHE L 118      18.606  19.563  18.536  1.00 14.37           C
ATOM    937  CG  PHE L 118      17.347  20.224  19.017  1.00 17.41           C
ATOM    938  CD1 PHE L 118      17.265  20.745  20.304  1.00 15.72           C
ATOM    939  CD2 PHE L 118      16.226  20.290  18.193  1.00 20.13           C
ATOM    940  CE1 PHE L 118      16.086  21.321  20.769  1.00 17.58           C
ATOM    941  CE2 PHE L 118      15.034  20.865  18.650  1.00 21.67           C
ATOM    942  CZ  PHE L 118      14.965  21.381  19.942  1.00 18.40           C
ATOM    943  N   PRO L 119      19.815  16.700  17.243  1.00 19.81           N
ATOM    944  CA  PRO L 119      20.959  16.117  16.536  1.00 18.67           C
ATOM    945  C   PRO L 119      21.472  17.191  15.585  1.00 19.51           C
ATOM    946  O   PRO L 119      20.796  18.189  15.356  1.00 19.80           O
ATOM    947  CB  PRO L 119      20.343  14.946  15.761  1.00 18.85           C
ATOM    948  CG  PRO L 119      19.022  14.694  16.451  1.00 24.77           C
ATOM    949  CD  PRO L 119      18.558  16.080  16.795  1.00 19.58           C
ATOM    950  N   PRO L 120      22.676  17.008  15.031  1.00 20.97           N
ATOM    951  CA  PRO L 120      23.231  17.992  14.098  1.00 21.56           C
ATOM    952  C   PRO L 120      22.383  18.103  12.829  1.00 25.06           C
ATOM    953  O   PRO L 120      21.851  17.104  12.339  1.00 22.77           O
ATOM    954  CB  PRO L 120      24.616  17.431  13.788  1.00 19.92           C
ATOM    955  CG  PRO L 120      24.977  16.703  15.047  1.00 24.16           C
ATOM    956  CD  PRO L 120      23.685  16.000  15.397  1.00 20.72           C
ATOM    957  N   SER L 121      22.266  19.316  12.294  1.00 26.39           N
ATOM    958  CA  SER L 121      21.509  19.537  11.062  1.00 29.46           C
ATOM    959  C   SER L 121      22.343  19.026   9.886  1.00 30.81           C
ATOM    960  O   SER L 121      23.570  18.980   9.972  1.00 31.79           O
ATOM    961  CB  SER L 121      21.247  21.026  10.870  1.00 29.86           C
ATOM    962  OG  SER L 121      22.473  21.726  10.750  1.00 27.09           O
ATOM    963  N   SER L 122      21.687  18.645   8.794  1.00 32.31           N
ATOM    964  CA  SER L 122      22.406  18.156   7.618  1.00 34.62           C
ATOM    965  C   SER L 122      23.339  19.237   7.090  1.00 32.62           C
ATOM    966  O   SER L 122      24.452  18.953   6.643  1.00 32.68           O
ATOM    967  CB  SER L 122      21.429  17.755   6.511  1.00 38.34           C
ATOM    968  OG  SER L 122      20.673  16.619   6.886  1.00 47.42           O
ATOM    969  N   GLU L 123      22.876  20.481   7.142  1.00 28.22           N
ATOM    970  CA  GLU L 123      23.671  21.606   6.672  1.00 30.40           C
ATOM    971  C   GLU L 123      25.028  21.679   7.367  1.00 30.09           C
ATOM    972  O   GLU L 123      26.046  21.940   6.719  1.00 31.18           O
ATOM    973  CB  GLU L 123      22.902  22.910   6.882  1.00 33.77           C
ATOM    974  CG  GLU L 123      21.632  22.995   6.056  1.00 40.35           C
ATOM    975  CD  GLU L 123      20.754  24.170   6.439  1.00 45.31           C
ATOM    976  OE1 GLU L 123      21.247  25.317   6.400  1.00 47.85           O
ATOM    977  OE2 GLU L 123      19.569  23.943   6.774  1.00 46.12           O
ATOM    978  N   GLN L 124      25.053  21.443   8.679  1.00 25.71           N
ATOM    979  CA  GLN L 124      26.314  21.501   9.413  1.00 25.58           C
ATOM    980  C   GLN L 124      27.228  20.336   9.065  1.00 23.66           C
ATOM    981  O   GLN L 124      28.422  20.519   8.858  1.00 22.13           O
ATOM    982  CB  GLN L 124      26.088  21.513  10.933  1.00 24.39           C
ATOM    983  CG  GLN L 124      27.388  21.767  11.705  1.00 21.71           C
ATOM    984  CD  GLN L 124      27.238  21.728  13.226  1.00 20.46           C
ATOM    985  OE1 GLN L 124      28.169  22.077  13.953  1.00 22.15           O
ATOM    986  NE2 GLN L 124      26.080  21.298  13.707  1.00 14.28           N
ATOM    987  N   LEU L 125      26.663  19.134   9.011  1.00 27.37           N
ATOM    988  CA  LEU L 125      27.442  17.938   8.691  1.00 32.30           C
ATOM    989  C   LEU L 125      28.230  18.126   7.398  1.00 34.69           C
ATOM    990  O   LEU L 125      29.317  17.581   7.237  1.00 35.46           O
ATOM    991  CB  LEU L 125      26.514  16.723   8.582  1.00 29.48           C
ATOM    992  CG  LEU L 125      25.886  16.268   9.906  1.00 26.81           C
ATOM    993  CD1 LEU L 125      24.844  15.191   9.657  1.00 27.37           C
ATOM    994  CD2 LEU L 125      26.979  15.760  10.824  1.00 26.09           C
ATOM    995  N   THR L 126      27.679  18.916   6.485  1.00 40.52           N
ATOM    996  CA  THR L 126      28.339  19.182   5.214  1.00 43.58           C
ATOM    997  C   THR L 126      29.616  19.999   5.407  1.00 44.41           C
ATOM    998  O   THR L 126      30.556  19.885   4.619  1.00 48.12           O
ATOM    999  CB  THR L 126      27.390  19.932   4.256  1.00 44.51           C
ATOM   1000  OG1 THR L 126      26.300  19.071   3.898  1.00 41.35           O
ATOM   1001  CG2 THR L 126      28.128  20.372   3.000  1.00 46.76           C
ATOM   1002  N   SER L 127      29.656  20.810   6.460  1.00 42.70           N
ATOM   1003  CA  SER L 127      30.824  21.643   6.739  1.00 42.23           C
ATOM   1004  C   SER L 127      31.948  20.858   7.409  1.00 40.37           C
ATOM   1005  O   SER L 127      33.051  21.376   7.591  1.00 41.28           O
ATOM   1006  CB  SER L 127      30.438  22.826   7.637  1.00 45.53           C
ATOM   1007  OG  SER L 127      30.295  22.427   8.994  1.00 45.92           O
ATOM   1008  N   GLY L 128      31.664  19.615   7.784  1.00 38.21           N
ATOM   1009  CA  GLY L 128      32.672  18.796   8.434  1.00 35.37           C
ATOM   1010  C   GLY L 128      32.601  18.844   9.950  1.00 35.07           C
ATOM   1011  O   GLY L 128      33.487  18.332  10.641  1.00 32.83           O
ATOM   1012  N   GLY L 129      31.543  19.457  10.473  1.00 33.96           N
ATOM   1013  CA  GLY L 129      31.381  19.554  11.912  1.00 30.00           C
ATOM   1014  C   GLY L 129      30.061  18.966  12.375  1.00 27.95           C
ATOM   1015  O   GLY L 129      29.194  18.659  11.559  1.00 26.40           O
ATOM   1016  N   ALA L 130      29.906  18.808  13.686  1.00 23.55           N
ATOM   1017  CA  ALA L 130      28.679  18.251  14.238  1.00 24.62           C
ATOM   1018  C   ALA L 130      28.435  18.758  15.656  1.00 23.91           C
ATOM   1019  O   ALA L 130      29.219  18.491  16.563  1.00 24.92           O
ATOM   1020  CB  ALA L 130      28.750  16.728  14.236  1.00 19.30           C
ATOM   1021  N   SER L 131      27.343  19.491  15.838  1.00 23.29           N
ATOM   1022  CA  SER L 131      26.995  20.027  17.145  1.00 19.61           C
ATOM   1023  C   SER L 131      25.692  19.428  17.647  1.00 20.26           C
ATOM   1024  O   SER L 131      24.680  19.489  16.961  1.00 24.19           O
ATOM   1025  CB  SER L 131      26.843  21.550  17.076  1.00 16.15           C
ATOM   1026  OG  SER L 131      28.059  22.175  16.714  1.00 19.83           O
ATOM   1027  N   VAL L 132      25.721  18.833  18.836  1.00 19.51           N
ATOM   1028  CA  VAL L 132      24.513  18.276  19.426  1.00 18.55           C
ATOM   1029  C   VAL L 132      24.078  19.301  20.479  1.00 20.78           C
ATOM   1030  O   VAL L 132      24.885  19.747  21.296  1.00 17.15           O
ATOM   1031  CB  VAL L 132      24.767  16.909  20.092  1.00 19.20           C
ATOM   1032  CG1 VAL L 132      23.445  16.290  20.510  1.00 13.22           C
ATOM   1033  CG2 VAL L 132      25.498  15.984  19.127  1.00 23.47           C
ATOM   1034  N   VAL L 133      22.802  19.675  20.452  1.00 18.23           N
ATOM   1035  CA  VAL L 133      22.291  20.682  21.365  1.00 15.80           C
ATOM   1036  C   VAL L 133      21.236  20.163  22.325  1.00 15.97           C
ATOM   1037  O   VAL L 133      20.404  19.325  21.983  1.00 17.77           O
ATOM   1038  CB  VAL L 133      21.700  21.884  20.571  1.00 13.36           C
ATOM   1039  CG1 VAL L 133      21.195  22.964  21.526  1.00 13.68           C
ATOM   1040  CG2 VAL L 133      22.744  22.439  19.643  1.00  9.78           C
ATOM   1041  N   CYS L 134      21.282  20.682  23.540  1.00 17.40           N
ATOM   1042  CA  CYS L 134      20.332  20.302  24.562  1.00 16.32           C
ATOM   1043  C   CYS L 134      19.844  21.560  25.263  1.00 15.78           C
ATOM   1044  O   CYS L 134      20.654  22.375  25.699  1.00 15.24           O
ATOM   1045  CB  CYS L 134      21.010  19.379  25.562  1.00 20.58           C
ATOM   1046  SG  CYS L 134      19.872  18.600  26.734  1.00 31.17           S
ATOM   1047  N   PHE L 135      18.525  21.727  25.341  1.00 18.11           N
ATOM   1048  CA  PHE L 135      17.926  22.878  26.015  1.00 16.09           C
ATOM   1049  C   PHE L 135      17.230  22.449  27.301  1.00 18.18           C
ATOM   1050  O   PHE L 135      16.471  21.479  27.310  1.00 20.13           O
ATOM   1051  CB  PHE L 135      16.879  23.566  25.136  1.00 18.31           C
ATOM   1052  CG  PHE L 135      17.443  24.276  23.938  1.00 20.82           C
ATOM   1053  CD1 PHE L 135      18.473  25.200  24.076  1.00 19.63           C
ATOM   1054  CD2 PHE L 135      16.908  24.055  22.676  1.00 21.88           C
ATOM   1055  CE1 PHE L 135      18.961  25.897  22.976  1.00 20.73           C
ATOM   1056  CE2 PHE L 135      17.390  24.749  21.566  1.00 25.03           C
ATOM   1057  CZ  PHE L 135      18.418  25.672  21.720  1.00 22.78           C
ATOM   1058  N   LEU L 136      17.488  23.180  28.380  1.00 13.63           N
ATOM   1059  CA  LEU L 136      16.869  22.921  29.671  1.00 17.06           C
ATOM   1060  C   LEU L 136      16.192  24.249  30.014  1.00 16.06           C
ATOM   1061  O   LEU L 136      16.841  25.185  30.489  1.00 14.67           O
ATOM   1062  CB  LEU L 136      17.928  22.562  30.719  1.00 18.25           C
ATOM   1063  CG  LEU L 136      18.829  21.364  30.413  1.00 21.45           C
ATOM   1064  CD1 LEU L 136      20.024  21.811  29.585  1.00 21.34           C
ATOM   1065  CD2 LEU L 136      19.308  20.749  31.718  1.00 24.55           C
ATOM   1066  N   ASN L 137      14.889  24.324  29.760  1.00 16.52           N
ATOM   1067  CA  ASN L 137      14.138  25.553  29.966  1.00 18.54           C
ATOM   1068  C   ASN L 137      13.248  25.659  31.192  1.00 19.47           C
ATOM   1069  O   ASN L 137      12.760  24.661  31.728  1.00 18.01           O
ATOM   1070  CB  ASN L 137      13.278  25.855  28.726  1.00 20.96           C
ATOM   1071  CG  ASN L 137      14.109  26.075  27.471  1.00 23.88           C
ATOM   1072  OD1 ASN L 137      15.219  26.610  27.526  1.00 26.18           O
ATOM   1073  ND2 ASN L 137      13.565  25.678  26.329  1.00 26.70           N
ATOM   1074  N   ASN L 138      13.053  26.909  31.608  1.00 17.59           N
ATOM   1075  CA  ASN L 138      12.206  27.292  32.729  1.00 18.38           C
ATOM   1076  C   ASN L 138      12.322  26.464  34.007  1.00 19.05           C
ATOM   1077  O   ASN L 138      11.358  25.820  34.424  1.00 15.36           O
ATOM   1078  CB  ASN L 138      10.741  27.324  32.267  1.00 18.43           C
ATOM   1079  CG  ASN L 138      10.548  28.145  30.997  1.00 22.22           C
ATOM   1080  OD1 ASN L 138      10.800  27.671  29.887  1.00 22.47           O
ATOM   1081  ND2 ASN L 138      10.111  29.387  31.158  1.00 22.19           N
ATOM   1082  N   PHE L 139      13.494  26.495  34.636  1.00 14.98           N
ATOM   1083  CA  PHE L 139      13.695  25.762  35.876  1.00 14.11           C
ATOM   1084  C   PHE L 139      14.145  26.674  37.021  1.00 15.67           C
ATOM   1085  O   PHE L 139      14.549  27.815  36.809  1.00 14.51           O
ATOM   1086  CB  PHE L 139      14.706  24.626  35.663  1.00 17.14           C
ATOM   1087  CG  PHE L 139      16.079  25.088  35.240  1.00 16.17           C
ATOM   1088  CD1 PHE L 139      17.030  25.449  36.189  1.00 13.43           C
ATOM   1089  CD2 PHE L 139      16.421  25.149  33.893  1.00 15.00           C
ATOM   1090  CE1 PHE L 139      18.305  25.865  35.808  1.00 13.20           C
ATOM   1091  CE2 PHE L 139      17.695  25.565  33.496  1.00 17.22           C
ATOM   1092  CZ  PHE L 139      18.640  25.923  34.454  1.00 15.06           C
ATOM   1093  N   TYR L 140      14.042  26.161  38.238  1.00 14.36           N
ATOM   1094  CA  TYR L 140      14.446  26.887  39.436  1.00 14.95           C
ATOM   1095  C   TYR L 140      14.601  25.843  40.534  1.00 15.08           C
ATOM   1096  O   TYR L 140      13.777  24.932  40.642  1.00 16.18           O
ATOM   1097  CB  TYR L 140      13.387  27.931  39.837  1.00 14.28           C
ATOM   1098  CG  TYR L 140      13.847  28.832  40.962  1.00 13.36           C
ATOM   1099  CD1 TYR L 140      13.875  28.376  42.284  1.00 17.13           C
ATOM   1100  CD2 TYR L 140      14.349  30.106  40.697  1.00 17.19           C
ATOM   1101  CE1 TYR L 140      14.402  29.164  43.315  1.00 14.54           C
ATOM   1102  CE2 TYR L 140      14.878  30.903  41.721  1.00 19.10           C
ATOM   1103  CZ  TYR L 140      14.903  30.424  43.024  1.00 20.15           C
ATOM   1104  OH  TYR L 140      15.441  31.200  44.030  1.00 20.14           O
ATOM   1105  N   PRO L 141      15.662  25.947  41.357  1.00 15.78           N
ATOM   1106  CA  PRO L 141      16.716  26.966  41.330  1.00 17.30           C
ATOM   1107  C   PRO L 141      17.672  26.880  40.140  1.00 15.63           C
ATOM   1108  O   PRO L 141      17.627  25.939  39.342  1.00 12.76           O
ATOM   1109  CB  PRO L 141      17.425  26.756  42.666  1.00 17.74           C
ATOM   1110  CG  PRO L 141      17.309  25.304  42.863  1.00 22.02           C
ATOM   1111  CD  PRO L 141      15.866  25.035  42.495  1.00 16.48           C
ATOM   1112  N   LYS L 142      18.545  27.875  40.044  1.00 18.47           N
ATOM   1113  CA  LYS L 142      19.514  27.972  38.957  1.00 18.85           C
ATOM   1114  C   LYS L 142      20.521  26.830  38.928  1.00 15.52           C
ATOM   1115  O   LYS L 142      21.028  26.479  37.867  1.00 16.21           O
ATOM   1116  CB  LYS L 142      20.256  29.308  39.064  1.00 25.85           C
ATOM   1117  CG  LYS L 142      21.265  29.570  37.959  1.00 32.81           C
ATOM   1118  CD  LYS L 142      21.999  30.881  38.212  1.00 38.93           C
ATOM   1119  CE  LYS L 142      23.022  31.171  37.126  1.00 42.09           C
ATOM   1120  NZ  LYS L 142      22.369  31.305  35.799  1.00 47.87           N
ATOM   1121  N   ASP L 143      20.808  26.251  40.089  1.00 15.98           N
ATOM   1122  CA  ASP L 143      21.778  25.162  40.183  1.00 19.76           C
ATOM   1123  C   ASP L 143      21.311  23.924  39.440  1.00 20.48           C
ATOM   1124  O   ASP L 143      20.237  23.380  39.717  1.00 18.29           O
ATOM   1125  CB  ASP L 143      22.039  24.801  41.645  1.00 22.61           C
ATOM   1126  CG  ASP L 143      22.544  25.974  42.447  1.00 26.06           C
ATOM   1127  OD1 ASP L 143      23.723  26.349  42.274  1.00 24.44           O
ATOM   1128  OD2 ASP L 143      21.753  26.529  43.242  1.00 29.19           O
ATOM   1129  N   ILE L 144      22.130  23.482  38.496  1.00 16.19           N
ATOM   1130  CA  ILE L 144      21.808  22.309  37.713  1.00 19.42           C
ATOM   1131  C   ILE L 144      23.099  21.716  37.150  1.00 21.24           C
ATOM   1132  O   ILE L 144      24.080  22.424  36.923  1.00 21.92           O
ATOM   1133  CB  ILE L 144      20.822  22.669  36.575  1.00 19.92           C
ATOM   1134  CG1 ILE L 144      20.176  21.401  36.018  1.00 20.37           C
ATOM   1135  CG2 ILE L 144      21.546  23.432  35.466  1.00 22.23           C
ATOM   1136  CD1 ILE L 144      19.037  21.680  35.049  1.00 20.41           C
ATOM   1137  N   ASN L 145      23.096  20.407  36.949  1.00 23.65           N
ATOM   1138  CA  ASN L 145      24.257  19.712  36.429  1.00 27.30           C
ATOM   1139  C   ASN L 145      23.853  18.938  35.180  1.00 26.78           C
ATOM   1140  O   ASN L 145      22.936  18.116  35.208  1.00 26.72           O
ATOM   1141  CB  ASN L 145      24.805  18.760  37.495  1.00 36.37           C
ATOM   1142  CG  ASN L 145      26.068  18.056  37.053  1.00 45.62           C
ATOM   1143  OD1 ASN L 145      27.116  18.682  36.883  1.00 51.88           O
ATOM   1144  ND2 ASN L 145      25.977  16.743  36.858  1.00 51.20           N
ATOM   1145  N   VAL L 146      24.537  19.222  34.080  1.00 23.67           N
ATOM   1146  CA  VAL L 146      24.263  18.567  32.816  1.00 24.32           C
ATOM   1147  C   VAL L 146      25.465  17.717  32.433  1.00 24.18           C
ATOM   1148  O   VAL L 146      26.602  18.167  32.529  1.00 26.85           O
ATOM   1149  CB  VAL L 146      24.007  19.608  31.702  1.00 24.76           C
ATOM   1150  CG1 VAL L 146      23.625  18.913  30.407  1.00 24.31           C
ATOM   1151  CG2 VAL L 146      22.907  20.563  32.136  1.00 24.43           C
ATOM   1152  N   LYS L 147      25.213  16.484  32.018  1.00 22.48           N
ATOM   1153  CA  LYS L 147      26.285  15.587  31.603  1.00 28.63           C
ATOM   1154  C   LYS L 147      25.980  15.038  30.224  1.00 26.89           C
ATOM   1155  O   LYS L 147      24.829  14.734  29.911  1.00 25.73           O
ATOM   1156  CB  LYS L 147      26.433  14.406  32.568  1.00 33.35           C
ATOM   1157  CG  LYS L 147      27.290  14.674  33.782  1.00 42.63           C
ATOM   1158  CD  LYS L 147      27.413  13.418  34.633  1.00 49.12           C
ATOM   1159  CE  LYS L 147      28.354  13.635  35.806  1.00 52.65           C
ATOM   1160  NZ  LYS L 147      28.459  12.421  36.661  1.00 57.07           N
ATOM   1161  N   TRP L 148      27.014  14.920  29.401  1.00 22.69           N
ATOM   1162  CA  TRP L 148      26.852  14.370  28.068  1.00 19.52           C
ATOM   1163  C   TRP L 148      27.469  12.989  28.017  1.00 21.40           C
ATOM   1164  O   TRP L 148      28.559  12.769  28.544  1.00 21.95           O
ATOM   1165  CB  TRP L 148      27.539  15.240  27.024  1.00 18.93           C
ATOM   1166  CG  TRP L 148      26.789  16.467  26.683  1.00 16.05           C
ATOM   1167  CD1 TRP L 148      26.960  17.705  27.215  1.00 15.60           C
ATOM   1168  CD2 TRP L 148      25.757  16.586  25.701  1.00 15.47           C
ATOM   1169  NE1 TRP L 148      26.104  18.597  26.622  1.00 17.97           N
ATOM   1170  CE2 TRP L 148      25.351  17.936  25.687  1.00 16.42           C
ATOM   1171  CE3 TRP L 148      25.136  15.681  24.828  1.00 16.97           C
ATOM   1172  CZ2 TRP L 148      24.349  18.411  24.831  1.00 15.78           C
ATOM   1173  CZ3 TRP L 148      24.138  16.151  23.975  1.00 17.54           C
ATOM   1174  CH2 TRP L 148      23.756  17.507  23.985  1.00 17.61           C
ATOM   1175  N   LYS L 149      26.765  12.062  27.385  1.00 17.84           N
ATOM   1176  CA  LYS L 149      27.261  10.707  27.239  1.00 19.97           C
ATOM   1177  C   LYS L 149      27.199  10.314  25.773  1.00 19.33           C
ATOM   1178  O   LYS L 149      26.162  10.459  25.126  1.00 18.65           O
ATOM   1179  CB  LYS L 149      26.429   9.731  28.074  1.00 22.42           C
ATOM   1180  CG  LYS L 149      26.580   9.911  29.579  1.00 28.84           C
ATOM   1181  CD  LYS L 149      25.742   8.893  30.324  1.00 32.85           C
ATOM   1182  CE  LYS L 149      25.932   8.997  31.821  1.00 37.81           C
ATOM   1183  NZ  LYS L 149      25.028   8.056  32.537  1.00 41.47           N
ATOM   1184  N   ILE L 150      28.326   9.848  25.249  1.00 17.42           N
ATOM   1185  CA  ILE L 150      28.415   9.399  23.864  1.00 20.99           C
ATOM   1186  C   ILE L 150      28.667   7.901  23.988  1.00 21.56           C
ATOM   1187  O   ILE L 150      29.697   7.481  24.518  1.00 20.44           O
ATOM   1188  CB  ILE L 150      29.593  10.082  23.132  1.00 21.07           C
ATOM   1189  CG1 ILE L 150      29.416  11.600  23.178  1.00 20.67           C
ATOM   1190  CG2 ILE L 150      29.662   9.608  21.689  1.00 22.97           C
ATOM   1191  CD1 ILE L 150      30.541  12.375  22.522  1.00 21.43           C
ATOM   1192  N   ASP L 151      27.725   7.098  23.508  1.00 21.23           N
ATOM   1193  CA  ASP L 151      27.829   5.646  23.632  1.00 21.70           C
ATOM   1194  C   ASP L 151      28.050   5.271  25.102  1.00 21.71           C
ATOM   1195  O   ASP L 151      28.870   4.406  25.421  1.00 21.00           O
ATOM   1196  CB  ASP L 151      28.964   5.077  22.768  1.00 18.71           C
ATOM   1197  CG  ASP L 151      28.555   4.892  21.313  1.00 21.03           C
ATOM   1198  OD1 ASP L 151      27.337   4.877  21.039  1.00 17.93           O
ATOM   1199  OD2 ASP L 151      29.446   4.751  20.443  1.00 19.26           O
ATOM   1200  N   GLY L 152      27.319   5.945  25.989  1.00 19.40           N
ATOM   1201  CA  GLY L 152      27.410   5.662  27.411  1.00 18.40           C
ATOM   1202  C   GLY L 152      28.590   6.250  28.162  1.00 21.91           C
ATOM   1203  O   GLY L 152      28.588   6.254  29.391  1.00 22.54           O
ATOM   1204  N   SER L 153      29.593   6.745  27.442  1.00 21.41           N
ATOM   1205  CA  SER L 153      30.777   7.323  28.078  1.00 23.78           C
ATOM   1206  C   SER L 153      30.614   8.830  28.281  1.00 23.93           C
ATOM   1207  O   SER L 153      30.161   9.539  27.384  1.00 25.28           O
ATOM   1208  CB  SER L 153      32.021   7.034  27.226  1.00 26.71           C
ATOM   1209  OG  SER L 153      33.189   7.593  27.807  1.00 33.36           O
ATOM   1210  N   GLU L 154      30.983   9.318  29.461  1.00 23.42           N
ATOM   1211  CA  GLU L 154      30.844  10.740  29.761  1.00 27.46           C
ATOM   1212  C   GLU L 154      31.868  11.583  29.008  1.00 28.73           C
ATOM   1213  O   GLU L 154      33.041  11.218  28.918  1.00 23.48           O
ATOM   1214  CB  GLU L 154      30.984  10.992  31.264  1.00 30.72           C
ATOM   1215  CG  GLU L 154      30.422  12.338  31.687  1.00 40.94           C
ATOM   1216  CD  GLU L 154      30.821  12.734  33.093  1.00 44.76           C
ATOM   1217  OE1 GLU L 154      30.657  11.909  34.017  1.00 47.13           O
ATOM   1218  OE2 GLU L 154      31.291  13.879  33.269  1.00 48.44           O
ATOM   1219  N   ARG L 155      31.414  12.713  28.473  1.00 28.39           N
ATOM   1220  CA  ARG L 155      32.275  13.606  27.712  1.00 31.83           C
ATOM   1221  C   ARG L 155      32.336  15.000  28.332  1.00 35.20           C
ATOM   1222  O   ARG L 155      31.312  15.659  28.504  1.00 36.17           O
ATOM   1223  CB  ARG L 155      31.773  13.695  26.265  1.00 35.82           C
ATOM   1224  CG  ARG L 155      32.479  14.746  25.419  1.00 39.58           C
ATOM   1225  CD  ARG L 155      33.961  14.461  25.326  1.00 44.28           C
ATOM   1226  NE  ARG L 155      34.297  13.712  24.124  1.00 50.36           N
ATOM   1227  CZ  ARG L 155      34.341  14.245  22.908  1.00 51.58           C
ATOM   1228  NH1 ARG L 155      34.070  15.533  22.738  1.00 53.09           N
ATOM   1229  NH2 ARG L 155      34.660  13.494  21.867  1.00 49.31           N
ATOM   1230  N   GLN L 156      33.543  15.445  28.663  1.00 36.90           N
ATOM   1231  CA  GLN L 156      33.740  16.763  29.260  1.00 41.03           C
ATOM   1232  C   GLN L 156      34.241  17.758  28.217  1.00 40.56           C
ATOM   1233  O   GLN L 156      33.876  18.931  28.234  1.00 41.63           O
ATOM   1234  CB  GLN L 156      34.770  16.684  30.394  1.00 46.15           C
ATOM   1235  CG  GLN L 156      34.398  15.776  31.553  1.00 54.47           C
ATOM   1236  CD  GLN L 156      33.299  16.355  32.426  1.00 60.74           C
ATOM   1237  OE1 GLN L 156      32.166  16.550  31.978  1.00 63.89           O
ATOM   1238  NE2 GLN L 156      33.631  16.637  33.682  1.00 61.58           N
ATOM   1239  N   ASN L 157      35.077  17.271  27.308  1.00 40.13           N
ATOM   1240  CA  ASN L 157      35.678  18.093  26.265  1.00 39.57           C
ATOM   1241  C   ASN L 157      34.721  18.546  25.169  1.00 37.34           C
ATOM   1242  O   ASN L 157      33.940  17.752  24.645  1.00 35.32           O
ATOM   1243  CB  ASN L 157      36.840  17.330  25.616  1.00 44.69           C
ATOM   1244  CG  ASN L 157      37.754  16.675  26.640  1.00 53.16           C
ATOM   1245  OD1 ASN L 157      37.316  15.845  27.441  1.00 58.47           O
ATOM   1246  ND2 ASN L 157      39.032  17.040  26.615  1.00 55.00           N
ATOM   1247  N   GLY L 158      34.799  19.827  24.822  1.00 33.30           N
ATOM   1248  CA  GLY L 158      33.967  20.368  23.761  1.00 31.53           C
ATOM   1249  C   GLY L 158      32.538  20.711  24.126  1.00 28.14           C
ATOM   1250  O   GLY L 158      31.676  20.796  23.253  1.00 31.41           O
ATOM   1251  N   VAL L 159      32.273  20.910  25.409  1.00 26.63           N
ATOM   1252  CA  VAL L 159      30.926  21.252  25.843  1.00 26.51           C
ATOM   1253  C   VAL L 159      30.859  22.729  26.218  1.00 26.19           C
ATOM   1254  O   VAL L 159      31.682  23.213  26.987  1.00 28.52           O
ATOM   1255  CB  VAL L 159      30.497  20.392  27.060  1.00 23.11           C
ATOM   1256  CG1 VAL L 159      29.096  20.788  27.528  1.00 19.32           C
ATOM   1257  CG2 VAL L 159      30.538  18.919  26.686  1.00 21.08           C
ATOM   1258  N   LEU L 160      29.889  23.441  25.652  1.00 24.95           N
ATOM   1259  CA  LEU L 160      29.700  24.859  25.940  1.00 25.07           C
ATOM   1260  C   LEU L 160      28.345  25.053  26.618  1.00 24.12           C
ATOM   1261  O   LEU L 160      27.302  24.713  26.050  1.00 19.14           O
ATOM   1262  CB  LEU L 160      29.748  25.689  24.649  1.00 26.58           C
ATOM   1263  CG  LEU L 160      31.036  25.645  23.819  1.00 33.27           C
ATOM   1264  CD1 LEU L 160      30.931  26.617  22.644  1.00 31.99           C
ATOM   1265  CD2 LEU L 160      32.225  26.006  24.699  1.00 32.28           C
ATOM   1266  N   ASN L 161      28.364  25.595  27.832  1.00 21.11           N
ATOM   1267  CA  ASN L 161      27.135  25.832  28.576  1.00 23.63           C
ATOM   1268  C   ASN L 161      26.865  27.318  28.710  1.00 23.38           C
ATOM   1269  O   ASN L 161      27.792  28.116  28.813  1.00 24.04           O
ATOM   1270  CB  ASN L 161      27.217  25.207  29.970  1.00 22.67           C
ATOM   1271  CG  ASN L 161      27.315  23.698  29.925  1.00 19.52           C
ATOM   1272  OD1 ASN L 161      26.539  23.041  29.242  1.00 22.32           O
ATOM   1273  ND2 ASN L 161      28.266  23.141  30.662  1.00 24.65           N
ATOM   1274  N   SER L 162      25.589  27.682  28.723  1.00 23.28           N
ATOM   1275  CA  SER L 162      25.195  29.076  28.841  1.00 21.47           C
ATOM   1276  C   SER L 162      23.821  29.199  29.505  1.00 18.33           C
ATOM   1277  O   SER L 162      22.890  28.482  29.153  1.00 16.76           O
ATOM   1278  CB  SER L 162      25.175  29.711  27.451  1.00 19.49           C
ATOM   1279  OG  SER L 162      24.845  31.078  27.526  1.00 24.49           O
ATOM   1280  N   TRP L 163      23.716  30.107  30.472  1.00 18.88           N
ATOM   1281  CA  TRP L 163      22.477  30.357  31.212  1.00 18.92           C
ATOM   1282  C   TRP L 163      21.932  31.735  30.865  1.00 19.32           C
ATOM   1283  O   TRP L 163      22.683  32.658  30.562  1.00 18.36           O
ATOM   1284  CB  TRP L 163      22.725  30.364  32.728  1.00 21.13           C
ATOM   1285  CG  TRP L 163      22.890  29.043  33.404  1.00 22.37           C
ATOM   1286  CD1 TRP L 163      21.973  28.408  34.198  1.00 21.25           C
ATOM   1287  CD2 TRP L 163      24.063  28.223  33.412  1.00 20.84           C
ATOM   1288  NE1 TRP L 163      22.507  27.245  34.704  1.00 22.48           N
ATOM   1289  CE2 TRP L 163      23.788  27.106  34.236  1.00 24.58           C
ATOM   1290  CE3 TRP L 163      25.321  28.323  32.804  1.00 23.86           C
ATOM   1291  CZ2 TRP L 163      24.729  26.093  34.467  1.00 27.02           C
ATOM   1292  CZ3 TRP L 163      26.259  27.315  33.034  1.00 25.29           C
ATOM   1293  CH2 TRP L 163      25.955  26.216  33.859  1.00 25.90           C
ATOM   1294  N   THR L 164      20.619  31.876  30.930  1.00 19.58           N
ATOM   1295  CA  THR L 164      19.997  33.162  30.685  1.00 21.33           C
ATOM   1296  C   THR L 164      19.881  33.773  32.078  1.00 23.17           C
ATOM   1297  O   THR L 164      20.057  33.071  33.074  1.00 20.66           O
ATOM   1298  CB  THR L 164      18.583  33.001  30.134  1.00 21.89           C
ATOM   1299  OG1 THR L 164      17.821  32.200  31.046  1.00 21.92           O
ATOM   1300  CG2 THR L 164      18.603  32.334  28.764  1.00 25.31           C
ATOM   1301  N   ASP L 165      19.608  35.071  32.162  1.00 26.05           N
ATOM   1302  CA  ASP L 165      19.429  35.693  33.470  1.00 28.15           C
ATOM   1303  C   ASP L 165      18.043  35.264  33.926  1.00 25.38           C
ATOM   1304  O   ASP L 165      17.307  34.630  33.171  1.00 25.33           O
ATOM   1305  CB  ASP L 165      19.474  37.220  33.382  1.00 30.96           C
ATOM   1306  CG  ASP L 165      20.868  37.751  33.134  1.00 40.38           C
ATOM   1307  OD1 ASP L 165      21.322  37.715  31.970  1.00 46.27           O
ATOM   1308  OD2 ASP L 165      21.513  38.197  34.111  1.00 41.46           O
ATOM   1309  N   GLN L 166      17.678  35.608  35.152  1.00 24.81           N
ATOM   1310  CA  GLN L 166      16.366  35.240  35.651  1.00 23.45           C
ATOM   1311  C   GLN L 166      15.300  35.974  34.843  1.00 26.11           C
ATOM   1312  O   GLN L 166      15.411  37.175  34.600  1.00 24.29           O
ATOM   1313  CB  GLN L 166      16.256  35.590  37.134  1.00 21.44           C
ATOM   1314  CG  GLN L 166      14.952  35.156  37.779  1.00 20.14           C
ATOM   1315  CD  GLN L 166      15.023  35.187  39.287  1.00 21.34           C
ATOM   1316  OE1 GLN L 166      15.549  36.134  39.875  1.00 20.59           O
ATOM   1317  NE2 GLN L 166      14.486  34.152  39.928  1.00 20.10           N
ATOM   1318  N   ASP L 167      14.278  35.239  34.414  1.00 27.95           N
ATOM   1319  CA  ASP L 167      13.189  35.805  33.630  1.00 29.93           C
ATOM   1320  C   ASP L 167      12.241  36.590  34.534  1.00 32.32           C
ATOM   1321  O   ASP L 167      11.771  36.074  35.549  1.00 28.91           O
ATOM   1322  CB  ASP L 167      12.415  34.687  32.933  1.00 35.59           C
ATOM   1323  CG  ASP L 167      11.308  35.212  32.041  1.00 43.09           C
ATOM   1324  OD1 ASP L 167      11.620  35.748  30.958  1.00 45.39           O
ATOM   1325  OD2 ASP L 167      10.125  35.097  32.426  1.00 50.52           O
ATOM   1326  N   SER L 168      11.953  37.833  34.164  1.00 33.22           N
ATOM   1327  CA  SER L 168      11.064  38.669  34.966  1.00 35.23           C
ATOM   1328  C   SER L 168       9.595  38.248  34.888  1.00 34.61           C
ATOM   1329  O   SER L 168       8.789  38.656  35.717  1.00 37.19           O
ATOM   1330  CB  SER L 168      11.198  40.135  34.545  1.00 36.36           C
ATOM   1331  OG  SER L 168      10.906  40.293  33.168  1.00 37.66           O
ATOM   1332  N   LYS L 169       9.241  37.429  33.904  1.00 34.88           N
ATOM   1333  CA  LYS L 169       7.854  36.995  33.777  1.00 36.42           C
ATOM   1334  C   LYS L 169       7.483  35.780  34.632  1.00 32.69           C
ATOM   1335  O   LYS L 169       6.346  35.664  35.076  1.00 30.70           O
ATOM   1336  CB  LYS L 169       7.509  36.715  32.307  1.00 42.22           C
ATOM   1337  CG  LYS L 169       7.267  37.970  31.479  1.00 48.53           C
ATOM   1338  CD  LYS L 169       6.745  37.629  30.088  1.00 55.82           C
ATOM   1339  CE  LYS L 169       6.497  38.890  29.263  1.00 58.26           C
ATOM   1340  NZ  LYS L 169       5.917  38.585  27.921  1.00 58.72           N
ATOM   1341  N   ASP L 170       8.424  34.866  34.850  1.00 28.93           N
ATOM   1342  CA  ASP L 170       8.131  33.691  35.661  1.00 22.71           C
ATOM   1343  C   ASP L 170       9.216  33.394  36.685  1.00 22.10           C
ATOM   1344  O   ASP L 170       9.116  32.426  37.438  1.00 21.97           O
ATOM   1345  CB  ASP L 170       7.913  32.461  34.779  1.00 24.60           C
ATOM   1346  CG  ASP L 170       9.112  32.135  33.912  1.00 26.56           C
ATOM   1347  OD1 ASP L 170      10.228  32.626  34.190  1.00 29.66           O
ATOM   1348  OD2 ASP L 170       8.935  31.366  32.949  1.00 30.73           O
ATOM   1349  N   SER L 171      10.253  34.225  36.705  1.00 20.46           N
ATOM   1350  CA  SER L 171      11.363  34.071  37.643  1.00 20.51           C
ATOM   1351  C   SER L 171      12.152  32.766  37.507  1.00 17.25           C
ATOM   1352  O   SER L 171      12.776  32.310  38.463  1.00 19.71           O
ATOM   1353  CB  SER L 171      10.847  34.214  39.080  1.00 20.21           C
ATOM   1354  OG  SER L 171      10.214  35.471  39.262  1.00 22.92           O
ATOM   1355  N   THR L 172      12.139  32.167  36.326  1.00 17.43           N
ATOM   1356  CA  THR L 172      12.885  30.927  36.125  1.00 18.12           C
ATOM   1357  C   THR L 172      14.147  31.193  35.312  1.00 18.93           C
ATOM   1358  O   THR L 172      14.377  32.307  34.847  1.00 18.61           O
ATOM   1359  CB  THR L 172      12.051  29.870  35.371  1.00 17.96           C
ATOM   1360  OG1 THR L 172      11.819  30.308  34.026  1.00 19.22           O
ATOM   1361  CG2 THR L 172      10.712  29.647  36.072  1.00 15.25           C
ATOM   1362  N   TYR L 173      14.972  30.164  35.164  1.00 17.92           N
ATOM   1363  CA  TYR L 173      16.189  30.267  34.379  1.00 15.72           C
ATOM   1364  C   TYR L 173      16.086  29.229  33.278  1.00 16.14           C
ATOM   1365  O   TYR L 173      15.250  28.332  33.343  1.00 14.22           O
ATOM   1366  CB  TYR L 173      17.438  29.963  35.222  1.00 17.15           C
ATOM   1367  CG  TYR L 173      17.705  30.932  36.352  1.00 16.57           C
ATOM   1368  CD1 TYR L 173      17.063  30.797  37.584  1.00 18.39           C
ATOM   1369  CD2 TYR L 173      18.598  31.986  36.189  1.00 18.69           C
ATOM   1370  CE1 TYR L 173      17.307  31.687  38.626  1.00 18.47           C
ATOM   1371  CE2 TYR L 173      18.849  32.887  37.227  1.00 18.35           C
ATOM   1372  CZ  TYR L 173      18.200  32.728  38.439  1.00 20.09           C
ATOM   1373  OH  TYR L 173      18.449  33.607  39.465  1.00 19.70           O
ATOM   1374  N   SER L 174      16.930  29.364  32.261  1.00 16.15           N
ATOM   1375  CA  SER L 174      16.973  28.406  31.165  1.00 14.61           C
ATOM   1376  C   SER L 174      18.430  28.203  30.831  1.00 15.98           C
ATOM   1377  O   SER L 174      19.256  29.079  31.069  1.00 13.49           O
ATOM   1378  CB  SER L 174      16.204  28.914  29.954  1.00 16.40           C
ATOM   1379  OG  SER L 174      14.814  28.860  30.213  1.00 18.71           O
ATOM   1380  N   MET L 175      18.754  27.041  30.286  1.00 19.92           N
ATOM   1381  CA  MET L 175      20.141  26.748  29.985  1.00 17.78           C
ATOM   1382  C   MET L 175      20.316  26.049  28.653  1.00 16.18           C
ATOM   1383  O   MET L 175      19.476  25.256  28.236  1.00 17.47           O
ATOM   1384  CB  MET L 175      20.719  25.865  31.089  1.00 22.48           C
ATOM   1385  CG  MET L 175      22.223  25.687  31.026  1.00 26.43           C
ATOM   1386  SD  MET L 175      22.737  24.181  31.849  1.00 29.78           S
ATOM   1387  CE  MET L 175      23.934  23.594  30.695  1.00 30.86           C
ATOM   1388  N   SER L 176      21.421  26.352  27.989  1.00 11.84           N
ATOM   1389  CA  SER L 176      21.737  25.737  26.719  1.00 15.67           C
ATOM   1390  C   SER L 176      23.074  25.012  26.858  1.00 16.12           C
ATOM   1391  O   SER L 176      24.038  25.558  27.403  1.00 13.99           O
ATOM   1392  CB  SER L 176      21.837  26.802  25.627  1.00 16.14           C
ATOM   1393  OG  SER L 176      22.191  26.213  24.391  1.00 18.80           O
ATOM   1394  N   SER L 177      23.127  23.779  26.368  1.00 16.05           N
ATOM   1395  CA  SER L 177      24.346  22.990  26.424  1.00 14.43           C
ATOM   1396  C   SER L 177      24.617  22.432  25.035  1.00 18.55           C
ATOM   1397  O   SER L 177      23.792  21.708  24.463  1.00 19.28           O
ATOM   1398  CB  SER L 177      24.205  21.853  27.441  1.00 15.92           C
ATOM   1399  OG  SER L 177      25.417  21.108  27.553  1.00 15.12           O
ATOM   1400  N   THR L 178      25.778  22.778  24.490  1.00 18.43           N
ATOM   1401  CA  THR L 178      26.160  22.338  23.158  1.00 16.88           C
ATOM   1402  C   THR L 178      27.406  21.457  23.164  1.00 20.48           C
ATOM   1403  O   THR L 178      28.439  21.830  23.726  1.00 22.05           O
ATOM   1404  CB  THR L 178      26.424  23.561  22.235  1.00 17.16           C
ATOM   1405  OG1 THR L 178      25.228  24.343  22.120  1.00 19.94           O
ATOM   1406  CG2 THR L 178      26.847  23.110  20.845  1.00 20.41           C
ATOM   1407  N   LEU L 179      27.304  20.284  22.543  1.00 22.32           N
ATOM   1408  CA  LEU L 179      28.441  19.368  22.435  1.00 21.07           C
ATOM   1409  C   LEU L 179      28.886  19.410  20.977  1.00 21.29           C
ATOM   1410  O   LEU L 179      28.128  19.037  20.087  1.00 20.43           O
ATOM   1411  CB  LEU L 179      28.035  17.941  22.820  1.00 21.66           C
ATOM   1412  CG  LEU L 179      29.071  16.836  22.573  1.00 22.35           C
ATOM   1413  CD1 LEU L 179      30.355  17.151  23.315  1.00 20.94           C
ATOM   1414  CD2 LEU L 179      28.510  15.496  23.026  1.00 22.39           C
ATOM   1415  N   THR L 180      30.108  19.878  20.733  1.00 24.12           N
ATOM   1416  CA  THR L 180      30.625  19.975  19.367  1.00 25.84           C
ATOM   1417  C   THR L 180      31.720  18.954  19.060  1.00 26.44           C
ATOM   1418  O   THR L 180      32.719  18.850  19.772  1.00 21.40           O
ATOM   1419  CB  THR L 180      31.182  21.391  19.077  1.00 29.86           C
ATOM   1420  OG1 THR L 180      30.137  22.359  19.233  1.00 33.73           O
ATOM   1421  CG2 THR L 180      31.722  21.474  17.650  1.00 31.34           C
ATOM   1422  N   LEU L 181      31.526  18.206  17.981  1.00 27.84           N
ATOM   1423  CA  LEU L 181      32.485  17.189  17.569  1.00 27.88           C
ATOM   1424  C   LEU L 181      32.774  17.358  16.086  1.00 25.63           C
ATOM   1425  O   LEU L 181      32.114  18.138  15.405  1.00 23.18           O
ATOM   1426  CB  LEU L 181      31.898  15.798  17.804  1.00 30.84           C
ATOM   1427  CG  LEU L 181      31.423  15.447  19.215  1.00 33.62           C
ATOM   1428  CD1 LEU L 181      30.498  14.239  19.157  1.00 35.84           C
ATOM   1429  CD2 LEU L 181      32.623  15.176  20.109  1.00 31.77           C
ATOM   1430  N   THR L 182      33.772  16.636  15.591  1.00 28.50           N
ATOM   1431  CA  THR L 182      34.094  16.683  14.171  1.00 28.26           C
ATOM   1432  C   THR L 182      33.109  15.709  13.548  1.00 29.68           C
ATOM   1433  O   THR L 182      32.591  14.832  14.234  1.00 30.89           O
ATOM   1434  CB  THR L 182      35.519  16.172  13.882  1.00 26.83           C
ATOM   1435  OG1 THR L 182      35.636  14.813  14.324  1.00 24.66           O
ATOM   1436  CG2 THR L 182      36.554  17.031  14.605  1.00 28.72           C
ATOM   1437  N   LYS L 183      32.843  15.861  12.257  1.00 33.77           N
ATOM   1438  CA  LYS L 183      31.922  14.969  11.570  1.00 33.68           C
ATOM   1439  C   LYS L 183      32.386  13.518  11.716  1.00 34.33           C
ATOM   1440  O   LYS L 183      31.574  12.614  11.913  1.00 29.48           O
ATOM   1441  CB  LYS L 183      31.850  15.341  10.086  1.00 33.64           C
ATOM   1442  CG  LYS L 183      30.985  14.421   9.236  1.00 35.35           C
ATOM   1443  CD  LYS L 183      31.194  14.708   7.745  1.00 39.24           C
ATOM   1444  CE  LYS L 183      30.464  13.710   6.861  1.00 37.84           C
ATOM   1445  NZ  LYS L 183      28.987  13.803   7.024  1.00 41.73           N
ATOM   1446  N   ASP L 184      33.698  13.307  11.631  1.00 34.54           N
ATOM   1447  CA  ASP L 184      34.265  11.964  11.725  1.00 35.73           C
ATOM   1448  C   ASP L 184      34.051  11.269  13.065  1.00 33.93           C
ATOM   1449  O   ASP L 184      33.826  10.058  13.111  1.00 30.41           O
ATOM   1450  CB  ASP L 184      35.762  11.997  11.404  1.00 42.36           C
ATOM   1451  CG  ASP L 184      36.047  12.503  10.001  1.00 49.31           C
ATOM   1452  OD1 ASP L 184      35.332  12.095   9.056  1.00 52.20           O
ATOM   1453  OD2 ASP L 184      36.993  13.302   9.839  1.00 53.88           O
ATOM   1454  N   GLU L 185      34.123  12.022  14.158  1.00 30.53           N
ATOM   1455  CA  GLU L 185      33.930  11.417  15.468  1.00 29.57           C
ATOM   1456  C   GLU L 185      32.449  11.185  15.732  1.00 24.71           C
ATOM   1457  O   GLU L 185      32.072  10.204  16.371  1.00 21.51           O
ATOM   1458  CB  GLU L 185      34.506  12.298  16.573  1.00 32.91           C
ATOM   1459  CG  GLU L 185      35.067  11.487  17.729  1.00 40.76           C
ATOM   1460  CD  GLU L 185      35.143  12.267  19.022  1.00 44.06           C
ATOM   1461  OE1 GLU L 185      35.644  13.413  19.006  1.00 45.45           O
ATOM   1462  OE2 GLU L 185      34.706  11.724  20.059  1.00 47.65           O
ATOM   1463  N   TYR L 186      31.616  12.096  15.239  1.00 22.95           N
ATOM   1464  CA  TYR L 186      30.171  11.994  15.415  1.00 22.27           C
ATOM   1465  C   TYR L 186      29.658  10.714  14.775  1.00 23.92           C
ATOM   1466  O   TYR L 186      28.760  10.061  15.307  1.00 22.37           O
ATOM   1467  CB  TYR L 186      29.464  13.190  14.768  1.00 22.25           C
ATOM   1468  CG  TYR L 186      27.952  13.087  14.793  1.00 22.07           C
ATOM   1469  CD1 TYR L 186      27.249  13.160  15.994  1.00 22.70           C
ATOM   1470  CD2 TYR L 186      27.228  12.885  13.621  1.00 19.16           C
ATOM   1471  CE1 TYR L 186      25.859  13.029  16.029  1.00 21.19           C
ATOM   1472  CE2 TYR L 186      25.841  12.752  13.646  1.00 22.00           C
ATOM   1473  CZ  TYR L 186      25.164  12.823  14.856  1.00 21.40           C
ATOM   1474  OH  TYR L 186      23.796  12.670  14.893  1.00 25.39           O
ATOM   1475  N   GLU L 187      30.242  10.358  13.633  1.00 25.44           N
ATOM   1476  CA  GLU L 187      29.831   9.167  12.900  1.00 28.75           C
ATOM   1477  C   GLU L 187      30.410   7.844  13.399  1.00 30.29           C
ATOM   1478  O   GLU L 187      30.021   6.778  12.925  1.00 34.87           O
ATOM   1479  CB  GLU L 187      30.142   9.354  11.418  1.00 29.14           C
ATOM   1480  CG  GLU L 187      29.548  10.636  10.872  1.00 32.84           C
ATOM   1481  CD  GLU L 187      29.581  10.714   9.365  1.00 36.60           C
ATOM   1482  OE1 GLU L 187      30.653  10.469   8.773  1.00 36.69           O
ATOM   1483  OE2 GLU L 187      28.528  11.035   8.775  1.00 42.02           O
ATOM   1484  N   ARG L 188      31.329   7.899  14.355  1.00 29.68           N
ATOM   1485  CA  ARG L 188      31.905   6.672  14.896  1.00 32.85           C
ATOM   1486  C   ARG L 188      31.160   6.234  16.156  1.00 30.86           C
ATOM   1487  O   ARG L 188      31.572   5.290  16.823  1.00 30.27           O
ATOM   1488  CB  ARG L 188      33.389   6.867  15.219  1.00 37.96           C
ATOM   1489  CG  ARG L 188      34.271   7.045  13.991  1.00 48.78           C
ATOM   1490  CD  ARG L 188      35.711   7.335  14.384  1.00 55.97           C
ATOM   1491  NE  ARG L 188      36.589   7.485  13.224  1.00 63.85           N
ATOM   1492  CZ  ARG L 188      36.897   6.503  12.381  1.00 67.24           C
ATOM   1493  NH1 ARG L 188      37.706   6.738  11.355  1.00 68.10           N
ATOM   1494  NH2 ARG L 188      36.401   5.285  12.562  1.00 68.59           N
ATOM   1495  N   HIS L 189      30.061   6.915  16.475  1.00 24.75           N
ATOM   1496  CA  HIS L 189      29.281   6.581  17.663  1.00 23.71           C
ATOM   1497  C   HIS L 189      27.803   6.520  17.339  1.00 24.64           C
ATOM   1498  O   HIS L 189      27.363   7.061  16.326  1.00 26.79           O
ATOM   1499  CB  HIS L 189      29.538   7.607  18.767  1.00 22.68           C
ATOM   1500  CG  HIS L 189      30.962   7.646  19.223  1.00 25.34           C
ATOM   1501  ND1 HIS L 189      31.550   6.605  19.907  1.00 26.15           N
ATOM   1502  CD2 HIS L 189      31.933   8.572  19.039  1.00 24.67           C
ATOM   1503  CE1 HIS L 189      32.823   6.886  20.122  1.00 26.25           C
ATOM   1504  NE2 HIS L 189      33.081   8.074  19.605  1.00 23.41           N
ATOM   1505  N   ASN L 190      27.031   5.875  18.206  1.00 25.08           N
ATOM   1506  CA  ASN L 190      25.605   5.729  17.957  1.00 25.31           C
ATOM   1507  C   ASN L 190      24.671   6.507  18.874  1.00 25.45           C
ATOM   1508  O   ASN L 190      23.769   7.196  18.396  1.00 24.83           O
ATOM   1509  CB  ASN L 190      25.218   4.250  18.007  1.00 29.15           C
ATOM   1510  CG  ASN L 190      23.781   4.007  17.570  1.00 31.49           C
ATOM   1511  OD1 ASN L 190      23.098   3.135  18.105  1.00 30.98           O
ATOM   1512  ND2 ASN L 190      23.322   4.773  16.586  1.00 34.25           N
ATOM   1513  N   SER L 191      24.860   6.400  20.186  1.00 23.83           N
ATOM   1514  CA  SER L 191      23.956   7.102  21.092  1.00 24.93           C
ATOM   1515  C   SER L 191      24.524   8.367  21.714  1.00 22.62           C
ATOM   1516  O   SER L 191      25.665   8.398  22.176  1.00 26.10           O
ATOM   1517  CB  SER L 191      23.475   6.162  22.200  1.00 25.58           C
ATOM   1518  OG  SER L 191      24.547   5.771  23.039  1.00 35.76           O
ATOM   1519  N   TYR L 192      23.704   9.413  21.711  1.00 20.96           N
ATOM   1520  CA  TYR L 192      24.066  10.703  22.275  1.00 18.77           C
ATOM   1521  C   TYR L 192      23.035  11.033  23.342  1.00 20.42           C
ATOM   1522  O   TYR L 192      21.830  11.045  23.080  1.00 20.12           O
ATOM   1523  CB  TYR L 192      24.098  11.767  21.179  1.00 15.79           C
ATOM   1524  CG  TYR L 192      25.237  11.537  20.217  1.00 19.38           C
ATOM   1525  CD1 TYR L 192      25.144  10.574  19.209  1.00 18.58           C
ATOM   1526  CD2 TYR L 192      26.448  12.213  20.374  1.00 13.17           C
ATOM   1527  CE1 TYR L 192      26.232  10.286  18.387  1.00 17.30           C
ATOM   1528  CE2 TYR L 192      27.537  11.932  19.561  1.00 19.20           C
ATOM   1529  CZ  TYR L 192      27.424  10.968  18.573  1.00 19.28           C
ATOM   1530  OH  TYR L 192      28.510  10.683  17.786  1.00 22.20           O
ATOM   1531  N   THR L 193      23.518  11.298  24.551  1.00 18.07           N
ATOM   1532  CA  THR L 193      22.634  11.555  25.674  1.00 17.57           C
ATOM   1533  C   THR L 193      22.939  12.822  26.451  1.00 16.70           C
ATOM   1534  O   THR L 193      24.093  13.128  26.741  1.00 17.17           O
ATOM   1535  CB  THR L 193      22.677  10.352  26.658  1.00 16.02           C
ATOM   1536  OG1 THR L 193      22.248   9.167  25.976  1.00 19.60           O
ATOM   1537  CG2 THR L 193      21.785  10.596  27.868  1.00 13.67           C
ATOM   1538  N   CYS L 194      21.877  13.547  26.785  1.00 16.69           N
ATOM   1539  CA  CYS L 194      21.958  14.772  27.572  1.00 17.33           C
ATOM   1540  C   CYS L 194      21.332  14.378  28.908  1.00 17.62           C
ATOM   1541  O   CYS L 194      20.185  13.931  28.948  1.00 16.52           O
ATOM   1542  CB  CYS L 194      21.129  15.873  26.912  1.00 18.04           C
ATOM   1543  SG  CYS L 194      21.102  17.428  27.842  1.00 32.91           S
ATOM   1544  N   GLU L 195      22.075  14.533  29.996  1.00 17.34           N
ATOM   1545  CA  GLU L 195      21.574  14.135  31.305  1.00 19.88           C
ATOM   1546  C   GLU L 195      21.563  15.298  32.289  1.00 20.22           C
ATOM   1547  O   GLU L 195      22.594  15.913  32.557  1.00 21.05           O
ATOM   1548  CB  GLU L 195      22.439  12.995  31.835  1.00 24.97           C
ATOM   1549  CG  GLU L 195      21.892  12.284  33.045  1.00 32.91           C
ATOM   1550  CD  GLU L 195      22.702  11.049  33.384  1.00 36.32           C
ATOM   1551  OE1 GLU L 195      22.763  10.126  32.540  1.00 38.85           O
ATOM   1552  OE2 GLU L 195      23.279  11.007  34.489  1.00 41.20           O
ATOM   1553  N   ALA L 196      20.390  15.595  32.834  1.00 16.39           N
ATOM   1554  CA  ALA L 196      20.265  16.705  33.769  1.00 21.33           C
ATOM   1555  C   ALA L 196      19.974  16.301  35.218  1.00 20.72           C
ATOM   1556  O   ALA L 196      19.032  15.556  35.493  1.00 17.53           O
ATOM   1557  CB  ALA L 196      19.190  17.663  33.276  1.00 18.50           C
ATOM   1558  N   THR L 197      20.797  16.796  36.137  1.00 18.09           N
ATOM   1559  CA  THR L 197      20.607  16.531  37.560  1.00 19.90           C
ATOM   1560  C   THR L 197      20.132  17.850  38.164  1.00 18.30           C
ATOM   1561  O   THR L 197      20.802  18.875  38.046  1.00 17.35           O
ATOM   1562  CB  THR L 197      21.920  16.078  38.243  1.00 24.04           C
ATOM   1563  OG1 THR L 197      22.265  14.757  37.797  1.00 29.31           O
ATOM   1564  CG2 THR L 197      21.756  16.054  39.749  1.00 28.68           C
ATOM   1565  N   HIS L 198      18.959  17.827  38.783  1.00 15.62           N
ATOM   1566  CA  HIS L 198      18.382  19.027  39.371  1.00 15.66           C
ATOM   1567  C   HIS L 198      17.677  18.621  40.660  1.00 17.04           C
ATOM   1568  O   HIS L 198      17.298  17.461  40.826  1.00 16.66           O
ATOM   1569  CB  HIS L 198      17.394  19.649  38.375  1.00 13.31           C
ATOM   1570  CG  HIS L 198      16.976  21.043  38.719  1.00 17.08           C
ATOM   1571  ND1 HIS L 198      15.722  21.346  39.205  1.00 17.72           N
ATOM   1572  CD2 HIS L 198      17.652  22.214  38.666  1.00 14.19           C
ATOM   1573  CE1 HIS L 198      15.644  22.643  39.439  1.00 14.45           C
ATOM   1574  NE2 HIS L 198      16.802  23.193  39.122  1.00 16.89           N
ATOM   1575  N   LYS L 199      17.491  19.561  41.576  1.00 16.74           N
ATOM   1576  CA  LYS L 199      16.861  19.197  42.826  1.00 19.00           C
ATOM   1577  C   LYS L 199      15.398  18.791  42.708  1.00 20.97           C
ATOM   1578  O   LYS L 199      14.867  18.167  43.621  1.00 21.85           O
ATOM   1579  CB  LYS L 199      17.002  20.319  43.853  1.00 20.45           C
ATOM   1580  CG  LYS L 199      16.153  21.535  43.602  1.00 22.66           C
ATOM   1581  CD  LYS L 199      16.051  22.362  44.874  1.00 26.15           C
ATOM   1582  CE  LYS L 199      15.501  21.515  46.007  1.00 21.03           C
ATOM   1583  NZ  LYS L 199      15.022  22.333  47.137  1.00 21.64           N
ATOM   1584  N   THR L 200      14.751  19.123  41.592  1.00 18.72           N
ATOM   1585  CA  THR L 200      13.342  18.777  41.416  1.00 19.72           C
ATOM   1586  C   THR L 200      13.071  17.315  41.081  1.00 20.83           C
ATOM   1587  O   THR L 200      11.921  16.888  41.076  1.00 26.38           O
ATOM   1588  CB  THR L 200      12.670  19.644  40.338  1.00 19.77           C
ATOM   1589  OG1 THR L 200      13.454  19.614  39.137  1.00 17.69           O
ATOM   1590  CG2 THR L 200      12.511  21.080  40.835  1.00 14.54           C
ATOM   1591  N   SER L 201      14.112  16.545  40.790  1.00 21.32           N
ATOM   1592  CA  SER L 201      13.909  15.131  40.495  1.00 24.17           C
ATOM   1593  C   SER L 201      14.963  14.256  41.181  1.00 25.64           C
ATOM   1594  O   SER L 201      16.163  14.545  41.127  1.00 23.14           O
ATOM   1595  CB  SER L 201      13.915  14.885  38.981  1.00 22.05           C
ATOM   1596  OG  SER L 201      15.181  15.156  38.415  1.00 29.12           O
ATOM   1597  N   THR L 202      14.501  13.195  41.837  1.00 27.73           N
ATOM   1598  CA  THR L 202      15.385  12.268  42.535  1.00 28.56           C
ATOM   1599  C   THR L 202      16.347  11.603  41.565  1.00 28.92           C
ATOM   1600  O   THR L 202      17.514  11.380  41.889  1.00 31.68           O
ATOM   1601  CB  THR L 202      14.585  11.176  43.258  1.00 31.31           C
ATOM   1602  OG1 THR L 202      13.688  11.784  44.194  1.00 36.27           O
ATOM   1603  CG2 THR L 202      15.519  10.250  44.009  1.00 32.66           C
ATOM   1604  N   SER L 203      15.851  11.269  40.378  1.00 27.56           N
ATOM   1605  CA  SER L 203      16.684  10.655  39.348  1.00 23.75           C
ATOM   1606  C   SER L 203      16.920  11.692  38.265  1.00 22.24           C
ATOM   1607  O   SER L 203      16.073  12.552  38.029  1.00 21.15           O
ATOM   1608  CB  SER L 203      15.993   9.437  38.733  1.00 20.42           C
ATOM   1609  OG  SER L 203      15.937   8.370  39.656  1.00 28.52           O
ATOM   1610  N   PRO L 204      18.077  11.630  37.596  1.00 23.24           N
ATOM   1611  CA  PRO L 204      18.362  12.602  36.540  1.00 25.65           C
ATOM   1612  C   PRO L 204      17.386  12.483  35.379  1.00 24.82           C
ATOM   1613  O   PRO L 204      16.856  11.408  35.109  1.00 25.58           O
ATOM   1614  CB  PRO L 204      19.797  12.264  36.137  1.00 28.16           C
ATOM   1615  CG  PRO L 204      19.893  10.799  36.416  1.00 27.58           C
ATOM   1616  CD  PRO L 204      19.185  10.669  37.743  1.00 22.91           C
ATOM   1617  N   ILE L 205      17.136  13.604  34.713  1.00 27.99           N
ATOM   1618  CA  ILE L 205      16.240  13.630  33.569  1.00 25.93           C
ATOM   1619  C   ILE L 205      17.106  13.347  32.350  1.00 26.15           C
ATOM   1620  O   ILE L 205      18.137  13.989  32.147  1.00 25.01           O
ATOM   1621  CB  ILE L 205      15.550  14.992  33.454  1.00 30.56           C
ATOM   1622  CG1 ILE L 205      14.696  15.224  34.706  1.00 33.11           C
ATOM   1623  CG2 ILE L 205      14.687  15.040  32.204  1.00 33.39           C
ATOM   1624  CD1 ILE L 205      13.959  16.544  34.726  1.00 40.58           C
ATOM   1625  N   VAL L 206      16.689  12.370  31.552  1.00 25.61           N
ATOM   1626  CA  VAL L 206      17.454  11.954  30.385  1.00 22.56           C
ATOM   1627  C   VAL L 206      16.748  12.084  29.041  1.00 23.74           C
ATOM   1628  O   VAL L 206      15.587  11.714  28.891  1.00 26.04           O
ATOM   1629  CB  VAL L 206      17.900  10.481  30.543  1.00 24.03           C
ATOM   1630  CG1 VAL L 206      18.702  10.044  29.337  1.00 24.31           C
ATOM   1631  CG2 VAL L 206      18.715  10.322  31.818  1.00 22.72           C
ATOM   1632  N   LYS L 207      17.474  12.617  28.068  1.00 21.44           N
ATOM   1633  CA  LYS L 207      16.981  12.773  26.710  1.00 22.91           C
ATOM   1634  C   LYS L 207      18.111  12.278  25.818  1.00 22.91           C
ATOM   1635  O   LYS L 207      19.274  12.608  26.052  1.00 20.68           O
ATOM   1636  CB  LYS L 207      16.681  14.242  26.398  1.00 22.57           C
ATOM   1637  CG  LYS L 207      15.471  14.799  27.114  1.00 29.92           C
ATOM   1638  CD  LYS L 207      14.198  14.129  26.638  1.00 29.61           C
ATOM   1639  CE  LYS L 207      12.995  14.643  27.405  1.00 36.42           C
ATOM   1640  NZ  LYS L 207      11.732  14.037  26.905  1.00 38.91           N
ATOM   1641  N   SER L 208      17.782  11.471  24.814  1.00 22.93           N
ATOM   1642  CA  SER L 208      18.807  10.961  23.911  1.00 23.69           C
ATOM   1643  C   SER L 208      18.253  10.587  22.549  1.00 22.47           C
ATOM   1644  O   SER L 208      17.046  10.627  22.318  1.00 19.97           O
ATOM   1645  CB  SER L 208      19.496   9.743  24.525  1.00 30.36           C
ATOM   1646  OG  SER L 208      18.568   8.698  24.742  1.00 31.97           O
ATOM   1647  N   PHE L 209      19.159  10.254  21.640  1.00 21.36           N
ATOM   1648  CA  PHE L 209      18.792   9.834  20.298  1.00 22.67           C
ATOM   1649  C   PHE L 209      19.927   8.951  19.791  1.00 26.96           C
ATOM   1650  O   PHE L 209      21.065   9.070  20.250  1.00 22.94           O
ATOM   1651  CB  PHE L 209      18.579  11.052  19.382  1.00 24.63           C
ATOM   1652  CG  PHE L 209      19.848  11.755  18.980  1.00 23.08           C
ATOM   1653  CD1 PHE L 209      20.615  11.283  17.920  1.00 22.08           C
ATOM   1654  CD2 PHE L 209      20.272  12.893  19.659  1.00 22.40           C
ATOM   1655  CE1 PHE L 209      21.792  11.936  17.539  1.00 26.03           C
ATOM   1656  CE2 PHE L 209      21.445  13.555  19.290  1.00 21.71           C
ATOM   1657  CZ  PHE L 209      22.208  13.075  18.226  1.00 20.59           C
ATOM   1658  N   ASN L 210      19.609   8.047  18.872  1.00 29.68           N
ATOM   1659  CA  ASN L 210      20.608   7.151  18.309  1.00 35.91           C
ATOM   1660  C   ASN L 210      20.653   7.359  16.807  1.00 38.80           C
ATOM   1661  O   ASN L 210      19.617   7.567  16.181  1.00 35.50           O
ATOM   1662  CB  ASN L 210      20.248   5.687  18.590  1.00 39.78           C
ATOM   1663  CG  ASN L 210      20.019   5.411  20.059  1.00 42.87           C
ATOM   1664  OD1 ASN L 210      20.840   5.757  20.907  1.00 45.62           O
ATOM   1665  ND2 ASN L 210      18.899   4.773  20.368  1.00 47.45           N
ATOM   1666  N   ARG L 211      21.848   7.304  16.228  1.00 43.49           N
ATOM   1667  CA  ARG L 211      21.977   7.467  14.788  1.00 50.94           C
ATOM   1668  C   ARG L 211      21.502   6.201  14.079  1.00 56.96           C
ATOM   1669  O   ARG L 211      22.277   5.518  13.411  1.00 61.08           O
ATOM   1670  CB  ARG L 211      23.425   7.767  14.402  1.00 48.48           C
ATOM   1671  CG  ARG L 211      23.938   9.090  14.929  1.00 44.50           C
ATOM   1672  CD  ARG L 211      25.201   9.523  14.203  1.00 43.64           C
ATOM   1673  NE  ARG L 211      26.213   8.475  14.194  1.00 42.96           N
ATOM   1674  CZ  ARG L 211      26.457   7.677  13.159  1.00 42.42           C
ATOM   1675  NH1 ARG L 211      25.767   7.807  12.034  1.00 43.30           N
ATOM   1676  NH2 ARG L 211      27.384   6.737  13.259  1.00 40.19           N
ATOM   1677  N   ASN L 212      20.223   5.891  14.251  1.00 63.62           N
ATOM   1678  CA  ASN L 212      19.602   4.727  13.634  1.00 70.84           C
ATOM   1679  C   ASN L 212      18.165   5.117  13.322  1.00 76.13           C
ATOM   1680  O   ASN L 212      17.640   4.819  12.247  1.00 78.13           O
ATOM   1681  CB  ASN L 212      19.618   3.532  14.588  1.00 71.04           C
ATOM   1682  CG  ASN L 212      21.016   3.163  15.037  1.00 72.56           C
ATOM   1683  OD1 ASN L 212      21.929   3.017  14.221  1.00 70.76           O
ATOM   1684  ND2 ASN L 212      21.191   3.000  16.343  1.00 73.07           N
ATOM   1685  N   GLU L 213      17.536   5.789  14.281  1.00 80.14           N
ATOM   1686  CA  GLU L 213      16.169   6.260  14.129  1.00 84.85           C
ATOM   1687  C   GLU L 213      16.268   7.740  13.769  1.00 86.71           C
ATOM   1688  O   GLU L 213      15.296   8.490  13.869  1.00 86.91           O
ATOM   1689  CB  GLU L 213      15.400   6.079  15.441  1.00 87.98           C
ATOM   1690  CG  GLU L 213      13.921   6.441  15.363  1.00 92.53           C
ATOM   1691  CD  GLU L 213      13.192   6.213  16.677  1.00 94.81           C
ATOM   1692  OE1 GLU L 213      13.609   6.796  17.701  1.00 95.41           O
ATOM   1693  OE2 GLU L 213      12.202   5.450  16.685  1.00 95.58           O
ATOM   1694  N   CYS L 214      17.466   8.139  13.348  1.00 89.38           N
ATOM   1695  CA  CYS L 214      17.764   9.516  12.962  1.00 92.10           C
ATOM   1696  C   CYS L 214      17.863  10.433  14.177  1.00 92.54           C
ATOM   1697  O   CYS L 214      18.962  10.983  14.406  1.00 91.81           O
ATOM   1698  CB  CYS L 214      16.697  10.046  12.000  1.00 94.22           C
ATOM   1699  SG  CYS L 214      16.569   9.119  10.436  1.00 97.85           S
ATOM   1700  OXT CYS L 214      16.846  10.588  14.885  1.00 93.46           O
TER
END
"""

def get_pdb_inputs(pdb_str):
  ppf = mmtbx.utils.process_pdb_file_srv().process_pdb_files(
    raw_records=pdb_str.splitlines())[0]
  xrs = ppf.xray_structure(show_summary = False)
  restraints_manager = mmtbx.restraints.manager(
    geometry      = ppf.geometry_restraints_manager(show_energies = False),
    normalization = True)
  return group_args(
    ph  = ppf.all_chain_proxies.pdb_hierarchy,
    grm = restraints_manager,
    xrs = xrs)

def exercise():
  """
  Exercise determination of optimal weights for real-space refinement of
  individual coordinates.
  """
  for d_min in [1,2,6]:
    print(d_min, "-"*69)
    pi = get_pdb_inputs(pdb_str=pdb_str_1)
    f_calc = pi.xrs.structure_factors(d_min = d_min).f_calc()
    fft_map = f_calc.fft_map(resolution_factor=0.25)
    fft_map.apply_sigma_scaling()
    map_data = fft_map.real_map_unpadded()
    w = weight.run(
      map_data                    = map_data,
      xray_structure              = pi.xrs,
      pdb_hierarchy               = pi.ph,
      geometry_restraints_manager = pi.grm).weight
    ro = individual_sites.simple(
      target_map = map_data,
      selection  = flex.bool(pi.xrs.scatterers().size(), True),
      geometry_restraints_manager = pi.grm.geometry)
    ro.refine(weight=w, xray_structure = pi.xrs)
    print(ro.rmsds())

if(__name__ == "__main__"):
  timer = user_plus_sys_time()
  exercise()
  print("Time: %6.2f" % timer.elapsed())
